/*
 * Decompiled with CFR 0.152.
 */
package tdm.lib;

import java.io.PrintWriter;
import java.util.Iterator;
import tdm.lib.BaseNode;
import tdm.lib.MatchedNodes;
import tdm.lib.Node;
import tdm.lib.XMLNode;

public class BranchNode
extends Node {
    public static final int MATCH_CHILDREN = 2;
    public static final int MATCH_CONTENT = 1;
    public static final int MATCH_FULL = 3;
    protected BaseNode baseMatch = null;
    protected int matchType = 0;
    protected MatchedNodes partners = null;

    public BranchNode(XMLNode aContent) {
        this.content = aContent;
    }

    protected BranchNode() {
    }

    public void debug(PrintWriter pw, int indent) {
        super.debug(pw, indent);
        String ind = "                                                           ".substring(0, indent + 1);
        pw.println(ind + (this.partners != null ? "Partners are:" : "(no partners)"));
        if (this.partners != null) {
            this.partners.debug(pw, indent + 1);
            pw.println(ind + "---");
        }
    }

    public void delBaseMatch() {
        this.baseMatch = null;
        this.matchType = 0;
    }

    public BaseNode getBaseMatch() {
        return this.baseMatch;
    }

    public int getBaseMatchType() {
        return this.matchType;
    }

    public BranchNode getChild(int ix) {
        return (BranchNode)this.children.elementAt(ix);
    }

    public BranchNode getFirstPartner(int typeFlags) {
        if ((this.matchType & typeFlags) == 0) {
            return null;
        }
        MatchedNodes m = this.getPartners();
        if (m == null) {
            return null;
        }
        Iterator i = m.getMatches().iterator();
        while (i.hasNext()) {
            BranchNode candidate = (BranchNode)i.next();
            if ((candidate.matchType & typeFlags) == 0) continue;
            return candidate;
        }
        return null;
    }

    public BranchNode getParent() {
        return (BranchNode)this.parent;
    }

    public MatchedNodes getPartners() {
        return this.partners;
    }

    public boolean hasBaseMatch() {
        return this.baseMatch != null;
    }

    public boolean isLeftTree() {
        if (this.baseMatch != null) {
            return this.baseMatch.getLeft().getMatches().contains(this);
        }
        return this.getParent().isLeftTree();
    }

    public boolean isMatch(int type) {
        return (this.matchType & type) != 0;
    }

    public void setBaseMatch(BaseNode p, int amatchType) {
        if (amatchType < 1 || amatchType > 3) {
            throw new IllegalArgumentException();
        }
        this.baseMatch = p;
        this.matchType = amatchType;
    }

    public void setMatchType(int amatchType) {
        if (amatchType < 1 || amatchType > 3) {
            throw new IllegalArgumentException();
        }
        this.matchType = amatchType;
    }

    public void setPartners(MatchedNodes p) {
        this.partners = p;
    }
}

