package org.w3c.wai.tablin.tools;

import java.io.*;

public class Tools {
	
 public static String codeString(String data) {
  StringBuffer sb=new StringBuffer();

  int ind=0;
  while (data.length()>ind) {
    char car=(char)data.charAt(ind);
    switch (car) {
	case '&' :
          sb.append("%26");
          break;
	case '~' :
          sb.append("%7E");
          break;
	case '#' :
          sb.append("%23");
          break;
	case '\\' :
          sb.append("%5C");
          break;
	case '+' :
          sb.append("%2B");
          break;
	case '=' :
          sb.append("%3D");
          break;
	case '$' :
          sb.append("%24");
          break;
	case '%' :
          sb.append("%25");
          break;
	case '/' :
          sb.append("%2F");
          break;
	case ':' :
          sb.append("%3A");
          break;
	case ' ' :
          sb.append("+");
          break;
	case '\'' :
          sb.append("%27");
          break;
	case '{' :
          sb.append("%7B");
          break;
	case '(' :
          sb.append("%28");
          break;
	case '[' :
          sb.append("%5B");
          break;
	case '|' :
          sb.append("%7C");
          break;
	case ')' :
          sb.append("%29");
          break;
	case ']' :
          sb.append("%5D");
          break;
	case '}' :
          sb.append("%7D");
          break;
	case '!' :
          sb.append("%21");
          break;
	case ';' :
          sb.append("%3B");
          break;
	case '?' :
          sb.append("%3F");
          break;
	default : 
          sb.append(car);
    }
    ind++;
  }
  return new String(sb);
 }

 public static String skipSpace(String str) {
  StringBuffer sb=new StringBuffer();
  int cpt=0;

  while (true) {
    if (cpt==str.length())
      break;
    if (str.charAt(cpt)==' ') {
      sb.append((char)str.charAt(cpt));
      cpt++;
      while (cpt<str.length() && str.charAt(cpt)==' ')
        cpt++;
      continue;
    }
    sb.append((char)str.charAt(cpt));
    cpt++;
  }    
  return new String(sb);
 }

  public static String getService(String conf) {
    String service=null;

	  FileReader fr=null;
	  try {
	    if (conf==null) 
	      fr=new FileReader("config/config.cfg");
	    else
	      fr=new FileReader(conf);
	  }
	  catch (FileNotFoundException e) {
	      System.out.println("config file doesn't exists\n");
	      System.exit(1);
	  }
    	  try {
	      service=readLine(fr);
	  }
	  catch (IOException e) {
	      System.out.println("Problem with the config file");
	      System.exit(1);
	  }
    return service;

  }

    private static String readLine(FileReader fr) throws IOException {
	int car;
	StringBuffer sb=new StringBuffer();
	while (true) {
	    car=fr.read();
	    if (car==-1 || car==0 || car=='\n' || car=='\r' ||
		car==32)
		break;
	    sb.append((char)car);
	}
	if ((new String(sb)).indexOf("http://")!=0 || sb.length()<8) {
	    System.out.println("Bad URL in config.cfg");
	    System.exit(1);
	}
	return new String(sb);
    }

  public static String filterString(String str) {
    StringBuffer sb=new StringBuffer(str);
    try {
      if (sb.charAt(sb.length()-1)=='\n' || sb.charAt(sb.length()-1)=='\r')
	  sb.setLength(sb.length()-1);
      if (sb.charAt(sb.length()-1)=='\r')
	  sb.setLength(sb.length()-1);
      return skipSpace((new String(sb)).replace('\n',' '));
    }
    catch (StringIndexOutOfBoundsException e) {
      return "";
    }
  }


    /*
     * cgi 
     */
    public static boolean recursePossible(StringBuffer sb) {
	String s=new String(sb);
	if (s.indexOf("/cgi-bin/")!=-1 || 
	    s.indexOf(".cgi")!=-1)
	    return false;
	return true;

    }
    
    /** 
     * This function replaces all '\n'
     * and <BR> by ' '
     */
    public static String noNewLine(String value) {
	StringBuffer sb=new StringBuffer(value);
	int index;
	char c; 
	
	for (index=0;index<sb.length();index++) 
	    if (sb.charAt(index)=='\n' || sb.charAt(index)=='\r')
		sb.setCharAt(index,' ');
	
	for (index=0;index<sb.length();index++) 
	    if (sb.charAt(index)=='<' && (index+3)<sb.length()) {
		if ((sb.charAt(index+1)=='B' || sb.charAt(index+1)=='b') && 
		    (sb.charAt(index+2)=='R' || sb.charAt(index+2)=='r')) {
		    int index2=index+3;
		    while (sb.charAt(index2)!='>' && index2<sb.length())
			index2++;
		    if (index2<sb.length()) 
			sb=Tools.replace(sb,index,index2+1," ");
		}
	    }
	
	return new String(sb);
    }    

    public static StringBuffer replace(StringBuffer sb,int start, int end, 
				       String str) {
	StringBuffer other=new StringBuffer();
	for (int cpt=0;cpt<start;cpt++)
	    other.append(sb.charAt(cpt));
	other.append(str);
	for (int cpt=end;cpt<sb.length();cpt++)
	    other.append(sb.charAt(cpt));
        return other;
    }
}
