package org.w3c.wai.tablin.tools;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.REMatch;
import java.util.Hashtable;

public class GnuTools {

    public static Hashtable recoverAttributes(StringBuffer buffer) 
	throws REException {

	Hashtable attr=new Hashtable();
	//long deb=System.currentTimeMillis();
	RE regexp=new RE("([^\\s\n\t\r=]+)"+
			 "(\\s|\t|\r|\n)*="+
			 "(\\s|\t|\r|\n)*"+
			 "(\"(.|\n|\r)*?\"|"+
			 "'(.|\n|\r)*?'|"+
			 "\\\"(.|\n|\r)*?\\\"|"+
			 "\\'(.|\n|\r)*?\\'|"+
			 "([^\\s\n\t\r>]+))",
			 RE.REG_ICASE);
	RE regexp2=new RE("^([^\\s\t\n\r=]*)",
			  RE.REG_ICASE);
	RE regexp3=new RE("(\"(.|\n|\r)*?\"$|"+
			  "\\\"(.|\n|\r)*?\\\"$|"+
			  "'(.|\n|\r)*?'$|"+
			  "\\'(.|\n|\r)*?\\'$|"+
			  "([^\\s\t\n\r=]*)$)",
			  RE.REG_ICASE);
	//catchAttr(regexp,regexp2,regexp3);
	
	REMatchEnumeration reme=regexp.
	    getMatchEnumeration(buffer);
	//long end=System.currentTimeMillis();
	//System.out.println("Dans la merde:"+(end-deb));
	//deb=System.currentTimeMillis();
	while (reme.hasMoreMatches()) {
	    String s=reme.nextElement().toString();
	    REMatch key=regexp2.getMatch(s);
	    REMatch value=regexp3.getMatch(s);
	    attr.put(key.toString().toLowerCase(),
	    value.toString());
	}
	//end=System.currentTimeMillis();
	//System.out.println("Pour la hashTab="+(end-deb));
	return attr;
	
    }

    /** 
     * Va enlever de la chaine donne en parametre 
     * les eventuels caracteres en debut et fin qui 
     * delimitent la valeur de la chaine de caracteres
     * (e.g "une chaine" => une chaine
     */
    public static String purifyString(String s) {
	if (s.length()>0) {
	    int begin=0;
	    int end=s.length()-1;
	    if (s.charAt(begin)=='"' || s.charAt(begin)=='\'') {
		begin++;
		end--;
	    }
	    else {
		if (s.charAt(begin)=='\\' && 
		    (s.charAt(end)=='"' || s.charAt(end)=='\'')) {
		    begin+=2;
		    end-=2;
		}
	    }
	    if (begin>end)
		return null;
	    return s.substring(begin,end+1);
	}
	else {
	    return null;
	}
	
	
    }


}
