package org.w3c.wai.tablin.tools;



import org.w3c.wai.tablin.tools.*;

import org.w3c.wai.tablin.Linearize;

import java.awt.Frame;

import java.awt.Button;

import java.awt.Label;

import java.awt.TextField;

import java.awt.GridBagLayout;

import java.awt.GridLayout;

import java.awt.GridBagConstraints;

import java.awt.CheckboxGroup;

import java.awt.Checkbox;

import java.awt.FlowLayout;

import java.awt.Panel;

import java.awt.event.ActionEvent;

import java.awt.event.ActionListener;

import java.awt.Dialog;

import java.awt.BorderLayout;

import java.net.URL;

import java.net.URLConnection;

import java.io.FileReader;

import java.io.FileNotFoundException;

import java.net.MalformedURLException;

import java.io.IOException;

import java.awt.event.ItemListener;

import java.awt.event.ItemEvent;

import java.io.*;



public class GUILinear extends Frame {

  private TextField url=null; 

  private TextField tab=null;

  private TextField cs=null;

  private TextField hs=null;

  private TextField vs=null;

  private TextField base=null;

  private TextField file=null;

  private CheckboxGroup orientationCBG=null;

  private CheckboxGroup repetitionCBG=null;

  private CheckboxGroup interactionCBG=null;

  private Checkbox row=null;

  private Checkbox column=null;

  private Checkbox markup=null;

  private Checkbox noRepet=null;

  private Checkbox dhferoc=null;

  private Checkbox dhfec=null;

  private Checkbox ahferoc=null;

  private Checkbox ahfec=null;

  private Checkbox nl=null;

  private Checkbox tll=null;

  private Checkbox recursiveCB=null;

  private Checkbox embeddedCB=null;



  private GridBagLayout gbl=null;

  private String service=null;

    private String tag=null;



  public GUILinear(String conf,String tagPath) {

    super("Table Linearize Interface v0.1");



    service=Tools.getService(conf);

    tag=tagPath;



    gbl=new GridBagLayout();

    GridBagConstraints gbc=new GridBagConstraints();

    setLayout(gbl);



    gbc.gridx=0;

    gbc.gridy=0;

    gbc.gridwidth=4;

    gbc.gridheight=1;

    gbc.fill=GridBagConstraints.NONE;

    gbc.weightx=0;

    gbc.weighty=0;

    gbc.anchor=GridBagConstraints.NORTHWEST;

    Label urlLabel=new Label("Url or file: ");

    gbl.setConstraints(urlLabel,gbc);   



    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    url=new TextField("",50);

    gbl.setConstraints(url,gbc);

    add(urlLabel);

    add(url);



    Label tableLabel=new Label("Table number within page (default 0):");

    tab=new TextField("",3);

    gbc.gridy=GridBagConstraints.RELATIVE;

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbl.setConstraints(tableLabel,gbc);

    add(tableLabel);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(tab,gbc);

    add(tab);

    

    Label csLabel=new Label("Cell separator (default \",\"):");

    cs=new TextField("",10);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbl.setConstraints(csLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(cs,gbc);    

    add(csLabel);

    add(cs);



    Label hsLabel=new Label("Header separator (default \",\"):");

    hs=new TextField("",10);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbl.setConstraints(hsLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(hs,gbc);    

    add(hsLabel);

    add(hs);



    Label vsLabel=new Label("Value separator (default \"=\"):");

    vs=new TextField("",10);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbl.setConstraints(vsLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(vs,gbc);        

    add(vsLabel);

    add(vs);    



    Label orientationLabel=new Label("Orientation:");

    Panel orientationPanel=new Panel(new GridLayout(3,1));

    orientationCBG=new CheckboxGroup();

    row=new Checkbox("Row",orientationCBG,true);

    column=new Checkbox("Column",orientationCBG,true);

    markup=new Checkbox("Markup",orientationCBG,false);

    orientationPanel.add(row);

    orientationPanel.add(column);

    orientationPanel.add(markup);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbc.gridheight=3;

    gbl.setConstraints(orientationLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(orientationPanel,gbc);        

    add(orientationLabel);

    add(orientationPanel);



    Label repetitionLabel=new Label("Repetition:");

    Panel repetitionPanel=new Panel(new GridLayout(4,1));

    repetitionCBG=new CheckboxGroup();

    noRepet=new Checkbox("No Repetition",repetitionCBG,true);

    dhferoc=new Checkbox("Deepest header for each row or column",

 			 repetitionCBG,false);

    dhfec=new Checkbox("Deepest header for each cell",

			 repetitionCBG,false);    

    ahferoc=new Checkbox("All headers for each row or column",

			 repetitionCBG,false);    

    ahfec=new Checkbox("All headers for each cell",

			 repetitionCBG,true);    

    //repetitionPanel.add(noRepet);

    repetitionPanel.add(dhferoc);

    repetitionPanel.add(dhfec);

    repetitionPanel.add(ahferoc);

    repetitionPanel.add(ahfec);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbc.gridheight=5;

    gbl.setConstraints(repetitionLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(repetitionPanel,gbc);        

    add(repetitionLabel);

    add(repetitionPanel);



    Label interactionLabel=new Label("Interaction:");

    Panel interactionPanel=new Panel(new GridLayout(2,1));

    interactionCBG=new CheckboxGroup();

    nl=new Checkbox("None (no link to other version)",

		    interactionCBG,true);

    tll=new Checkbox("Table level link",

 		     interactionCBG,false);



    interactionPanel.add(nl);

    interactionPanel.add(tll);

    gbc.gridx=0;

    gbc.gridwidth=4;

    gbc.gridheight=3;

    gbl.setConstraints(interactionLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(interactionPanel,gbc);        

    add(interactionLabel);

    add(interactionPanel);



    recursiveCB=new Checkbox("Recursive Mode",null,true);

    embeddedCB=new Checkbox("Embedded Mode",null,true);

    /*embeddedCB.addItemListener(new ItemListener() {

      public void itemStateChanged(ItemEvent evt) {

	if (embeddedCB.getState()) {

	  base.setEnabled(true);

	}

	else {

	  base.setEnabled(false);

	}

      }

    }

				 );*/

    gbc.gridwidth=4;

    gbc.gridheight=1;

    gbl.setConstraints(recursiveCB,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(embeddedCB,gbc);        

    add(recursiveCB);

    add(embeddedCB);



    base=new TextField("",50);

    Label baseLabel=new Label("Base:");

    gbc.gridwidth=4;

    gbc.gridheight=1;

    gbl.setConstraints(baseLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(base,gbc);        

    add(baseLabel);

    add(base);



    file=new TextField("",50);

    Label fileLabel=new Label("Output file (nothing for standard output):");

    gbc.gridwidth=4;

    gbc.gridheight=1;

    gbl.setConstraints(fileLabel,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(file,gbc);        

    add(fileLabel);

    add(file);



    Button resetButton=new Button("Reset");

    resetButton.addActionListener(new ActionListener() {

      public void actionPerformed(ActionEvent evt) {

        url.setText("");

	tab.setText("");

	cs.setText("");

	hs.setText("");

	vs.setText("");

        recursiveCB.setState(true);

        embeddedCB.setState(true);

        ahfec.setState(true);

        column.setState(true);

        nl.setState(true);

	base.setText("");

	file.setText("");

      }

    });

    Button submitButton=new Button("Submit");

    submitButton.addActionListener(new ActionListener() {

      public void actionPerformed(ActionEvent evt) {

	int table=0;

	int type=0;

	int orient=1;

  	int repeat=4;



        if (url.getText().equals("")) {

          new MyDialog("URL problem","This fields can't be empty");

          return;

        }



        try {

          FileReader fr=new FileReader(url.getText());

	  type=1;

        }

        catch(FileNotFoundException e) {

          try {

	    URL u=new URL(url.getText());

            URLConnection uc=u.openConnection();

	    uc.getInputStream();

  	    type=0;

          }

          catch(MalformedURLException e2) {

            new MyDialog("URL problem","Bad url or file");

            return;

          }

          catch(IOException e3) {

 	    new MyDialog("URL problem","Bad url or file");

    	    return;

          }

        }

	

	if (!tab.getText().equals("")) {

	  try {

	    table=Integer.parseInt(tab.getText());

	  }

          catch (NumberFormatException e) {

	    new MyDialog("Table problem","I want a number for table");

	    return;

 	  }

        }



	orient=(row.getState()?1:(column.getState()?2:3));

	repeat=(ahfec.getState()?4:(dhfec.getState()?2:(dhferoc.getState()?1:3)));

	if ((embeddedCB.getState() || recursiveCB.getState()) 

	    && type==1 && base.getText().equals("")) {

	  new MyDialog("Parameter problem","In file mode with recursive or embedded mode active, please give me a base url.");

	    return;

	}

	

	if ((embeddedCB.getState() || recursiveCB.getState()) 

	    && type==1) {	

	  if (base.getText().length()>7) {

	    if (!base.getText().substring(0,7).equalsIgnoreCase("http://")) {

	      new MyDialog("Base problem",

			   "For base give a url (e.g http://www.w3.org");

	      return;

	    }

	  }

	  else {

	    new MyDialog("Base problem",

			 "For base give a url (e.g http://www.w3.org");

	    return;

	  }

	}

	

	



	try {

	  new Linearize(url.getText(),table,orient,repeat,

			(recursiveCB.getState()?1:0),

			(nl.getState()?0:1),

			(hs.getText().equals("")?", ":hs.getText()),

			(vs.getText().equals("")?"= ":vs.getText()),

			(cs.getText().equals("")?", ":cs.getText()),

			"",

			type,

			(file.getText().equals("")?null:file.getText()),

			service,

			0,

			base.getText(),

			(embeddedCB.getState()?1:0),

			false,

			(tag==null?"config/tag.dec":tag));

	}

	catch(IOException e) {

	    new MyDialog("Problem with Linearizer.",e.toString());

	    return;

	}

	new MyDialog("Finish","Linearize complete.");	

      }

    });

    gbc.gridwidth=4;

    gbc.gridheight=1;

    gbl.setConstraints(resetButton,gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;

    gbc.gridwidth=GridBagConstraints.REMAINDER;

    gbl.setConstraints(submitButton,gbc);            

    add(resetButton);

    add(submitButton);

    

    pack();

    setSize(700,500);

    setVisible(true);

  }



  private String readLine(FileReader fr) throws IOException {

    int car;

    StringBuffer sb=new StringBuffer();

    while (true) {

      car=fr.read();

      if (car==-1 || car==0 || car=='\n' || car=='\r' ||

	  car==32)

	break;

      sb.append((char)car);

    }

    if ((new String(sb)).indexOf("http://")!=0 || sb.length()<8) {

      System.out.println("Bad URL in config.cfg");

      System.exit(1);

    }

    return new String(sb);

  }

  

  

  public static void main(String args[]) {

      if (args.length>0) {

	  if (args[0].equals("-help") || args.length<2) {

	      System.out.println("java org.w3C.wai.tablin.tools.GUILinear <conf_path> <tag_path>");

	      System.exit(0);

	  }

	  new GUILinear(args[0],args[1]);

      }

      else

	  new GUILinear(null,null);

      

  }

      

}

