package org.w3c.wai.tablin.tools;
import java.io.*;
import java.util.*;

/*
 * The tool change the length of the document.
 * So it's necessary to change the value of the data
 * 'content-length' or to remove it.
 */

public class Filter {
    /* 
     * Stream where the data of the page was returned
     */
    private InputStream stream=null;

    /*
     * Result of the cgi in stdout
     */
    private BufferedWriter fw=null;

    /*
     * True if "Content-type: text/html" found, false elsewhere
     * Important to know if the daemon return an html page or a 
     * simple text file (not necessary to launch the parser in
     * this case)
     */
    private boolean htmlText=false;

    /*
     * status code after the request
     */
    private int statusCode=0;

    /*
     * URI redirection
     */
    private String location=null;

    public Filter(InputStream stream) throws FilterException,
					     RedirectionException,
    FilterEOFException {
	this.stream=stream;
	//fw=new BufferedWriter(new OutputStreamWriter(System.out));;
	init();
    }
    
    /*
     *  Read the header lines (response of the HTTP GET command)
     * and update (if necessary)
     * the "htmlText" attribute
     */
    private void init() throws FilterException, RedirectionException,
    FilterEOFException {
	String line=null;

	try {	
	  line=readLine();
        }
    	catch(IOException e) {
	  throw new FilterException("Problem with input stream.");
  	}

        if (line==null || line.length()==0)
	    throw new FilterEOFException("Request HTTP problem");

	int begin=line.indexOf(32);
	int end=line.indexOf(32,begin+1);
    	try {
          statusCode=Integer.parseInt(line.substring(begin+1,end));
	}
	catch(NumberFormatException e) {
          throw new FilterException("Problem with http protocol.");
        }

	while (true) {
          try {
	      if ((line=readLine())==null)
		  return;
          }
          catch (IOException e) {
	      try {
		  stream.close();
	      }
	      catch (IOException e2) {
		  throw new FilterException("Problem with input stream.");
	      }
	      throw new FilterException("Problem with input stream.");
	  }
	  //System.out.println("Line="+line+" Length="+line.length());
	  if (line.length()==0)
	    return;
	  if (isEndHeader(line))
	      break;
	  if (isContentType(line))
	      htmlText=true;
	  if (isLocation(line))
	    throw new RedirectionException(location);
	  if (!isContentLength(line)) {
	      /*
		try {
		fw.write(line);
		fw.flush();
		}
		catch (IOException e) {
		return;
		}
	      */
	  }
	}
	/*try {
	  fw.write("\n");
	  fw.flush();
	  }
	  catch (IOException e) {
	  return;
	  }
	*/
      if (((int)(statusCode/100))==3) {
        throw new FilterException("Redirection necessary.");
      }

    }
    
    /*
     * End of the header in http protocol
     */
    private boolean isEndHeader(String line) {
	return line.equals("\n") || line.equals("\r\n");
    }
    
    /*
     * Line content-length in the header of http protocol
     */
    private boolean isContentLength(String line) {
	String type=line.substring(0,line.indexOf(' '));
	return type.equals("Content-Length:");
    }

    private boolean isContentType(String line) {
	return line.indexOf(": text/html")!=-1;
    }

    private boolean isLocation(String line) {
      if (line.substring(0,line.indexOf(' ')).equals("Location:")) {
        int ind=line.indexOf(' ')+1;
        while (line.charAt(ind)==' ')
 	  ind++;
        location=line.substring(ind,line.length()-2);
        return true;
      }
      return false;
    }    

    private String readLine() throws IOException {
	StringBuffer sb=new StringBuffer();
	int car;
	
	//System.out.println("readLine");
	
	while ((car=stream.read())!=-1 && car!='\n') {
	    char c=(char)car;
	    sb.append(c);
	}

	if (car=='\n')
	    sb.append('\n');
	return new String(sb);
    }
    
    public boolean getHtmlText() {
	return htmlText;
    }
}
