package org.w3c.wai.tablin.parser.html4.struct.table;



import java.util.Vector;

import java.io.*;



public class Row {

  private Vector cell=null;

  

  public Row() {

    cell=new Vector();

  }



  protected boolean layoutTable() {

    for (int cpt=0;cpt<cell.size();cpt++) 

      if (!elementAt(cpt).isAnHeader()) 

	return true;

    return false;

  }

  

  protected void printLayout(BufferedWriter fw) throws IOException {

    for (int cpt=0;cpt<cell.size();cpt++) 

      elementAt(cpt).printLayout(fw);

  }

  

  protected void printMarkup(BufferedWriter fw) throws IOException {

    boolean boolHeader=false;

    boolean boolData=false;

    int nbr=0;

    

    for (int cpt=0;cpt<cell.size();cpt++) {

      Cell c=elementAt(cpt);

      if (c.isAnHeader()) {

	if (c.getType()!=Cell.TH_SPECIAL && 

	     c.getType()!=Cell.SPECIAL_TH_ROW_COL) {

	  if (c.isNotEmptyHeader()) {

	    if (boolData) {

	      nbr=0;

	      boolData=false;

	      fw.write(Table.cellSeparator);

	      fw.flush();

	    }

	    if (nbr>0) {

	    fw.write(Table.headerSeparator);

	    fw.flush();

	    }

	    

	    c.print(fw);

	    nbr++;

	    boolHeader=true;

	  }

	}

      }

      else {

	if (c.isNotEmpty()) {

	  if (boolHeader) {

	    nbr=0;

	    boolHeader=false;

	    fw.write(Table.valueSeparator);

	    fw.flush();

	  }

	  if (nbr>0) {

	    fw.write(Table.cellSeparator);

	    fw.flush();

	  }

	  c.print(fw);

	  nbr++;

	  boolData=true;

	}

      }

    }

    fw.write("\n");

    fw.flush();

  }

  

  protected void completeCellTable(int max) {

    int numberOfCell=max-numberOfCell();

    

    while (numberOfCell!=0) {

      addCell(new Cell(new Vector()

		       ,Cell.TD,1,1,"",-1,

		       "",""));

      numberOfCell--;

    }

  }

  

  public void addCell(Cell cell) {

    this.cell.addElement(cell);

  }

  

  public String toString() {

    StringBuffer str=new StringBuffer();

    

    for (int cpt=0;cpt<cell.size();cpt++)

      str.append(elementAt(cpt).toString()+" ");

    str.append("\n");

    return new String(str);

  }

  

  protected int numberOfCell() {

    return cell.size();

  }

  

  public int size() {

    return cell.size();

  }

  

  public Cell elementAt(int indice) {

    return ((Cell)cell.elementAt(indice));

  }

  

  protected void insertCellInRow(int ind,

				 Cell c) 

       throws ArrayIndexOutOfBoundsException {

	 

	 if (cell.size()<ind)

	   while (cell.size()!=ind) 

	     cell.addElement(new Cell(new Vector(),

				      Cell.TD,1,1,"",-1,"",""));

	 cell.insertElementAt(c,ind);

  }

  

  public void header() {

    for (int cpt=0;cpt<cell.size();cpt++) 

      elementAt(cpt).setHeader();

  }

  

  protected Cell findIdWithHeader(String header) {

    for (int cpt=0;cpt<cell.size();cpt++) 

      if (header.equals(elementAt(cpt).getId()) && 

	  elementAt(cpt).isNotEmptyHeader())

	return elementAt(cpt);

    return null;

  }

  

}















