/* Generated By:JavaCC: Do not edit this line. html4.java */
package org.w3c.wai.tablin.parser.html4;
import java.io.*;
import java.util.*;
import java.net.*;
import org.w3c.wai.tablin.parser.html4.struct.table.*;
import org.w3c.wai.tablin.tools.*;

public class html4 implements html4Constants {

  private int embedded;

  // url of the cgi 
  private String cgiUrl="http://jigsaw.w3.org/tablin/";

  // output of the cgi (stdout for us)
  private BufferedWriter fw=null;

  /*
   *  Table to linarize
   *  if tableNumber = 1, the parser linearize the first table in
   * document html. With a value of 0, the parser linearize all
   * the table on the document.
   */
  private int tableNumber;

  // count the table on document. Used when you want linearize 
  // only one table
  private int currentTable;

  /*
   * You can choose here, if you want to print the header row before
   * the header column.
   * Possible value: 1 for row first, 2 for column and 3 for markup order
   */
  private int orientation;

  /*
   * Value : 0 disable
   *         1 enable
   * Change the link on the document to invoke the
   * cgi 
   */
  private int recurs;

  private int interact;

  private int repeat;

  /*
   * The user can choose the "symbol" to use as separator 
   * of header
   * eg: Header1, Header2
   *      or
   *      Header1 -separator- Header2
   */
  private String headerSeparator;

  /*
   * The symbol use as separator between headers and the value of the cell
   * eg: Header1 : value
   *     Header1 -value separator- value
   */
  private String valueSeparator;

  /*
   * The symbol use as separator between two cell
   * eg: Header1 : value -new cell- Header2 : value2
   */
  private String cellSeparator;

  /* 
   * Symbol use as line separator
   */
  private String lineSeparator;

  /*
   * Base url is used to try to resolve problem with relative-url.
   */
  private String baseUrl;

  private int lynx;

  private StringBuffer dataOutOfBounds=new StringBuffer("");

public html4(String baseUrl,
               InputStream stream,
               OutputStream fos,
               int tableNumber,
               int orientation,
               int repeat,
               int recurs,
               int interact,
               String headerSeparator,
               String valueSeparator,
               String cellSeparator,
               String lineSeparator,
               String cgiUrl,
               int lynx,int embedded) throws IOException {
    this.baseUrl=baseUrl;
    this.lynx=lynx;
    this.embedded=embedded;
    this.tableNumber=tableNumber;
    this.fw=new BufferedWriter(new OutputStreamWriter(fos));
    this.recurs=recurs;
    this.cgiUrl=cgiUrl;
    this.interact=interact;
    this.repeat=repeat;
    currentTable=0;
    this.orientation=orientation;
    this.headerSeparator=headerSeparator;
    this.valueSeparator=valueSeparator;
    this.cellSeparator=cellSeparator;
    this.lineSeparator=lineSeparator;

    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new html4TokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 16; i++) jj_la1[i] = -1;
    try {
      init();
    }
    catch (ParseException e) {
      //System.out.println("Parsing problem (init)");
      return;
    }
  }

  public static void main(String argv[]) {
      try {
      html4 h=new html4(argv[0],
                        System.in,
                        System.out,
                        Integer.parseInt(argv[1]),
                        Integer.parseInt(argv[2]),
                        Integer.parseInt(argv[3]),
                        Integer.parseInt(argv[4]),
                        Integer.parseInt(argv[5]),
                        argv[6],argv[7],argv[8],argv[9],
                        null,0,0);
      }
      catch (IOException e) {
        System.out.println("Problem with streams.");
      }
  }

/*<ATTCOMM> SKIP :
{
	<		( ~["-"] )+			>
|	<		"-" ( ~["-"] )+			>
|	<		"--"				>	: ATTLIST
}*/

/* -----------------------------------------------------------*/
/* BNF rules for the grammar 				      */
/* -----------------------------------------------------------*/


// start of the parsing
// return of the init only
// at the end of the document
  final public void init() throws ParseException, IOException {
    skipToTable();
    reste();
    jj_consume_token(0);
  }

// seek a series of Table 
// and other thing than table 
  final public void reste() throws ParseException, IOException {
 Table tab=null;
    label_1:
    while (true) {
      tab = correctTable();
          if (tab!=null) {
            tab.print();
            if (!dataOutOfBounds.equals("")) {
              fw.write(new String(dataOutOfBounds));
              dataOutOfBounds=new StringBuffer("");
            }
          }
      skipToTable();
          if (getToken(1).kind==EOF)
            {if (true) return;}
      ;
    }
  }

// Call when the parser found a "<TABLE" token
// Construction of an instance of Table
  final public Table table() throws ParseException {
 Table table=new Table(fw,
                       tableNumber,
                       orientation,
                       repeat,
                       recurs,
                       interact,
                       headerSeparator,
                       valueSeparator,
                       cellSeparator,
                       lineSeparator,baseUrl,cgiUrl);
    jj_consume_token(STABLE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attTable(table);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    try {
      caption(table);
      colgroup();
      defTable(table);
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==SCAPTION) {
        captionAfterTableError(table);
        break;
      }
      if (t.kind==SCOLGROUP) {
        colgroupAfterTableError(table);
        break;
      }
      if (t.kind==STHEAD || t.kind==STFOOT ||
          t.kind==STBODY || t.kind==STR) {
        defTable(table);
        break;
      }
      if (t.kind==ETABLE)
        break;
      if (t.kind==EOF)
        {if (true) return table;}
      t=getNextToken();
    }
    }
    try {
      jj_consume_token(ETABLE);
      {if (true) return table;}
    } catch (ParseException e) {
     // EOF it's the end
     {if (true) return table;}
    }
    throw new Error("Missing return statement in function");
  }

  final public void captionAfterTableError(Table table) throws ParseException {
    caption(table);
    try {
      colgroup();
      defTable(table);
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==SCOLGROUP) {
        colgroupAfterCaptionError(table);
        break;
      }
      if (t.kind==STR || t.kind==STHEAD ||
          t.kind==STFOOT || t.kind==STBODY) {
        defTable(table);
        break;
      }
      if (t.kind==ETABLE || t.kind==EOF)
        break;
      t=getNextToken();
    }
    }
  }

  final public void colgroupAfterCaptionError(Table table) throws ParseException {
    colgroup();
    defTable(table);
  }

  final public void colgroupAfterTableError(Table table) throws ParseException {
    colgroup();
    defTable(table);
  }

// For more information look the html4.0 specification
  final public void colgroup() throws ParseException {
    try {
      label_2:
      while (true) {
        jj_consume_token(SCOLGROUP);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A_NAME:
          attlist();
          break;
        default:
          jj_la1[1] = jj_gen;
          ;
        }
        jj_consume_token(TAGC);
        skipToCol();
        col();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ECOLGROUP:
          jj_consume_token(ECOLGROUP);
          break;
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        skipToColgroup();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOLGROUP:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==SCOLGROUP) {
        colgroup();
        break;
      }
      if (t.kind==STHEAD || t.kind==STFOOT ||
            t.kind==STBODY || t.kind==STR || t.kind==ETABLE ||
            t.kind==EOF)
        break;
      t=getNextToken();
    }
    }
  }

  void skipToColgroup() throws ParseException {
  Token t=null;
  while (true) {
    t=getToken(1);
    if (t.kind==SCOLGROUP ||
        t.kind==STHEAD || t.kind==STFOOT ||
        t.kind==STBODY || t.kind==STR)
        break;
    t=getNextToken();
  }
  }

  void skipToCol() throws ParseException {
  Token t=null;
  while (true) {
    t=getToken(1);
    if (t.kind==SCOL || t.kind==SCOLGROUP ||
        t.kind==STHEAD || t.kind==STFOOT ||
        t.kind==STBODY || t.kind==STR || t.kind==ETABLE ||
        t.kind==EOF)
        break;
    t=getNextToken();
  }
  }

// For more information look the html4.0 specification
  final public void col() throws ParseException {
    try {
      label_3:
      while (true) {
        jj_consume_token(SCOL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A_NAME:
          attlist();
          break;
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        jj_consume_token(TAGC);
        skipToCol();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOL:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_3;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==SCOL) {
        col();
        break;
      }
      if (t.kind==STHEAD || t.kind==STFOOT ||
            t.kind==STBODY || t.kind==STR || t.kind==SCOLGROUP ||
            t.kind==ETABLE || t.kind==EOF)
        break;
      t=getNextToken();
    }
    }
  }

  void defTable(Table table) throws ParseException {
  Token t=null;
  while (true) {
    t=getToken(1);
    if (t.kind==STHEAD || t.kind==STFOOT ||
        t.kind==STBODY) {
      defTableGroup(table);
      break;
    }
    if (t.kind==STR) {
      defTableLine(table);
      break;
    }
    if (t.kind==EOF || t.kind==ETABLE)
      break;
    t=getNextToken();
  }
  }

  final public void defTableGroup(Table table) throws ParseException {
    try {
      thead(table);
      tfoot();
      label_4:
      while (true) {
        tbody(table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STBODY:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_4;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==STHEAD) {
        theadAfterError(table);
        break;
      }
      if (t.kind==STFOOT) {
        tfootAfterError(table);
        break;
      }
      if (t.kind==STBODY) {
        tbodyAfterError(table);
        break;
      }
      if (t.kind==EOF || t.kind==ETABLE)
        break;
      t=getNextToken();
    }
    }
  }

  final public void theadAfterError(Table table) throws ParseException {
    thead(table);
    try {
      tfoot();
      label_5:
      while (true) {
        tbody(table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STBODY:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_5;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==STFOOT) {
        tfootAfterError(table);
        break;
      }
      if (t.kind==STBODY) {
        tbodyAfterError(table);
        break;
      }
      if (t.kind==EOF || t.kind==ETABLE)
        break;
      t=getNextToken();
    }
    }
  }

  final public void tfootAfterError(Table table) throws ParseException {
    tfoot();
    try {
      label_6:
      while (true) {
        tbody(table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STBODY:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_6;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==STBODY) {
        tbodyAfterError(table);
        break;
      }
      if (t.kind==EOF || t.kind==ETABLE)
        break;
      t=getNextToken();
    }
    }
  }

  final public void tbodyAfterError(Table table) throws ParseException {
    try {
      label_7:
      while (true) {
        tbody(table);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STBODY:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_7;
        }
      }
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==STBODY) {
        tbodyAfterError(table);
        break;
      }
      if (t.kind==EOF || t.kind==ETABLE)
        break;
      t=getNextToken();
    }
    }
  }

  final public void thead(Table table) throws ParseException {
    jj_consume_token(STHEAD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attlist();
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTRHead();
    label_8:
    while (true) {
      defTHeadLine(table);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STR:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_8;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETHEAD:
      jj_consume_token(ETHEAD);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
  }

  final public void tfoot() throws ParseException {
    jj_consume_token(STFOOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attlist();
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTRFoot();
    label_9:
    while (true) {
      defTFootLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STR:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_9;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETFOOT:
      jj_consume_token(ETFOOT);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
  }

  final public void tbody(Table table) throws ParseException {
    jj_consume_token(STBODY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attlist();
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTRBody();
    label_10:
    while (true) {
      defBodyLine(table);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STR:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_10;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETBODY:
      jj_consume_token(ETBODY);
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    skipToBody();
  }

  void skipToBody() throws ParseException {
  Token t=null;
  while (true) {
    t=getToken(1);
    if (t.kind==STBODY || t.kind==ETABLE || t.kind==EOF)
      break;
    t=getNextToken();
  }
  }

  final public void defTHeadLine(Table table) throws ParseException {
 Row row=new Row();
    jj_consume_token(STR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attTr();
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTDTHHead();
    label_11:
    while (true) {
      cell(table,row);
      skipToTDTHHead2();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STH:
      case STD:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_11;
      }
    }
    row.header();
    table.addRow(row);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETR:
      jj_consume_token(ETR);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    skipToTRHead();
  }

  final public void defTFootLine() throws ParseException {
 Row row=new Row();
    jj_consume_token(STR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attTr();
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTDTHFoot();
    label_12:
    while (true) {
      cell(null,row);
      skipToTDTHFoot2();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STH:
      case STD:
        ;
        break;
      default:
        jj_la1[23] = jj_gen;
        break label_12;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETR:
      jj_consume_token(ETR);
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    skipToTRFoot();
  }

  final public void defBodyLine(Table table) throws ParseException {
 Row row=new Row();
    jj_consume_token(STR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attTr();
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTDTHBody();
    label_13:
    while (true) {
      cell(table,row);
      skipToTDTHBody2();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STH:
      case STD:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_13;
      }
    }
    table.addRow(row);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETR:
      jj_consume_token(ETR);
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    skipToTRBody();
  }

  final public void defTableLine(Table table) throws ParseException {
    label_14:
    while (true) {
      try {
        defLine(table);
      } catch (ParseException e) {
      Token t=getToken(1);
      while (true) {
        t=getToken(0);
        if (t.kind==STR) {
          defTableLine(table);
        }
        if (t.kind==ETABLE || t.kind==EOF)
          break;
        t=getNextToken();
      }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STR:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_14;
      }
    }
  }

  final public void defLine(Table table) throws ParseException {
    line(table);
  }

  final public void line(Table table) throws ParseException {
 Row row=new Row();
    jj_consume_token(STR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attTr();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    skipToTDTHLine();
    try {
      label_15:
      while (true) {
        cell(table,row);
        skipToTDTHLine2();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STH:
        case STD:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_15;
        }
      }
      table.addRow(row);
    } catch (ParseException e) {
    table.addRow(row);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETR:
      jj_consume_token(ETR);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    skipToTRLine();
  }

  final public void cell(Table table,Row row) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STD:
      td(table,row);
      break;
    case STH:
      th(table,row);
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void td(Table table,Row row) throws ParseException {
 Hashtable ht=null;
 Vector vec=null;
 String abbr=null;
 String headers=null;
 String id=null;
 String aux=null;
    jj_consume_token(STD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      ht = attDelimiteur();
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    vec = cellData(table);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETD:
      jj_consume_token(ETD);
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
            int colspan=1;
            if (ht!=null && ht.get("colspan")!=null) {
                aux=(String)ht.get("colspan");
                try {
                  colspan=Integer.parseInt(aux);
                }
                catch (NumberFormatException e) {
                  try {
                    colspan=Integer.parseInt(aux.substring(1,aux.length()-1));
                  }
                  catch (NumberFormatException e2) {
                    colspan=1;
                  }
                }
            }

            int rowspan=1;
            if (ht!=null && ht.get("rowspan")!=null) {
                aux=(String)ht.get("rowspan");
                try {
                  rowspan=Integer.parseInt(aux);
                }
                catch (NumberFormatException e) {
                  try {
                    rowspan=Integer.parseInt(aux.substring(1,aux.length()-1));
                  }
                  catch (NumberFormatException e2) {
                    rowspan=1;
                  }
                }
            }

            if (ht!=null)
              abbr=(String)ht.get("abbr");
            if (ht!=null) {
              headers=(String)ht.get("headers");
              if (headers!=null &&
                  headers.length()>1 && headers.charAt(0)=='"')
                headers=headers.substring(1,headers.length()-1);
            }
            if (ht!=null) {
              id=(String)ht.get("id");
              if (id!=null &&
                  id.length()>1 && id.charAt(0)=='"')
                id=id.substring(1,id.length()-1);
            }

            int scope=-1;
            if (ht!=null)
              aux=(String)ht.get("scope");
            if (aux!=null) {
              if ( (aux.equalsIgnoreCase("row")) ||
                    (aux.length()>2 &&
                     aux.substring(1,aux.length()-1).equalsIgnoreCase("row"))) {
                scope=4;
              }
              else
                if ((aux.equalsIgnoreCase("col")) ||
                     (aux.length()>2 &&
                     aux.substring(1,aux.length()-1).equalsIgnoreCase("col"))) {
                  scope=3;
                }
                else
                  if ((aux.equalsIgnoreCase("colgroup")) ||
                       (aux.length()>2 &&
                       aux.substring(1,aux.length()-1).equalsIgnoreCase("colgroup"))) {
                    scope=6;
                  }
                  else
                    if ((aux.equalsIgnoreCase("rowgroup")) ||
                         (aux.length()>2 &&
                         aux.substring(1,aux.length()-1).equalsIgnoreCase("rowgroup"))) {
                      scope=5;
                    }
            }
            row.addCell(new Cell(vec,
                                 1,colspan,rowspan,
                                 abbr,scope,headers,id));
            int cpt2=colspan;
            cpt2--;
            while (cpt2!=0) {
              row.addCell(new Cell(vec,
                                 11,colspan,rowspan,
                                 abbr,scope,headers,id));
              cpt2--;
            }
  }

  final public void th(Table table,Row row) throws ParseException {
 Hashtable ht=null;
 Vector vec=null;
 String abbr=null;
 String headers=null;
 String id=null;
 String aux=null;
    jj_consume_token(STH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      ht = attDelimiteur();
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    vec = cellData(table);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ETH:
      jj_consume_token(ETH);
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
            int colspan=1;
            if (ht!=null && ht.get("colspan")!=null) {
                aux=(String)ht.get("colspan");
                try {
                  colspan=Integer.parseInt(aux);
                }
                catch (NumberFormatException e) {
                  try {
                    colspan=Integer.parseInt(aux.substring(1,aux.length()-1));
                  }
                  catch (NumberFormatException e2) {
                    colspan=1;
                  }
                }
            }

            int rowspan=1;
            if (ht!=null && ht.get("rowspan")!=null) {
                aux=(String)ht.get("rowspan");
                try {
                  rowspan=Integer.parseInt(aux);
                }
                catch (NumberFormatException e) {
                  try {
                    rowspan=Integer.parseInt(aux.substring(1,aux.length()-1));
                  }
                  catch (NumberFormatException e2) {
                    rowspan=1;
                  }
                }
            }

            if (ht!=null)
              abbr=(String)ht.get("abbr");
            if (ht!=null) {
              headers=(String)ht.get("headers");
              if (headers!=null &&
                  headers.length()>1 && headers.charAt(0)=='"')
                headers=headers.substring(1,headers.length()-1);
            }
            if (ht!=null) {
              id=(String)ht.get("id");
              if (id!=null &&
                  id.length()>1 && id.charAt(0)=='"')
                id=id.substring(1,id.length()-1);
            }

            int scope=-1;
            if (ht!=null)
              aux=(String)ht.get("scope");

            if (aux!=null) {
              if ( (aux.equalsIgnoreCase("row")) ||
                    (aux.length()>2 &&
                     aux.substring(1,aux.length()-1).equalsIgnoreCase("row"))) {
                scope=4;
              }
              else
                if ((aux.equalsIgnoreCase("col")) ||
                     (aux.length()>2 &&
                     aux.substring(1,aux.length()-1).equalsIgnoreCase("col"))) {
                  scope=3;
                }
                else
                  if ((aux.equalsIgnoreCase("colgroup")) ||
                       (aux.length()>2 &&
                       aux.substring(1,aux.length()-1).equalsIgnoreCase("colgroup"))) {
                    scope=6;
                  }
                  else
                    if ((aux.equalsIgnoreCase("rowgroup")) ||
                         (aux.length()>2 &&
                         aux.substring(1,aux.length()-1).equalsIgnoreCase("rowgroup"))) {
                      scope=5;
                    }

            }
            row.addCell(new Cell(vec,
                                 0,colspan,rowspan,
                                 abbr,scope,headers,id));
            int cpt2=colspan;
            cpt2--;
            while (cpt2!=0) {
              row.addCell(new Cell(vec,
                          10,colspan,rowspan,
                          abbr,scope,headers,id));
              cpt2--;
            }
  }

  final public Hashtable attDelimiteur() throws ParseException {
 Hashtable ht;
    ht = attlist();
          {if (true) return ht;}
    throw new Error("Missing return statement in function");
  }

  final public void attTr() throws ParseException {
    attlist();
  }

  final public void attTable(Table table) throws ParseException {
 Hashtable ht=null;
    ht = attlist();
          String s=(String)ht.get("summary");
          if (s==null)
            s="";
          table.setSummary(s);
  }

  final public void caption(Table table) throws ParseException {
 String c=null;
    jj_consume_token(SCAPTION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A_NAME:
      attCaption();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(TAGC);
    c = captionText();
    table.setCaption(c);
    try {
      jj_consume_token(ECAPTION);
    } catch (ParseException e) {
    Token t=null;
    while (true) {
      t=getToken(1);
      if (t.kind==SCOLGROUP || t.kind==STHEAD ||
          t.kind==STFOOT || t.kind==STBODY ||
          t.kind==STR || t.kind==ETABLE || t.kind==EOF)
        break;
      t=getNextToken();
    }
    }
  }

  final public void attCaption() throws ParseException {
    attlist();
  }

  final public Hashtable attlist() throws ParseException {
 Hashtable ht=new Hashtable();
    label_16:
    while (true) {
      attribute(ht);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A_NAME:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_16;
      }
    }
          {if (true) return ht;}
    throw new Error("Missing return statement in function");
  }

  final public void attribute(Hashtable ht) throws ParseException {
 String attrName=null;
 String attrValue=null;
 Token a1,a2=null;
    try {
      a1 = jj_consume_token(A_NAME);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A_EQ:
        jj_consume_token(A_EQ);
        a2 = jj_consume_token(CDATA);
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
            ht.put(a1.image.toLowerCase(),(a2!=null?a2.image:""));
    } catch (ParseException e) {
          Token t=null;
          while (true) {
            t=getToken(1);
            if (t.kind==TAGC)
              break;
            t=getNextToken();
          }
    }
  }

  final public String image() throws ParseException {
 Hashtable ht;
    jj_consume_token(IMAGE);
    ht = attlist();
    jj_consume_token(TAGC);
          //System.out.println("image");
          String s=(String)ht.get("src");
          StringBuffer sb=new StringBuffer();
          sb.append("<img src=");
          if (s!=null) {
            int begin=0;
            int end=s.length()-1;

            //System.out.println(s+"\n"+baseUrl);

            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

            StringBuffer urlAux=new StringBuffer();
            String anchorString=s.substring(begin,end+1);

            if (anchorString.length()>0) {
            if (anchorString.charAt(0)=='/') {
               if (baseUrl.substring(7).indexOf("/")==-1) {
                 urlAux.append(baseUrl+anchorString);
               }
               else {
                 //System.out.println("Probleme ici");
                 urlAux.append(baseUrl.substring(0,
                               (baseUrl.substring(7).indexOf("/")+7))+
                               anchorString);
               }
            }
            else {
              try {
                new URL(anchorString);
                urlAux.append(anchorString);
              }
              catch (MalformedURLException e) {
                if (baseUrl.indexOf(".htm")!=-1) {
                  urlAux.append(baseUrl.substring(0,baseUrl.lastIndexOf("/")
                                                    +1)+anchorString);
                }
                else {
                  if (baseUrl.charAt(baseUrl.length()-1)=='/') {
                    urlAux.append(baseUrl+anchorString);
                  }
                  else {
                    urlAux.append(baseUrl+"/"+anchorString);
                  }
                }
              }
            }
            }
            else
              urlAux.append("\"\"");

            sb.append(new String(urlAux));
          }
          else
            sb.append("\"\"");

          ht.remove("src");

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String base() throws ParseException {
 Hashtable ht;
    jj_consume_token(BASE);
    ht = attlist();
    jj_consume_token(TAGC);
          String s=(String)ht.get("href");
          StringBuffer sb=new StringBuffer();
          sb.append("<base href=");
          if (s!=null) {
              int begin=0;
              int end=s.length()-1;

            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

              baseUrl=s.substring(begin,end+1);
              if (baseUrl.lastIndexOf(".htm")!=-1)
                baseUrl=baseUrl.substring(0,
                                          baseUrl.lastIndexOf('/')+1);
              sb.append(baseUrl);
          }
          else
            sb.append("\"\"");

          ht.remove("href");
          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          //System.out.println("baseUrl: "+baseUrl);
          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String frame() throws ParseException {
 Hashtable ht;
    jj_consume_token(FRAME);
    ht = attlist();
    jj_consume_token(TAGC);
          String s=(String)ht.get("src");
          StringBuffer sb=new StringBuffer();
          sb.append("<frame src=");
          if (s!=null) {
              int begin=0;
              int end=s.length()-1;
            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

              StringBuffer urlAux=new StringBuffer();
              String anchorString=s.substring(begin,end+1);

            if (anchorString.length()>0) {
            if (anchorString.charAt(0)=='#') {
              //urlAux.append(baseUrl+anchorString);
              urlAux.append(anchorString);
            }
            else {
            if (anchorString.charAt(0)=='/') {
               if (baseUrl.substring(7).indexOf("/")==-1) {
                 urlAux.append(baseUrl+anchorString);
               }
               else {
                 urlAux.append(baseUrl.substring(0,
                               (baseUrl.substring(7).indexOf("/")+7))+
                               anchorString);
               }
            }
            else {
              try {
                new URL(anchorString);
                urlAux.append(anchorString);
              }
              catch (MalformedURLException e) {
                if (baseUrl.indexOf(".htm")!=-1) {
                  urlAux.append(baseUrl.substring(0,baseUrl.lastIndexOf("/")
                                                    +1)+anchorString);
                }
                else {
                  if (baseUrl.charAt(baseUrl.length()-1)=='/') {
                    urlAux.append(baseUrl+anchorString);
                  }
                  else {
                    urlAux.append(baseUrl+"/"+anchorString);
                  }
                }
              }
            }
            }
            }
            else
              urlAux.append(baseUrl);
              sb.append(cgiUrl+"?url="+
                        Tools.codeString(new String(urlAux))+
                        "&amp;tableno="+tableNumber+
                        "&amp;orient="+(orientation==0?"row":orientation==1?"col":"mark")+
                        "&amp;recurs="+(recurs==1?"yes":"no")+
                        "&amp;interact="+interact+
                        "&amp;repeat="+repeat+
                        "&amp;cellSeparator="+Tools.codeString(cellSeparator)+
                        "&amp;headerSeparator="+Tools.codeString(headerSeparator)+
                        "&amp;valueSeparator="+Tools.codeString(valueSeparator)+
                        "&amp;embedded="+(embedded==1?"yes":"no")+
                        "&amp;submit=Submit");
          }
          else
              sb.append("\"\"");

          ht.remove("src");

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String anchor() throws ParseException {
 Hashtable ht;
    jj_consume_token(ANCHOR);
    ht = attlist();
    jj_consume_token(TAGC);
          String s=(String)ht.get("href");
          StringBuffer sb=new StringBuffer();
          sb.append("<a href=");
          if (s!=null) {
              int begin=0;
              int end=s.length()-1;
            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

              StringBuffer urlAux=new StringBuffer();
              String anchorString=s.substring(begin,end+1);
        if (anchorString.length()>0) {
            if (anchorString.charAt(0)=='#') {
              //urlAux.append(baseUrl+anchorString);
              urlAux.append(anchorString);
            }
            else {
            if (anchorString.charAt(0)=='/') {
               if (baseUrl.substring(7).indexOf("/")==-1) {
                 urlAux.append(baseUrl+anchorString);
               }
               else {
                 urlAux.append(baseUrl.substring(0,
                               (baseUrl.substring(7).indexOf("/")+7))+
                               anchorString);
               }
            }
            else {
              try {
                new URL(anchorString);
                urlAux.append(anchorString);
              }
              catch (MalformedURLException e) {
                if (baseUrl.indexOf(".htm")!=-1) {
                  urlAux.append(baseUrl.substring(0,baseUrl.lastIndexOf("/")
                                                    +1)+anchorString);
                }
                else {
                  if (baseUrl.charAt(baseUrl.length()-1)=='/') {
                    urlAux.append(baseUrl+anchorString);
                  }
                  else {
                    urlAux.append(baseUrl+"/"+anchorString);
                  }
                }
              }
            }
            }
            }
            else
              urlAux.append(baseUrl);


            if (urlAux.charAt(0)!='#' &&
                (new String(urlAux)).substring(0,7).equalsIgnoreCase("http://")) {
            if (lynx==1)
              sb.append("x"+new String(urlAux));
            else
              if (recurs==1 && Tools.recursePossible(urlAux))
                sb.append(cgiUrl+"?url="+
                        Tools.codeString(new String(urlAux))+
                        "&amp;tableno="+tableNumber+
                        "&amp;orient="+(orientation==0?"row":orientation==1?"col":"mark")+
                        "&amp;recurs="+(recurs==1?"yes":"no")+
                        "&amp;interact="+interact+
                        "&amp;repeat="+repeat+
                        "&amp;cellSeparator="+Tools.codeString(cellSeparator)+
                        "&amp;headerSeparator="+Tools.codeString(headerSeparator)+
                        "&amp;valueSeparator="+Tools.codeString(valueSeparator)+
                        "&amp;embedded="+(embedded==1?"yes":"no")+
                        "&amp;submit=Submit");
              else
                sb.append(new String(urlAux));

          }
          else {
            sb.append(urlAux);
          }
          }
          else
              sb.append("\"\"");

          ht.remove("href");

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String object() throws ParseException {
 Hashtable ht;
    jj_consume_token(OBJECT);
    ht = attlist();
    jj_consume_token(TAGC);
          StringBuffer sb=new StringBuffer();
          sb.append("<object ");
          String s=(String)ht.get("codebase");
          if (s==null) {
            if (baseUrl.indexOf(".htm")!=-1)
              ht.put("codebase",baseUrl.substring(0,
                                                  baseUrl.lastIndexOf("/")+1));
            else
              ht.put("codebase",baseUrl);
          }

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }
          sb.append(">");
          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String applet() throws ParseException {
 Hashtable ht;
    jj_consume_token(APPLET);
    ht = attlist();
    jj_consume_token(TAGC);
          StringBuffer sb=new StringBuffer();
          sb.append("<APPLET ");
          String s=(String)ht.get("codebase");
          if (s==null) {
            if (baseUrl.indexOf(".htm")!=-1)
              ht.put("codebase",baseUrl.substring(0,
                                                  baseUrl.lastIndexOf("/")+1));
            else
              ht.put("codebase",baseUrl);
          }

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }
          sb.append(">");
          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String area() throws ParseException {
 Hashtable ht;
    jj_consume_token(AREA);
    ht = attlist();
    jj_consume_token(TAGC);
          StringBuffer sb=new StringBuffer();
          sb.append("<area ");
          resolveURI(ht,baseUrl,"href",sb);

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }
          sb.append(">");
          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  void resolveURI(Hashtable ht,String objectCodeBase,String element,
                StringBuffer sb) throws ParseException {
  String s=(String)ht.get(element);
  if (s!=null && s.length()>0) {
    int begin=0;
    int end=s.length()-1;
            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

    StringBuffer urlAux=new StringBuffer();
    String anchorString=s.substring(begin,end+1);

    if (anchorString.length()>0) {
    if (anchorString.charAt(0)=='#') {
      //urlAux.append(objectCodeBase+anchorString);
        urlAux.append(anchorString);
    }
    else {
      if (anchorString.charAt(0)=='/') {
        if (objectCodeBase.substring(7).indexOf("/")==-1) {
                 urlAux.append(objectCodeBase+anchorString);
        }
        else {
          urlAux.append(objectCodeBase.substring(0,
                               (objectCodeBase.substring(7).indexOf("/")+7))+
                        anchorString);
        }
      }
      else {
        try {
          new URL(anchorString);
          urlAux.append(anchorString);
        }
        catch (MalformedURLException e) {
          if (objectCodeBase.indexOf(".htm")!=-1) {
            urlAux.append(objectCodeBase.substring(0,
                                                   objectCodeBase.lastIndexOf("/")+1)
                          +anchorString);
          }
          else {
            if (objectCodeBase.charAt(objectCodeBase.length()-1)=='/') {
              urlAux.append(objectCodeBase+anchorString);
            }
            else {
              urlAux.append(objectCodeBase+"/"+anchorString);
            }
          }
        }
      }
    }
    }
    else
      urlAux.append(baseUrl);

            if (urlAux.charAt(0)!='#' &&
                (new String(urlAux)).substring(0,7).equalsIgnoreCase("http://")) {

            if (lynx==1)
              sb.append(element+"=x"+new String(urlAux)+" ");
            else
              if (recurs==1)
                sb.append(element+"="+cgiUrl+"?url="+
                        Tools.codeString(new String(urlAux))+
                        "&amp;tableno="+tableNumber+
                        "&amp;orient="+(orientation==0?"row":orientation==1?"col":"mark")+
                        "&amp;recurs="+(recurs==1?"yes":"no")+
                        "&amp;interact="+interact+
                        "&amp;repeat="+repeat+
                        "&amp;cellSeparator="+Tools.codeString(cellSeparator)+
                        "&amp;headerSeparator="+Tools.codeString(headerSeparator)+
                        "&amp;valueSeparator="+Tools.codeString(valueSeparator)+
                        "&amp;embedded="+(embedded==1?"yes":"no")+
                        "&amp;submit=Submit ");
                else
                  sb.append(element+"="+new String(urlAux));
          }
          else {
            sb.append(element+"="+urlAux);
          }

  }

  ht.remove(element);
  }

  final public String link() throws ParseException {
 Hashtable ht;
    jj_consume_token(LINK);
    ht = attlist();
    jj_consume_token(TAGC);
          String s=(String)ht.get("href");
          StringBuffer sb=new StringBuffer();
          sb.append("<link href=");
          if (s!=null) {
              int begin=0;
              int end=s.length()-1;

            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

              StringBuffer urlAux=new StringBuffer();
              String anchorString=s.substring(begin,end+1);
            if (anchorString.length()>0) {
            if (anchorString.charAt(0)=='#') {
              //urlAux.append(baseUrl+anchorString);
              urlAux.append(anchorString);
            }
            else {
            if (anchorString.charAt(0)=='/') {
               if (baseUrl.substring(7).indexOf("/")==-1) {
                 urlAux.append(baseUrl+anchorString);
               }
               else {
                 urlAux.append(baseUrl.substring(0,
                               (baseUrl.substring(7).indexOf("/")+7))+
                               anchorString);
               }
            }
            else {
              try {
                new URL(anchorString);
                urlAux.append(anchorString);
              }
              catch (MalformedURLException e) {
                if (baseUrl.indexOf(".htm")!=-1) {
                  urlAux.append(baseUrl.substring(0,baseUrl.lastIndexOf("/")
                                                    +1)+anchorString);
                }
                else {
                  if (baseUrl.charAt(baseUrl.length()-1)=='/') {
                    urlAux.append(baseUrl+anchorString);
                  }
                  else {
                    urlAux.append(baseUrl+"/"+anchorString);
                  }
                }
              }
            }
            }
            }
            else
              urlAux.append(baseUrl);

            if (urlAux.charAt(0)!='#' &&
                (new String(urlAux)).substring(0,7).equalsIgnoreCase("http://")) {

            if (lynx==1)
              sb.append("x"+new String(urlAux));
            else
              if (recurs==1 && Tools.recursePossible(urlAux))
                sb.append(cgiUrl+"?url="+
                        Tools.codeString(new String(urlAux))+
                        "&amp;tableno="+tableNumber+
                        "&amp;orient="+(orientation==0?"row":orientation==1?"col":"mark")+
                        "&amp;recurs="+(recurs==1?"yes":"no")+
                        "&amp;interact="+interact+
                        "&amp;repeat="+repeat+
                        "&amp;cellSeparator="+Tools.codeString(cellSeparator)+
                        "&amp;headerSeparator="+Tools.codeString(headerSeparator)+
                        "&amp;valueSeparator="+Tools.codeString(valueSeparator)+
                        "&amp;embedded="+(embedded==1?"yes":"no")+
                        "&amp;submit=Submit");
                else
                  sb.append(new String(urlAux));
          }
          else {
            sb.append(urlAux);
          }
          }
          else
              sb.append("\"\"");

          ht.remove("href");

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  final public String form() throws ParseException {
 Hashtable ht;
    jj_consume_token(FORM);
    ht = attlist();
    jj_consume_token(TAGC);
          String s=(String)ht.get("action");
          StringBuffer sb=new StringBuffer();
          sb.append("<form action=");
          if (s!=null) {
              int begin=0;
              int end=s.length()-1;

            if (s.charAt(begin)=='"' || s.charAt(begin)=='\'')
              begin++;
            else
              if (s.charAt(begin)=='\\' && s.length()>1 &&
                  s.charAt(begin+1)=='"')
              begin+=2;
            if (s.charAt(end)=='"' || s.charAt(end)=='\'')
              end--;
            if (end>-1)
              if (s.charAt(end)=='\\')
                end--;

              StringBuffer urlAux=new StringBuffer();
              String anchorString=s.substring(begin,end+1);
            if (anchorString.length()>0) {
            if (anchorString.charAt(0)=='/') {
               if (baseUrl.substring(7).indexOf("/")==-1) {
                 urlAux.append(baseUrl+anchorString);
               }
               else {
                 urlAux.append(baseUrl.substring(0,
                               (baseUrl.substring(7).indexOf("/")+7))+
                               anchorString);
               }
            }
            else {
              try {
                new URL(anchorString);
                urlAux.append(anchorString);
              }
              catch (MalformedURLException e) {
                if (baseUrl.indexOf(".htm")!=-1) {
                  urlAux.append(baseUrl.substring(0,baseUrl.lastIndexOf("/")
                                                    +1)+anchorString);
                }
                else {
                  if (baseUrl.charAt(baseUrl.length()-1)=='/') {
                    urlAux.append(baseUrl+anchorString);
                  }
                  else {
                    urlAux.append(baseUrl+"/"+anchorString);
                  }
                }
              }
            }
            }
            else
              urlAux.append("\"\"");
            sb.append(new String(urlAux));
          }
          else
              sb.append("\"\"");

          ht.remove("action");

          Enumeration e=ht.keys();
          while (e.hasMoreElements()) {
            String key=(String)e.nextElement();
            sb.append(" "+key+"="+ht.get(key));
          }

          sb.append(">");

          {if (true) return new String(sb);}
    throw new Error("Missing return statement in function");
  }

  Table correctTable() throws ParseException {
  if (getToken(1).kind==STABLE) {
    currentTable++;
    if (tableNumber==0 || tableNumber==currentTable)
      return table();
    else {
      getNextToken();
      try {
        fw.write("<table ");
      }
      catch (IOException e) {
        /* nothing to do */
      }
    }
  }
  return null;
  }

  Vector cellData(Table table) throws ParseException {
  Vector v=new Vector();
  v.addElement(Tools.filterString(cellValue()));
  while (getToken(1).kind==STABLE) {
    //System.out.println("Recurse TABLE");
    v.addElement(cellTable());
    v.addElement(Tools.filterString(cellValue()));
  }
  return v;
  }

  Table cellTable() throws ParseException {
    //System.out.println("Ok recursive table");
    return table();
  }

  String cellValue() throws ParseException {
  Token t=null;
  StringBuffer sb=new StringBuffer(16);

  if (!dataOutOfBounds.equals("")) {
    sb.append(dataOutOfBounds);
    dataOutOfBounds=new StringBuffer("");
  }

  while (true) {
    t=getToken(1);
    if (t.kind==ANCHOR) {
      if (recurs==1 || (embedded==1 && !baseUrl.equals(""))) {
        // if recursive mode is active 
        // it's necessary to call anchor method to
        // modify the anchor
        sb.append(anchor());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }
    if (t.kind==FORM) {
      if (embedded==1 && !baseUrl.equals("")) {
        sb.append(form());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==LINK) {
      if (recurs==1 || (embedded==1 && !baseUrl.equals(""))) {
        // if recursive mode is active 
        // it's necessary to call anchor method to
        // modify the anchor
        sb.append(link());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==AREA) {
      if (recurs==1 || (embedded==1 && !baseUrl.equals(""))) {
        sb.append(area());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==OBJECT) {
      if (recurs==1 || (embedded==1 && !baseUrl.equals(""))) {
        sb.append(object());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==APPLET) {
      if (embedded==1 && !baseUrl.equals("")) {
        sb.append(applet());
      }
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==IMAGE) {
      if (embedded==1 && !baseUrl.equals(""))
        sb.append(image());
      else {
        sb.append(t.image+" ");
        t=getNextToken();
      }
      continue;
    }

    if (t.kind==ETH || t.kind==ETD || t.kind==ETR || t.kind==ETHEAD ||
        t.kind==ETFOOT || t.kind==ETBODY ||
        t.kind==STH || t.kind==STD || t.kind==STR || t.kind==STHEAD ||
        t.kind==STFOOT || t.kind==STBODY ||
        t.kind==ETABLE || t.kind==STABLE || t.kind==EOF)
      break;
    sb.append(t.image+(t.image.equals("<")?"":" "));
    t=getNextToken();
  }
  /*System.out.println("Cell Value:"+new String(sb));*/
  return noNewLine(new String(sb));
  }

  String noNewLine(String value) throws ParseException {
  StringBuffer sb=new StringBuffer(value);
  int index;
  char c;

  for (index=0;index<sb.length();index++)
    if (sb.charAt(index)=='\n' || sb.charAt(index)=='\r')
      sb.setCharAt(index,' ');

  for (index=0;index<sb.length();index++)
    if (sb.charAt(index)=='<' && (index+3)<sb.length()) {
      if ((sb.charAt(index+1)=='B' || sb.charAt(index+1)=='b') &&
          (sb.charAt(index+2)=='R' || sb.charAt(index+2)=='r')) {
        int index2=index+3;
        while (sb.charAt(index2)!='>' && index2<sb.length())
          index2++;
        if (index2<sb.length())
          sb=replace(sb,index,index2+1," ");
      }
    }

  return new String(sb);
  }

  String captionText() throws ParseException {
  StringBuffer sb=new StringBuffer();
        Token t=null;
        while (true) {
            t=getToken(1);
            // return the string when it found ECAPTION (normal case)
            // The other token are used when the table isn't correct
            // (to continue the processing in a "good" condition
            if (t.kind==ECAPTION || t.kind==EOF ||
                t.kind==SCOLGROUP || t.kind==STHEAD ||
                t.kind==STFOOT || t.kind==STBODY || t.kind==STR ||
                t.kind==ETABLE)
                break;
            sb.append(t.image);
            t=getNextToken();
        }
        return new String(sb);
  }

  void skipToTable() throws ParseException {
  StringBuffer sb=new StringBuffer();

        try {
          Token t=null;
          while (true) {
            t=getToken(1);
            // only search the anchor token if 
            // recurse mode active
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==FRAME && recurs==1) {
              sb.append(frame());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
            if (t.kind==STABLE || t.kind==EOF)
                break;
            sb.append(t.image);
            if (t.kind!=PCDATA && t.kind!=STAGO)
              sb.append(" "); /* add a space for the space skip */
            t=getNextToken();
          }
          fw.write(new String(sb));
          fw.flush();
        }
        catch (IOException e) {
          return;
        }
        catch (TokenMgrError e) {
          return;
        }
  }

  void skipToTRHead() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STR || t.kind==STBODY ||
        t.kind==STFOOT || t.kind==ETABLE || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTRFoot() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STR || t.kind==STBODY || t.kind==ETFOOT ||
        t.kind==EOF || t.kind==ETABLE)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTRBody() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STR || t.kind==STBODY ||
        t.kind==ETABLE || t.kind==ETBODY || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHHead() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==STFOOT || t.kind==STBODY || t.kind==ETHEAD ||
        t.kind==ETABLE || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHHead2() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETR || t.kind==EOF || t.kind==ETABLE ||
        t.kind==STFOOT || t.kind==STBODY || t.kind==ETHEAD)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHFoot() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==STBODY || t.kind==ETFOOT || t.kind==ETABLE ||
        t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHFoot2() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETR || t.kind==ETABLE || t.kind==EOF ||
        t.kind==STBODY || t.kind==ETFOOT)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHBody() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETABLE || t.kind==STBODY || t.kind==ETBODY ||
        t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHBody2() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETR || t.kind==EOF ||
        t.kind==ETABLE || t.kind==STBODY || t.kind==ETBODY)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHLine() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETABLE || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTDTHLine2() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STD || t.kind==STH || t.kind==STR ||
        t.kind==ETR ||
        t.kind==ETABLE || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  void skipToTRLine() throws ParseException {
  StringBuffer sb=new StringBuffer();
  Token t=null;
  while (true) {
    t=getToken(1);
            if (t.kind==ANCHOR && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(anchor());
              continue;
            }

            if (t.kind==AREA && (recurs==1 || (embedded==1 &&
                                                !baseUrl.equals("")))) {
              sb.append(area());
              continue;
            }

            if (t.kind==OBJECT && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(object());
              continue;
            }

            if (t.kind==APPLET && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(applet());
              continue;
            }

            if (t.kind==LINK && (recurs==1 || (embedded==1 &&
                                                 !baseUrl.equals("")))) {
              sb.append(link());
              continue;
            }

            if (t.kind==FORM && (embedded==1 && !baseUrl.equals(""))) {
              sb.append(form());
              continue;
            }

            if (t.kind==BASE) {
              sb.append(base());
              continue;
            }

            if (t.kind==IMAGE && embedded==1 && !baseUrl.equals("")) {
              sb.append(image());
              continue;
            }
    if (t.kind==STR || t.kind==ETABLE || t.kind==EOF)
      break;
            sb.append(t.image);
    t=getNextToken();
  }
  dataOutOfBounds.append(sb);
  }

  StringBuffer replace(StringBuffer sb,int start, int end,
                                  String str) throws ParseException {
        StringBuffer other=new StringBuffer();
        for (int cpt=0;cpt<start;cpt++)
          other.append(sb.charAt(cpt));
        other.append(str);
        for (int cpt=end;cpt<sb.length();cpt++)
          other.append(sb.charAt(cpt));
        return other;
  }

  public html4TokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[40];
  final private int[] jj_la1_0 = {0x0,0x0,0x8000,0x4000,0x0,0x10000,0x800000,0x800000,0x800000,0x800000,0x0,0x2000000,0x100000,0x0,0x2000000,0x400000,0x0,0x2000000,0x1000000,0x0,0x28000000,0x4000000,0x0,0x28000000,0x4000000,0x0,0x28000000,0x4000000,0x2000000,0x0,0x28000000,0x4000000,0x28000000,0x0,0x40000000,0x0,0x10000000,0x0,0x0,0x0,};
  final private int[] jj_la1_1 = {0x80,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x80,0x0,0x80,0x0,0x80,0x80,0x8,};

  public html4(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new html4TokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  public html4(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new html4TokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  public html4(html4TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  public void ReInit(html4TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 40; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[41];
    for (int i = 0; i < 41; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 40; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 41; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
