package org.w3c.wai.tablin.filter.tag;

import org.w3c.wai.tablin.filter.exception.*;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * Cette classe va permettre de lire dans un fichier 
 * les tags qu'il faudra reconnaitre pour qu'ils
 * subissent des transformations.
 
 * A completer
 */


public class TagDeclaration {

    private BufferedReader br=null;
    private Hashtable tagList=null;

    public TagDeclaration(String tagFile) 
	throws FileNotFoundException,TagInitError {

	br=new BufferedReader(new FileReader(tagFile));
	tagList=new Hashtable();
	initTag();
    }
 

    private void initTag() throws TagInitError {
	try {
	    String line=null;
	    StringTokenizer st=null;
	    while (true) {
		line=br.readLine();
		if (line==null) 
		    return;
		st=new StringTokenizer(line);
		if (st.countTokens()!=2)
		    throw new TagInitError("Bad format in tag.dec file.");
		addTag(st.nextToken().toLowerCase(),
		       st.nextToken());
	    }
	}
	catch (IOException e) {
	    throw new TagInitError("Problem reading tag.dec file.");
	}
    }


    /**
     * Rajoute dans la hastable un couple tag-class qui 
     * va permettre quand on rencontre le tag
     * de charger la classe qui correspond a son traitement.
     */
    public void addTag(String key,
		       String value) {
	tagList.put(key.toLowerCase(),
		    value);
    }


    /**
     * Permet d'enlever un tag de la hastable.
     * On ne tiendra plus compte de ce tag si on
     * le rencontre a nouveau et si on ne le 
     * rajoute pas.
     */
    public void deleteTag(String key) {
	tagList.remove(key);
    }
    

    public void isTag(StringBuffer tagBuffer) 
	throws FilterTagFound,FilterTagNotFound {

	String key=null;

	if (tagBuffer.charAt(tagBuffer.length()-1)!='>')
	    key=(new String(tagBuffer)).substring(0,tagBuffer.length()-1);
	else
	    key=new String(tagBuffer);

	key=key.toLowerCase();

	String value=(String)tagList.get(key);
	if (value==null) {
	    key=(new String(tagBuffer)).substring(0,tagBuffer.length()-1);
	    key=key.toLowerCase();
	    value=(String)tagList.get(key);
	    if (value==null)
		throw new FilterTagNotFound(key);
	    else
		throw new FilterTagFound(key,value);
	}
	else
	    throw new FilterTagFound(key,value);
    }

    public String toString() {
	return tagList.toString();
    }

    static public void main(String argv[]) {
	try {
	    TagDeclaration td=new TagDeclaration("");
	    System.out.println(td);
	}
	catch (Exception e) {
	    System.out.println(e);
	}
    }

    
    public boolean isPresent(String key) {
	if (tagList.get(key)==null)
	    return false;
	else 
	    return true;
    }


}
