package org.w3c.wai.tablin.filter.engine;

import org.w3c.wai.tablin.filter.tag.*;
import org.w3c.wai.tablin.filter.exception.*;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.FileNotFoundException;

public class TokenManager {
    
    //==================== Declaration des attributs =============
    /**
     * Le stream de lecture de la page html
     */
    private InputStream is=null;
    /**
     * Le buffer qui sert a recuperer les caracteres de la 
     * page web.
     */
    private StringBuffer buffer=null;
    /**
     * Le buffer qui va permettre de recuperer les infos a traiter sur 
     * l'eventuel tag a traiter
     */
    private StringBuffer tagBuffer=null;
    /**
     * Contient les tags qu'il faudra traiter avec 
     */
    private TagDeclaration td=null;
    
    private StringBuffer recup=null;
    private int offsetStart;
    private int offsetEnd;

    
    //================= Declaration des constructeurs ============    

    public TokenManager(InputStream is,
			String tagFile)
	throws FileNotFoundException, TagInitError {

	this.is=is;
	td=new TagDeclaration(tagFile);
	buffer=new StringBuffer();
	recup=new StringBuffer();
	recup.setLength(0);
	offsetStart=0;
	offsetEnd=0;
    }

    
    //===================== Declaration des methodes =============

    /**
     * On stocke dans le buffer tous les caracteres
     * rencontres, jusqu'au debut du prochain tag ou 
     * jusqu'a la fin du stream.
     */
    public void nextToken() 
	throws FilterEOF,FilterTagFound, FilterError {
	int car=0;
	buffer=new StringBuffer();
	byte[] buff=new byte[512];

	//System.out.println("nextToken");


	if (offsetEnd!=0) {
	    // on avait trouve un token avant...
	    // faut penser a l'eliminer
	    recup=new StringBuffer(recup.toString().substring(offsetEnd));
	    offsetEnd=0;
	}
	
	offsetStart=0;
	while (true) {
	    if (offsetStart==recup.length()) {
		//System.out.println("On doit en reprendre");
		buffer.append(recup);
		recup.setLength(0);
		offsetStart=0;
		try {
		    car=is.read(buff);
		    //System.out.println(new String(buff));
		}
		catch (IOException e) {
		    throw 
			new FilterError("Problem in TokenManager."+
					"nextToken().");
		}	    
		if (car==-1)
		    throw new FilterEOF("End of file (done)");
		recup.append(new String(buff));
		continue;
	    }
	
	    if (recup.charAt(offsetStart)=='<') {
		buffer.append(recup.toString().substring(0,offsetStart));
		recup=new StringBuffer(recup.toString().
				       substring(offsetStart));
		offsetStart=0;
		try {
		    searchPossibleToken();
		}
		catch(FilterTagNotFound e) {
		    buffer.append(recup.toString().
				  substring(offsetStart,offsetEnd));
		    recup=new StringBuffer(recup.toString().
					   substring(offsetEnd));
		    offsetStart=0;
		    continue;
		}
	    }
	    offsetStart++;
	}
    }


    /**
     * On vient de reconcontrer un '<'.
     * On va chercher a savoir si il y a un tag 
     * a transformer. Pour se faire on va chercher un un 
     * token (s'arreter au premier caractere qui pourra donner 
     * un token et ensuite a l'aide de la classe tag nous verrons
     * si le tag trouver doit etre traite ou pas.
     */
    private void searchPossibleToken() 
	throws FilterTagFound, FilterTagNotFound, FilterEOF, FilterError {

	int car=0;
	byte[] buff=new byte[512];
	offsetEnd=offsetStart;

	while (true) {
	    if (offsetEnd==recup.length()) {
		try {
		    car=is.read(buff);
		}
		catch (IOException e) {
		    throw new FilterError("Problem in TokenManager."+
					  "searchPossibleToken().");
		}
		if (car==-1) {
		    buffer.append(recup);
		    throw new FilterEOF("End of file (done).");
		}
		recup.append(new String(buff));
		continue;
	    }

	    if (recup.charAt(offsetEnd)==' ' ||
		recup.charAt(offsetEnd)=='\n' ||
		recup.charAt(offsetEnd)=='\t' ||
		recup.charAt(offsetEnd)=='\r' ||
		recup.charAt(offsetEnd)=='>') {
		offsetEnd++;
		break;
	    }

	    offsetEnd++;
	}
	
	tagBuffer=new StringBuffer(recup.toString().substring(offsetStart,
							      offsetEnd));
	//System.out.println("tag="+tagBuffer+"=");
	td.isTag(tagBuffer);
    }

    public void endTag() 
	throws FilterError, FilterEOF {
	int car=0;
	byte[] buff=new byte[512];

	buffer.setLength(0);
	if (tagBuffer.charAt(tagBuffer.length()-1)=='>') {
	    //offsetEnd++;
	    return;
	}

	while (true) {
	    if (offsetEnd==recup.length()) {
		try {
		    car=is.read(buff);
		}
		catch (IOException e) {
		    throw new FilterError("Problem in TokenManager."+
					  "endTag().");
		}
		if (car==-1) {
		    buffer.append(tagBuffer);
		    throw new FilterEOF("End of file (done).");
		}
		recup.append(new String(buff));
		continue;
	    }
	    tagBuffer.append((char)recup.charAt(offsetEnd));
	    if (recup.charAt(offsetEnd)=='>') {
		offsetEnd++;
		break;
	    }
	    offsetEnd++;
	}
    }

    
    /**
     * N'est utilise que par HTMLComment.
     */
    public void endTagComment() 
	throws FilterError, FilterEOF {
	int car=0;
	byte[] buff=new byte[512];

	buffer.setLength(0);
	if (tagBuffer.charAt(tagBuffer.length()-1)=='>')
	    if (tagBuffer.length()>=7) 
		if (tagBuffer.charAt(tagBuffer.length()-2)=='-' &&
		    tagBuffer.charAt(tagBuffer.length()-3)=='-') {
		    //offsetEnd++;
		    return;
		}

	
	while (true) {
	    if (offsetEnd==recup.length()) {
		try {
		    car=is.read(buff);
		}
		catch (IOException e) {
		    throw new FilterError("Problem in TokenManager."+
					  "endTag().");
		}
		if (car==-1) {
		    buffer.append(tagBuffer);
		    throw new FilterEOF("End of file (done).");
		}
		recup.append(new String(buff));
		continue;
	    }
	    tagBuffer.append((char)recup.charAt(offsetEnd));
	    if (recup.charAt(offsetEnd)=='>') {
		if (tagBuffer.length()>=7) 
		    if (tagBuffer.charAt(tagBuffer.length()-2)=='-' &&
			tagBuffer.charAt(tagBuffer.length()-3)=='-') {
			offsetEnd++;
			break;
		    }		
	    }
	    offsetEnd++;
	}
    }


    /**
     * Permet de rajouter dans la declaration des
     * tags a gerer d'autres tags 
     * qui n'etaient pas present dans le fichier
     * tag.dec.
     */
    public void addTag(String key,String value) {
	td.addTag(key,value);
    }


    /**
     * Permet d'enlever dans la declaration des
     * tags a gerer d'autres tags 
     * qui etaient deja present
     */
    public void deleteTag(String key) {
	td.deleteTag(key);
    }
     

    public String getBuffer() {
	return new String(buffer);
    }

    public StringBuffer getTagBuffer() {
	return tagBuffer;
    }

    
    /**
     * On demande si ce tag est actif
     * (present dans la hastable du l'attribut td)
     */
    public boolean isPresent(String key) {
	return td.isPresent(key);
    }

}
