package org.w3c.wai.tablin.filter.engine;

import java.io.OutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;


/**
 * Cette classe va permettre de stocker les 
 * options de l'application. Une instance sera passee en parametre 
 * aux classes qui implementent les tags.
 * Il sera donc facile de rajouter une option en parametre et de la
 * deployer dans le reste de l'application.
 */
public class Parameters {
    
    /**
     * Il s'agit de la base de l'url
     * qui va permettre de corriger les adresses
     * relatives. (e.g http://www.w3.org/WAI/ER/IG/index.html
     * => http://www.w3.org/WAI/ER/IG/)
     */
    private String baseUrl=null;
    /**
     * Une stream qui va nous permettre de restituer la page 
     * une fois transformee.
     */
    private BufferedWriter bw=null;
    /**
     * Ce nombre indique la table a linearizer dans le 
     * document html. Si ce nombre est 0, alors toutes les 
     * tables devront etre linezrizees (le nombre doit etre
     * >=0).
     */
    private int tableNumber;
    /**
     * Ici on choisit si on va afficher les entetes colonne avant les 
     * entetes lignes.
     */
    private int orientation;
    private int repeat;
    private int recurs;
    private int interact;
    private String headerSeparator=null;
    private String valueSeparator=null;
    private String lineSeparator=null;
    private String cellSeparator=null;
    /**
     * Permet de faire fonctionner le mode recursif.
     * Il donne l'url ou l'on peut trouver une servlet 
     * tablin qui pourra etre utiliser pour linearizer les 
     * tables dans un document html.
     * (e.g http://www.jigsaw.org/servlet/tablin)
     */
    private String cgiUrl=null;
    private int lynx;
    /**
     * Si on active cette option on va modifier toutes les url
     * qui ne sont pas absolu, de facon a faire en sorte qu'elle 
     * fonctionne encore apres le passage de tablin. Pour cela on va 
     * se servir de l'option base.
     */
    private int embedded;


    public Parameters(String baseUrl,
		      OutputStream os,
		      int tableNumber,
		      int orientation,
		      int repeat,
		      int recurs,
		      int interact,
		      String headerSeparator,
		      String valueSeparator,
		      String cellSeparator,
		      String lineSeparator,		     
		      String cgiUrl,
		      int lynx,
		      int embedded) {
	
	this.baseUrl=baseUrl;
	bw=new BufferedWriter(new OutputStreamWriter(os));
	this.tableNumber=tableNumber;
	this.orientation=orientation;
	this.repeat=repeat;
	this.recurs=recurs;
	this.interact=interact;
	this.headerSeparator=headerSeparator;
	this.valueSeparator=valueSeparator;
	this.cellSeparator=cellSeparator;
	this.lineSeparator=lineSeparator;
	this.cgiUrl=cgiUrl;
	this.lynx=lynx;
	this.embedded=embedded;
    }


    // Les differents accesseurs

    public String getBase() {
	return baseUrl;
    }


    public int getRecurs() {
	return recurs;
    }

    public int getRepeat() {
	return repeat;
    }
    
    public String getCGIUrl() {
	return cgiUrl;
    }


    public int getEmbedded() {
	return embedded;
    }

    
    public int getLynx() {
	return lynx;
    }

    public BufferedWriter getBW() {
	return bw;
    }

    public int getInteract() {
	return interact;
    }

    public int getTableNumber() {
	return tableNumber;
    }

    public void setBase(String base) {
	baseUrl=base;
    }

    public int getOrient() {
	return orientation;
    }

    public String getCellSeparator() {
	return cellSeparator;
    }

    public String getHeaderSeparator() {
	return headerSeparator;
    }

    public String getValueSeparator() {
	return valueSeparator;
    }

    public String getLineSeparator() {
	return lineSeparator;
    }

}
