package org.w3c.wai.tablin.filter.engine;

import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.filter.tag.*;
import org.w3c.wai.tablin.filter.addon.*;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.lang.reflect.*;

/**
 * Cette classe va permettre de filtrer une page html et 
 * d'executer les transformations necessaires sur ces tags.
 * 
 */

public class FilterTag {
    /**
     * Va permettre de recuperer les tokens et 
     * donc de lancer les regles appropriees pour 
     * executer les transformations.
     */
    private TokenManager tm=null;
    /**
     * On stocke les differentes options de tablin
     * qui pourront etre utilisees par la suite dans une 
     * instance quelconque du programme.
     */
    private Parameters param=null;
    Class[] parameter=new Class[1];
    Object objParameter[]=new Object[1];

    public FilterTag(String baseUrl,
		     InputStream is,
		     OutputStream os,
		     int tableNumber,
		     int orientation,
		     int repeat,
		     int recurs,
		     int interact,
		     String headerSeparator,
		     String valueSeparator,
		     String cellSeparator,
		     String lineSeparator,		     
		     String cgiUrl,
		     int lynx,
		     int embedded,
		     String tagFile) {


	param=new Parameters(baseUrl,
			     os,
			     tableNumber,
			     orientation,
			     repeat,
			     recurs,
			     interact,
			     headerSeparator,
			     valueSeparator,
			     cellSeparator,
			     lineSeparator,
			     cgiUrl,
			     lynx,
			     embedded);
	try {
	    tm=new TokenManager(is,tagFile);
	}
	catch (FileNotFoundException e) {
	    System.out.println(e);
	    return;
	}
	catch (TagInitError e) {
	    System.out.println(e);
	    return;	    
	}
	try {
	    processFiltering();
	}
	catch (FilterError e) {
	    System.out.println(e);
	    return;
	}
	catch (FilterEOF e) {
	    try {
		param.getBW().write(tm.getBuffer());
		param.getBW().flush();
		//System.out.println(tm.getBuffer());
		return;
	    }
	    catch (IOException eio) {
		return;
	    }

	}
	catch (IOException ioex) {
	    // On ne peut rien afficher...
	    // on a deja eu une exception sur le flux de sortie
	    return;
	}
    }


    
    private void processFiltering() 
	throws FilterEOF,FilterError, IOException {
	while (true) {
	    try {
		tm.nextToken();
	    }
	    catch (FilterTagFound e) {
		param.getBW().write(tm.getBuffer());
		param.getBW().flush();
		//System.out.println(tm.getBuffer());
		//System.out.println("Loading class File...");
		//System.out.println(e);
		try {
		    //System.out.println("Chargement classe");
		    //long deb=System.currentTimeMillis();
		    Class cl=Class.forName("org.w3c.wai.tablin.filter."+
					   "addon."+e.getValue());
		    try {
			//Class[] parameter=new Class[1];
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter."+
						   "engine.TokenManager");
			Method meth=cl.getDeclaredMethod("setTokenManager",
							 parameter);
			Object obj=cl.newInstance();
			//Object objParameter[]=new Object[1];
			objParameter[0]=tm;
			meth.invoke(obj,objParameter);

			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter.engine."+
						   "Parameters");
			meth=cl.getDeclaredMethod("setParameters",
						  parameter);
			objParameter[0]=param;
			meth.invoke(obj,objParameter);
			//long fin=System.currentTimeMillis();
			//System.out.println("Total="+(fin-deb));
			meth=cl.getDeclaredMethod("initParsing",null);
			String result=(String)meth.invoke(obj,null);
			if (result!=null) {
			    param.getBW().write(result);
			    param.getBW().flush();
			    //System.out.println(result);
			}
			else {
			    meth=cl.getDeclaredMethod("print",null);
			    meth.invoke(obj,null);
			}
		    }
		    catch (InvocationTargetException e4) {
			if (e4.getTargetException() instanceof FilterEOF)
			    throw new FilterEOF(e4.getTargetException().toString());
			else 
			    throw new FilterError(e4.getTargetException().toString());
		    }
		    catch (Exception e3) {
			System.out.println(e3);
			return;
		    }
		}
		catch (ClassNotFoundException e2) {
		    System.out.println(e2);
 		    return;
		}
	    }
	}
    }

    public static void main(String argv[]) {
	new FilterTag("http://www.w3.org",
		      System.in,
		      System.out,
		      0,
		      0,0,0,0,
		      null,null,null,null,
		      "http://mygale.inria.fr:8001/servlet/tablin",
		      0,
		      1,"");
    }
    
}
