package org.w3c.wai.tablin.filter.addon;

import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.GnuTools;
import org.w3c.wai.tablin.parser.html4.struct.table.*;

import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.IOException;
import java.lang.reflect.*;

/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <TR.
 */

public class HTMLTr {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    /**
     * Les donnees mal placees que l'ont recupere 
     * au cas ou
     */
    private StringBuffer badText=null;
    /**
     * La ligne que l'on va rajouter a la table
     */
    private Row row=null;
    /**
     * La table
     */
    private Table table=null;
    /**
     * Pour savoir si c'est une ligne de thead ou tfoot
     */
    private boolean isHeaderLine;
    private boolean inThead=true;
    private boolean inTfoot=true;
    private boolean inTBody=true;

    public HTMLTr(TokenManager tm,
		   Parameters param,
		  Table table) {
	this(tm,param,table,false);
    }

    public HTMLTr(TokenManager tm,
		   Parameters param,
		  Table table,
		  boolean isHeaderLine) {

	author="Eric Cabrit";
	date="20000220";
	version="0.4";
	buffer=new StringBuffer();
	this.tm=tm;
	this.param=param;
	badText=new StringBuffer();
	row=new Row();
	this.table=table;
	this.isHeaderLine=isHeaderLine;
    }
    

    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public void initParsing() 
	throws FilterError, FilterEOF, FilterTagFound {
	
	tm.endTag();
	tm.addTag("</tr>","---");
	tm.addTag("<td","---");
	tm.addTag("<th","---");
	//System.out.println("HTMLTr.initParsing()=>"+tm.getTagBuffer());
	while (true) {
	    try {
		tm.nextToken();
	    }
	    catch (FilterTagFound e) {
		//System.out.println("tr=>"+e);
		badText.append(tm.getBuffer());
		if (e.getTag().equals("</tr>")) {
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    continue;
		}
		if (e.getTag().equals("</thead>")) {
		    inThead=false;
		    tm.deleteTag("</thead>");
		    tm.deleteTag("<thead");
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    continue;
		}
		if (e.getTag().equals("<tfoot")) {
		    inThead=false;
		    tm.deleteTag("</thead>");
		    tm.deleteTag("<thead");
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    if (isHeaderLine)
			row.header();
		    table.addRow(row);
		    //System.out.println(row);
		    throw e;
		}
		if (e.getTag().equals("</tfoot>")) {
		    inTfoot=false;
		    tm.deleteTag("</tfoot>");
		    tm.deleteTag("<tfoot");
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    continue;
		}
		if (e.getTag().equals("<tbody")) {
		    inTfoot=false;
		    inThead=false;
		    tm.deleteTag("</tfoot>");
		    tm.deleteTag("<tfoot");		    
		    tm.deleteTag("</thead>");
		    tm.deleteTag("<thead");
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    if (isHeaderLine)
			row.header();
		    table.addRow(row);
		    //System.out.println(row);
		    throw e;
		}
		if (e.getTag().equals("</tbody>")) {
		    inTBody=false;
		    tm.deleteTag("</tbody>");
		    tm.deleteTag("</tr>");
		    tm.deleteTag("<td");
		    tm.deleteTag("<th");
		    continue;
		}

		if (e.getTag().equals("<td")) {
		    onTd();
		    continue;
		}	
		if (e.getTag().equals("<th")) {
		    onTh();
		    continue;
		}
		if (e.getTag().equals("<tr") ||
		    e.getTag().equals("</table>")) {
		    if (isHeaderLine)
			row.header();
		    table.addRow(row);
		    //System.out.println(row);
		    throw e;
		}

		/*
		 * On charge dynamiquement les classes que l'on
		 * a pas code (les tags qui ne servent pas 
		 * a la gestion des tables.
		 */
		try {
		    Class cl=Class.forName("org.w3c.wai.tablin.filter."+
					   "addon."+e.getValue());
		    try {
			Class[] parameter=new Class[1];
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter."+
						   "engine.TokenManager");
			Method meth=cl.getDeclaredMethod("setTokenManager",
							 parameter);
			Object obj=cl.newInstance();
			Object objParameter[]=new Object[1];
			objParameter[0]=tm;
			meth.invoke(obj,objParameter);
			
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter.engine."+
						   "Parameters");
			meth=cl.getDeclaredMethod("setParameters",
						  parameter);
			objParameter[0]=param;
			meth.invoke(obj,objParameter);
			
			meth=cl.getDeclaredMethod("initParsing",null);
			String result=(String)meth.invoke(obj,null);
			
			// A revoir obligatoirement....
			if (result!=null) {
			    badText.append(result);
			}
			else {
			    meth=cl.getDeclaredMethod("print",null);
			    meth.invoke(obj,null);
			}
		    }
		    catch (InvocationTargetException e4) {
			if (e4.getTargetException() 
			    instanceof FilterEOF)
			    throw 
				new FilterEOF(e4.
					      getTargetException().
					      toString());
			else 
			    throw 
				new FilterError(e4.
						getTargetException().
						toString());
		    }
		    catch (Exception e3) {
			System.out.println(e3);
			return;
		    }
		}
		catch (ClassNotFoundException e2) {
		    System.out.println(e2);
		    return;
		}
	    }
	}
    }


    /**
     * On se trouve sur un tag <td
     */
    private void onTd() 
	throws FilterEOF, FilterError, FilterTagFound {
	//System.out.println("onTd (tr)");

	HTMLTd td=null;
	
	try {
	    td=new HTMLTd(tm,param,row);
	    td.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("tr(onTd)=>"+e);
	    badText.append(td.getBadText());
	    if (e.getTag().equals("</table>")) {
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		throw e;
	    }
	    if (e.getTag().equals("<tr")) {
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		throw e;
	    }
	    if (e.getTag().equals("</tr>")) {
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("</thead>")) {
		inThead=false;
		tm.deleteTag("</tr>");
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<tfoot")) {
		inThead=false;
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		//System.out.println(row);
		throw e;
	    }
	    if (e.getTag().equals("</tfoot>")) {
		inTfoot=false;
		tm.deleteTag("</tfoot>");
		tm.deleteTag("<tfoot");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<tbody")) {
		inTfoot=false;
		inThead=false;
		tm.deleteTag("</tfoot>");
		tm.deleteTag("<tfoot");		    
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		//System.out.println(row);
		throw e;
	    }
	    if (e.getTag().equals("</tbody>")) {
		inTBody=false;
		tm.deleteTag("</tbody>");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<td"))
		onTd();
	    else
		if (e.getTag().equals("<th"))
		    onTh();
	}
    }
    
    /**
     * On se trouve sur un tag <th
     */
    private void onTh() 
	throws FilterEOF, FilterError, FilterTagFound {
	//System.out.println("onTh (tr)");

	HTMLTh th=null;
	
	try {
	    th=new HTMLTh(tm,param,row);
	    th.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println(row);
	    badText.append(th.getBadText());
	    if (e.getTag().equals("</table>")) {
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		throw e;
	    }
	    if (e.getTag().equals("<tr")) {
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		throw e;
	    }
	    if (e.getTag().equals("</thead>")) {
		inThead=false;
		tm.deleteTag("</tr>");
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("</tr>")) {
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<tfoot")) {
		inThead=false;
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		//System.out.println(row);
		throw e;
	    }
	    if (e.getTag().equals("</tfoot>")) {
		tm.deleteTag("</tfoot>");
		tm.deleteTag("<tfoot");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<tbody")) {
		inThead=false;
		tm.deleteTag("</tfoot>");
		tm.deleteTag("<tfoot");		    
		tm.deleteTag("</thead>");
		tm.deleteTag("<thead");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		if (isHeaderLine)
		    row.header();
		table.addRow(row);
		//System.out.println(row);
		throw e;
	    }
	    if (e.getTag().equals("</tbody>")) {
		tm.deleteTag("</tbody>");
		tm.deleteTag("</tr>");
		tm.deleteTag("<td");
		tm.deleteTag("<th");
		return;
	    }
	    if (e.getTag().equals("<td"))
		onTd();
	    else
		if (e.getTag().equals("<th"))
		    onTh();
	}
    }


    /**
     * Donne le texte mal place
     */
    public StringBuffer getBadText() {
	return badText;
    }


    public boolean getInTHead() {
	return inThead;
    }


    public boolean getInTFoot() {
	return inTfoot;
    }

    
    public boolean getInTBody() {
	return inTBody;
    }


    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

