package org.w3c.wai.tablin.filter.addon;

import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.*;
import org.w3c.wai.tablin.tools.Tools;
import org.w3c.wai.tablin.parser.html4.struct.table.*;

import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;
import java.io.IOException;
import java.lang.reflect.*;

/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <TH.
 */

public class HTMLTh {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    /**
     * Les donnees mal placees que l'ont recupere 
     * au cas ou
     */
    private StringBuffer badText=null;
    /**
     * Va nous permettre de stocker les attributs du tag
     */
    private Hashtable attr=null;    
    /**
     * Les valeurs des attributs du tag 
     * <td. On va les utiliser pour construire 
     * notre objet cellule de notre table
     * linearizee.
     */
    private int colspan=1;
    private int rowspan=1;
    private String aux=null;
    private String abbr=null;
    private String headers=null;
    private String id=null;
    private int scope=-1;
    /**
     * La ligne ou il faudra rajoutre la
     * nouvelle cellule cree a partir des donnees
     * du tag <th.
     */
    private Row row=null;
    /**
     * Pour savoir si on a deja lu </td>
     */
    private boolean dataValue=true;
    /**
     * Pour stocker les donnees de la cellule
     */
    private Vector vec=null;

    public HTMLTh(TokenManager tm,
		  Parameters param,
		  Row row) {

	author="Eric Cabrit";
	date="20000218";
	version="0.4";
	buffer=new StringBuffer();
	this.tm=tm;
	this.param=param;
	badText=new StringBuffer();
	this.row=row;
	vec=new Vector();
    }
    

    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public void initParsing() 
	throws FilterError, FilterEOF, FilterTagFound {
	
	tm.endTag();
	//try {
	//attr=GnuTools.recoverAttributes(tm.getTagBuffer());
	attr=new GetAttributes(tm.getTagBuffer()).getAttr();
	prepareCell();
	//}
	//catch (REException e) {
	//throw new FilterError("HTMLTh.initParsing(). Probleme de regexp.");
	//}

	tm.addTag("</th>","---");
	//System.out.println("HTMLTh.initParsing()=>"+tm.getTagBuffer());
	while (true) {
	    try {
		tm.nextToken();
	    }
	    catch (FilterTagFound e) {
		if (dataValue)
		    buffer.append(tm.getBuffer());
		else
		    badText.append(tm.getBuffer());
		if (e.getTag().equals("</th>")) {
		    tm.deleteTag("</th>");
		    tm.deleteTag("<table");
		    dataValue=false;
		    continue;
		}
		/*
		 * les differents tag que l'on peut rencontrer
		 * </table> <tr> <td> </tr> <th> <table>
		 */
		if (e.getTag().equals("<table")) {
		    vec.addElement(
				   Tools.
				   filterString(Tools.
						noNewLine(buffer.
							  toString())));
		    buffer.setLength(0);
		    boolean isTHead=tm.isPresent("<thead");
		    boolean isTFoot=tm.isPresent("<tfoot");
		    boolean isTBody=tm.isPresent("<tbody");
		    HTMLTable tab=new HTMLTable();
		    tab.setTokenManager(tm);
		    tab.setParameters(param);
		    tab.initParsing();
		    vec.addElement(tab.getTable());
		    tm.addTag("<tr","---");
		    tm.addTag("</tr>","---");
		    tm.addTag("<th","---");
		    tm.addTag("</th>","---");
		    tm.addTag("<td","---");
		    tm.addTag("</table>","---");
		    if (isTHead)
			tm.addTag("<thead","---");
		    if (isTFoot)
			tm.addTag("<tfoot","---");
		    if (isTBody)
			tm.addTag("<tbody","---");
		    continue;
		}
		if (e.getValue().equals("---")) {
		    vec.addElement(
				   Tools.
				   filterString(Tools.
						noNewLine(buffer.
							  toString())));
		    addCell();
		    throw e;
		}
		/*
		 * On charge dynamiquement les classes que l'on
		 * a pas code (les tags qui ne servent pas 
		 * a la gestion des tables.
		 */
		try {
		    Class cl=Class.forName("org.w3c.wai.tablin.filter."+
					   "addon."+e.getValue());
		    try {
			Class[] parameter=new Class[1];
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter."+
						   "engine.TokenManager");
			Method meth=cl.getDeclaredMethod("setTokenManager",
							 parameter);
			Object obj=cl.newInstance();
			Object objParameter[]=new Object[1];
			objParameter[0]=tm;
			meth.invoke(obj,objParameter);
			
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter.engine."+
						   "Parameters");
			meth=cl.getDeclaredMethod("setParameters",
						  parameter);
			objParameter[0]=param;
			meth.invoke(obj,objParameter);
			
			meth=cl.getDeclaredMethod("initParsing",null);
			String result=(String)meth.invoke(obj,null);
			
			// A revoir obligatoirement....
			if (result!=null) {
			    if (dataValue)
				buffer.append(result);
			    else
				badText.append(result);
			}
			else {
			    meth=cl.getDeclaredMethod("print",null);
			    meth.invoke(obj,null);
			}
		    }
		    catch (InvocationTargetException e4) {
			if (e4.getTargetException() 
			    instanceof FilterEOF)
			    throw 
				new FilterEOF(e4.
					      getTargetException().
					      toString());
			else 
			    throw 
				new FilterError(e4.
						getTargetException().
						toString());
		    }
		    catch (Exception e3) {
			System.out.println(e3);
			return;
		    }
		}
		catch (ClassNotFoundException e2) {
		    System.out.println(e2);
		    return;
		}
	    }
	}
    }

    
    /**
     * Cette fonction recupere les parametres du td pour
     * construire la cellule qui va permettre la linearization
     */
    private void prepareCell() {
	//System.out.println(attr);
	if ((aux=(String)attr.get("colspan"))!=null) {
	    try {
		aux=GnuTools.purifyString(aux);
		colspan=Integer.parseInt(aux);
	    }
	    catch (NumberFormatException e) {
		colspan=1;
	    }
	}

	if ((aux=(String)attr.get("rowspan"))!=null) {
	    try {
		aux=GnuTools.purifyString(aux);
		rowspan=Integer.parseInt(aux);
	    }
	    catch (NumberFormatException e) {
		rowspan=1;
	    }
	}
	
	if ((abbr=(String)attr.get("abbr"))!=null) 
	    abbr=GnuTools.purifyString(abbr);

	if ((headers=(String)attr.get("headers"))!=null) 
	    headers=GnuTools.purifyString(headers);
	
	if ((id=(String)attr.get("id"))!=null) 
	    id=GnuTools.purifyString(id);
	
	if ((aux=(String)attr.get("scope"))!=null) {
	    aux=GnuTools.purifyString(aux);
	    if (aux.equalsIgnoreCase("row"))
		scope=4;
	    else
		if (aux.equalsIgnoreCase("col"))
		    scope=3;
		else
		    if (aux.equalsIgnoreCase("colgroup"))
			scope=6;
		    else
			if (aux.equalsIgnoreCase("rowgroup"))
			    scope=5;
	}
    }

    /**
     * On rajoute la ou les cellules a la ligne
     */
    private void addCell() {
	row.addCell(new Cell(vec,0,colspan,rowspan,
			     abbr,scope,headers,id));
	int cpt=colspan;
	cpt--;
	while (cpt!=0) {
	    row.addCell(new Cell(vec,10,colspan,rowspan,
				 abbr,scope,headers,id));
	    cpt--;
	}
    }


    /**
     * Donne le texte mal place
     */
    public StringBuffer getBadText() {
	return badText;
    }


    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

