package org.w3c.wai.tablin.filter.addon;

import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.*;
import org.w3c.wai.tablin.parser.html4.struct.table.*;

import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.net.URL;
import java.net.MalformedURLException;
import java.lang.reflect.*;
import java.io.IOException;


/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <TABLE.
 */

public class HTMLTable implements TagInterface {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Va nous permettre de stocker les attributs du tag
     */
    private Hashtable attr=null;
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    
    /**
     * La classe qui va permettre de recuperer la 
     * structure de la table
     */
    private Table table=null;

    /**
     * Le code HTML mal place est enregistre 
     * dans cette variable. Il sera affiche avant le
     * le contenue de la table.
     */
    private StringBuffer badText=null;


    public HTMLTable() {
	author="Eric Cabrit";
	date="20000220";
	version="0.5";
	attr=null;
	buffer=new StringBuffer();
	badText=new StringBuffer();
    }

    
    /**
     * On fournit a la classe le moyen de lire la fin du tag 
     * a l'aide du TokenManager
     */
    public void setTokenManager(TokenManager tm) {
	this.tm=tm;
    }

    /**
     * On fournit a la classe le moyen de recuperer les 
     * options donnees au programme.
     */
    public void setParameters(Parameters param) {
	this.param=param;
	table=new Table(param.getBW(),
			param.getTableNumber(),
			param.getOrient(),
			param.getRepeat(),
			param.getRecurs(),
			param.getInteract(),
			param.getHeaderSeparator(),
			param.getValueSeparator(),
			param.getCellSeparator(),
			param.getLineSeparator(),
			param.getBase(),
			param.getCGIUrl());
    }


    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public String initParsing() 
	throws FilterError, FilterEOF {

	tm.endTag();
	//System.out.println("HTMLTable.initParsing()=>"+tm.getTagBuffer());
	//try {
	//attr=GnuTools.recoverAttributes(tm.getTagBuffer());
	attr=new GetAttributes(tm.getTagBuffer()).getAttr();
	setSummary();
	searchAfterTable();
	return null;
	//}
	//catch (REException e) {
	//throw new FilterError("Table.initParsing(). Probleme de regexp.");
	//}
    }
    
    
    private void searchAfterTable() 
	throws FilterError, FilterEOF {

	/*
	 * On ne traite les tables recursives
	 * que dans les td th
	 * pas de sens sinon
	 */
	tm.deleteTag("<table");
	tm.addTag("<caption","---");
	tm.addTag("</table>","---");
	tm.addTag("<col","---");
	tm.addTag("<colgroup","---");
	tm.addTag("<tr","---");
	tm.addTag("<thead","---");
	tm.addTag("<tfoot","---");
	tm.addTag("<tbody","---");
	
	while (true) {
	    try {
		tm.nextToken();
	    }
	    catch (FilterTagFound e) {
		//System.out.println(e);
		badText.append(tm.getBuffer());
		if (e.getTag().equals("<caption")) {
		    tm.deleteTag("<caption");
		    onCaption();
		    break;
		}
		if (e.getTag().equals("<col")) {
		    tm.deleteTag("<caption");
		    tm.deleteTag("<colgroup");
		    onCol();
		    break;
		}
		if (e.getTag().equals("<colgroup")) {
		    tm.deleteTag("<caption");
		    onColgroup();
		    break;
		}
		if (e.getTag().equals("<thead")) {
		    tm.deleteTag("<caption");
		    tm.deleteTag("<colgroup");
		    tm.deleteTag("<col");
		    tm.deleteTag("<thead");
		    onThead();
		    break;
		}
		if (e.getTag().equals("<tfoot")) {
		    tm.deleteTag("<caption");
		    tm.deleteTag("<colgroup");
		    tm.deleteTag("<col");
		    tm.deleteTag("<thead");
		    tm.deleteTag("<tfoot");
		    onTfoot();
		    break;
		}
		if (e.getTag().equals("<tbody")) {
		    tm.deleteTag("<caption");
		    tm.deleteTag("<colgroup");
		    tm.deleteTag("<col");
		    tm.deleteTag("<thead");
		    tm.deleteTag("<tfoot");
		    onTBody();
		    break;
		}
		if (e.getTag().equals("<tr")) {
		    tm.deleteTag("<caption");
		    tm.deleteTag("<colgroup");
		    tm.deleteTag("<col");
		    tm.deleteTag("<thead");
		    tm.deleteTag("<tfoot");
		    tm.deleteTag("<tbody");
		    onTr();
		    break;
		}
		if (e.getTag().equals("</table>")) {
		    onETable();
		    break;
		}
		/*
		 * On charge dynamiquement les classes que l'on
		 * a pas code (les tags qui ne servent pas 
		 * a la gestion des tables.
		 */
		try {
		    Class cl=Class.forName("org.w3c.wai.tablin.filter."+
					   "addon."+e.getValue());
		    try {
			Class[] parameter=new Class[1];
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter."+
						   "engine.TokenManager");
			Method meth=cl.getDeclaredMethod("setTokenManager",
							 parameter);
			Object obj=cl.newInstance();
			Object objParameter[]=new Object[1];
			objParameter[0]=tm;
			meth.invoke(obj,objParameter);
			
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter.engine."+
						   "Parameters");
			meth=cl.getDeclaredMethod("setParameters",
						  parameter);
			objParameter[0]=param;
			meth.invoke(obj,objParameter);
			
			meth=cl.getDeclaredMethod("initParsing",null);
			String result=(String)meth.invoke(obj,null);
			
			// A revoir obligatoirement....
			if (result!=null) {
			    badText.append(result);
			}
			else {
			    meth=cl.getDeclaredMethod("print",null);
			    meth.invoke(obj,null);
			}
		    }
		    catch (InvocationTargetException e4) {
			if (e4.getTargetException() 
			    instanceof FilterEOF)
			    throw 
				new FilterEOF(e4.
					      getTargetException().
					      toString());
			else 
			    throw 
				new FilterError(e4.
						getTargetException().
						toString());
		    }
		    catch (Exception e3) {
			System.out.println(e3);
			return;
		    }
		}
		catch (ClassNotFoundException e2) {
		    System.out.println(e2);
		    return;
		}
	    }
	}
    }

    
    /**
     * On rencontrfe ici un caption
     */
    private void onCaption() 
	throws FilterError, FilterEOF {
	
	HTMLCaption caption=null;
	try {
	    caption=new HTMLCaption(table,tm,param);
	    caption.initParsing();
	}
	catch (FilterTagFound e) {
	    badText.append(caption.getBadText());
	    if (e.getTag().equals("<col")) {
		tm.deleteTag("<colgroup");
		onCol();
	    }
	    else
		if (e.getTag().equals("<colgroup"))
		    onColgroup();
		else
		    if (e.getTag().equals("<tr")) {
			tm.deleteTag("<col");
			tm.deleteTag("<colgroup");
			tm.deleteTag("<thead");
			tm.deleteTag("<tfoot");
			tm.deleteTag("<tbody");
			onTr();
		    }
		    else
			if (e.getTag().equals("</table>"))
			    onETable();
			else
			    if (e.getTag().equals("<thead")) {
				tm.deleteTag("<col");
				tm.deleteTag("<colgroup");
				tm.deleteTag("<thead");
				onThead();
			    }
			    else
				if (e.getTag().equals("<tfoot")) {
				    tm.deleteTag("<col");
				    tm.deleteTag("<colgroup");
				    tm.deleteTag("<thead");
				    tm.deleteTag("<tfoot");
				    onTfoot();
				}
				else
				    if (e.getTag().equals("<tbody")) {
					tm.deleteTag("<col");
					tm.deleteTag("<colgroup");
					tm.deleteTag("<thead");
					tm.deleteTag("<tfoot");
					onTBody();
				    }
	}
    }
    
    
    /**
     * On rencontre la fin de la table
     */
    private void onETable() {
	//System.out.println("onETable");
	tm.deleteTag("<caption");
	tm.deleteTag("</table>");
	tm.deleteTag("<col");
	tm.deleteTag("<colgroup");
	tm.deleteTag("<tr");
	tm.deleteTag("<thead");
	tm.deleteTag("<tfoot");
	tm.deleteTag("<tbody");
	/**
	 * On termine une table
	 * et on doit reactiver le tag table
	 */
	tm.addTag("<table","HTMLTable");
    }


    /**
     * On se trouve sur un tag <col
     */
    private void onCol() 
	throws FilterEOF, FilterError {
	//System.out.println("onCol");

	HTMLCol col=null;
	
	try {
	    col=new HTMLCol(tm,param);
	    col.initParsing();
	}
	catch (FilterTagFound e) {
	    badText.append(col.getBadText());
	    if (e.getTag().equals("<col"))
		onCol();
	    else
		if (e.getTag().equals("<tr")) {
		    tm.deleteTag("<col");
		    tm.deleteTag("<thead");
		    tm.deleteTag("<tfoot");
		    tm.deleteTag("<tbody");
		    onTr();
		}
		else
		    if (e.getTag().equals("</table>"))
			onETable();
		    else
			if (e.getTag().equals("<thead")) {
			    tm.deleteTag("<col");
			    tm.deleteTag("<thead");
			    onThead();
			}		
			else
			    if (e.getTag().equals("<tfoot")) {
				tm.deleteTag("<col");
				tm.deleteTag("<thead");
				tm.deleteTag("<tfoot");
				onTfoot();
			    }		
			    else
				if (e.getTag().equals("<tbody")) {
				    tm.deleteTag("<col");
				    tm.deleteTag("<thead");
				    tm.deleteTag("<tfoot");
				    onTBody();
				}		
	}
    }
    

    /**
     * On se trouve sur un tag <colgroup
     */
    private void onColgroup() 
	throws FilterEOF, FilterError {
	//System.out.println("onColgroup");

	HTMLColgroup colgroup=null;
	
	try {
	    colgroup=new HTMLColgroup(tm,param);
	    colgroup.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("onColgroup(Table)=>"+e);
	    badText.append(colgroup.getBadText());
	    if (e.getTag().equals("<colgroup"))
		onColgroup();
	    else
		if (e.getTag().equals("<tr")) {
		    tm.deleteTag("<col");
		    tm.deleteTag("<colgroup");
		    tm.deleteTag("<thead");
		    tm.deleteTag("<tfoot");
		    tm.deleteTag("<tbody");
		    onTr();
		}
		else
		    if (e.getTag().equals("</table>"))
			onETable();
		    else
			if (e.getTag().equals("<thead")) {
			    tm.deleteTag("<col");
			    tm.deleteTag("<colgroup");
			    tm.deleteTag("<thead");
			    onThead();
			}
			else
			    if (e.getTag().equals("<tfoot")) {
				tm.deleteTag("<col");
				tm.deleteTag("<colgroup");
				tm.deleteTag("<thead");
				tm.deleteTag("<tfoot");
				onTfoot();
			    }
			    else
				if (e.getTag().equals("<tbody")) {
				    tm.deleteTag("<col");
				    tm.deleteTag("<colgroup");
				    tm.deleteTag("<thead");
				    tm.deleteTag("<tfoot");
				    onTBody();
				}
	}
    }
    

    /**
     * On se trouve sur un tag <tr
     */
    private void onTr() 
	throws FilterEOF, FilterError {

	HTMLTr tr=null;
	
	try {
	    tr=new HTMLTr(tm,param,table);
	    tr.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("onTr=>"+e);
	    badText.append(tr.getBadText());
	    tm.deleteTag("<td");
	    tm.deleteTag("<th");
	    if (e.getTag().equals("<tr")) {
		onTr();
	    }
	    else
		if (e.getTag().equals("</table>"))
		    onETable();
	}
    }


    /**
     * On se trouve sur un tag <thead
     */
    private void onThead() 
	throws FilterEOF, FilterError {
	//System.out.println("onThead");

	HTMLThead thead=null;
	
	try {
	    thead=new HTMLThead(tm,param,table);
	    thead.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("thead=>"+e);
	    badText.append(thead.getBadText());
	    if (e.getTag().equals("<tr")) {
		tm.deleteTag("<tfoot");
		tm.deleteTag("<tbody");
		onTr();
	    }
	    else
		if (e.getTag().equals("</table>")) 
		    onETable();
		else
		    if (e.getTag().equals("<tfoot")) {
			tm.deleteTag("<tfoot");
			onTfoot();
		    }
		    else
			if (e.getTag().equals("<tbody")) {
			    tm.deleteTag("<tfoot");
			    onTBody();
			}
	}
    }


    /**
     * On se trouve sur un tag <tfoot
     */
    private void onTfoot() 
	throws FilterEOF, FilterError {
	//System.out.println("onTfoot");

	HTMLTfoot tfoot=null;
	
	try {
	    tfoot=new HTMLTfoot(tm,param,table);
	    tfoot.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("tfoot=>"+e);
	    badText.append(tfoot.getBadText());
	    if (e.getTag().equals("<tr")) {
		tm.deleteTag("<tbody");
		onTr();
	    }
	    else
		if (e.getTag().equals("</table>")) 
		    onETable();
		else
		    if (e.getTag().equals("<tbody"))
			onTBody();
	}
    }
    

    /**
     * On se trouve sur un tag <tbody
     */
    private void onTBody() 
	throws FilterEOF, FilterError {
	//System.out.println("onTBody");

	HTMLTbody tbody=null;
	
	try {
	    tbody=new HTMLTbody(tm,param,table);
	    tbody.initParsing();
	}
	catch (FilterTagFound e) {
	    //System.out.println("tbody=>"+e);
	    badText.append(tbody.getBadText());
	    if (e.getTag().equals("<tr")) {
		tm.deleteTag("<tbody");
		onTr();
	    }
	    else
		if (e.getTag().equals("</table>")) 
		    onETable();
		else
		    if (e.getTag().equals("<tbody")) {
			onTBody();
		    }
	}
    }


    /**
     * Verifie si un attribut summary est present
     * dans le tag et si c'est le cas
     * le traite.
     */
    private void setSummary() {
	String s=(String)attr.get("summary");
	table.setSummary((s==null?"":s));
    }

    
    public void print() throws IOException {
	param.getBW().write(badText.toString());
	table.print();
    }

    
    /**
     * Donne la structure de la table
     */
    public Table getTable() {
	return table;
    }


    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

