package org.w3c.wai.tablin.filter.addon;


import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.*;

import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <INPUT.
 */

public class HTMLInput implements TagInterface {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Va nous permettre de stocker les attributs du tag
     */
    private Hashtable attr=null;
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    

    public HTMLInput() {
	author="Eric Cabrit";
	date="20000124";
	version="0.1";
	attr=null;
	buffer=new StringBuffer();
    }

    
    /**
     * On fournit a la classe le moyen de lire la fin du tag 
     * a l'aide du TokenManager
     */
    public void setTokenManager(TokenManager tm) {
	this.tm=tm;
    }

    /**
     * On fournit a la classe le moyen de recuperer les 
     * options donnees au programme.
     */
    public void setParameters(Parameters param) {
	this.param=param;
    }


    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public String initParsing() 
	throws FilterError, FilterEOF {

	tm.endTag();
	//System.out.println("Anchor.initParsing()=>"+tm.getTagBuffer());
	//try {
	//attr=GnuTools.recoverAttributes(tm.getTagBuffer());
	attr=new GetAttributes(tm.getTagBuffer()).getAttr();
	applyTransformation();
	return new String(buffer);
	//}
	//catch (REException e) {
	//throw new FilterError("Anchor.initParsing(). Probleme de regexp.");
	//}
    }
    
    
    /**
     * On applique les transformations necessaires sur le tag
     * que l'on vient de recuperer.
     */
    private void applyTransformation() {
	buffer.append("<input");
	Enumeration e=attr.keys();
	
	if (param.getEmbedded()==1 || param.getRecurs()==1)
	    transformSrc();


	while (e.hasMoreElements()) {
	    String key=(String)e.nextElement();
	    String value=(String)attr.get(key);
	    buffer.append(" "+key+"="+value);
	}
	buffer.append(">");
    }

    private void transformSrc() {
	StringBuffer sb=new StringBuffer();
	String s=(String)attr.get("src");
	if (s!=null) {
	    String result=GnuTools.purifyString(s);
	    if (result!=null) {
		try {
		    URL url=new URL(result);
		    sb.append(url.toString());
		}
		catch (MalformedURLException e) {
		    // Dans ce cas on a une adresse relative
		    if (result.charAt(0)=='/') {
			if (param.getBase().
			    substring(7).indexOf("/")==-1) {
			    sb.append(param.getBase()+result);
			}
			else {
			    sb.append(param.
				      getBase().
				      substring(0,
						(param.
						 getBase().
						 substring(7).
						 indexOf("/")+7))+result);
			}
		    }
		    else {
			if (param.getBase().
			    indexOf(".",
				    ((param.getBase().substring(7).
				      lastIndexOf("/")==-1)?
				     param.getBase().length()-1:
				     param.getBase().substring(7).
				     lastIndexOf("/")))!=-1) {
			    sb.append(param.getBase().
				      substring(0,
						param.getBase().
						lastIndexOf("/")+1)+
				      result);
			}
			else {
			    if (param.getBase().
				charAt(param.getBase().length()-1)
				=='/') 
				sb.append(param.getBase()+result);
			    else
				sb.append(param.getBase()+"/"+result);
			}
		    }
		}
		//System.out.println("HOULA:"+sb);
		buffer.append(" src=\""+sb.toString()+"\"");
	    }
	    attr.remove("src");
	}
    }

    
    public void print() {
	System.out.println(buffer);
    }
    
    
    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

