package org.w3c.wai.tablin.filter.addon;

import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.GnuTools;
import org.w3c.wai.tablin.tools.Tools;
import org.w3c.wai.tablin.tools.GetAttributes;
import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <!--.
 */

public class HTMLComment implements TagInterface {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Va nous permettre de stocker les attributs du tag
     */
    private Hashtable attr=null;
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    

    public HTMLComment() {
	author="Eric Cabrit";
	date="20000129";
	version="0.1";
	attr=null;
	buffer=new StringBuffer();
    }

    
    /**
     * On fournit a la classe le moyen de lire la fin du tag 
     * a l'aide du TokenManager
     */
    public void setTokenManager(TokenManager tm) {
	this.tm=tm;
    }

    /**
     * On fournit a la classe le moyen de recuperer les 
     * options donnees au programme.
     */
    public void setParameters(Parameters param) {
	this.param=param;
    }


    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public String initParsing() 
	throws FilterError, FilterEOF {

	tm.endTagComment();
	//System.out.println("HTMLComment.initParsing()=>"+tm.getTagBuffer());
	buffer.append(tm.getTagBuffer());
	return new String(buffer);
    }
    
    
    public void print() {
	System.out.println(buffer);
    }
    
    
    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

