package org.w3c.wai.tablin.filter.addon;

import org.w3c.wai.tablin.filter.engine.TokenManager;
import org.w3c.wai.tablin.filter.engine.Parameters;
import org.w3c.wai.tablin.filter.exception.*;
import org.w3c.wai.tablin.tools.GnuTools;
import org.w3c.wai.tablin.parser.html4.struct.table.*;

import gnu.regexp.REException;
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.IOException;
import java.lang.reflect.*;

/**
 * Class qui sera chargee de facon dynamique.
 * Elle donne le code pour le parsing et la transformation
 * du tag <COL.
 */

public class HTMLCol {
    /**
     * Nom de la personne qui a code la classe
     */
    private String author=null;
    /**
     * Data a laquelle la classe a ete code (aaaammjj)
     */
    private String date=null;
    /**
     * Numero de la version
     */
    private String version=null;
    /**
     * Il va permettre de recuperer le reste du tag qui 
     * va nous interesser.
     */
    private  TokenManager tm=null;    
    /**
     * Buffer qui contient le resultat du tag apres transformation
     */
    private StringBuffer buffer=null;
    /** 
     * Les options qu'on a donne au programme.
     */
    private Parameters param=null;
    /**
     * Les donnees mal placees que l'ont recupere 
     * au cas ou
     */
    private StringBuffer badText=null;
    
    
    public HTMLCol(TokenManager tm,
		   Parameters param) {

	author="Eric Cabrit";
	date="20000211";
	version="0.2";
	buffer=new StringBuffer();
	this.tm=tm;
	this.param=param;
	badText=new StringBuffer();
    }
    

    /**
     * On va donner ici la "grammaire" du 
     * tag qu'il faudra parser puis transformer.
     */
    public void initParsing() 
	throws FilterError, FilterEOF, FilterTagFound {
	
	tm.endTag();
	tm.addTag("</col>","---");
	//System.out.println("HTMLCol.initParsing()=>"+tm.getTagBuffer());
	while (true) {
	    try {
		tm.nextToken();
	    }
	    catch (FilterTagFound e) {
		badText.append(tm.getBuffer());
		if (e.getTag().equals("</col>")) {
		    tm.deleteTag("</col>");
		    continue;
		}
		/*
		 * les differents tag que l'on peut rencontrer
		 * </table> <col> <colgroup> </colgroup> <tr> <thead>
		 */
		if (e.getValue().equals("---")) {
		    throw e;
		}
		/*
		 * On charge dynamiquement les classes que l'on
		 * a pas code (les tags qui ne servent pas 
		 * a la gestion des tables.
		 */
		try {
		    Class cl=Class.forName("org.w3c.wai.tablin.filter."+
					   "addon."+e.getValue());
		    try {
			Class[] parameter=new Class[1];
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter."+
						   "engine.TokenManager");
			Method meth=cl.getDeclaredMethod("setTokenManager",
							 parameter);
			Object obj=cl.newInstance();
			Object objParameter[]=new Object[1];
			objParameter[0]=tm;
			meth.invoke(obj,objParameter);
			
			parameter[0]=Class.forName("org.w3c.wai.tablin."+
						   "filter.engine."+
						   "Parameters");
			meth=cl.getDeclaredMethod("setParameters",
						  parameter);
			objParameter[0]=param;
			meth.invoke(obj,objParameter);
			
			meth=cl.getDeclaredMethod("initParsing",null);
			String result=(String)meth.invoke(obj,null);
			
			// A revoir obligatoirement....
			if (result!=null) {
			    badText.append(result);
			}
			else {
			    meth=cl.getDeclaredMethod("print",null);
			    meth.invoke(obj,null);
			}
		    }
		    catch (InvocationTargetException e4) {
			if (e4.getTargetException() 
			    instanceof FilterEOF)
			    throw 
				new FilterEOF(e4.
					      getTargetException().
					      toString());
			else 
			    throw 
				new FilterError(e4.
						getTargetException().
						toString());
		    }
		    catch (Exception e3) {
			System.out.println(e3);
			return;
		    }
		}
		catch (ClassNotFoundException e2) {
		    System.out.println(e2);
		    return;
		}
	    }
	}
    }


    /**
     * Donne le texte mal place
     */
    public StringBuffer getBadText() {
	return badText;
    }


    /**
     * Donne les informations sur la classe.
     */
    public String toString() {
	return "By "+author+" on "+date+" ver"+version;
    }
}

