/*
 * This class is given the responsability to
 * connect web page, open the file
 * or read the stdin and launch the table parser 
 * wich generate a new HTML document
 */

package org.w3c.wai.tablin;
import java.net.*;
import java.io.*;
import java.util.*;
import org.w3c.wai.tablin.parser.html4.*;
import org.w3c.wai.tablin.tools.*;
import org.w3c.wai.tablin.filter.engine.FilterTag;

public class Linearize {
    final static public int URL=0;
    final static public int FILE=1;
    final static public int STDIN=2;

    // Network connection for url
    private Socket s=null;

  /*
   * Stream connected to daemon http.
   * This daemon returns the content of the page by
   * the stream
   */
  private InputStream isUrl=null;
    
     /*
      * Stream use to provide the HTTP request to the daemon
      */
  private BufferedWriter bwUrl=null;

    private String hostConn=null;

    /*
     * Read the file on standard input and 
     * launch the parser
     */
    public Linearize(int tableNumber,int orientation,
		     int repeat,
		     int recurs,
		     int interact,
		     String headerSeparator,String valueSeparator,
		     String cellSeparator,String lineSeparator,
		     String outputFile,
		     String service,
		     int lynx,
		     String base,
		     int embedded,
		     boolean javacc,
		     String tagFile) 
       throws IOException {
      
	 /*
	  * the significaton to tableNumber, orientation, recurs, 
	  * headSeparator,valueSeparator, cellSeparator, lineSeparator
	  * are discussed later
	  */
	 
	 
	 isUrl=System.in;

	 if (outputFile==null) {
	     if (javacc) {
		 new html4(base,isUrl,
			   System.out,
			   tableNumber,
			   orientation,
			   repeat,
			   recurs,
			   interact,
			   headerSeparator,
			   valueSeparator,
			   cellSeparator,
			   lineSeparator,
			   service,
			   lynx,
			   embedded);
	     }
	     else {
		 new FilterTag(base,isUrl,
			       System.out,
			       tableNumber,
			       orientation,
			       repeat,
			       recurs,
			       interact,
			       headerSeparator,
			       valueSeparator,
			       cellSeparator,
			       lineSeparator,
			       service,
			       lynx,
			       embedded,tagFile);
	     }
	 }
	 else {
	     try {
		 FileOutputStream fos=new FileOutputStream(outputFile);
		 if (javacc)
		     new html4(base,isUrl,
			       fos,		
			       tableNumber,orientation,repeat,
			       recurs,interact,
			       headerSeparator,
			       valueSeparator,
			       cellSeparator,lineSeparator,service,lynx,
			       embedded);
		 else 
		     new FilterTag(base,isUrl,
				   fos,		
				   tableNumber,orientation,repeat,
				   recurs,interact,
				   headerSeparator,
				   valueSeparator,
				   cellSeparator,lineSeparator,service,lynx,
				   embedded,tagFile);		 
		 
	     }
	     catch(FileNotFoundException e) {
		 System.out.println("Impossible to create the output file.");
		 System.exit(4);
	     }
	 }
    }
    
  
  /*
   * Connect the web page or the file and 
   * launch the parser
   */
  public Linearize(String url,
		   int tableNumber,int orientation,
		   int repeat,
		   int recurs,
		   int interact,
		   String headerSeparator,String valueSeparator,
		   String cellSeparator,String lineSeparator,
		   int type,
		   String outputFile,
		   String service,
		   int lynx,
		   String base,
		   int embedded,
		   boolean javacc,
		   String tagFile) 
       throws IOException {
		     
		     
	 switch (type) {
	   
	 case URL : 
	   Filter f=null;
	   try {
	       connectURL(url);
	       //if (outputFile==null) {
		   f=new Filter(isUrl);
		   /*}
		     else {
		     f=new Filter(isUrl);
		     }*/
	   }
	   catch (MalformedURLException e) {
	       //System.out.print("Content-type: text/html\n\n");
	       System.out.println("Malformed URL.");
	       return;
	   }
	   catch (IOException e) {
	       //System.out.print("Content-type: text/html\n\n");
	       System.out.println("Impossible to connect remote httpd.");
	       try {
		   if (s!=null) 
		       s.close();
		   if (isUrl!=null)
		       isUrl.close();
		   if (bwUrl!=null)
		       bwUrl.close();
	       }
	       catch (IOException e3) {}
	       return;
	   }
	   catch (FilterException e) {
	       //System.out.print("Content-type: text/html\n\n");
	       System.out.println(e);
	       try {
		   if (s!=null) 
		       s.close();
		   if (isUrl!=null)
		       isUrl.close();
		   if (bwUrl!=null)
		       bwUrl.close();
	       }
	       catch (IOException e3) {}
	       return;
	   }
	   catch (RedirectionException e) {
	       System.out.println(e);
	       //System.out.println("*"+e.getUrl()+"*");
	       try {
		   if (s!=null) 
		       s.close();
		   if (isUrl!=null)
		       isUrl.close();
		   if (bwUrl!=null)
		       bwUrl.close();
	       }
	       catch (IOException e3) {}
	       //System.out.println("hostConn="+hostConn);
	       //System.out.println("e.getUrl()="+e.getUrl());
	       if (e.getUrl().indexOf("http://")==0)
		   new Linearize(e.getUrl(),tableNumber,orientation,
				 repeat,recurs,interact,headerSeparator,
				 valueSeparator,cellSeparator,lineSeparator,
				 type,outputFile,service,lynx,base,embedded,
				 javacc,tagFile);
	       else 
		   new Linearize(("http://"+hostConn+e.getUrl()),
				 tableNumber,orientation,
				 repeat,recurs,interact,headerSeparator,
				 valueSeparator,cellSeparator,lineSeparator,
				 type,outputFile,service,lynx,base,embedded,
				 javacc,tagFile);
	       return;	     
 	   }
	   catch (FilterEOFException e) {
	       System.out.println(e);
	       return;
	   }
	   
	   /*if (f.getHtmlText()) 
	     System.out.println("Content-type: text/html\n\n");
	     else 
	     System.out.println("Content-type: text/plain\n\n");*/
	   break;
	   
	 case FILE :
	   try {
	     isUrl=new FileInputStream(url);
	   }
	   catch (FileNotFoundException e) {
	     System.out.println("File not found.");
	     return;
	   }
	   //recurs=0;
	   break;
	 }
	 
	 if (outputFile==null) {
	     if (javacc) {
		 new html4((base.equals("")?url:base),
			   isUrl,
			   System.out,
			   tableNumber,
			   orientation,
			   repeat,
			   recurs,
			   interact,
			   headerSeparator,
			   valueSeparator,
			   cellSeparator,
			   lineSeparator,
			   service,
			   lynx,
			   embedded);
	     }
	     else {
		 new FilterTag((base.equals("")?url:base),
			   isUrl,
			   System.out,
			   tableNumber,
			   orientation,
			   repeat,
			   recurs,
			   interact,
			   headerSeparator,
			   valueSeparator,
			   cellSeparator,
			   lineSeparator,
			   service,
			   lynx,
			   embedded,tagFile);
	     }
	 }
	 else {
	   try {
	     FileOutputStream fos=new FileOutputStream(outputFile);
	     if (javacc) {
		 new html4((base.equals("")?url:base),
			   isUrl,fos,		
			   tableNumber,orientation,repeat,
			   recurs,interact,headerSeparator,
			   valueSeparator,
			   cellSeparator,lineSeparator,service,lynx,
			   embedded);
	     }
	     else {
		 new FilterTag((base.equals("")?url:base),
			       isUrl,fos,		
			       tableNumber,orientation,repeat,
			       recurs,interact,headerSeparator,
			       valueSeparator,
			       cellSeparator,lineSeparator,service,lynx,
			       embedded,tagFile);
	     }
	   }
	   catch(FileNotFoundException e) {
	     System.out.println("Impossible to create the output file.");
	     return;
	   }
	 }
  }
  
  public Linearize(String url,
		   int tableNumber,int orientation,int repeat,
		   int recurs,int interact,
		   String headerSeparator,String valueSeparator,
		   String cellSeparator,String lineSeparator,
		   OutputStream res,String service,int lynx,
		   String base,int embedded,
		   boolean javacc,String tagFile)
       throws IOException {
		     
	 Filter f=null;
	 try {
	   connectURL(url);
	   f=new Filter(isUrl);
	 }
	 catch (MalformedURLException e) { return;}
	 catch (IOException e) {
	   res.write((new String("Impossible to connect remote httpd.")).getBytes());
	   try {
	     if (s!=null) 
	       s.close();
	     if (isUrl!=null)
	       isUrl.close();
	     if (bwUrl!=null)
	       bwUrl.close();
	   }
	   catch (IOException e3) {}
	   return;
	 }
	 catch (FilterException e) {
	   res.write((new String("Problem with input stream.")).getBytes());
	   try {
	     if (s!=null) 
	       s.close();
	     if (isUrl!=null)
	       isUrl.close();
	     if (bwUrl!=null)
	       bwUrl.close();
	   }
	   catch (IOException e3) {}
	   return;
	 }

	   catch (RedirectionException e) {
	       try {
		   if (s!=null) 
		       s.close();
		   if (isUrl!=null)
		       isUrl.close();
		   if (bwUrl!=null)
		       bwUrl.close();
	       }
	       catch (IOException e3) {}
	       if (e.getUrl().indexOf("http://")==0)
		   new Linearize(e.getUrl(),tableNumber,orientation,
				 repeat,recurs,interact,headerSeparator,
				 valueSeparator,cellSeparator,lineSeparator,
				 res,service,lynx,base,embedded,
				 javacc,tagFile);
	       
	       else 
		   new Linearize(hostConn+e.getUrl(),tableNumber,orientation,
				 repeat,recurs,interact,headerSeparator,
				 valueSeparator,cellSeparator,lineSeparator,
				 res,service,lynx,base,embedded,
				 javacc,tagFile);
	       return;	     
 	   }
	   catch (FilterEOFException e) {
	       res.write((new String("Request HTTP problem...")).getBytes());
	       return;
	   }
	   
	   if (javacc)
	       new html4(url,
			 isUrl,
			 res,
			 tableNumber,
			 orientation,
			 repeat,
			 recurs,
			 interact,
			 headerSeparator,
			 valueSeparator,
			 cellSeparator,
			 lineSeparator,
			 service,
			 lynx,
			 embedded);
	   else
	       new FilterTag(url,
			 isUrl,
			 res,
			 tableNumber,
			 orientation,
			 repeat,
			 recurs,
			 interact,
			 headerSeparator,
			 valueSeparator,
			 cellSeparator,
			 lineSeparator,
			 service,
			 lynx,
			 embedded,tagFile);

  }
  
  /* 
   * Connect the url
   */
  private void connectURL(String urlStr) throws MalformedURLException,
	 IOException {
    URL url=new URL(urlStr);
    hostConn=url.getHost();
    s=new Socket(url.getHost(),url.getPort()==-1?80:url.getPort());
    s.setSoTimeout(45000);
    //s.setTcpNoDelay(true);
    //s.setSoLinger(true,1);
    isUrl=s.getInputStream();
    bwUrl=new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
    readHTML(url);
  }
  
    /*
   * Send the a GET request to the server
   */
    private void readHTML(URL url) {
      String file=url.getFile();
      String line=null;
      
      line="GET "+file+" HTTP/1.0\nHost: "+url.getHost()+
	(url.getPort()==-1?"\n":(":"+url.getPort()+"\n"))+
	  "User-Agent: W3C-Tablin/0.6b2\nConnection: Close\nPragma: no-cache\n\n";
      //line="GET "+file+" HTTP/1.0\n\n";
  
      //System.out.println("Line="+line);
      
      try {
	bwUrl.write(line);
	bwUrl.flush();
      }
      catch (IOException e) {
	System.out.print("Content-type: text/html\n\n");
	System.out.println("Problem sending request at httpd");
	return;
      }
    }
  
  public static void main(String argv[]) {
    int nbr=argv.length;
    int ind=-1;
    int table=0;
    int orient=1;
    int repeat=4;
    int recurs=0;
    int interact=0;
    String hs=", ";
    String vs="= ";
    String cs=", ";
    String ls="";
    int type=STDIN;
    String url=null;
    String outputFile=null;
    String service=null;
    int lynx=0;
    String base="";
    int embedded=0;
    String conf=null;
    boolean javacc=false;
    String tagFile=null;

    if (nbr==1 && argv[0].equals("-help")) {
      printHelp();
      return;
    }

    if (getIndiceOption("-javacc",argv)!=-1)
	javacc=true;

    if (getIndiceOption("-ver",argv)!=-1) {
	printVersion();
	return;
    }

    if ((ind=getIndiceOption("-conf",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
	conf=argv[ind+1];
    }
    
    if ((ind=getIndiceOption("-tag",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
	tagFile=argv[ind+1];
    }
    else 
	tagFile="config/tag.dec";
    
    if ((ind=getIndiceOption("-t",argv))!=-1) {
	if (ind+1>=nbr){
	    printHelp();
	    return;
	}
      try {
	table=Integer.parseInt(argv[ind+1]);
      }
      catch(NumberFormatException e) {
	System.out.println("Give a number for table option");
	return;
      }
    }
    
    if ((ind=getIndiceOption("-repeat",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      if (argv[ind+1].equals("deepest4all"))
	repeat=2;
      else 
	  if (argv[ind+1].equals("all4all"))
	      repeat=4;
	  else
	      if (argv[ind+1].equals("deepest"))
		  repeat=1;	    
	      else
		  if (argv[ind+1].equals("all"))
		      repeat=3;	    
	      else {
		System.out.println("Error... values for repeat can only be: all4all or deepest4all");
		return;
	    }
    }

    if ((ind=getIndiceOption("-base",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
	base=argv[ind+1];
	if (base.lastIndexOf(".htm")!=-1) {
	    base=base.substring(0,
				base.lastIndexOf('/')+1);
	}
    }

    if (getIndiceOption("-e",argv)!=-1) {
	if (getIndiceOption("-url",argv)==-1)
	    if (base.equals("")) {
		System.out.println("If you want to change the embedded URL (loading a local file), please give me a base (-base option).");
		return;
	    }
	embedded=1;
    }
    
    if ((ind=getIndiceOption("-orient",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
	if (argv[ind+1].equals("row"))
	    orient=1;
	else 
	    if (argv[ind+1].equals("column"))
		orient=2;
	    else
		if (argv[ind+1].equals("markup"))
		    orient=3;
		else {
		    System.out.println("Error... values for orientation can only be: row,column or markup");
		    return;
		}
    }
    
    if ((ind=getIndiceOption("-r",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      if (argv[ind+1].equals("true")) {
	  service=Tools.getService(conf);
	  recurs=1;
      }
      else 
	  if (argv[ind+1].equals("false"))
	      recurs=0;
	  else {
	      System.out.println("Error... values for recursive can only be: true or false");
	      return;
	  }
    }
    
    if ((ind=getIndiceOption("-hs",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      hs=parse(argv[ind+1]);
    }
    
    if ((ind=getIndiceOption("-vs",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      vs=parse(argv[ind+1]);
    }
    
    if ((ind=getIndiceOption("-cs",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      cs=parse(argv[ind+1]);
    }
    
    if ((ind=getIndiceOption("-ls",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      ls=parse(argv[ind+1]);
    }
    
    if ((ind=getIndiceOption("-o",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      outputFile=argv[ind+1];
    }
    
    if (getIndiceOption("-x",argv)!=-1) 
	lynx=1;

    if ((ind=getIndiceOption("-interact",argv))!=-1) {
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
      try {
	interact=Integer.parseInt(argv[ind+1]);
      }
      catch(NumberFormatException e) {
	System.out.println("Give a number for Interaction mode");
	return;
      }
      if (interact<0 || interact>1) {
	System.out.println("Error... values for interact can only be: 0 or 1");
	return;
      }
      if (service==null) {
	service=Tools.getService(conf);
      }
    }    

    if ((ind=getIndiceOption("-url",argv))!=-1)
      type=URL;
    else 
      if ((ind=getIndiceOption("-file",argv))!=-1)
	type=FILE;
    
    if (recurs==1 && (type==STDIN || type==FILE) && 
	base.equals("")) {
      System.out.println("If you want use recursive mode with file please give me a base (-base option)");
      return;
    }

    if (type==URL && embedded==1)
      base="";

    if (!base.equals("")) {
      if (base.length()>7) {
	if (!base.substring(0,7).equalsIgnoreCase("http://")) {
	  System.out.println("Bad base...");
	  return;
	}
      }
      else {
	System.out.println("Bad base...");
	return;
      }
    }

    if (service!=null) {
      if (service.length()>7) {
	if (!service.substring(0,7).equalsIgnoreCase("http://")) {
	  System.out.println("Bad url in config.cfg...");
	  return;
	}
      }
      else {
	System.out.println("Bad url in config.cfg...");
	return;
      }
    }

    if (type!=STDIN) {      
	if (ind+1>=nbr) {
	    printHelp();
	    return;
	}
	url=argv[ind+1];
      try {
	new Linearize(url,
		      table,orient,repeat,recurs,
		      interact,
		      hs,vs,cs,ls,type,outputFile,
		      service,lynx,base,embedded,javacc,tagFile);
      }
      catch(IOException e) {
	System.out.println("Problem with streams.");
      }
    }
    else 
	try {
	    new Linearize(table,orient,repeat,recurs,interact,
			  hs,vs,cs,ls,outputFile,
			  service,lynx,base,embedded,javacc,tagFile);
	}
	catch (IOException e) {
	    System.out.println("Problem with streams.");
	}
  }
    
  private static void printHelp() {
    System.out.println("java Linearize [ (-url <url>) | (-file <string>) ] [-t <number>] [-orient <string>] [-repeat <string>] [-r <boolean>] [-hs <string>] [-vs <string>] [-cs <string>] [-ls <string>] [-interact <number>] [-base <string>] [-o <string>] [-x] [-e] [-conf <string>] [-javacc] [-tag <string>] [-ver]");
  }
  
  private static int getIndiceOption(String option,String[] tab) {
    for (int cpt=0;cpt<tab.length;cpt++) 
      if (tab[cpt].equals(option))
	return cpt;
    return -1;
  }

    private static void printVersion() {
	System.out.println("Tablin version 0.6b2 (20000225)");
	return;
    }
  
  
  private static String parse(String value) {
    StringBuffer sb=new StringBuffer();
    int begin=0;
    int end=0;
    while (true) {
      end=value.indexOf('\\',end);
      if (end==-1) {
	sb.append(value.substring(begin));
	break;
      }
      sb.append(value.substring(begin,end));
      switch (value.charAt(end+1)) {
      case 'r' : 
	sb.append('\r');
	begin=end+2;
	end=begin;
	break;
      case 't' : 
	sb.append('\t');
	begin=end+2;
	end=begin;
	break;
      case 'n' :
	sb.append('\n');
	begin=end+2;
	end=begin;
	break;
      default : 
	sb.append('\\');
	begin=++end;
      }
    } 
    return new String(sb);
  }
}
