import org.w3c.wai.tablin.Linearize;

import java.io.*;
import java.util.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

public class TablinServlet extends HttpServlet implements SingleThreadModel {
  private String service=null;
  private final String fileName="url.log";
  private FileWriter fw=null;
    private String tagFile=null;

    public void init(ServletConfig config) throws ServletException
    {
      //System.out.println("Servlet initialized...");
      super.init(config);
      //try {
      //fw=new FileWriter(fileName,true);
      //}
      //catch (IOException e) {
      //System.out.println("No log file.");
      //}
      service=config.getInitParameter("service");
      tagFile=config.getInitParameter("tag");
    }
  
    public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {
	
      int table=0;
      int orient=1;
      int recurs=0;
      int interact=1;
      String hs=", ";
      String vs="= ";
      String cs=", ";
      String ls="";
      int repeat=4;
      int embedded=0;
      
      if (service.length()<8 || 
	  service.indexOf("http://")!=0) {
	problem("Problem in servlet.properties file. Service must be an url.",res); 
	return;
      }
      
	  
      if (req.getParameterValues("url")[0].equals("") ||
	  req.getParameterValues("url")[0].length()<8 ||
	  req.getParameterValues("url")[0].indexOf("http://")!=0) {
	problem("Please give me an url.",res);
	return;
      }
     
      /*try {
	fw.write(req.getParameterValues("url")[0]);
	}
	catch (IOException e) {
	System.out.println("No log file.");
	}*/
 
      String tableno=req.getParameterValues("tableno")[0];
      if (!tableno.equals("")) {
	try {
	  table=Integer.parseInt(tableno);
	}
	catch (NumberFormatException e) {
	  problem("Value of table is an integer greater or equal to 0.",res);
	  return;
	}
      }
      
      if (!req.getParameterValues("cellSeparator")[0].equals("")) 
	cs=req.getParameterValues("cellSeparator")[0];
      
      if (!req.getParameterValues("headerSeparator")[0].equals("")) 
	hs=req.getParameterValues("headerSeparator")[0];
      
      if (!req.getParameterValues("valueSeparator")[0].equals("")) 
	vs=req.getParameterValues("valueSeparator")[0];

      /*if (!req.getParameterValues("lineSeparator")[0].equals("")) 
	ls=req.getParameterValues("lineSeparator")[0];*/
      
      if (req.getParameterValues("orient")[0].equals("row")) 
	orient=1;
      else 
	if (req.getParameterValues("orient")[0].equals("col")) 
	  orient=2;
	else 
          orient=3;
      
      if (req.getParameterValues("recurs")!=null) 
	recurs=1;
      
      if (req.getParameterValues("embedded")!=null) 
	embedded=1;

      String srepeat=req.getParameterValues("repeat")[0];
      try {
	repeat=Integer.parseInt(srepeat);
      }
      catch (NumberFormatException e) {
	problem("Bad form. The value of repeat field is an integer.",res);
	return;
      }
      
      String sinteract=req.getParameterValues("interact")[0];
      try {
	interact=Integer.parseInt(sinteract);
	if (interact==2)
	  interact=0;
      }
      catch (NumberFormatException e) {
	problem("Bad form. The value of interact field is an integer.",res);
	return;
      }
      
      URL anUrl=null;
      try {
	anUrl=new URL(req.getParameterValues("url")[0]);
	try {
	  URLConnection uc=anUrl.openConnection();
	  /*if (uc.getContentType().equals("text/html"))
	    res.setContentType("text/html");
	    else 
	    res.setContentType("text/plain");*/
	}
	catch (IOException e2) {
	  problem("Problem with input stream.",res);
	  return;
	}
      }
      catch(MalformedURLException e) {
	problem("Malformed URL.",res);
	return;
      }
      

      try {
	new Linearize(req.getParameterValues("url")[0],
		      table,orient,repeat,recurs,interact,
		      hs,vs,cs,ls,res.getOutputStream(),service,0,
		      "",
		      embedded,
		      //req.getParameterValues("new")==null?true:false,
		      false,
		      tagFile);
      }
      catch (IOException e) {
        problem("Problem with streams.",res);
	return;
      }
      
      
    }
  
  private void problem(String line,HttpServletResponse res) 
       throws IOException {
	 res.setContentType("text/html");
	 PrintWriter toClient = res.getWriter();
	 toClient.println("<html>");
	 toClient.println("<title>Problem!</title>");
	 toClient.println(line);
	 toClient.close();
  }

  public String getServletInfo() {
    return "HTML Table Linearizer (v0.5b2)";
  }
  
  public void destroy() {
      /*try {
	fw.close();
	}
	catch(Exception e) {
	
	}*/
  }

}






