﻿package wcagSamples {
	import flash.display.*;
	import flash.text.*;
	import fl.controls.*
	import flash.accessibility.*;
	import fl.accessibility.*;


	/**
	 *  Basic example that demonstrates how to simulate a fieldset, as provided in HTML.
	 *  The FieldSet class takes a group of controls and places them inside a fieldset rectangle 
	 *  with the legend text at the top. For each form control, the legend text is prepended to the control's
	 *  accessible name
	 *  
	 *  Note: This is only a proof of concept, not a fully functional class
	 * 
	 *  @langversion 3.0
	 *  @playerversion Flash 10
	 * 
	 */
	public class FieldSet extends Sprite{
		private var legend:String;
		private var bBox:Shape;
		private var currentY:int = 20;
		
	public static var LABEL_OFFSET_X:int = 20;
	public static var CONTROL_OFFSET_X:int = 110;

	/** 
	 *  CONSTRUCTOR
	 *  Legend specifies the FieldSet's legend text, items is an array describing the controls to be added to the FieldSet 
	 */
	 
	public function FieldSet(legendText:String, items:Array) {	
			// enable accessibility for components used in this example
			RadioButtonAccImpl.enableAccessibility();
			CheckBoxAccImpl.enableAccessibility();
			
			//create FieldSet rectangle and legend
			legend = legendText;
			bBox = new Shape();
			bBox.graphics.lineStyle(1);
			bBox.graphics.drawRect(10, 10, 300, 250);
			bBox.graphics.beginFill(0x0000FF, 1);
			addChild(bBox);
			
			var fieldSetLegend:TextField = new TextField();
			fieldSetLegend.text = legend;
			fieldSetLegend.x = 20;
			fieldSetLegend.y = 3;
			fieldSetLegend.background = true;
			fieldSetLegend.backgroundColor = 0xFFFFFF;
			fieldSetLegend.border = true;
			fieldSetLegend.borderColor = 0x000000;
			fieldSetLegend.autoSize = TextFieldAutoSize.LEFT;
			addChild(fieldSetLegend);
			
			// add controls
			for (var i = 0; i < items.length; i++) {
				processItem(items[i]);	
			}
		}
		
		/**
		 * Adds the control to the Fieldset and sets its accessible name. A control is represented as an array,
		 * containing the following values:
		 * [0] : A string describing the component type (can be "TextInput", TextArea", Checkbox" or "RadioGroup").
		 * [1] : The label used to identify the control
		 * [2] : If [0] is "RadioGroup", then [2] needs to contain an array of the labels for each individual radio button.
		 *       if [0] is "CheckBox", then [1] can either be empty or a question (e.g. "Do you smoke?"), and [2] the CheckBox label
		 *       (e.g. "Yes").
		 *
		 */
		function processItem(item:Array) {
			if (item.length < 2)
				return;
			currentY += 30;
			var newControl;
			//create visual label
			var lbl:Label;
			lbl = new Label();
			lbl.text = item[1] + ": ";
			lbl.x = FieldSet.LABEL_OFFSET_X;
			lbl.y = currentY;
			lbl.width = FieldSet.CONTROL_OFFSET_X; 
			lbl.autoSize = TextFieldAutoSize.RIGHT;
			lbl.wordWrap = true;
			addChild(lbl);	
			switch (item[0]) {
				case "TextInput":
				case "TextArea":
					newControl = item[0] == "TextInput" ? new TextInput() : new TextArea();
					newControl.x = FieldSet.CONTROL_OFFSET_X;
					//concatenate accessible name, combining legend and label
					setAccName(newControl, legend + " " + item[1]);	
				break;
				case "CheckBox":
					newControl = new CheckBox();
					newControl.label = item[2];
					newControl.x = FieldSet.CONTROL_OFFSET_X;
					setAccName(newControl, legend + " " + item[1]);
				break;
				case "RadioGroup":
					if (item[2] && item[2].length > 0) {
						var radioGroup:RadioButtonGroup = new RadioButtonGroup(item[0]);
						var newBtn:RadioButton;;
						for (var i = 0; i < item[2].length; i++) {
							newBtn = new RadioButton();
							// concatenate the legend, the group label, and the button label
							setAccName(newBtn, legend + " " + item[1]);
							newBtn.label = item[2][i];
							newBtn.group = radioGroup;
							newBtn.x = FieldSet.CONTROL_OFFSET_X;
							newBtn.y = currentY;
							addChild(newBtn);
							if (i < item[2].length -1)
								currentY += 30;
						}
					}
				break;
			}
			
			if (newControl) {
				newControl.y = currentY;
				addChild(newControl);
			}
		}
		
		/**
		 * Creates and AccessibilityProperties object for an object and sets its name property
		 */
		public function setAccName(obj,accName) {
			var accProps:AccessibilityProperties = new AccessibilityProperties();
			accProps.name = accName;
			obj.accessibilityProperties = accProps;	
			
		}
	}
}