package {
	import fl.video.*;
	import flash.events.*;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.net.URLRequest;
	import flash.display.Sprite;

	public class AudioDescriptions extends Sprite {
		private var channel:SoundChannel = new SoundChannel;
		private var myPlayer:FLVPlayback;
		private var _enabled: Boolean = true;
		private var _toggleBtn:Button;
		private var snd:Sound = new Sound();
		public function AudioDescriptions() {
			//point myPlayer to the FLVPlayback component instance on the stage, which should be loaded with a valid video source.
			myPlayer = my_FLVPlybk;
			//add cue points. When any of these are reached, the MetadataEvent.CUE_POINT event will fire
			myPlayer.addASCuePoint(8.35, "ASpt1");
			myPlayer.addASCuePoint(23.23, "ASpt2");
			
			enable();
			
			enable_AD_btn.addEventListener(MouseEvent.CLICK, handleBtnClick);
		}
		
		private function handleBtnClick(e) {
			_enabled = !_enabled;
			if (!_enabled) {
				disable();
				enable_AD_btn.label = "Enable Audio Descriptions";
			}
			else {
				enable();
				enable_AD_btn.label = "Disable Audio Descriptions";
			}
		}
			
		public function enable() {
			// set up an event handler which will be called each time a cue point is reached
			myPlayer.addEventListener(MetadataEvent.CUE_POINT, cp_listener);
		}
		
		public function disable() {
			// set up an event handler which will be called each time a cue point is reached
			myPlayer.removeEventListener(MetadataEvent.CUE_POINT, cp_listener);
		}
	
		private function cp_listener(eventObject:MetadataEvent):void {
			snd= new Sound(); //recreate sound object as it can only load one mp3 file
			//check to see which cue point was reached 
			switch (eventObject.info.name) {
			case "ASpt1":
				snd.load(new URLRequest("sphere.mp3")); //create a new Sound object, and load the appropriate mp3	
				channel = snd.play(); // play the audio description, and assign it to the SoundChannel object
				break;
			case "ASpt2":
				snd.load(new URLRequest("transfrm.mp3"));
				channel = snd.play();			
				break;
			}
		}
	}
}