<!-- ...................................................................... -->
<!-- Voice XML SSML Module  ...................................... -->
<!-- file: voicexml-ssml-1.mod

     This is VoiceXML 2.0, a reprosodyulation of Voice XML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: voicexml-ssml-1.mod,v 0.1 2001/10/25 00:00:00 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ELEMENTS VOICEXML SSML 1.0//EN"
       SYSTEM "http://www.w3.org/TR/voicexml-modularization/DTD/voicexml-ssml-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- System Output and Speech Synthesis Markup Language (SSML) elements

        prompt, value, audio, emphasis, voice, break, prosody, say-as,
	  phoneme, paragraph, p, sentence, s

     This module declares the System Output and SSML types and their attributes.
--> 

<!ENTITY % VOICEXML.prompt.qname "prompt" >
<!ENTITY % VOICEXML.value.qname "value" >
<!ENTITY % VOICEXML.audio.qname "audio" >
<!ENTITY % VOICEXML.emphasis.qname "emphasis" >
<!ENTITY % VOICEXML.voice.qname "voice" >
<!ENTITY % VOICEXML.break.qname "break" >
<!ENTITY % VOICEXML.prosody.qname "prosody" >
<!ENTITY % VOICEXML.say-as.qname "say-as" >
<!ENTITY % VOICEXML.phoneme.qname "phoneme" >
<!ENTITY % VOICEXML.paragraph.qname "paragraph" >
<!ENTITY % VOICEXML.p.qname "p" >
<!ENTITY % VOICEXML.sentence.qname "sentence" >
<!ENTITY % VOICEXML.s.qname "s" >
<!ENTITY % VOICEXML.mark.qname "mark" >

<!ENTITY % SentenceContent.mix "%Audio.mix; | %SentenceElements.class;" >

<!-- prompt:  Definition List ............................ -->

<!ENTITY % prompt.element "INCLUDE" >
<![%prompt.element;[
<!ENTITY % prompt.content "(%Audio.mix; | %TTS.mix;)*" >
<!ELEMENT %VOICEXML.prompt.qname; %prompt.content; >
<!-- end of prompt.element -->]]>

<!ENTITY % prompt.attlist "INCLUDE" >
<![%prompt.attlist;[
<!ATTLIST %VOICEXML.prompt.qname;
	bargein	%Boolean.datatype;	#IMPLIED
	bargeintype	(energy | speech | recognition) #IMPLIED
	cond		%Script.datatype;		#IMPLIED
	count		%Integer.datatype;	#IMPLIED
	xml:lang	NMTOKEN			#IMPLIED
	timeout	%Duration.datatype;	#IMPLIED >
<!-- end of prompt.attlist -->]]>

<!-- value:  Definition List ............................ -->

<!ENTITY % value.element "INCLUDE" >
<![%value.element;[
<!ENTITY % value.content "EMPTY" >
<!ELEMENT %VOICEXML.value.qname; %value.content; >
<!-- end of value.element -->]]>

<!ENTITY % value.attlist "INCLUDE" >
<![%value.attlist;[
<!ATTLIST %VOICEXML.value.qname;
	expr		%Script.datatype; 	#REQUIRED >
<!-- end of value.attlist -->]]>

<!-- audio:  Definition List ............................ -->

<!ENTITY % audio.element "INCLUDE" >
<![%audio.element;[
<!ENTITY % audio.content "(%Audio.mix; | %TTS.mix;)*" >
<!ELEMENT %VOICEXML.audio.qname; %audio.content; >
<!-- end of audio.element -->]]>

<!ENTITY % audio.attlist "INCLUDE" >
<![%audio.attlist;[
<!ATTLIST %VOICEXML.audio.qname;
	src	%URI.datatype;		#IMPLIED
	expr	%Script.datatype;		#IMPLIED
	%VOICEXML.Cache.attrib; >
<!-- end of audio.attlist -->]]>

<!-- emphasis:  Definition List ............................ -->

<!ENTITY % emphasis.element "INCLUDE" >
<![%emphasis.element;[
<!ENTITY % emphasis.content "(%SentenceContent.mix;)*" >
<!ELEMENT %VOICEXML.emphasis.qname; %emphasis.content; >
<!-- end of emphasis.element -->]]>

<!ENTITY % emphasis.attlist "INCLUDE" >
<![%emphasis.attlist;[
<!ATTLIST %VOICEXML.emphasis.qname;
	level	  (strong | moderate | none | reduced) 'moderate' >
<!-- end of emphasis.attlist -->]]>

<!-- voice:  Definition List ............................ -->

<!ENTITY % voice.element "INCLUDE" >
<![%voice.element;[
<!ENTITY % voice.content "(%SentenceContent.mix; | %Structure.class;)*" >
<!ELEMENT %VOICEXML.voice.qname; %voice.content; >
<!-- end of voice.element -->]]>

<!ENTITY % voice.attlist "INCLUDE" >
<![%voice.attlist;[
<!ATTLIST %VOICEXML.voice.qname;
	gender 	(male | female | neutral)	#IMPLIED
	age	  	%Integer.datatype;		#IMPLIED
	category	(child | teenager | adult | elder)  #IMPLIED
	variant	%Integer.datatype;		#IMPLIED
	name		CDATA					#IMPLIED >
<!-- end of voice.attlist -->]]>

<!-- break:  Definition List ............................ -->

<!ENTITY % break.element "INCLUDE" >
<![%break.element;[
<!ENTITY % break.content "EMPTY" >
<!ELEMENT %VOICEXML.break.qname; %break.content; >
<!-- end of break.element -->]]>

<!ENTITY % break.attlist "INCLUDE" >
<![%break.attlist;[
<!ATTLIST %VOICEXML.break.qname;
	size		(large | medium | small | none)  'medium'
	time		%Duration.datatype; >
<!-- end of break.attlist -->]]>

<!-- prosody:  Definition List ............................ -->

<!ENTITY % prosody.element "INCLUDE" >
<![%prosody.element;[
<!ENTITY % prosody.content "(%SentenceContent.mix; | %Structure.class;)*" >
<!ELEMENT %VOICEXML.prosody.qname; %prosody.content; >
<!-- end of prosody.element -->]]>

<!ENTITY % prosody.attlist "INCLUDE" >
<![%prosody.attlist;[
<!ATTLIST %VOICEXML.prosody.qname;
	pitch		CDATA		#IMPLIED
	contour	CDATA		#IMPLIED
	range		CDATA		#IMPLIED
	rate		CDATA		#IMPLIED
	duration	CDATA		#IMPLIED
	volume	CDATA		#IMPLIED >
<!-- end of prosody.attlist -->]]>

<!-- mark:  Definition List ............................ -->

<!ENTITY % mark.element "INCLUDE" >
<![%mark.element;[
<!ENTITY % mark.content "EMPTY" >
<!ELEMENT %VOICEXML.mark.qname; %mark.content; >
<!-- end of mark.element -->]]>

<!ENTITY % mark.attlist "INCLUDE" >
<![%mark.attlist;[
<!ATTLIST %VOICEXML.mark.qname;
	name		CDATA 	#REQUIRED >
<!-- end of mark.attlist -->]]>

<!-- say-as:  Definition List ............................ -->

<!ENTITY % say-as.element "INCLUDE" >
<![%say-as.element;[
<!ENTITY % say-as.content "(#PCDATA
				    %Value.class;)" >
<!ELEMENT %VOICEXML.say-as.qname; %say-as.content; >
<!-- end of say-as.element -->]]>

<!ENTITY % say-as.attlist "INCLUDE" >
<![%say-as.attlist;[
<!ATTLIST %VOICEXML.say-as.qname;
	type		CDATA		#REQUIRED
	sub		CDATA 	#IMPLIED >
<!-- end of say-as.attlist -->]]>

<!-- phoneme:  Definition List ............................ -->

<!ENTITY % phoneme.element "INCLUDE" >
<![%phoneme.element;[
<!ENTITY % phoneme.content "(#PCDATA)" >
<!ELEMENT %VOICEXML.phoneme.qname; %phoneme.content; >
<!-- end of phoneme.element -->]]>

<!ENTITY % phoneme.attlist "INCLUDE" >
<![%phoneme.attlist;[
<!ATTLIST %VOICEXML.phoneme.qname;
	ph		CDATA		#REQUIRED
	alphabet	CDATA 	#IMPLIED >
<!-- end of phoneme.attlist -->]]>

<!-- paragraph:  Definition List ............................ -->

<!ENTITY % paragraph.element "INCLUDE" >
<![%paragraph.element;[
<!ENTITY % paragraph.content "(%SentenceContent.mix; | %Sentence.class;)*" >
<!ELEMENT %VOICEXML.paragraph.qname; %paragraph.content; >
<!-- end of paragraph.element -->]]>

<!ENTITY % paragraph.attlist "INCLUDE" >
<![%paragraph.attlist;[
<!ATTLIST %VOICEXML.paragraph.qname;
	xml:lang	NMTOKEN	#IMPLIED >
<!-- end of paragraph.attlist -->]]>

<!-- p:  Definition List ............................ -->

<!ENTITY % p.element "INCLUDE" >
<![%p.element;[
<!ENTITY % p.content "(%SentenceContent.mix; | %Sentence.class;)*" >
<!ELEMENT %VOICEXML.p.qname; %p.content; >
<!-- end of p.element -->]]>

<!ENTITY % p.attlist "INCLUDE" >
<![%p.attlist;[
<!ATTLIST %VOICEXML.p.qname;
	xml:lang	NMTOKEN	#IMPLIED >
<!-- end of p.attlist -->]]>

<!-- sentence:  Definition List ............................ -->

<!ENTITY % sentence.element "INCLUDE" >
<![%sentence.element;[
<!ENTITY % sentence.content "(%SentenceContent.mix;)*" >
<!ELEMENT %VOICEXML.sentence.qname; %sentence.content; >
<!-- end of sentence.element -->]]>

<!ENTITY % sentence.attlist "INCLUDE" >
<![%sentence.attlist;[
<!ATTLIST %VOICEXML.sentence.qname;
	xml:lang	NMTOKEN	#IMPLIED >
<!-- end of sentence.attlist -->]]>

<!-- s:  Definition List ............................ -->

<!ENTITY % s.element "INCLUDE" >
<![%s.element;[
<!ENTITY % s.content "(%SentenceContent.mix;)*" >
<!ELEMENT %VOICEXML.s.qname; %s.content; >
<!-- end of s.element -->]]>

<!ENTITY % s.attlist "INCLUDE" >
<![%s.attlist;[
<!ATTLIST %VOICEXML.s.qname;
	xml:lang	NMTOKEN	#IMPLIED >
<!-- end of s.attlist -->]]>

<!-- end of voicexml-ssml-1.mod -->