<!-- ....................................................................... -->
<!-- VOICEXML Qname Module  ................................................ -->
<!-- file: voicexml-qname-1.mod

     This is VOICEXML 2.0, a reformulation of VOICEXML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: VOICEXML-qname-1.mod,v 4.0 2001/10/19 22:42:49 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ENTITIES VOICEXML Qualified Names 1.0//EN"
       SYSTEM "http://www.w3.org/TR/VOICEXML-modularization/DTD/voicexml-qname-1.mod"

     Revisions:
#2000-10-22: added qname declarations for ruby elements
     ....................................................................... -->

<!-- VOICEXML Qname (Qualified Name) Module

     This module is contained in two parts, labeled Section 'A' and 'B':

       Section A declares parameter entities to support namespace-
       qualified names, namespace declarations, and name prefixing
       for VOICEXML and extensions.

       Section B declares parameter entities used to provide
       namespace-qualified names for all VOICEXML element types:

         %catch.qname;   the xmlns-qualified name for <catch>
         %field.qname;   the xmlns-qualified name for <field>
         ...

     VOICEXML extensions would create a module similar to this one.
     Included in the VOICEXML distribution is a template module
     ('template-qname-1.mod') suitable for this purpose.
-->

<!-- Section A: VOICEXML XML Namespace Framework :::::::::::::::::::: -->

<!-- 1. Declare a %VOICEXML.prefixed; conditional section keyword, used
        to activate namespace prefixing. The default value should
        inherit '%NS.prefixed;' from the DTD driver, so that unless
        overridden, the default behaviour follows the overall DTD
        prefixing scheme.
-->
<!ENTITY % NS.prefixed "IGNORE" >
<!ENTITY % VOICEXML.prefixed "%NS.prefixed;" >

<!-- 2. Declare a parameter entity (eg., %VOICEXML.xmlns;) containing
        the URI reference used to identify the VOICEXML namespace:
-->
<!ENTITY % VOICEXML.xmlns  "http://www.w3.org/2001/voicexml20" >

<!-- 3. Declare parameter entities (eg., %VOICEXML.prefix;) containing
        the default namespace prefix string(s) to use when prefixing
        is enabled. This may be overridden in the DTD driver or the
        internal subset of an document instance. If no default prefix
        is desired, this may be declared as an empty string.

     NOTE: As specified in [XMLNAMES], the namespace prefix serves
     as a proxy for the URI reference, and is not in itself significant.
-->
<!ENTITY % VOICEXML.prefix  "vxml" >

<!-- 4. Declare parameter entities (eg., %VOICEXML.pfx;) containing the
        colonized prefix(es) (eg., '%VOICEXML.prefix;:') used when
        prefixing is active, an empty string when it is not.
-->
<![%VOICEXML.prefixed;[
<!ENTITY % VOICEXML.pfx  "%VOICEXML.prefix;:" >
]]>
<!ENTITY % VOICEXML.pfx  "" >

<!-- declare qualified name extensions here ............ -->
<!ENTITY % VOICEXML-qname-extra.mod "" >
%VOICEXML-qname-extra.mod;

<!-- 5. The parameter entity %VOICEXML.xmlns.extra.attrib; may be
        redeclared to contain any non-VOICEXML namespace declaration
        attributes for namespaces embedded in VOICEXML. The default
        is an empty string.  XLink should be included here if used
        in the DTD.
-->
<!ENTITY % VOICEXML.xmlns.extra.attrib "" >

<!-- The remainder of Section A is only followed in VOICEXML, not extensions. -->

<!-- Declare a parameter entity %NS.decl.attrib; containing
     all XML Namespace declarations used in the DTD, plus the
     xmlns declaration for VOICEXML, its form dependent on whether
     prefixing is active.
-->
<![%VOICEXML.prefixed;[
<!ENTITY % NS.decl.attrib
     "xmlns:%VOICEXML.prefix;  %URI.datatype; #FIXED '%VOICEXML.xmlns;'
      %VOICEXML.xmlns.extra.attrib;"
>
]]>
<!ENTITY % NS.decl.attrib
     "%VOICEXML.xmlns.extra.attrib;"
>

<!-- This is a placeholder for future XLink support.
-->
<!ENTITY % XLINK.xmlns.attrib "" >

<!-- Declare a parameter entity %NS.decl.attrib; containing all
     XML namespace declaration attributes used by VOICEXML, including
     a default xmlns attribute when prefixing is inactive.
-->
<![%VOICEXML.prefixed;[
<!ENTITY % VOICEXML.xmlns.attrib
     "%NS.decl.attrib;
      %XLINK.xmlns.attrib;"
>
]]>
<!ENTITY % VOICEXML.xmlns.attrib
     "xmlns        %URI.datatype;	#FIXED '%VOICEXML.xmlns;'
      %XLINK.xmlns.attrib;"
>

<!-- placeholder for qualified name redeclarations -->
<!ENTITY % VOICEXML-qname.redecl "" >
%VOICEXML-qname.redecl;

<!-- Section B: VOICEXML Qualified Names ::::::::::::::::::::::::::::: -->

<!-- 6. This section declares parameter entities used to provide
        namespace-qualified names for all VOICEXML element types.
-->

<!-- module:  voicexml-events-1.mod -->
<!ENTITY % VOICEXML.catch.qname   "%VOICEXML.pfx;catch" >
<!ENTITY % VOICEXML.help.qname    "%VOICEXML.pfx;help" >
<!ENTITY % VOICEXML.noinput.qname "%VOICEXML.pfx;noinput" >
<!ENTITY % VOICEXML.nomatch.qname "%VOICEXML.pfx;nomatch" >
<!ENTITY % VOICEXML.error.qname   "%VOICEXML.pfx;error" >
<!ENTITY % VOICEXML.throw.qname   "%VOICEXML.pfx;throw" >

<!-- module:  voicexml-exec-1.mod -->
<!ENTITY % VOICEXML.assign.qname   "%VOICEXML.pfx;assign" >
<!ENTITY % VOICEXML.clear.qname    "%VOICEXML.pfx;clear" >
<!ENTITY % VOICEXML.var.qname      "%VOICEXML.pfx;var" >
<!ENTITY % VOICEXML.log.qname	 "%VOICEXML.pfx;log" >
<!ENTITY % VOICEXML.reprompt.qname "%VOICEXML.pfx;reprompt" >

<!-- module:  voicexml-filled-1.mod -->
<!ENTITY % VOICEXML.filled.qname "%VOICEXML.pfx;filled" >

<!-- module:  voicexml-flow-1.mod -->
<!ENTITY % VOICEXML.if.qname "%VOICEXML.pfx;if" >
<!ENTITY % VOICEXML.else.qname "%VOICEXML.pfx;else" >
<!ENTITY % VOICEXML.elseif.qname "%VOICEXML.pfx;elseif" >
<!ENTITY % VOICEXML.return.qname  "%VOICEXML.pfx;return" >

<!-- module:  voicexml-form-1.mod -->
<!ENTITY % VOICEXML.form.qname    "%VOICEXML.pfx;form" >
<!ENTITY % VOICEXML.field.qname   "%VOICEXML.pfx;field" >
<!ENTITY % VOICEXML.record.qname  "%VOICEXML.pfx;record" >
<!ENTITY % VOICEXML.subdialog.qname "%VOICEXML.pfx;subdialog" >
<!ENTITY % VOICEXML.block.qname     "%VOICEXML.pfx;block" >
<!ENTITY % VOICEXML.initial.qname   "%VOICEXML.pfx;initial" >
<!ENTITY % VOICEXML.option.qname    "%VOICEXML.pfx;option" >

<!-- module:  voicexml-menu-1.mod -->
<!ENTITY % VOICEXML.choice.qname    "%VOICEXML.pfx;choice" >
<!ENTITY % VOICEXML.enumerate.qname "%VOICEXML.pfx;enumerate" >
<!ENTITY % VOICEXML.menu.qname      "%VOICEXML.pfx;menu" >

<!-- module:  voicexml-misc-1.mod -->
<!ENTITY % VOICEXML.exit.qname    "%VOICEXML.pfx;exit" >
<!ENTITY % VOICEXML.goto.qname    "%VOICEXML.pfx;goto" >
<!ENTITY % VOICEXML.link.qname    "%VOICEXML.pfx;link" >
<!ENTITY % VOICEXML.script.qname   "%VOICEXML.pfx;script" >
<!ENTITY % VOICEXML.submit.qname  "%VOICEXML.pfx;submit" >

<!-- module:  voicexml-object-1.mod -->
<!ENTITY % VOICEXML.object.qname   "%VOICEXML.pfx;object" >

<!-- module:  voicexml-resource-1.mod -->
<!ENTITY % VOICEXML.param.qname    "%VOICEXML.pfx;param" >
<!ENTITY % VOICEXML.property.qname "%VOICEXML.pfx;property" >

<!-- module:  voicexml-root-1.mod -->
<!ENTITY % VOICEXML.meta.qname     "%VOICEXML.pfx;meta" >
<!ENTITY % VOICEXML.vxml.qname     "%VOICEXML.pfx;vxml" >

<!-- module:  voicexml-ssml-1.mod -->
<!ENTITY % VOICEXML.prompt.qname  "%VOICEXML.pfx;prompt" >
<!ENTITY % VOICEXML.value.qname  "%VOICEXML.pfx;value" >
<!ENTITY % VOICEXML.audio.qname  "%VOICEXML.pfx;audio" >
<!ENTITY % VOICEXML.emphasis.qname  "%VOICEXML.pfx;emphasis" >
<!ENTITY % VOICEXML.voice.qname  "%VOICEXML.pfx;voice" >
<!ENTITY % VOICEXML.break.qname  "%VOICEXML.pfx;break" >
<!ENTITY % VOICEXML.mark.qname	"%VOICEXML.pfx;mark" >
<!ENTITY % VOICEXML.prosody.qname  "%VOICEXML.pfx;prosody" >
<!ENTITY % VOICEXML.say-as.qname  "%VOICEXML.pfx;say-as" >
<!ENTITY % VOICEXML.phoneme.qname  "%VOICEXML.pfx;phoneme" >
<!ENTITY % VOICEXML.paragraph.qname  "%VOICEXML.pfx;paragraph" >
<!ENTITY % VOICEXML.p.qname  "%VOICEXML.pfx;p" >
<!ENTITY % VOICEXML.sentence.qname  "%VOICEXML.pfx;sentence" >
<!ENTITY % VOICEXML.s.qname "%VOICEXML.pfx;s" >
<!ENTITY % VOICEXML.mark.qname "%VOICEXML.pfx;mark" >

<!-- module:  voicexml-telephony-1.mod -->
<!ENTITY % VOICEXML.transfer.qname    "%VOICEXML.pfx;transfer" >
<!ENTITY % VOICEXML.disconnect.qname  "%VOICEXML.pfx;disconnect" >

<!-- module:  voicexml-grammar-1.mod -->
<!ENTITY % VOICEXML.grammar.qname  "%VOICEXML.pfx;grammar" >
<!ENTITY % VOICEXML.count.qname    "%VOICEXML.pfx;count" >
<!ENTITY % VOICEXML.example.qname  "%VOICEXML.pfx;example" >
<!ENTITY % VOICEXML.import.qname   "%VOICEXML.pfx;import" >
<!ENTITY % VOICEXML.item.qname     "%VOICEXML.pfx;item" >
<!ENTITY % VOICEXML.one-of.qname   "%VOICEXML.pfx;one-of" >
<!ENTITY % VOICEXML.rule.qname     "%VOICEXML.pfx;rule" >
<!ENTITY % VOICEXML.ruleref.qname  "%VOICEXML.pfx;ruleref" >
<!ENTITY % VOICEXML.token.qname    "%VOICEXML.pfx;token" >

<!-- end of voicexml-qname-1.mod -->
