<!-- ...................................................................... -->
<!-- Voice XML User Input Module  ......................................... -->
<!-- file: voicexml-grammar-1.mod

     This is VoiceXML 2.0, a reformulation of Voice XML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: voicexml-grammar-1.mod,v 0.1 2001/10/24 00:00:00 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ELEMENTS VOICEXML Grammar 1.0//EN"
       SYSTEM "http://www.w3.org/TR/voicexml-modularization/DTD/voicexml-grammar-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Grammar elements

        grammar, count, token, example, import, item, one-of, rule, ruleref

     This module declares the grammar element types and their attributes.
--> 

<!ENTITY % VOICEXML.grammar.qname "grammar" >
<!ENTITY % VOICEXML.count.qname "count" >
<!ENTITY % VOICEXML.token.qname "token" >
<!ENTITY % VOICEXML.example.qname "example" >
<!ENTITY % VOICEXML.import.qname "import" >
<!ENTITY % VOICEXML.item.qname "item" >
<!ENTITY % VOICEXML.one-of.qname "one-of" >
<!ENTITY % VOICEXML.rule.qname "rule" >
<!ENTITY % VOICEXML.ruleref.qname "ruleref" >

<!ENTITY % RuleExpansion.class 
	"#PCDATA 
      | %VOICEXML.token.qname; 
      | %VOICEXML.ruleref.qname;
      | %VOICEXML.item.qname;
      | %VOICEXML.one-of.qname; 
      | %VOICEXML.count.qname;"
>

<!-- grammar:  Definition List ............................ -->

<!ENTITY % grammar.element "INCLUDE" >
<![%grammar.element;[
<!ENTITY % grammar.content 
        "(#PCDATA | %VOICEXML.import.qname; | %VOICEXML.rule.qname;)*"
>
<!ELEMENT %VOICEXML.grammar.qname; %grammar.content; >
<!-- end of grammar.element -->]]>

<!ENTITY % grammar.attlist "INCLUDE" >
<![%grammar.attlist;[
<!ATTLIST %VOICEXML.grammar.qname;
	%VOICEXML.Cache.attrib;
	version	CDATA			'2.0'
	xml:lang	NMTOKEN		#IMPLIED
	root		IDREF			#IMPLIED
	mode		(voice | dtmf)	'voice'
	scope		%Scope.datatype;	#IMPLIED
	src		%URI.datatype;	#IMPLIED
	type		CDATA			#IMPLIED
	weight	CDATA			#IMPLIED >
<!-- end of grammar.attlist -->]]>

<!-- count:  Definition List ............................ -->

<!ENTITY % count.element "INCLUDE" >
<![%count.element;[
<!ENTITY % count.content "(%RuleExpansion.class;)*" >
<!ELEMENT %VOICEXML.count.qname; %count.content; >
<!-- end of count.element -->]]>

<!ENTITY % count.attlist "INCLUDE" >
<![%count.attlist;[
<!ATTLIST %VOICEXML.count.qname;
	number	CDATA			#IMPLIED
	tag		CDATA			#IMPLIED
	xml:lang	NMTOKEN		#IMPLIED >
<!-- end of count.attlist -->]]>

<!-- token:  Definition List .............................. -->

<!ENTITY % token.element "INCLUDE" >
<![%token.element;[
<!ENTITY % token.content "(#PCDATA)" >
<!ELEMENT %VOICEXML.token.qname; %token.content; >
<!-- end of token.element -->]]>

<!ENTITY % token.attlist "INCLUDE" >
<![%token.attlist;[
<!ATTLIST %VOICEXML.token.qname;
	lexicon	CDATA		#IMPLIED
	xml:lang	NMTOKEN	#IMPLIED >
<!-- end of token.attlist -->]]>

<!-- example:  Definition List ............................ -->

<!ENTITY % example.element "INCLUDE" >
<![%example.element;[
<!ENTITY % example.content "(#PCDATA)" >
<!ELEMENT %VOICEXML.example.qname; %example.content; >
<!-- end of example.element -->]]>

<!-- import:  Definition List ............................ -->

<!ENTITY % import.element "INCLUDE" >
<![%import.element;[
<!ENTITY % import.content "EMPTY" >
<!ELEMENT %VOICEXML.import.qname; %import.content; >
<!-- end of import.element -->]]>

<!ENTITY % import.attlist "INCLUDE" >
<![%import.attlist;[
<!ATTLIST %VOICEXML.import.qname;
	uri	%URI.datatype; #REQUIRED
	name	CDATA		   #REQUIRED >
<!-- end of import.attlist -->]]>

<!-- item:  Definition List ............................ -->

<!ENTITY % item.element "INCLUDE" >
<![%item.element;[
<!ENTITY % item.content	"(%RuleExpansion.class;)*" >
<!ELEMENT %VOICEXML.item.qname; %item.content; >
<!-- end of item.element -->]]>

<!ENTITY % item.attlist "INCLUDE" >
<![%item.attlist;[
<!ATTLIST %VOICEXML.item.qname;
	weight		NMTOKEN	#IMPLIED
	tag			CDATA		#IMPLIED
	xml:lang		NMTOKEN	#IMPLIED >
<!-- end of item.attlist -->]]>

<!-- one-of:  Definition List ............................ -->

<!ENTITY % one-of.element "INCLUDE" >
<![%one-of.element;[
<!ENTITY % one-of.content "(%VOICEXML.item.qname;)*" >
<!ELEMENT %VOICEXML.one-of.qname; %one-of.content; >
<!-- end of one-of.element -->]]>

<!ENTITY % one-of.attlist "INCLUDE" >
<![%one-of.attlist;[
<!ATTLIST %VOICEXML.one-of.qname;
	tag			CDATA		#IMPLIED
	xml:lang		NMTOKEN	#IMPLIED >
<!-- end of one-of.attlist -->]]>

<!-- rule:  Definition List ............................ -->

<!ENTITY % rule.element "INCLUDE" >
<![%rule.element;[
<!ENTITY % rule.content "(%RuleExpansion.class; | %VOICEXML.example.qname;)*" >
<!ELEMENT %VOICEXML.rule.qname; %rule.content; >
<!-- end of rule.element -->]]>

<!ENTITY % rule.attlist "INCLUDE" >
<![%rule.attlist;[
<!ATTLIST %VOICEXML.rule.qname;
	id		ID		#REQUIRED
	scope 	(private | public)    'private' >
<!-- end of rule.attlist -->]]>

<!-- ruleref:  Definition List ............................ -->

<!ENTITY % ruleref.element "INCLUDE" >
<![%ruleref.element;[
<!ENTITY % ruleref.content "EMPTY" >
<!ELEMENT %VOICEXML.ruleref.qname; %ruleref.content; >
<!-- end of ruleref.element -->]]>

<!ENTITY % ruleref.attlist "INCLUDE" >
<![%ruleref.attlist;[
<!ATTLIST %VOICEXML.ruleref.qname;
	uri			%URI.datatype; #IMPLIED
	import		CDATA		#IMPLIED
	special		CDATA		#IMPLIED
	tag			CDATA		#IMPLIED
	xml:lang		NMTOKEN	#IMPLIED >
<!-- end of ruleref.attlist -->]]>

<!-- end of voicexml-grammar-1.mod -->


