<!-- ...................................................................... -->
<!-- Voice XML Form Module  ............................................. -->
<!-- file: voicexml-form-1.mod

     This is VoiceXML 2.0, a reformulation of Voice XML in terms of XML modules.
     Copyright 1998-2001 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: $Id: voicexml-form-1.mod,v 0.1 2001/10/24 00:00:00 gm Exp $ SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

       PUBLIC "-//W3C//ELEMENTS VOICEXML Form 1.0//EN"
       SYSTEM "http://www.w3.org/TR/voicexml-modularization/DTD/voicexml-form-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Form and Form children

        form, field, record, subdialog, block, initial, option

     This module declares the form element types and their attributes.
--> 

<!ENTITY % VOICEXML.option.qname "option" >
<!ENTITY % VOICEXML.initial.qname "initial" >
<!ENTITY % VOICEXML.block.qname "block" >
<!ENTITY % VOICEXML.subdialog.qname "subdialog" >
<!ENTITY % VOICEXML.record.qname "record" >
<!ENTITY % VOICEXML.field.qname "field" >
<!ENTITY % VOICEXML.form.qname "form" >

<!-- %Form.mix; includes all Form content elements ....... -->
<!ENTITY % Form.mix
	"EventHandler.class;
	 Grammar.class;
	 Filled.class;
	 Initial.class;
	 Object.class;
	 Link.class;
	 Property.class;
	 Record.class;
	 Script.class;
	 Subdialog.class;
	 Transfer.class;
	 Variable.class;" >

<!-- option:  Definition List ............................ -->

<!ENTITY % option.element "INCLUDE" >
<![%option.element;[
<!ENTITY % option.content "(#PCDATA)" >
<!ELEMENT %VOICEXML.option.qname; %option.content; >
<!-- end of option.element -->]]>

<!ENTITY % option.attlist "INCLUDE" >
<![%option.attlist;[
<!ATTLIST %VOICEXML.option.qname;
	dtmf CDATA #IMPLIED
	value CDATA #IMPLIED >
<!-- end of option.attlist -->]]>

<!-- initial:  Definition List ............................ -->

<!ENTITY % initial.element "INCLUDE" >
<![%initial.element;[
<!ENTITY % initial.content 
	"( %Audio.mix;
	 | %EventHandler.class;
         %Link.class;
         %Prompt.class;
         %Property.class; )* >
<!ELEMENT %VOICEXML.initial.qname; %initial.content; >
<!-- end of initial.element -->]]>

<!-- block:  Definition List ............................ -->

<!ENTITY % block.element "INCLUDE" >
<![%block.element;[
<!ENTITY % block.content "(%Exec.mix)*" >
<!ELEMENT %VOICEXML.block.qname; %block.content; >
<!-- end of block.element -->]]>

<!ENTITY % block.attlist "INCLUDE" >
<![%block.attlist;[
<!ATTLIST %VOICEXML.block.qname;
	%VOICEXML.Item.attrib; >
<!-- end of block.attlist -->]]>

<!-- subdialog:  Definition List ............................ -->

<!ENTITY % subdialog.element "INCLUDE" >
<![%subdialog.element;[
<!ENTITY % subdialog.content 
	"( %Audio.mix;
	   %Filled.class;
	   %Param.class;
	   %Prompt.class;
	   %Property.class; )*" >
<!ELEMENT %VOICEXML.subdialog.qname; %subdialog.content; >
<!-- end of subdialog.element -->]]>

<!ENTITY % subdialog.attlist "INCLUDE" >
<![%subdialog.attlist;[
<!ATTLIST %VOICEXML.subdialog.qname;
	%VOICEXML.Item.attrib;
	src	%URI.datatype; #REQUIRED
	%VOICEXML.Cache.attrib;
	fetchaudio %URI.datatype; #IMPLIED
	%VOICEXML.Submit.attrib; >
<!-- end of subdialog.attlist -->]]>

<!-- record:  Definition List ............................ -->

<!ENTITY % record.element "INCLUDE" >
<![%record.element;[
<!ENTITY % record.content
	"( %Audio.mix;
	 | %EventHandler.class;
         %Filled.class;
         %Grammar.class;
         %Prompt.class;
         %Property.class; )*" >
<!ELEMENT %VOICEXML.record.qname; %record.content; >
<!-- end of record.element -->]]>

<!ENTITY % record.attlist "INCLUDE" >
<![%record.attlist;[
<!ATTLIST %VOICEXML.record.qname;
	%VOICEXML.Item.attrib;
	type 	CDATA				#IMPLIED
	beep	%Boolean.datatype;	'false'
	dest	%URI.datatype;		#IMPLIED
	maxtime %Duration.datatype;	#IMPLIED
	modal %Boolean.datatype;	'true'
	finalsilence  %Duration.datatype; #IMPLIED
	dtmfterm %Boolean.datatype;	'true' >
<!-- end of record.attlist -->]]>

<!-- field:  Definition List ............................ -->

<!ENTITY % field.element "INCLUDE" >
<![%field.element;[
<!ENTITY % field.content 
	"( %Audio.mix;
	 | %EventHandler.class;
         %Filled.class;
         %Grammar.class;
	   %Link.class;
	 | %VOICEXML.option.qname;
         %Prompt.class;
	   %Property.class; )*" >
<!ELEMENT %VOICEXML.field.qname; %field.content; >
<!-- end of field.element -->]]>

<!ENTITY % field.attlist "INCLUDE" >
<![%field.attlist;[
<!ATTLIST %VOICEXML.field.qname;
	%VOICEXML.Item.attrib;
	type		CDATA		#IMPLIED
	slot		NMTOKEN	#IMPLIED
	modal		%Boolean.datatype; 'false' >
<!-- end of field.attlist -->]]>

<!-- form:  Definition List ............................ -->

<!ENTITY % form.element "INCLUDE" >
<![%form.element;[
<!ENTITY % form.content "( %Form.mix; )*" >
<!ELEMENT %VOICEXML.form.qname; %form.content; >
<!-- end of form.element -->]]>

<!ENTITY % form.attlist "INCLUDE" >
<![%form.attlist;[
<!ATTLIST %VOICEXML.form.qname;
	id		ID		#IMPLIED
	scope %VOICEXML.Scope.attrib;    'dialog' >
<!-- end of form.attlist -->]]>

<!-- end of voicexml-form-1.mod -->
