package org.w3c.ddr.simple.exception;

/**
 * Represents a DDR Exception.
 * 
 * @author Jo Rabin (dotMobi) 
 * @author <br/>Jose Manuel Cantera Fonseca (Telefonica I+D) 
 * @author <br/>Rotan Hanrahan (MobileAware) 
 * @author <br/>Ignacio Marin (Fundacion CTIC) <br/>
 * <a href="http://www.w3.org/Consortium/Legal/ipr-notice#Copyright">Copyright</a>
 * &copy; 2008 <a href="http://www.w3.org/"><acronym title="World Wide Web Consortium">W3C</acronym></a><sup>&reg;</sup>
 * (<a href="http://www.csail.mit.edu/"><acronym title="Massachusetts Institute of Technology">MIT</acronym></a>,
 * <a href="http://www.ercim.org/"><acronym title="European Research Consortium for Informatics and Mathematics">ERCIM</acronym></a>,
 * <a href="http://www.keio.ac.jp/">Keio</a>), All Rights Reserved.<br/>
 * W3C <a href="http://www.w3.org/Consortium/Legal/ipr-notice#Legal_Disclaimer">liability</a>,
 * <a href="http://www.w3.org/Consortium/Legal/ipr-notice#W3C_Trademarks">trademark</a>
 * and <a href="http://www.w3.org/Consortium/Legal/copyright-documents">document use</a> rules apply.
 * 
 */
public class DDRException  extends Exception {

	/**
	 * Implementation specific error codes must be greater than this
	 */
	public static int IMPLEMENTATION_ERROR = 65536;
  
  /**
   * Constructs a DDRException instance with an undefined exception code.
   */
	public DDRException() {
		super();
	}
	
	/**
   * Constructs a DDRException instance with a code and human-readable message.
   * 
	 * @param code This should be a constant from this exception class.
	 * @param message Diagnostic message intended for human reading.
	 */
	public DDRException(int code, String message) {
		super(message);
		this.code = code;
	}

	/**
   * Constructs a DDRException instance with a code and Throwable object that
   * may indicate further details of the cause of the exception.
   * 
	 * @param code This should be a constant from this exception class.
	 * @param thr A Throwable object that may contain further details on the exception.
	 */
	public DDRException(int code, Throwable thr) {
		super(thr);
		this.code = code;
	}
  
  /**
   * This is a Java-specific version management feature to deal with serialisation and deserialisation of class instances.
   */
  static final long serialVersionUID = 2618094065573111548L; // Generated by serialver.exe

  /**
   * Retrieves the exception code, which determines the nature/cause of the exception.
   * 
   * @return Explanatory code.
   */
  public int getCode() {
		return code;
	}
	
	/**
   * Retrieves a human-readable diagnostic message, intended for error messages.
   * 
   * @return Human-readable diagnostic message.
   */
  @Override
  public String getMessage() {
		return super.getMessage();
	}

  /**
   * An exception code, which represents the nature/cause of the exception.
   */
	protected int code;
}
