<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <ns uri="http://www.w3.org/2005/11/its" prefix="its"/>
  <ns uri="http://www.w3.org/1999/xlink" prefix="xlink"/>
  <pattern>
    <title>Indicating the Version of ITS</title>
    <rule context="*[@its:*]">
      <assert test="ancestor-or-self::*/@its:version | //its:rules/@version">The version is indicated by the ITS version attribute. This attribute is mandatory for the rules element, where it MUST be in no namespace. If there is no rules element in an XML document, a prefixed ITS version attribute (e.g. its:version) MUST on the element where the ITS markup is used, or on one of its ancestors.</assert>
    </rule>
    <rule context="its:provenanceRecords | its:locQualityIssues">
      <assert test="self::*/@version | ancestor::*/@its:version | //its:rules/@version">The version is indicated by the ITS version attribute. This attribute is mandatory for the rules element, where it MUST be in no namespace. If there is no rules element in an XML document, a prefixed ITS version attribute (e.g. its:version) MUST on the element where the ITS markup is used, or on one of its ancestors. For standoff markup unprefixed version attribute is used.</assert>
    </rule>
    <rule context="*[@its:version]">
      <assert test="if (@its:version and //its:rules/@version) then //its:rules/@version = @its:version else true()">There MUST NOT be two different versions of ITS in the same document.</assert>
      <assert test="every $v in //*/@its:version satisfies $v = @its:version">There MUST NOT be two different versions of ITS in the same document.</assert>
    </rule>
    <rule context="its:provenanceRecords | its:locQualityIssues">
      <assert test="if (@version and //its:rules/@version) then //its:rules/@version = @version else true()">There MUST NOT be two different versions of ITS in the same document.</assert>
      <assert test="every $v in //*/@its:version satisfies $v = @version">There MUST NOT be two different versions of ITS in the same document.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>Global, Rule-based Selection</title>
    <rule context="its:rules">
      <assert test="every $rules in //its:rules satisfies $rules/@version = current()/@version">If there is more than one rules element in an XML document, the rules from each section are to be processed at the same precedence level. The rules sections are to be read in document order, and the ITS rules with them processed sequentially. The versions of these rules elements MUST NOT be different.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>Link to External Rules</title>
    <rule context="its:rules[@xlink:href]">
      <assert test="count(doc(resolve-uri(@xlink:href, base-uri()))//its:rules) le 1">The referenced document must be a valid XML document containing at most one rules element.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>ITS Tools Annotation</title>
    <rule context="*[@its:annotatorsRef]">
      <assert test="every $ref in tokenize(@its:annotatorsRef, '\s+') satisfies matches($ref, '(translate|localization-note|terminology|directionality|language-information|elements-within-text|domain|text-analysis|locale-filter|provenance|external-resource|target-pointer|id-value|preserve-space|localization-quality-issue|localization-quality-rating|mt-confidence|allowed-characters|storage-size)\|.+')">The value of annotatorsRef is a space-separated list of references where each reference is composed of two parts: a data category identifier and an IRI. These two parts are separated by a character | VERTICAL LINE (U+007C).</assert>
    </rule>
  </pattern>
  <pattern>
    <title>Source of confidence</title>
    <rule context="*[@its:termConfidence]">
      <assert test="ancestor-or-self::*[@its:annotatorsRef][matches(@its:annotatorsRef, '.*\s*terminology\|.+')]">Any node selected by the terminology data category with the termConfidence attribute specified MUST be contained in an element with the annotatorsRef attribute specified for the Terminology data category.</assert>
    </rule>
    <rule context="*[@its:taConfidence]">
      <assert test="ancestor-or-self::*[@its:annotatorsRef][matches(@its:annotatorsRef, '.*\s*text-analysis\|.+')]">Any node selected by the Text Analysis data category with the taConfidence attribute specified MUST be contained in an element with the annotatorsRef attribute specified for the Text Analysis data category.</assert>
    </rule>
    <rule context="*[@its:mtConfidence]">
      <assert test="ancestor-or-self::*[@its:annotatorsRef][matches(@its:annotatorsRef, '.*\s*mt-confidence\|.+')]">Any node selected by the MT Confidence data category MUST be contained in an element with the annotatorsRef attribute specified for the MT Confidence data category.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>Text analysis</title>
    <rule context="its:textAnalysisRule">
      <assert test="@taClassRefPointer | @taSourcePointer | @taIdentPointer | @taIdentRefPointer">Text analysis rule must specify at least target type class or target identity.</assert>
    </rule>
  </pattern>
  <pattern>
    <title>Provenance standoff markup</title>
    <rule context="its:provenanceRecord">
      <assert test="@person | @personRef | @org | @orgRef | @tool | @toolRef | @revPerson | @revPersonRef | @revOrg | @revOrgRef | @revTool | @revToolRef | @provRef">At least one attribute must be specified on the provenanceRecord element.</assert>
    </rule>
  </pattern>
</schema>