<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 1998-2003 W3C (MIT, ERCIM, Keio), All Rights Reserved. See http://www.w3.org/Consortium/Legal/. -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:conf="http://www.w3.org/2005/ccxml-conformance" xmlns="http://www.w3.org/2002/09/ccxml" version="1.0">

<!--
Release 1.2 - 2010-10-21
FIXED:
ISSUE-727: var for rr declaration added
-->

	<xsl:output cdata-section-elements="script" indent="yes"/>
	<!-- Assume assertion number is passed in -->
	<xsl:param name="assertnum"/>
	<xsl:param name="connectiontype"/>
	<!-- ############################################# -->
	<!-- D o c u m e n t   H e a d e r s               -->
	<!-- ############################################# -->
	<!-- Copy everything that doesn't match other rules -->
	<xsl:template match="/ | @* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- strip comments -->
	<xsl:template match="comment()"/>
	<!-- ############################################# -->
	<!-- F i n a l   S t a t u s   I n d i c a t o r s -->
	<!-- ############################################# -->
	<!-- Success criteria -->
	<xsl:template match="conf:pass">
		<xsl:call-template name="conf-pass">
			<xsl:with-param name="reason" select="@reason"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="conf-pass">
		<xsl:param name="reason"/>
		<script>remove_from_assert_trace(ASSERTION_NUM);</script>
		<xsl:choose>
			<xsl:when test="$reason != ''">
				<log label="s_TA+ASSERTION_NUM" expr="s_PASS + {$reason}"/>
			</xsl:when>
			<xsl:otherwise>
				<log label="s_TA+ASSERTION_NUM" expr="s_PASS"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Failure criteria -->
	<xsl:template match="conf:fail">
		<xsl:call-template name="conf-fail">
			<xsl:with-param name="reason" select="@reason"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="conf-fail">
		<xsl:param name="reason"/>
		<script>remove_from_assert_trace(ASSERTION_NUM);</script>
		<xsl:choose>
			<xsl:when test="$reason != ''">
				<log label="s_TA+ASSERTION_NUM" expr="s_FAIL + {$reason}"/>
			</xsl:when>
			<xsl:otherwise>
				<log label="s_TA+ASSERTION_NUM" expr="s_FAIL"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="conf:not_exec">
		<xsl:call-template name="conf-not_exec">
			<xsl:with-param name="reason" select="@reason"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="conf-not_exec">
		<xsl:param name="reason"/>
		<xsl:choose>
			<xsl:when test="$reason != ''">
				<log label="s_TA+ASSERTION_NUM" expr="s_NOT_EXECUTED + {$reason}"/>
			</xsl:when>
			<xsl:otherwise>
				<log label="s_TA+ASSERTION_NUM" expr="s_NOT_EXECUTED"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ############################################# -->
	<!-- I n t e r m e d i a t e   R e p o r t s       -->
	<!-- ############################################# -->
	<!-- Copy everything doesn't match the other rules -->
	<xsl:template match="conf:comment">
		<log label="s_TA+ASSERTION_NUM" expr="'Comment: '+{@expr}"/>
	</xsl:template>
	<xsl:template match="conf:uncond_exit">
		<log label="s_TA" expr="{@expr} + '  EXIT.'"/>
		<exit/>
	</xsl:template>

	<!-- ############################################# -->
	<!-- Document Setup                                -->
	<!-- ############################################# -->
	<!-- Apply values to commonly used expressions -->
	<xsl:template match="conf:docsetup">
		<var name="s_NONE" expr="'NONE'"/>
		<var name="s_ASSERTIONS_LEFT"/>
		<script><![CDATA[
var trace_separator = ' ';
var assert_trace = new Object();
function add_2_assert_trace(N){
assert_trace[N] = true;
}
function show_remained_assertions(){
var rr_ini = '';
var rr = rr_ini;
	var sIndex;
	for(sIndex in assert_trace ) {
		if( assert_trace[sIndex]){rr = rr + sIndex + trace_separator};
	}
	if (rr == rr_ini){rr = s_NONE;}
	return 'ASSERTIONS_LEFT: ' + rr;
}
function remove_from_assert_trace(N){
assert_trace[N] = false;
s_ASSERTIONS_LEFT = show_remained_assertions();
}
function init_assertion(N){
// FIXED ISSUE-727:  var added on declaration of rr 
var rr = Object();
rr.number = N;
rr.P_F = s_NOT_EXECUTED;
rr.reason = '';
rr.N_child = 0;
add_2_assert_trace(N);
return rr;
}
var a_tmp_1 = session.uri.split("\/");
var s_tmp_2 = a_tmp_1[a_tmp_1.length - 1];
var a_tmp_3 = s_tmp_2.split("\.");
var s_LOG_PREFIX = a_tmp_3[0]; 


]]></script>
		<var name="assertions" expr="Object();"/>
		<var name="current_state" expr="'init'"/>
		<var name="cur_event_ID"/>
		<var name="s_TA" expr="s_LOG_PREFIX + ' TA-'"/>
		<var name="s_PASS" expr="'PASS: '"/>
		<var name="s_FAIL" expr="'FAIL: '"/>
		<var name="s_NOT_EXECUTED" expr="'NOT_EXECUTED: '"/>
		<var name="state_prefix" expr="'ASSERTION_NMBR_'"/>
		<var name="name_prefix" expr="'user.ASSERTION_'"/>
		<var name="start_name_prefix" expr="'user.START_ASSERTION_'"/>
		<var name="name_prepare_new" expr="'user.PREPARE_NEW'"/>
		<var name="USER_ERROR" expr="'user.error'"/>
		<var name="TEST_CREATECALL_DEST_NOANSWER" expr="'sip:10.229.47.209'"/>
		<var name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE" expr="new Object();"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[0]" expr="'sip:10.229.47.209'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[1]" expr="'sip:10.229.47.111'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[2]" expr="'sip:10.229.47.209'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[3]" expr="'18005551004'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[4]" expr="'18005551005'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[5]" expr="'18005551006'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[6]" expr="'18005551007'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[7]" expr="'18005551008'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[8]" expr="'18005551009'"/>
		<assign name="TEST_CREATECALL_DEST_ANSWER_AND_STAY_ACTIVE[9]" expr="'18005551010'"/>
		<var name="TEST_CREATECALL_DEST_ANSWER_AND_DISCONNECT_SHORT" expr="'18005552000'"/>
		<var name="TEST_CREATECALL_DEST_ANSWER_AND_FAIL_JOIN" expr="'18005553000'"/>
		<var name="TEST_SHORT_TIMEOUT" expr="'10s'"/>
		<var name="TEST_LONG_TIMEOUT" expr="'30s'"/>
		<var name="TEST_VERY_LONG_TIMEOUT" expr="'150s'"/>
		<var name="ASSERTION_NUM" expr="'{$assertnum}'"/>
		<var name="SETUP_CONNECTION_TYPE" expr="'{$connectiontype}'"/>
		<var name="t_ASSERT_RESULT"/>
		<var name="t_ASSERT_REASON" expr="''"/>
		<var name="TEST_BASIC_HTTP_URI" expr="''"/>
		<var name="TEST_IR_URI" expr="'http://10.229.47.117:8080/W3C_CCXML_IR/output/'"/>
		<var name="TEST_ABSOLUTE_URI" expr="''"/>
		<var name="uri_UNREACHEABLE" expr="'http://10.255.255.254/unrea3chable'"/>

	</xsl:template>
	<!-- ############################################# -->
	<!-- Connection Setup                              -->
	<!-- ############################################# -->
	<!-- Setup the connection requested and handle appropriate events -->
	<xsl:template match="conf:setup">
        <xsl:call-template name="conf-setup">
            <xsl:with-param name="connectiontype" select="@type"/>
        </xsl:call-template>
	</xsl:template>
	
	<xsl:template name="conf-setup">
	   <xsl:param name="connectiontype"/>
	   <xsl:choose>
			<xsl:when test="$connectiontype = 'alerting'">
				<transition event="ccxml.loaded">
					<log label="s_TA+ASSERTION_NUM" expr="'Started: ' + event$.name"/>
					<!-- Insert script to initiate a call here -->
				</transition>
			</xsl:when>
			<xsl:when test="$connectiontype = 'connected'">
				<transition event="ccxml.loaded">
					<log label="s_TA+ASSERTION_NUM" expr="'Started: ' + event$.name"/>
					<!-- Insert script to initiate a call here -->
				</transition>
				<transition event="connection.signal" state="init">
					<log label="s_TA+ASSERTION_NUM" expr="'Received: ' + event$.name"/>
				</transition>
				<transition event="connection.alerting" state="init">
					<log label="s_TA+ASSERTION_NUM" expr="'Received: ' + event$.name"/>
					<accept connectionid="event$.connectionid"/>
					<log label="s_TA+ASSERTION_NUM" expr="'Accepted: ' + event$.connectionid"/>
				</transition>
			</xsl:when>
			<xsl:otherwise>
				<!-- type is "noconnection" or an invalid type -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ############################################# -->
	<!-- Remote Disconnect                              -->
	<!-- ############################################# -->
	<!-- Instruct a remote agent to disconnect the specified connection -->
	<xsl:template match="conf:remotedisconnect">
		<log label="s_TA+ASSERTION_NUM" expr="'RemoteDisconnect: Please hang-up connection: ' + {@connectionid}"/>
	</xsl:template>
	<!-- ############################################# -->
	<!-- Helper Functions                              -->
	<!-- ############################################# -->
	<xsl:template match="conf:check-event-name">
		<if cond="!event$.name">
			<xsl:call-template name="conf-fail">
				<xsl:with-param name="reason">
					<xsl:text>'name property not defined'</xsl:text>
				</xsl:with-param>
			</xsl:call-template>
			<elseif cond="event$.name != '{@value}'"/>
			<xsl:call-template name="conf-fail">
				<xsl:with-param name="reason">
					<xsl:text>'name property should be' + </xsl:text>
					<xsl:value-of select="@value"/>
					<xsl:text> 'but is ' + event$.name </xsl:text>
				</xsl:with-param>
			</xsl:call-template>
			<else/>
			<xsl:call-template name="conf-pass"/>
		</if>
	</xsl:template>
	


	
	
</xsl:stylesheet>
