<?xml version="1.0"?>
<!-- Copyright 1998-2005 W3C (MIT, ERCIM, Keio), All Rights Reserved. See http://www.w3.org/Consortium/Legal/. -->
<!-- Transforms an ircgi test file into a Java Server Page.-->
<!-- 
    NOTE: This JSP requires the com.oreilly.servlet package available at http://www.servlets.com/cos/
0    The source code, object code, and documentation in the com.oreilly.servlet package
    (http://www.servlets.com/cos/) is copyright and owned by Jason Hunter.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text"/>

<xsl:template match="/" >
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="ircgi">
  <xsl:call-template name="header" />
  <xsl:call-template name="declarations" />
  <xsl:call-template name="determineResult" />
</xsl:template>

<!--   Official contentType is 'application/ccxml+xml'.
  Change contentType to 'text/xml' to view generated JSP in IE.

   NOTE: The "header" template content below must be on a single line so that whitespace is not
   introduced at the beginning of the resulting XML document. XML parsers will complain. 
   Line breaks are included here for readability in the documentation.
 -->
<xsl:template name="header" >&lt;%@ page language="java" contentType="text/xml" %>&lt;%@ page import="java.io.*" %>&lt;%@ page import="java.net.*" %>&lt;%@ page import="java.util.*" %>&lt;%@ page import="com.oreilly.servlet.multipart.*" %></xsl:template>

<!--   Define a Result class to hold the destination, comments, and
  HTTP status code that will be set by 'determineResult' method.
-->
<xsl:template name="declarations">&lt;%!
    
    // Handles server side includes so they can be parsed
    private class JSPIncluder
    {
		void readInput(HttpServletRequest request, String strIncludePath, boolean absolute) throws JspException    
		{
        	URLConnection conn;

        	// Get URL
        	StringBuffer strUrl;
			String strUri;

			if(!absolute){
				strUrl = request.getRequestURL();
        		strUri = strUrl.toString();
        		int nFindSlash = strUri.lastIndexOf("/");
        		if (nFindSlash != -1)
        		{
            		strUri = strUri.substring(0, nFindSlash + 1);              
        		}
        		strUri += strIncludePath;
			 }else{
				strUri = strIncludePath;
			 }
        	// Open connection
        	try
        	{
            	conn = (new URL(strUri)).openConnection();
            	conn.setDoInput(true);
            	conn.setDoOutput(false);
            	conn.connect();
        	}
            catch (Exception e)
            {
                throw new JspException(e.toString());
            }

            // Read in contents
            try
            {
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer buff = new StringBuffer();
                char[] chars = new char[2048];
                int nLen;

                while ((nLen = in.read(chars, 0, chars.length)) &gt;= 0)
                {
                    buff.append(chars, 0, nLen);
                }
                m_strBuffer = buff.toString();
                in.close();
            }
            catch (Exception e)
            {
                throw new JspException(e.toString());
            }
        }

        boolean replace(String strFind, String strReplace)
        {
            boolean bFound = false;
            if (m_strBuffer != null &amp;&amp; m_strBuffer.length() > 0)
            {
                int a = 0;
                int b = 0;
                while (true)
                {
                    a = m_strBuffer.indexOf(strFind, b);
                    if (a != -1)
                    {
                        m_strBuffer = m_strBuffer.substring(0, a) + strReplace + m_strBuffer.substring(a + strFind.length());
                        b = a + strReplace.length();
                        bFound = true;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            return bFound;
        }
        
        void doOutput(PageContext context) throws JspException
        {
            JspWriter out = context.getOut();
            try
            {
                out.print(m_strBuffer.toString());
            }
            catch (Exception e)
            {
                throw new JspException(e.toString());
            }   
        }
        private String m_strBuffer;
    }
    
    // Handles multipart/form-data 
    private class MultiPartHandler 
    {
        HttpServletRequest request;
        
        public MultiPartHandler(HttpServletRequest req)
        {
            request = req;
        }
        
        public boolean find(String strFind, int nOfSize) throws JspException 
        {            
            MultipartParser parser;
            Part part;
            String strName;
            if((request.getContentType() != null)&amp;&amp;(request.getContentType().startsWith("multipart/form-data")))
            {
                try
                {
                    parser = new MultipartParser(request, request.getContentLength());
                    while ((part = parser.readNextPart()) != null)
                    {
                        strName = part.getName();
                        if(strName.equals(strFind))
                        {
                            if (nOfSize == -1)
                            {
                                return true;
                            }
                            else
                            {
                                if (part.isFile())
                                {
                                    InputStream stream = ((FilePart)part).getInputStream();
                                    if (getSizeOfStream(stream) == nOfSize)
                                    {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    throw new JspException(e.toString());
                }
            }
            
            return false;        
         }
         
         private long getSizeOfStream(InputStream stream)
         {
            if (null == stream) return 0;
            
            int nRead = 0;
            int nSize = 0;
            byte[] temp = new byte[1024];
            try 
            {
                while ((nRead = stream.read(temp)) != -1)
                {
                    nSize += nRead;
                }  
            }
            catch (IOException e) {}
            
            return nSize;         
         }
     }
    
  private class Result {
    String dest;
    long sleep = 0;
    boolean expiresHeaderSet = false;
    long expires = 0;
    boolean include = false;
    boolean isVXML = false;
    StringBuffer comments = new StringBuffer();
    int statusCode = 200;
	boolean absolute = false;
  }
  private final String NL = System.getProperty("line.separator");
  private void determineResult(HttpServletRequest request, Result result, MultiPartHandler multipart) throws JspException
  {
    <xsl:apply-templates />
  }
%&gt;</xsl:template>


<!--  Create Result object and call 'determineResult' to set its fields.
  Return CCXML document only if HTTP response status code is 200.
  Otherwise, return just the status code.
-->
<xsl:template name="determineResult" >&lt;%
    Result myResult = new Result();
    MultiPartHandler myMultiPart = new MultiPartHandler(request);
    determineResult(request, myResult, myMultiPart);
    response.setStatus(myResult.statusCode);
    
    if (myResult.sleep &gt; 0)
    {
        try
        {
            Thread.sleep(myResult.sleep * 1000);
        }
        catch (InterruptedException e)
        {
            throw new JspException(e.toString());
        }
    }
    
    if (myResult.expiresHeaderSet)
    {
        Date now = new Date();
        long nMillis = now.getTime();
        response.setDateHeader("Expires", nMillis + myResult.expires*1000);
    }
    
    if (myResult.include) 
    {
        Date now = new Date();
        long nMillis = now.getTime();
        String strEpoch = String.valueOf(nMillis);
        JSPIncluder includer = new JSPIncluder();
        includer.readInput(request, myResult.dest, myResult.absolute);
        includer.replace("__EPOCH__", strEpoch);
        includer.doOutput(pageContext);
    }
    else if (myResult.isVXML) 
    	{%&gt;<xsl:call-template name="vxml" />&lt;%}
    else
    	{%&gt;<xsl:call-template name="ccxml" />&lt;%}%&gt; 
   
    

         
</xsl:template>


<xsl:template match="if-parameter" >
  if (<xsl:call-template name="genIfExpr">
        <xsl:with-param name="type" select="'Parameter'" />
      </xsl:call-template>) {
    <xsl:apply-templates />
  }
</xsl:template>


<xsl:template match="if-header" >
  if (<xsl:call-template name="genIfExpr">
        <xsl:with-param name="type" select="'Header'" />
      </xsl:call-template>) {
    <xsl:apply-templates />
  }
</xsl:template>


<xsl:template match="if-all-params" >
  if (<xsl:for-each select="/ircgi/params[@id=current()/@ref]/param">
        <xsl:call-template name="genIfExpr">
          <xsl:with-param name="type" select="'Parameter'" />
        </xsl:call-template>
        <xsl:if test="position() != last()">&amp;&amp;</xsl:if>
      </xsl:for-each>) {
    <xsl:apply-templates />
  }
</xsl:template>


<xsl:template match="if-upload" >
  int nSize = -1;
  <xsl:if test="@size">
    if (null != request.getParameter("<xsl:value-of select='@size'/>"))
    {
      try {
        nSize = Integer.parseInt(request.getParameter("<xsl:value-of select='@size'/>"));
      }
      catch (NumberFormatException e) { }
    }
    else
    {
      try {
        nSize = Integer.parseInt("<xsl:value-of select='@size'/>");
      }
      catch (NumberFormatException e) { }
    }
  </xsl:if>  
  if (multipart.find("<xsl:value-of select="@name"/>", nSize))
  {
    <xsl:apply-templates />
  } 
</xsl:template>


<!--  Generate an expression that determines when the condition of an if-parameter / if-header
  element is true.  The 'type' parameter determines the
  HttpServletRequest method to use to get the value to be checked.
-->
<xsl:template name="genIfExpr" >
  <xsl:param name="type" />
  <xsl:param name="size" />
  <xsl:variable name="method">
    <xsl:choose>
      <xsl:when test="@ignore-case = 'true'" >equalsIgnoreCase</xsl:when>
      <xsl:otherwise>equals</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="@value">
      request.get<xsl:value-of select="$type"/>
        ("<xsl:value-of select="@name"/>") != null &amp;&amp;
      request.get<xsl:value-of select="$type"/>
        ("<xsl:value-of select="@name"/>").<xsl:value-of select="$method"/>
        ("<xsl:value-of select="@value" />")
    </xsl:when>
    <xsl:when test="@starts-with">
       request.get<xsl:value-of select="$type"/>
        ("<xsl:value-of select="@name"/>") != null &amp;&amp;
       request.get<xsl:value-of select="$type"/>
        ("<xsl:value-of select="@name"/>").startsWith("<xsl:value-of select="@starts-with"/>")
    </xsl:when>     
    <xsl:otherwise>
      request.get<xsl:value-of select="$type"/>("<xsl:value-of select="@name"/>") != null 
        || multipart.find("<xsl:value-of select="@name"/>", -1)
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="if-method" >
  if (request.getMethod().equalsIgnoreCase("<xsl:value-of select="@type" />")) {
    <xsl:apply-templates />
  }
</xsl:template>


<!--  Disarm double quotes and newline characters from comments, then
  add to result's comment buffer for use later in 'log' element.
-->
<xsl:template match="comment" >
  result.comments.append
    ("<xsl:value-of select="translate(., '&#034;&#013;&#010;', '   ')" />".trim());
  result.comments.append(NL);
</xsl:template>


<xsl:template match="next" >
  <xsl:if test="@code" >
    result.statusCode = <xsl:value-of select="@code" />;
  </xsl:if>
  <xsl:if test="@dest" >
      result.dest = "<xsl:value-of select="@dest" />";
  </xsl:if>
  <xsl:if test="@param">
	result.dest = request.getParameter("<xsl:value-of select="@param"/>");
  </xsl:if>
  <xsl:if test="@include = 'true'">
    result.include = true;
  </xsl:if>  
  <xsl:if test="@isVXML = 'true'">
    result.isVXML = true;
  </xsl:if>  
  <xsl:if test="@sleep">
      result.sleep = <xsl:value-of select="@sleep" />;
  </xsl:if>  
  <xsl:if test="@expires">
      result.expiresHeaderSet = true;
      result.expires = <xsl:value-of select="@expires" />;
  </xsl:if>
  <xsl:if test="@absolute">
	result.absolute = <xsl:value-of select="@absolute"/>;
  </xsl:if>
    return;
</xsl:template>


<!--  Generate CCXML document that does a 'goto' to the document
  indicated in myResult.  If comment buffer is not empty, include
  a 'log' element to aid in debugging.
-->

<xsl:template name="ccxml" ><![CDATA[<?xml version="1.0" encoding="UTF-8"?>
<ccxml version="1.0" xmlns="http://www.w3.org/2002/09/ccxml">
  <eventprocessor>
    <transition event="ccxml.loaded">
      <% String comments = myResult.comments.toString();
        if (comments.length()>0) {%>
        <log>]]>
        <xsl:text disable-output-escaping="yes">
          &lt;![CDATA[&lt;%= comments %&gt;]]&gt;
        </xsl:text><![CDATA[
        </log><%}%>
        <fetch next="'<%= myResult.dest %>'"/>
    </transition>
  <transition event="fetch.done">
    <goto fetchid="event$.fetchid"/>
  </transition>
</eventprocessor>
</ccxml> ]]>
</xsl:template>



<!--  Generate VoiceXML document that does a 'goto' to the document
  indicated in myResult.  If comment buffer is not empty, include
  a 'log' element to aid in debugging.
-->

<xsl:template name="vxml" ><![CDATA[<?xml version="1.0" encoding="UTF-8"?>
<vxml version="2.1" xmlns="http://www.w3.org/2001/vxml">
  <form>
    <block><% String comments = myResult.comments.toString();
   if (comments.length()>0) {%>
      <log>]]>
        <xsl:text disable-output-escaping="yes">
          &lt;![CDATA[&lt;%= comments %&gt;]]&gt;
        </xsl:text><![CDATA[
      </log><%}%>
      <goto next="<%= myResult.dest %>"/>
    </block>
  </form>
</vxml> ]]>
</xsl:template>



</xsl:stylesheet>
