<?xml version="1.0" encoding="UTF-8"?>
<!--This file was created automatically by html2xhtml-->
<!--from the HTML stylesheets. Do not edit this file.-->
<!-- ********************************************************
     This stylesheet is meant to be used for publishing the Character
     Model spec (Charmod). It imports the 'official' xmlspec.xsl
     stylesheet and adds or overrides some behaviour.

     The behaviour depends on the presence or absence of a
     role='editors-copy' atribute on the spec element.  If this
     attribute is absent, the stylesheet produces a version for
     publication.  If it is present, then the following occurs

      - The $Id stuff appears at the very top (now contained in
        the 1st para in <revisiondesc>)
      - The W3C logo disappears.
      - A notice appears in the Status section, saying this is an
        editors copy with no standing.
      - The base.css stylesheet is used instead of W3C-xx. To
        facilitate offline editing, base.css is assumed to be in
        the same directory as the document.
      - The <ins> and <del> markup is preserved, styling is added
        for it in the CSS stylesheet embedded in the doc.
      - The Javascript to turn redlining on and off is included.
      - Editor's notes (<ednote>) appear.
     ********************************************************--><!-- Version: $Id: xmlspec-CM.xsl,v 1.1 2002/04/25 13:22:36 duerst Exp $ --><!-- Author: François Yergeau (fyergeau@alis.com) --><!-- Author: Richard Ishida (richard.ishida@gbr.xerox.com) --><!-- Date Created: 2002.03.10 --><!-- This stylesheet is copyright (c) 2000 by its authors.  Free
     distribution and modification is permitted, including adding to
     the list of authors and copyright holders, as long as this
     copyright notice is maintained. --><!-- ChangeLog:
  14 Mar 2002: (fyergeau@alis.com)
  - Updated to account for new version of xmlspec.xls:
    - the divx/head templates now call anchor, don't need our copies anymore


  10 Mar 2002: (fyergeau@alis.com)
  - Initial version
  - Couldn't solve the stray xmlns attribute problem, so reverted to HTML output
    for now.
  - This is heavily based on Richard Ishida's modifications of an earlier version
    of xmlspec.xsl.  Richard's comments are therefore listed below for reference.

  19 Dec 2001: (richard.ishida@gbr.xerox.com)
  - additional.css: added css declarations to this document, rather than using a
    separate file (to get around the pubrules requirement that the W3C stylesheet is
    the last one called)
  - ipr-notice: changed ipr-notice link to ipr-notice-20000612 in all (3) locations

  14 Dec 2001: (richard.ishida@gbr.xerox.com)
  - olist, ulist: because a list may be a child of req and not just p, changed the validity.hacks transforms
  - abstract, status: corrected duplicate assignment of id
  - created anchor element for list items if an id was assigned in the xml
  - created anchor element for notes and examples if an id was assigned in the xml

  12 Dec 2001: (richard.ishida@gbr.xerox.com)

  - output: changed to output as xhtml
  - general: for every <a> with name=, added id= with same attr value
  - general: lowercased all element and attribute names in output
  - ednote: made appear using <span class="editor-note">
  - example: if first child is p and no head, heading 'EXAMPLE: ' appears *inline* at beginning of first p
    otherwise 'EXAMPLE:' appears in its own block
    heading 'EXAMPLE: ' wrapped with <span class="example-head">
  - note: if first child is p, heading 'NOTE: ' appears *inline* at beginning of first p
    otherwise 'NOTE:' appears in its own block
    heading 'NOTE: ' wrapped with <span class="note-head">
    NB: CharMod commonly uses notes for informative text
  - graphic: added code to deal with height and width attributes
  - item: added name= and id= attributes to allow linking to list items
    added <span class="req"> to highlight if part of a requirement
  - kw: changed <b> to <span class="keyword"> to allow more flexibility in presentation
  - olist, ulist: used $validity.hacks to close off <span class="req"> and start again if a requirement includes a list
  - del, ins: added code to deal with these new elements (expectation that all ins and del markup will be removed prior to publication)
  - quote: surrounded with <span class="quote"> to allow for alternative styling (CharMod italicises the text)
  - html and head elements:
    - changed document declaration for xhtml
    - added xml:lang to html tag
    - added charset declaration, set to utf-8
    - made the default stylesheet link relative
    - removed internal css (added to local css file mentioned below)
    - linked to local css file (that currently overwrites everything in the default for CharMod)
    - added link to javascript file and constructs to allow for hiding/showing redlining (this will be removed prior to publication)
  - term: replaced <b> with <span class="term"> to allow for flexibility in rendering
  - added new templates to deal with the following new elements:
    - req
    - qterm
    - qchar
    - rfc2119
    - uname
    - abbr
    - acronym
    - figure (includes its own caption handling at the moment)
    - image

--><xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://icl.com/saxon" exclude-result-prefixes="saxon" version="1.0">


  <!-- First, import the main stylesheet -->
  <xsl:import href="xmlspec.xsl"/>


  <!--xsl:param name="additional.title">(Editors' copy)</xsl:param-->
  <xsl:param name="show.ednotes">0</xsl:param>
  <xsl:variable name="output.mode" select="'xhtml'"/>

  <xsl:output method="xml" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" indent="no" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>


  <!-- abbr: an abbreviation -->
  <xsl:template match="abbr">
    <abbr xmlns="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
      <xsl:apply-templates/>
    </abbr>
  </xsl:template>


  <!-- acronym: an acronym -->
  <xsl:template match="acronym">
    <acronym xmlns="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
      <xsl:apply-templates/>
    </acronym>
  </xsl:template>


  <!--  del: not rendered at all for publication, marked as del in editors' copy -->
  <xsl:template match="del">
    <xsl:if test="/spec/@role='editors-copy'">
      <del xmlns="http://www.w3.org/1999/xhtml"><xsl:apply-templates/></del>
    </xsl:if>
  </xsl:template>


  <!-- ednote: editors' note -->
  <!-- Show only if $show.ednotes parameter is not 0 or if editors' copy. -->
  <!-- Overriden for use as a phrase level element -->
  <xsl:template match="ednote">
    <xsl:if test="$show.ednotes!='0' or /spec/@role='editors-copy'">
      <span xmlns="http://www.w3.org/1999/xhtml" class="editor-note"><xsl:value-of select="."/></span>
    </xsl:if>
  </xsl:template>


  <!-- example: what it seems -->
  <!-- block-level with title -->
  <!-- see also example/head and example/p   Together these have the following effect: -->
  <!-- if the first element in an example is a p, make the EXAMPLE: heading appear inline -->
  <!-- otherwise pop it into a p block before all other elements -->
  <xsl:template match="example">
    <div xmlns="http://www.w3.org/1999/xhtml" class="example">
      <xsl:if test="name(*[1]) != 'p' and name(*[1]) != 'head'">
        <p><span class="example-head">EXAMPLE:</span></p>
      </xsl:if>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="example/p">
    <p xmlns="http://www.w3.org/1999/xhtml">
      <xsl:if test="@id">
        <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@role">
        <xsl:attribute name="class"><xsl:value-of select="@role"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="position() = 1">
        <span class="example-head">EXAMPLE: </span>
      </xsl:if>
      <xsl:apply-templates/>
    </p>
  </xsl:template>


  <xsl:template match="figure">
    <div xmlns="http://www.w3.org/1999/xhtml" class="figure" align="center">
      <xsl:if test="image">
        <xsl:apply-templates select="image"/>
      </xsl:if>
      <xsl:if test="table">
        <xsl:apply-templates select="table"/>
      </xsl:if>
      <xsl:if test="caption">
        <div class="caption">
          <!--xsl:text>Figure&#xA0;</xsl:text>
          <xsl:number count="figure" level="any" />
          <xsl:text>:&#xA0;</xsl:text-->
          <xsl:value-of select="caption"/>
        </div>
      </xsl:if>
    </div>
  </xsl:template>


  <!-- graphic: external illustration -->
  <!-- reference external graphic file with alt text -->
  <xsl:template match="graphic">
    <img xmlns="http://www.w3.org/1999/xhtml" src="{@source}">
      <xsl:if test="@alt">
        <xsl:attribute name="alt">
          <xsl:value-of select="@alt"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@width">
        <xsl:attribute name="width">
          <xsl:value-of select="@width"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="@height">
        <xsl:attribute name="height">
          <xsl:value-of select="@height"/>
        </xsl:attribute>
      </xsl:if>
    </img>
  </xsl:template>


  <xsl:template match="image">
    <img xmlns="http://www.w3.org/1999/xhtml" align="middle">
      <xsl:attribute name="src">
        <xsl:value-of select="graphic/@source"/>
      </xsl:attribute>
      <xsl:attribute name="alt">
        <xsl:value-of select="alt"/>
      </xsl:attribute>
      <xsl:if test="graphic/@height">
        <xsl:attribute name="height">
          <xsl:value-of select="graphic/@height"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:if test="graphic/@width">
        <xsl:attribute name="width">
          <xsl:value-of select="graphic/@width"/>
        </xsl:attribute>
      </xsl:if>
    </img>
  </xsl:template>



  <!--  ins: content goes straight through for publication, marked as ins in editors' copy -->
  <xsl:template match="ins">
    <xsl:choose>
      <xsl:when test="/spec/@role='editors-copy'">
        <ins xmlns="http://www.w3.org/1999/xhtml"><xsl:apply-templates/></ins>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <!-- item: generic list item -->
  <xsl:template match="item">
    <li xmlns="http://www.w3.org/1999/xhtml">
      <xsl:if test="@id"><a name="{@id}" id="{@id}"/></xsl:if>
      <xsl:if test="ancestor-or-self::*/req">
        <xsl:attribute name="class"><xsl:text>req</xsl:text></xsl:attribute>
      </xsl:if>
      <xsl:apply-templates/>
    </li>
  </xsl:template>


  <!-- kw: keyword -->
  <!-- make it <code class="keyword"> instead of bold -->
  <xsl:template match="kw">
    <code xmlns="http://www.w3.org/1999/xhtml" class="keyword"><xsl:apply-templates/></code>
  </xsl:template>


  <!-- note: a note about the spec -->
  <!-- see also note/p   Together these have the following effect: -->
  <!-- if the first element in an example is a p, make the NOTE: heading appear inline -->
  <!-- otherwise pop it into a p block before all other elements -->
  <!-- CharMod uses the note element for *informative* text, typically a single para -->
  <xsl:template match="note">
    <div xmlns="http://www.w3.org/1999/xhtml" class="note">
      <xsl:if test="@id"><a name="{@id}" id="{@id}"/></xsl:if>
      <xsl:if test="name(*[1]) != 'p'">
        <p class="prefix">NOTE:</p>
      </xsl:if>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="note/p">
    <p xmlns="http://www.w3.org/1999/xhtml">
      <xsl:if test="@id">
        <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="@role">
        <xsl:attribute name="class"><xsl:value-of select="@role"/></xsl:attribute>
      </xsl:if>
      <xsl:if test="position() = 1">
        <span class="note-head"><xsl:text>NOTE: </xsl:text></span>
      </xsl:if>
      <xsl:apply-templates/>
    </p>
  </xsl:template>


  <!-- olist: an ordered list -->
  <!-- Why was the validity hack removed from xmlspec? -->
  <xsl:template match="olist">
    <xsl:variable name="numeration">
      <xsl:call-template name="list.numeration"/>
    </xsl:variable>

    <xsl:variable name="type">
      <xsl:choose>
        <xsl:when test="$numeration='arabic'">1</xsl:when>
        <xsl:when test="$numeration='loweralpha'">a</xsl:when>
        <xsl:when test="$numeration='lowerroman'">i</xsl:when>
        <xsl:when test="$numeration='upperalpha'">A</xsl:when>
        <xsl:when test="$numeration='upperroman'">I</xsl:when>
        <!-- What!? This should never happen -->
        <xsl:otherwise>
          <xsl:message>
            <xsl:text>Unexpected numeration: </xsl:text>
            <xsl:value-of select="$numeration"/>
          </xsl:message>
          <xsl:value-of select="1"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:if test="$validity.hacks and ancestor::*/req">
      <xsl:text disable-output-escaping="yes">&lt;/span&gt;</xsl:text>
    </xsl:if>
    <xsl:if test="$validity.hacks and ((local-name(..) = 'p') or (local-name(..) = 'req'))">
      <xsl:text disable-output-escaping="yes">&lt;/p&gt;</xsl:text>
    </xsl:if>
    <ol xmlns="http://www.w3.org/1999/xhtml" type="{$type}">
      <xsl:apply-templates/>
    </ol>
    <xsl:if test="$validity.hacks and ((local-name(..) = 'p') or (local-name(..) = 'req'))">
      <xsl:text disable-output-escaping="yes">&lt;p&gt;</xsl:text>
    </xsl:if>
    <xsl:if test="$validity.hacks and ancestor::*/req">
      <xsl:text disable-output-escaping="yes">&lt;span class="req"&gt;</xsl:text>
    </xsl:if>
  </xsl:template>


  <!-- prevlocs: previous locations for this spec -->
  <!-- called in a <dl> context from header -->
  <!-- Overriden to generate multiple <dd>s (one per loc) -->
  <xsl:template match="prevlocs">
    <dt xmlns="http://www.w3.org/1999/xhtml">
      <xsl:text>Previous version</xsl:text>
      <xsl:if test="count(loc) &gt; 1">s</xsl:if>
      <xsl:text>:</xsl:text>
    </dt>
    <xsl:for-each select="loc">
      <dd xmlns="http://www.w3.org/1999/xhtml">
        <xsl:apply-templates select="."/>
      </dd>
    </xsl:for-each>
  </xsl:template>


  <!-- qchar: a cited or referred to character/letter or small group of such -->
  <xsl:template match="qchar">
    <xsl:text>'</xsl:text><span xmlns="http://www.w3.org/1999/xhtml" class="qchar"><xsl:apply-templates/></span><xsl:text>'</xsl:text>
  </xsl:template>


  <!-- quote: a quoted string or phrase -->
  <!-- it would be nice to use HTML <q> elements, but browser support
       is abysmal -->
  <xsl:template match="quote">
    <xsl:text>"</xsl:text><span xmlns="http://www.w3.org/1999/xhtml" class="quote"><xsl:apply-templates/></span><xsl:text>"</xsl:text>
  </xsl:template>


  <!-- qterm: a cited or referred to term -->
  <xsl:template match="qterm">
    <xsl:text>'</xsl:text><span xmlns="http://www.w3.org/1999/xhtml" class="qterm"><xsl:apply-templates/></span><xsl:text>'</xsl:text>
  </xsl:template>


  <!-- req, req-type and reqtext: markup normative requirements of the spec -->
  <!-- Just pass some markup through for CSS to decorate -->
  <xsl:template match="req">
    <span xmlns="http://www.w3.org/1999/xhtml" class="req"><xsl:apply-templates/></span>
  </xsl:template>

  <xsl:template match="req-type">
    <span xmlns="http://www.w3.org/1999/xhtml" class="requirement-type"><xsl:text>[</xsl:text><xsl:value-of select="."/><xsl:text>]</xsl:text></span><xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template match="req-text">
    <xsl:apply-templates/>
  </xsl:template>


  <!-- rfc2119: the terms MUST, SHOULD, etc. used in requirements -->
  <!-- Just pass some markup through for CSS to decorate -->
  <xsl:template match="rfc2119">
    <span xmlns="http://www.w3.org/1999/xhtml" class="rfc2119"><xsl:apply-templates/></span>
  </xsl:template>


  <!-- spec: the specification itself -->
  <xsl:template match="spec">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <xsl:if test="header/langusage/language">
        <xsl:attribute name="xml:lang">
          <xsl:value-of select="header/langusage/language/@id"/>
        </xsl:attribute>
        <xsl:attribute name="lang">
          <xsl:value-of select="header/langusage/language/@id"/>
        </xsl:attribute>
      </xsl:if>
      <head>
        <xsl:if test="$output.mode='xhtml'">
          <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        </xsl:if>
        <title>
          <xsl:apply-templates select="header/title"/>
          <xsl:if test="header/version">
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="header/version"/>
          </xsl:if>
          <xsl:if test="$additional.title != ''">
            <xsl:text> -- </xsl:text>
            <xsl:value-of select="$additional.title"/>
          </xsl:if>
          <xsl:if test="/spec/@role='editors-copy'">
            <xsl:text> -- (Editors' copy)</xsl:text>
          </xsl:if>
        </title>
        <xsl:call-template name="css"/>
        <xsl:if test="/spec/@role='editors-copy'">
          <xsl:text disable-output-escaping="yes">&lt;script language="JavaScript" src="redlining.js" type="text/javascript"&gt;&lt;/script&gt;</xsl:text>
        </xsl:if>
      </head>
      <body>
        <xsl:if test="/spec/@role='editors-copy'">
          <xsl:attribute name="ondblclick">toggleRows();</xsl:attribute>
          <xsl:value-of select="//revisiondesc/p[1]"/>
          <div id="revisions"/>
          <script type="text/javascript">showButton()</script>
        </xsl:if>
        <xsl:apply-templates/>
        <xsl:if test="//footnote[not(ancestor::table)]">
          <hr/>
          <div class="endnotes">
            <xsl:text>
</xsl:text>
            <h3>
              <xsl:call-template name="anchor">
                <xsl:with-param name="conditional" select="0"/>
                <xsl:with-param name="default.id" select="'endnotes'"/>
              </xsl:call-template>
              <xsl:text>End Notes</xsl:text>
            </h3>
            <dl>
              <xsl:apply-templates select="//footnote[not(ancestor::table)]" mode="notes"/>
            </dl>
          </div>
        </xsl:if>
      </body>
    </html>
  </xsl:template>


  <!-- term: the actual mention of a term within a termdef -->
  <xsl:template match="term">
    <span xmlns="http://www.w3.org/1999/xhtml" class="new-term"><xsl:apply-templates/></span>
  </xsl:template>


  <!-- ulist: unordered list -->
  <!-- Why was the validity hack removed from xmlspec? -->
  <xsl:template match="ulist">
    <xsl:if test="$validity.hacks and ancestor::*/req">
      <xsl:text disable-output-escaping="yes">&lt;/span&gt;</xsl:text>
    </xsl:if>
    <xsl:if test="$validity.hacks and ((local-name(..) = 'p') or (local-name(..) = 'req'))">
      <xsl:text disable-output-escaping="yes">&lt;/p&gt;</xsl:text>
    </xsl:if>
    <ul xmlns="http://www.w3.org/1999/xhtml">
      <xsl:apply-templates/>
    </ul>
    <xsl:if test="$validity.hacks and ((local-name(..) = 'p') or (local-name(..) = 'req'))">
      <xsl:text disable-output-escaping="yes">&lt;p&gt;</xsl:text>
    </xsl:if>
    <xsl:if test="$validity.hacks and ancestor::*/req">
      <xsl:text disable-output-escaping="yes">&lt;span class="req"&gt;</xsl:text>
    </xsl:if>
  </xsl:template>


  <!-- uname: a Unicode character name -->
  <!-- Just pass some markup through for CSS to decorate -->
  <xsl:template match="uname">
    <span xmlns="http://www.w3.org/1999/xhtml" class="uname"><xsl:apply-templates/></span>
  </xsl:template>


  <xsl:template name="css">
    <style xmlns="http://www.w3.org/1999/xhtml" type="text/css">
      <xsl:text>
code           { font-family: monospace; }

div.constraint,
div.issue,
div.note,
div.example,
div.notice     { margin-left: 2em; }
.example-head, .note-head { font-weight: bold }

dt.label       { display: run-in; }

li p           { margin-top: 0.3em;
                 margin-bottom: 0.3em; }

.rfc2119, .uname { text-transform: lowercase; font-variant: small-caps; }

.new-term { font-weight: bold }
.quote { font-style: italic }

.figure { margin-bottom: 2em; }

.caption {
  text-align: center;
  margin: 0.5em 2em;
  font-style: italic;
  }

.editor-note { font-style: italic; color: red; }

.req { background: #ffffcc; }

@media print {
 .req { background: #ffcc99 }
}
      </xsl:text>
      <xsl:if test="/spec/@role='editors-copy'">
        <xsl:text>
ins { text-decoration: underline; }
del { display: inline; color: silver; }
        </xsl:text>
      </xsl:if>
      <xsl:if test="$tabular.examples = 0">
        <xsl:text>
div.exampleInner pre { margin-left: 1em;
                       margin-top: 0em; margin-bottom: 0em}
div.exampleOuter {border: 4px double gray;
                  margin: 0em; padding: 0em}
div.exampleInner { background-color: #d5dee3;
                   border-top-width: 4px;
                   border-top-style: double;
                   border-top-color: #d3d3d3;
                   border-bottom-width: 4px;
                   border-bottom-style: double;
                   border-bottom-color: #d3d3d3;
                   padding: 4px; margin: 0em }
div.exampleWrapper { margin: 4px }
div.exampleHeader { font-weight: bold;
                    margin: 4px}
</xsl:text>
      </xsl:if>
      <xsl:value-of select="$additional.css"/>
    </style>
    <link xmlns="http://www.w3.org/1999/xhtml" rel="stylesheet" type="text/css">
      <xsl:attribute name="href">
        <xsl:if test="not(/spec/@role='editors-copy')">
          <xsl:text>http://www.w3.org/StyleSheets/TR/</xsl:text>
        </xsl:if>
        <xsl:choose>
          <xsl:when test="/spec/@role='editors-copy'">base.css</xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="/spec/@w3c-doctype='wd'">W3C-WD</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='rec'">W3C-REC</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='pr'">W3C-PR</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='cr'">W3C-CR</xsl:when>
              <xsl:when test="/spec/@w3c-doctype='note'">W3C-NOTE</xsl:when>
              <xsl:otherwise>base</xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <!--xsl:text>.css</xsl:text-->
      </xsl:attribute>
    </link>
  </xsl:template>

</xsl:transform>
