/*
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.validation;

/**
 *  These operations may throw a <code>ExceptionVAL</code> as described in 
 * their descriptions. 
 * <p>See also the <a href='http://www.w3.org/TR/2002/WD-DOM-Level-3-Val-20021008'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public class ExceptionVAL extends RuntimeException {
    public ExceptionVAL(short code, String message) {
       super(message);
       this.code = code;
    }
    public short   code;
    // ExceptionVALCode
    /**
     *  If the <code>DocumentEditVAL</code> related to the node does not have 
     * any grammar and <code>wfValidityCheckLevel</code> is set to 
     * <code>PARTIAL</code> or <code>STRICT_VALIDITY_CHECK</code>. 
     */
    public static final short NO_GRAMMAR_AVAILABLE      = 71;
    /**
     *  Raised if document is invalid. 
     */
    public static final short VALIDATION_ERR            = 72;

}
