/*
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */

package org.w3c.dom.validation;

/**
 * This interface extends the <code>NodeEditVAL</code> interface with 
 * additional methods for document editing.
 * <p>See also the <a href='http://www.w3.org/TR/2002/WD-DOM-Level-3-Val-20021008'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public interface DocumentEditVAL extends NodeEditVAL {
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. Setting this to <code>true</code> 
     * will result in an exception being thrown, i.e., 
     * <code>VALIDATION_ERR</code>, for documents that are invalid at the 
     * time of the call. When set to true, the implementation if free to 
     * raise the <code>VALIDATION_ERR</code> exception on DOM operations 
     * that would make the document invalid with respect to "partial 
     * validity." If the document is invalid, then this attribute will 
     * remain <code>false</code>. This attribute is <code>false</code> by 
     * default.
     */
    public boolean getContinuousValidityChecking();
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. Setting this to <code>true</code> 
     * will result in an exception being thrown, i.e., 
     * <code>VALIDATION_ERR</code>, for documents that are invalid at the 
     * time of the call. When set to true, the implementation if free to 
     * raise the <code>VALIDATION_ERR</code> exception on DOM operations 
     * that would make the document invalid with respect to "partial 
     * validity." If the document is invalid, then this attribute will 
     * remain <code>false</code>. This attribute is <code>false</code> by 
     * default.
     */
    public void setContinuousValidityChecking(boolean continuousValidityChecking);

    /**
     * Validates the document against the grammar. If the document is mutated 
     * during validation, a warning will be issued. In addition, the 
     * validation cannot modify the document, e.g., for default attributes. 
     * This method makes use of the passed-in error handler, as described in 
     *  interface. 
     * @exception ExceptionVAL
     *   NO_GRAMMAR_AVAILABLE: Raised if an error occurs when the grammar is 
     *   not available for the document.
     */
    public void validateDocument()
                                 throws ExceptionVAL;

}
