
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGMarkerElement extends 
               SVGElement,
               SVGLangSpace,
               SVGExternalResourcesRequired,
               SVGStylable,
               SVGFitToViewBox {
  // Marker Unit Types
  public static final short SVG_MARKERUNITS_UNKNOWN        = 0;
  public static final short SVG_MARKERUNITS_USERSPACEONUSE = 1;
  public static final short SVG_MARKERUNITS_USERSPACE      = 2;
  public static final short SVG_MARKERUNITS_STROKEWIDTH    = 3;
  // Marker Orientation Types
  public static final short SVG_MARKER_ORIENT_UNKNOWN      = 0;
  public static final short SVG_MARKER_ORIENT_AUTO         = 1;
  public static final short SVG_MARKER_ORIENT_ANGLE        = 2;

  public SVGAnimatedLength      getRefX( );
  public void      setRefX( SVGAnimatedLength refX )
                       throws DOMException;
  public SVGAnimatedLength      getRefY( );
  public void      setRefY( SVGAnimatedLength refY )
                       throws DOMException;
  public SVGAnimatedEnumeration getMarkerUnits( );
  public void      setMarkerUnits( SVGAnimatedEnumeration markerUnits )
                       throws DOMException;
  public SVGAnimatedLength      getMarkerWidth( );
  public void      setMarkerWidth( SVGAnimatedLength markerWidth )
                       throws DOMException;
  public SVGAnimatedLength      getMarkerHeight( );
  public void      setMarkerHeight( SVGAnimatedLength markerHeight )
                       throws DOMException;
  public SVGAnimatedEnumeration getOrientType( );
  public SVGAnimatedAngle      getOrientAngle( );

  void setOrientToAuto (  );
  void setOrientToAngle ( SVGAngle angle );
}
