
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGGradientElement extends 
               SVGElement,
               SVGURIReference,
               SVGExternalResourcesRequired,
               SVGUnitTypes {
  // Spread Method Types
  public static final short SVG_SPREADMETHOD_UNKNOWN = 0;
  public static final short SVG_SPREADMETHOD_PAD     = 1;
  public static final short SVG_SPREADMETHOD_REFLECT = 2;
  public static final short SVG_SPREADMETHOD_REPEAT  = 3;

  public SVGAnimatedEnumeration   getGradientUnits( );
  public void      setGradientUnits( SVGAnimatedEnumeration gradientUnits )
                       throws DOMException;
  public SVGAnimatedTransformList getGradientTransform( );
  public void      setGradientTransform( SVGAnimatedTransformList gradientTransform )
                       throws DOMException;
  public SVGAnimatedEnumeration   getSpreadMethod( );
  public void      setSpreadMethod( SVGAnimatedEnumeration spreadMethod )
                       throws DOMException;
}
