
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGFETurbulenceElement extends 
               SVGElement,
               SVGFilterPrimitiveStandardAttributes {
  // Turbulence Types
  public static final short SVG_TURBULENCE_TYPE_UNKNOWN      = 0;
  public static final short SVG_TURBULENCE_TYPE_FRACTALNOISE = 1;
  public static final short SVG_TURBULENCE_TYPE_TURBULENCE   = 2;
  // Stitch Options
  public static final short SVG_STITCHTYPE_UNKNOWN  = 0;
  public static final short SVG_STITCHTYPE_STITCH   = 1;
  public static final short SVG_STITCHTYPE_NOSTITCH = 2;

  public SVGAnimatedNumber      getBaseFrequencyX( );
  public void      setBaseFrequencyX( SVGAnimatedNumber baseFrequencyX )
                       throws DOMException;
  public SVGAnimatedNumber      getBaseFrequencyY( );
  public void      setBaseFrequencyY( SVGAnimatedNumber baseFrequencyY )
                       throws DOMException;
  public SVGAnimatedInteger     getNumOctaves( );
  public void      setNumOctaves( SVGAnimatedInteger numOctaves )
                       throws DOMException;
  public SVGAnimatedNumber      getSeed( );
  public void      setSeed( SVGAnimatedNumber seed )
                       throws DOMException;
  public SVGAnimatedEnumeration getStitchTiles( );
  public void      setStitchTiles( SVGAnimatedEnumeration stitchTiles )
                       throws DOMException;
  public SVGAnimatedEnumeration getType( );
  public void      setType( SVGAnimatedEnumeration type )
                       throws DOMException;
}
