
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGFEConvolveMatrixElement extends 
               SVGElement,
               SVGFilterPrimitiveStandardAttributes {
  // Edge Mode Values
  public static final short SVG_EDGEMODE_UNKNOWN   = 0;
  public static final short SVG_EDGEMODE_DUPLICATE = 1;
  public static final short SVG_EDGEMODE_WRAP      = 2;
  public static final short SVG_EDGEMODE_NONE      = 3;

  public SVGAnimatedInteger     getOrderX( );
  public void      setOrderX( SVGAnimatedInteger orderX )
                       throws DOMException;
  public SVGAnimatedInteger     getOrderY( );
  public void      setOrderY( SVGAnimatedInteger orderY )
                       throws DOMException;
  public SVGAnimatedNumberList  getKernelMatrix( );
  public SVGAnimatedNumber      getDivisor( );
  public void      setDivisor( SVGAnimatedNumber divisor )
                       throws DOMException;
  public SVGAnimatedNumber      getBias( );
  public void      setBias( SVGAnimatedNumber bias )
                       throws DOMException;
  public SVGAnimatedInteger     getTargetX( );
  public void      setTargetX( SVGAnimatedInteger targetX )
                       throws DOMException;
  public SVGAnimatedInteger     getTargetY( );
  public void      setTargetY( SVGAnimatedInteger targetY )
                       throws DOMException;
  public SVGAnimatedEnumeration getEdgeMode( );
  public void      setEdgeMode( SVGAnimatedEnumeration edgeMode )
                       throws DOMException;
  public SVGAnimatedLength      getKernelUnitLengthX( );
  public void      setKernelUnitLengthX( SVGAnimatedLength kernelUnitLengthX )
                       throws DOMException;
  public SVGAnimatedLength      getKernelUnitLengthY( );
  public void      setKernelUnitLengthY( SVGAnimatedLength kernelUnitLengthY )
                       throws DOMException;
  public SVGAnimatedBoolean     getPreserveAlpha( );
  public void      setPreserveAlpha( SVGAnimatedBoolean preserveAlpha )
                       throws DOMException;
}
