
package org.w3c.dom.svg;

import org.w3c.dom.DOMException;

public interface SVGComponentTransferFunctionElement extends 
               SVGElement {
  // Component Transfer Types
  public static final short SVG_FECOMPONENTTRANFER_TYPE_UNKNOWN  = 0;
  public static final short SVG_FECOMPONENTTRANFER_TYPE_IDENTITY = 1;
  public static final short SVG_FECOMPONENTTRANFER_TYPE_TABLE    = 2;
  public static final short SVG_FECOMPONENTTRANFER_TYPE_DISCRETE    = 3;
  public static final short SVG_FECOMPONENTTRANFER_TYPE_LINEAR   = 4;
  public static final short SVG_FECOMPONENTTRANFER_TYPE_GAMMA    = 5;

  public SVGAnimatedEnumeration getType( );
  public void      setType( SVGAnimatedEnumeration type )
                       throws DOMException;
  public SVGAnimatedNumberList  getTableValues( );
  public SVGAnimatedNumber      getSlope( );
  public void      setSlope( SVGAnimatedNumber slope )
                       throws DOMException;
  public SVGAnimatedNumber      getIntercept( );
  public void      setIntercept( SVGAnimatedNumber intercept )
                       throws DOMException;
  public SVGAnimatedNumber      getAmplitude( );
  public void      setAmplitude( SVGAnimatedNumber amplitude )
                       throws DOMException;
  public SVGAnimatedNumber      getExponent( );
  public void      setExponent( SVGAnimatedNumber exponent )
                       throws DOMException;
  public SVGAnimatedNumber      getOffset( );
  public void      setOffset( SVGAnimatedNumber offset )
                       throws DOMException;
}
