# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# This module defines the class -Tree-
# that maintaints a tree used to encode the sentences

import cost

# This class maintains a structured tree
# (internally codified as a string)
# to handle:
# statement -> triple (subject, predicate, object)
# logical operators  -> and, or, not, imply
# containers -> bag,alt,seq (both on subject and object)
class Tree:

    #class constructor
    def __init__ (self):
        self.__all=['discourse']
        self.__index=0   


    # returns a tree in form of a list
    def list(self):
        return self.__all

    # adds a new statement to the tree
    # subject = subject in the statement
    # predicate = predicate in the statement
    # object = object in the statement
    def new_stat(self,subject='',predicate='',object=''):
        self.__index+=1
        stat=['stat',subject,predicate,object] 
        self.__all.append(stat)
    

    # modify the subject in the current statement
    # subject = new subject
    def subj(self,subject):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            self.__all[self.__index][1]=subject        
        else:      #look for the last statement of the logical operators (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            self.__all[self.__index][max_ind][1]=subject  

    
    # modify the predicate in the current statement
    # predicate = new predicate
    def pred(self,predicate):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            self.__all[self.__index][2]=predicate        
        else:   
            max_ind= len(self.__all[self.__index])-1
            self.__all[self.__index][max_ind][2]=predicate  


    # modify the object in the current statement
    # object = new object
    def obj(self,object):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            self.__all[self.__index][3]=object        
        else:   
            max_ind= len(self.__all[self.__index])-1
            self.__all[self.__index][max_ind][3]=object  

    
    # negates the current statement
    # in case the statement has already been negated, then
    # returns the statement without negation
    def notStat (self):
        if (self.__all[self.__index][0]== 'stat'):
            self.__all[self.__index][0]='Nstat'
        elif (self.__all[self.__index][0]== 'Nstat'):
            self.__all[self.__index][0]='stat'
        else:   #must look gor the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if self.__all[self.__index][max_ind][0]=='stat':
                self.__all[self.__index][max_ind][0]='Nstat'
            elif self.__all[self.__index][max_ind][0]=='Nstat':
                self.__all[self.__index][max_ind][0]='stat'


    # puts in the current statement a "bag" container in place of the subject
    # adding to this same bag the old subject plus the new subject
    # new_subj = new subject to insert in the bag
    def addBagSubj(self, new_subj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][1][0]=='bag'):    #the bag in the subject was already present
                self.__all[self.__index][1].append(new_subj)
            else:                               # creates a brand new bag in the subject
                temp=['bag']
                temp.append(self.__all[self.__index][1])
                temp.append(new_subj)
                self.__all[self.__index][1]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][1][0]=='bag'):    #the bag in the subject already existed
                 self.__all[self.__index][max_ind][1].append(new_subj)
            else:                               # creates a brand new bag in the subject
                temp=['bag']
                temp.append(self.__all[self.__index][max_ind][1])
                temp.append(new_subj)
                self.__all[self.__index][max_ind][1]=temp


    # puts in the current statement a "sequence" container in place of the subject
    # adding to the seq itself the old subject plus the new one
    # new_subj = new subject to insert in the seq
    def addSeqSubj(self, new_subj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][1][0]=='seq'):    #the seq in the subject already existed
                self.__all[self.__index][1].append(new_subj)
            else:                               # creates a brand new seq in the subject
                temp=['seq']
                temp.append(self.__all[self.__index][1])
                temp.append(new_subj)
                self.__all[self.__index][1]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][1][0]=='seq'):    #the seq in the subject already existed
                 self.__all[self.__index][max_ind][1].append(new_subj)
            else:                               # creates a brand new seq in the subject
                temp=['seq']
                temp.append(self.__all[self.__index][max_ind][1])
                temp.append(new_subj)
                self.__all[self.__index][max_ind][1]=temp


    # puts in the current statement a "sequence" container in place of the subject
    # adding to the seq itself the old subject plus the new one
    # in case the subject was already a Bag, it is converted to a Seq
    # new_subj = new subject to insert in a seq
    def addSeqSubj2(self, new_subj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            y=self.__all[self.__index][1][0]
            if (y=='seq' or y=='bag'):    #the bag/seq in the subject already existed
                self.__all[self.__index][1][0]='seq'
                self.__all[self.__index][1].append(new_subj)
            else:                               # creates a brand new seq in the subject
                temp=['seq']
                temp.append(self.__all[self.__index][1])
                temp.append(new_subj)
                self.__all[self.__index][1]=temp
        else:   #must look the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            x=self.__all[self.__index][max_ind][1][0]
            if (x=='seq'or x=='bag'):    #the bag/seq in the subject already existed
                 self.__all[self.__index][max_ind][1][0]='seq'
                 self.__all[self.__index][max_ind][1].append(new_subj)
            else:                               # creates a brand new seq in the subject
                temp=['seq']
                temp.append(self.__all[self.__index][max_ind][1])
                temp.append(new_subj)
                self.__all[self.__index][max_ind][1]=temp
                

    # puts in the current statement an "alternative" container in place of the subject
    # adding to the alt itself the old subject plus the new one
    # new_subj = new subject to insert in the alt
    def addAltSubj(self, new_subj):            
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][1][0]=='alt'):    #the alt in the subject already existed
                self.__all[self.__index][1].append(new_subj)
            else:                               # creates a brand new alt in the subject 
                temp=['alt']
                temp.append(self.__all[self.__index][1])
                temp.append(new_subj)
                self.__all[self.__index][1]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][1][0]=='alt'):    #the alt in the subject already existed
                 self.__all[self.__index][max_ind][1].append(new_subj)
            else:                               # creates a brand new alt in the subject
                temp=['alt']
                temp.append(self.__all[self.__index][max_ind][1])
                temp.append(new_subj)
                self.__all[self.__index][max_ind][1]=temp


    # puts in the current statement a "bag" container in place of the object
    # adding to the bag itself the old object plus the new one
    # new_obj = new object to insert in the bag
    def addBagObj(self, new_obj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][3][0]=='bag'):    #the bag in the object already existed
                self.__all[self.__index][3].append(new_obj)
            else:                               # creates a brand new bag in the object
                temp=['bag']
                temp.append(self.__all[self.__index][3])
                temp.append(new_obj)
                self.__all[self.__index][3]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][3][0]=='bag'):    #the bag on the object already existed
                 self.__all[self.__index][max_ind][3].append(new_obj)
            else:                               # creates a brand new bag in the object
                temp=['bag']
                temp.append(self.__all[self.__index][max_ind][3])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][3]=temp
                

    # puts in the current statement a "seq" container in place of the object
    # adding to the seq itself the old object plus the new one
    # new_obj = new object to insert in the seq
    def addSeqObj(self, new_obj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][3][0]=='seq'):    #the bag in the object already existed
                self.__all[self.__index][3].append(new_obj)
            else:                               # creates a brand new seq in the object
                temp=['seq']
                temp.append(self.__all[self.__index][3])
                temp.append(new_obj)
                self.__all[self.__index][3]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][3][0]=='seq'):    #the seq in the object already existed
                 self.__all[self.__index][max_ind][3].append(new_obj)
            else:                               # creates a brand new seq in the object
                temp=['seq']
                temp.append(self.__all[self.__index][max_ind][3])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][3]=temp


    # puts in the current statement a "seq" container in place of the object
    # adding to the seq itself the old object plus the new one
    # in case the object was already a "bag" it is converted into a "seq"
    # new_obj = new object to insert in the seq
    def addSeqObj2(self, new_obj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            y=self.__all[self.__index][3][0]
            if (y=='seq' or y=='bag'):    #the bag/seq in the object already existed
                self.__all[self.__index][3][0]='seq'
                self.__all[self.__index][3].append(new_obj)
            else:                               # creates a brand new seq in the object
                temp=['seq']
                temp.append(self.__all[self.__index][3])
                temp.append(new_obj)
                self.__all[self.__index][3]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            x=self.__all[self.__index][max_ind][3][0]
            if (x=='seq'or x=='bag'):    #the bag/seq in the object already existed
                 self.__all[self.__index][max_ind][3][0]='seq'
                 self.__all[self.__index][max_ind][3].append(new_obj)
            else:                               # creates a brand new seq in the object
                temp=['seq']
                temp.append(self.__all[self.__index][max_ind][3])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][3]=temp


    # puts in the current statement a "alternative" container in place of the object
    # adding to the alt itself the old object plus the new one
    # new_obj = new object to insert in the alt
    def addAltObj(self, new_obj):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][3][0]=='alt'):    #the alt in the object already existed
                self.__all[self.__index][3].append(new_obj)
            else:                               # creates a brand new alt in the object
                temp=['alt']
                temp.append(self.__all[self.__index][3])
                temp.append(new_obj)
                self.__all[self.__index][3]=temp
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1
            if (self.__all[self.__index][max_ind][3][0]=='alt'):    #the alt in the object already existed
                 self.__all[self.__index][max_ind][3].append(new_obj)
            else:                               # creates a brand new alt in the object
                temp=['alt']
                temp.append(self.__all[self.__index][max_ind][3])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][3]=temp



    # substitute the current statement with a logical operator "AND"
    # having as operands the current statement plus the new input statement
    # (subject, predicate, object)
    # If the current statement is already an "AND", then
    # adds to it a new statement 
    # subject = subject in the statement
    # predicate = predicate in the statement
    # object = object in the statement
    def newAndStat(self,subject='',predicate='',object=''):
        stat=['stat',subject,predicate,object] 
        if (self.__all[self.__index][0]=='and'):
            old_and =(self.__all[self.__index])
            to_and =old_and + [stat]
        else:
            to_and= ['and',self.__all[self.__index], stat]
        self.__all[self.__index]=to_and
        
    # substitute the current statement with a logical operator "OR"
    # having as operands the current statement plus the new input statement
    # (subject, predicate, object)
    # If the current statement is already an "OR", then
    # adds to it a new statement 
    # subject = subject in the statement
    # predicate = predicate in the statement
    # object = object in the statement
    def newOrStat(self,subject='',predicate='',object=''):

        stat=['stat',subject,predicate,object] 

        if (self.__all[self.__index][0]=='or'):
            old_or =(self.__all[self.__index])
            to_or =old_or + [stat]
        else:
            to_or= ['or',self.__all[self.__index], stat]
        self.__all[self.__index]=to_or                

    # substitute the current statement with a logical operator "IMPLY"
    # having as operands the current statement plus the new input statement
    # (subject, predicate, object)
    # subject = subject in the statement
    # predicate = predicate in the statement
    # object = object in the statement
    def newImplyStat(self,subject='',predicate='',object=''):

        stat=['stat',subject,predicate,object]
        if self.__all[self.__index]!= 'discourse':
            to_imply= ['imply',self.__all[self.__index], stat]
            self.__all[self.__index]=to_imply
        else:
            print "Cannot insert implication!"



    # developed in the 18/06/02 build :
    
    # in the current statement puts an operator in place of the object
    # adding to the operator the old object plus the new one 
    # new_obj = new object to insert in the bag
    # NameOp= type of operation
    def addOpObj(self, new_obj,NameOp):
        if (self.__all[self.__index][0]== 'stat' or self.__all[self.__index][0]== 'Nstat'):
            if (self.__all[self.__index][3][0]==NameOp):    #the operation in the subject already existed
                self.__all[self.__index][3].append(new_obj)
            else:                               # creates ex novo a bag in the subject
                temp=[NameOp]
                temp.append(self.__all[self.__index][3])
                temp.append(new_obj)
                self.__all[self.__index][3]=temp
            
        else:   #must look for the last statement of the logical op (and,or,imply)
            max_ind= len(self.__all[self.__index])-1

            # Math recursion to the left of the predicate
            if NameOp in ['add','divide','times','sub'] and self.__all[self.__index][max_ind][0] in ['stat','Nstat']: 
                temp =[NameOp]
                temp.append(self.__all[self.__index][max_ind][1])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][1]=temp
                # If math recursion to the right of the predicate
            elif self.__all[self.__index][max_ind][0] in ['great','ne','eq','less','leq','geq']:
                temp =[NameOp]
                temp.append(self.__all[self.__index][max_ind][2])
                temp.append(new_obj)
                self.__all[self.__index][max_ind][2]=temp               
            else:
                if (self.__all[self.__index][max_ind][3][0]==NameOp):    #the bag in the subject already existed
                     self.__all[self.__index][max_ind][3].append(new_obj)
                else:                               # creates a brand new bag inthe subject
                    temp=[NameOp]
                    temp.append(self.__all[self.__index][max_ind][3])
                    temp.append(new_obj)
                    self.__all[self.__index][max_ind][3]=temp

    # creates a tree in case of a comparison predicate
    def addPredObj(self, new_obj,NameOp):
        temp=[NameOp]
        temp.append(self.__all[self.__index][2][1])
        temp.append(new_obj)
        self.__all[self.__index][2]=temp


    # creates a tree in case of a math op predicate
    def addPredMath(self,new_obj,NameOp,stringa):
        if stringa == 'prec':
            max_ind= len(self.__all[self.__index])-1
            temp =[NameOp]
            temp.append(self.__all[self.__index][max_ind][2])
            temp.append(new_obj)
            self.__all[self.__index][max_ind][2]=temp
        elif stringa == 'succ':
            max_ind= len(self.__all[self.__index])-1
            temp =[NameOp]
            temp.append(self.__all[self.__index][max_ind][1])
            temp.append(new_obj)
            self.__all[self.__index][max_ind][1]=temp


