# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that translates a Metalog file to an N-triple file
# with the annotation N-triples
#********************************************************#

# Import various contants
from    definitions     import  *

# Import procedures
from    procedure       import  *

# Import Annotation Metalog Class
from  macro2ntriple     import Macro2Ntriple


#********************************************************#
# Class translating ML to NT triples with assertions
#********************************************************#
class TranslatorAnnClass:

  "Translator with annotations"

  #********************************************************************************************
  # Initialization of the internal data structures
  #********************************************************************************************
  def __init__(self, M):
    self.d_assertions = []
    self.d_que        = []
    self.t_assertions = []
    self.t_que        = []
    self.m_ok         = -1
    self.M            = M

  #********************************************************************************************
  # Procedure that translates ML to NT with annotations
  #********************************************************************************************
  def translatorAnn(self, ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name, choice, MACRO, NT_FORMAT):

    # Computes the N-triples of assertions and queries and saves in the corresponding folders

    if choice == 'stat':

      # Computes the assertions N-Triples
      triple = self.M.createNTriple(ml_name, type=choice, nameFileOut=assertions_name)
      self.M.destroyAll()

      F = open(que_name,'w')
      F.write(' ')
      F.close()

    elif choice == 'query':

      # Computes the queries N-Triples
      triple = self.M.createNTriple(ml_name, type=choice, nameFileOut=que_name)
      self.M.destroyAll()

      F = open(assertions_name,'w')
      F.write(' ')
      F.close()

    else:

      # Computes the assertions N-Triples
      triple = self.M.createNTriple(ml_name, type='stat', nameFileOut=assertions_name)
      self.M.destroyAll()

      # Computes the queries N-triples
      triple = self.M.createNTriple(ml_name, type='query', nameFileOut=que_name)
      self.M.destroyAll()

    # Computes the N-Triple temp file (to unlock the last written file)
    # this, as the ML-NT translator keeps locked the last file it wrote.
    triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
    self.M.destroyAll()

    try:

      # Generates the macros (from the assertions and queries) from the ML input file. Saves the result in the N-triples file.

      class_macro = Macro2Ntriple()
      MACRO_OK = class_macro.calcolafrommacro(ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name)
      self.d_assertions = class_macro.data_assertions
      self.d_que = class_macro.data_que
      self.t_assertions = class_macro.assertions
      self.t_que = class_macro.que
      del class_macro

      #####################################################################
      # Appends the computed annotations to the N-triples file without annotations
      mergeNtripleAnnotation(assertions_name, ann_assertions_name)
      mergeNtripleAnnotation(que_name, ann_que_name)
      self.m_ok = MACRO_OK

      modify_nt_format(assertions_name, NT_FORMAT)
      modify_nt_format(que_name, NT_FORMAT)
      modify_nt_format(ann_assertions_name, NT_FORMAT)
      modify_nt_format(ann_que_name, NT_FORMAT)

    except:
      print "\n\n  Error during computation of Annotation Ntriples\n"
      print "  Original annotations cannot be used and deduced data cannot be created. Only the result data will be computed."
      MACRO_OK = -1
      self.m_ok = -1


    if MACRO != '1':   # Clears the macro tables for assertions and queries
      self.d_assertions = []
      self.d_que = []
    return(1)


