# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module with the procedure for disk saves               #
#********************************************************#

# Import of constants
from  definitions      import *

# Imports the traslator from ML to NT format (with annotations)
from  translatorAnn    import *


#********************************************************************************************
# Saves the results in a text file (with ml and nt extensions)
#********************************************************************************************
def saveresult(pathml, pathnt, result_que, str1, varprint, NT_FORMAT, M, MACRO):

  prefix = result_que[0]
  stringa = result_que[1]

  try:
    i = 0
    
    while i < len(prefix):
      str_open = os.path.normpath(os.path.join(pathml,str1 + str(i) + ".ml"))
      str_open1 = os.path.normpath(os.path.join(pathnt,str1 + str(i) + ".nt"))

      pref = prefix[i]
      stri = stringa[i]

      fresult = open(str_open, 'w')
      fresult.write("comment: Output of the Metalog query.\n\n")

      if varprint:
        print("comment: Output of the Metalog query.\n\n")
    
      for p in pref:        
        fresult.write(p+".\n")
        if varprint:
          print(p+".")

      fresult.write("\n")
      if varprint:
        print("")
      a=0
      s=""
      while a < len(stri)-1:
        fresult.write(stri[a]+", and \n")
        s = s + stri[a]+", and \n"
        a=a+1
    
      fresult.write(stri[a] +".\n\n ")
      if varprint:
        print(s + stri[a] + ".\n")
      fresult.close()

      if MACRO == '1':
        [name_tmp, name_file_que] = cal_name(str_open)

        [configuration, str_tmp] = read_choose()

        # Setting of files directories and extensions
        assertions_name = str_open1
        que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
        ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "ann.nt"))
        ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "ann_QRY.nt"))
        ml_name = str_open

        # translation of the ML file to NT file with annotation
        class_translator = TranslatorAnnClass(M)
        out = class_translator.translatorAnn(ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name, 'stat', MACRO, NT_FORMAT)
      else:
          
        # Computation of N-triples
        triple = M.createNTriple(str_open,type='stat',nameFileOut=str_open1)

        # Computation of the N-Triples temp file (to unlock the last written file)
        # This because the ML-NT translator keeps locked the last file that it wrote.
        triple = M.createNTriple(TMP_ASSERTION , type='stat')

        modify_nt_format(str_open1, NT_FORMAT)

      i=i+1
            
    if varprint:
      print("Result written in 'ml' and 'nt' form.")
    return(1)
      
  except:
    print('\n ERROR when translating "ml" file into "nt" file.')
    return(-1)

  
#********************************************************************************************
# Saves the deduced results (assertions + answers to queries) in ml and nt files.
#********************************************************************************************
def savededuced(result, str1, varprint):

  try:
    [pref, stri] = result
    str_open  = os.path.normpath(os.path.join(ML_DEDUCED_FOLDER,str1 + ".ml"))
    str_open1 = os.path.normpath(os.path.join(NT_DEDUCED_FOLDER,str1 + ".nt"))

    fresult = open(str_open, 'w')
    fresult.write("comment: Output of Metalog; This file contains assertions deduced from the query.\n\n")

    if varprint:
      print("comment: Output of Metalog; This file contains assertions deduced from the query.\n\n")
    
    for p in pref:        
      fresult.write(p+".\n")
      if varprint:
        print(p+".")

    fresult.write("\n")
    if varprint:
      print("")
    a=0
    s=""
    while a < len(stri)-1:
      fresult.write(stri[a]+".\n")
      s = s + stri[a]+".\n"
      a=a+1
    
    fresult.write(stri[a] +".\n\n ")
    if varprint:
      print(s + stri[a] + ".\n")
    fresult.close()

    # Load translator (ml 2 nt)
    MM = translator.TheTranslator()
    EE = error03.Error(None,MM)
    MM.initError(EE)

    # Computation of N-triples
    triple = MM.createNTriple(str_open, type='stat', nameFileOut=str_open1)
    
    # Computation of N-Triple temp file (to unlock the last written file)
    # This because the ML-NT translator keeps locked the last written file
    triple = MM.createNTriple(TMP_ASSERTION , type='stat')

    del MM
    del EE
      
    if varprint:
      print("Deduced data written in 'ml' and 'nt' form.")
      
    return(1)
      
  except:
    print('\n ERROR when translating "ml" file into "nt" file.')
    return(-1)
