# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that analyzes the result (at Metalog level)     #
#********************************************************#

# Import libraries
import time

# Import libraries
import os
import string

# Import misc costants
from    definitions     import  *

# Import procedures
from    procedure       import  *


#********************************************************#
# Class that analyzes the result of the inferential system at Metalog level
#********************************************************#
class ResultClass:

  "Class that analyze queries result"
  
  #********************************************************************************************
  # Initalizes the internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data               = []
    self.table              = []
    self.table_asser       = []
    self.table_que          = []

    
  #********************************************************************************************
  # Analysis of the output file in a prolog system (SAVE !!!!!!!!!!!!!!!!!!!!!1
  #********************************************************************************************
  def analyze_results(self, assertions, queries, list_var_a, list_var_q):

    self.readdata()

    if self.table[len(self.table)-1]!='end_of_file':
      self.data = [-3]
    else:

      # Transforms a table series, that represent the assertions, in a single table.
      asser = flat(assertions)

      # Creates listing of queries
      que = flat(queries)

      num_asser = len(asser)
      num_que = len(que)
    
      [n_asser, n_que] = self.asser_que(asser, que, list_var_a, list_var_q)

      if n_asser == -1 or n_que == -1:
        
        return([-1])

      # Normalizes the results
      table_asser1 = name2uri(self.table_asser)
      table_que1 = name2uri(self.table_que)  

      # Normalization 2: takes away multiple answers in the same query (that is, in the table that contains the unifications that 
      # make the clause true; these are not necessary as, subsequently, there is the check that eliminates all the
      # double unifications: but, it gets smaller tables, takes away redundant data, and makes all the next phases quicker.
      table_asser1 = normalize(table_asser1)
      table_que1 = normalize_que(table_que1)

      # Analysis of the results
      if num_asser == n_asser and num_que == n_que and table_que1[len(table_que1)-1][1] == []:

        self.data = [-3]
  
      elif num_asser == n_asser and num_que == n_que:
        self.data = [table_asser1, table_que1]  

      elif num_que != n_que:
        self.data = [-3]

      elif num_asser < n_asser:
        self.data = [-4]

      else:
        self.data = [-2]
  
  #********************************************************************************************
  # Reads the data from file and saves in the table self.table
  #********************************************************************************************
  def readdata(self):
    
    fpro = open(PIPEOUT,'r')
  
    dat0 = fpro.readline()
    table_tmp = []

    while dat0 <> '':
      if table_tmp != '\n':
        table_tmp = table_tmp + [dat0[0:len(dat0)-1]]
      if dat0[0:len(dat0)-1] != 'end_of_file':
        dat0 = fpro.readline()
      else:
        dat0 = ''  
         
    fpro.close()        
    self.table = table_tmp


  #********************************************************************************************
  # Procedure that analyzes the data of the system and generates the assertions and queries tables
  #********************************************************************************************
  def asser_que(self, assertions, queries, list_var_a, list_var_q):

    n_asser = len(assertions)
    n_que = len(queries)

    a = 0
    table_asser = []
    while a < n_asser:
      table_asser.append([])
      a = a + 1
    num = len(self.table)
    
    u1 = 0    
    i = 0
    inc = 0
  
    while i + inc < n_asser * 4:
      line = self.table[i]
      out1 = analyze_result_asser1(self.table, line, i, u1, list_var_a, assertions, inc)
      if out1 == -1:
        self.data = [-1]
        return([-1, -1])
      else:
        [out, som] = out1
        inc = inc + som
        table_asser[u1] = out
      i = i + 4 - som 

      u1 = u1 + 1
    self.table_asser = table_asser
    num_asser = n_asser
    a = 0
    table_que = []
    while a < n_que:
      table_que.append([])
      a = a + 1

    u2 = 0
    while i < num-1:
      line = self.table[i]
      out = analyze_result_que1(self.table, line, i, u2, list_var_q)
      if out == -1:
        self.data = [-2]
        return([-1, -1])
      else:
        out_dat = out[0]
        # Returns 1 if there is a unique unification, 0 otherwhise
        if out[1] == 1:
          table_que [u2] = [1, out_dat]
        else:
          table_que [u2] = [0, out_dat]
      i = i + 2 + 2 * len(out_dat)
      u2 = u2 + 1
    self.table_que = table_que
    num_que = u2
    return([num_asser, num_que])
    

#********************************************************************************************
# Checks if a subject or object are variables
#********************************************************************************************
def check_var(sub):
  if sub[0] == '_':
    return(1)
  else:
    for char in sub:
      if not(char in MAIUSCOLE) and not(char in NUMERI):
        return(0)
    return(1)


#********************************************************************************************
# Checks if a subject or object are numbers. If so, returns a number between double quotes.
#********************************************************************************************
def numero(sub):
  virgola = 0
  v1 = 0
  i = 0
  while i < len(sub):
    char = sub[i]                
    if not(char in NUMERI or char in ('.', ',')):
      return(sub)
    if char in ('.', ','):
      virgola = virgola + 1
      v1 = i      
    i = i + 1

  if virgola == 0:
    return('"' + sub + '"')
  elif virgola == 1:
    return('"' + sub[0:v1] + '"')
  else:
    return(sub)


#********************************************************************************************
# Analysis of the output assertion of SWI-Prolog
#********************************************************************************************
def apici(str, num1, num2, lista):

  num=[[], [], []]
  for l in lista:
    if l[1] == num1 and l[2] == num2:
      if l[3] == 'sub':
        num[0] = l[0]
      elif l[3] == 'obj': 
        num[1] = l[0]
      else:
        num[2] = l[0]

  if str[0:7] == "assert(":
    str_tmp = str[7:len(str)]
  else:
    str_tmp = str
    
  if str_tmp[0] == '(' and str_tmp[len(str_tmp)-1] == ')':
    str_tmp = str_tmp[1:len(str_tmp)-1]
  
  par1 = find_char_norm(str_tmp,"(")
  if str_tmp[0:1] == " ":
    pre = str_tmp[1:par1]
  else:
    pre = str_tmp[0:par1]

  str_tmp=str_tmp[par1+1:len(str_tmp)]

  if str_tmp[0] != '[':
    vir = find_char_norm(str_tmp,",")
    if str_tmp[0:1] == " ":
      sub = str_tmp[1:vir]
    else:
      sub = str_tmp[0:vir]
    # Checks if it is a simple number
    sub = numero(sub)
    if check_var(sub) == 1 and num[0]!=[]:
      sub = num[0][0]
    str_tmp = str_tmp[vir+1:len(str_tmp)]
  else:
    qua = find_char_norm(str_tmp,"]")
    lista_1 = str_tmp[0:qua+1]
    lista_1_a = ricava_lista(lista_1)
    sub = "["
    p = 0
    while p < len(lista_1_a):
      el = lista_1_a[p]
      el = numero(el)
      if len(lista_1_a) == len(num[0]):      
        if check_var(el) == 1 and num[0][p]!="":
          el = num[0][p]
      else:
        if check_var(el) == 1:
          # Particular Case: Query with variable, answer container with variables. --> Random variable.
          el = "AAAAA"

      if p == len(lista_1_a)-1:
        sub = sub + el + "]"
      else:
        sub = sub + el + ", "
      p = p + 1

    str_tmp = str_tmp[qua+2:len(str_tmp)]   
  ###########################################################
    
  if str_tmp[0:1] == " ":
    str_tmp = str_tmp[1:len(str_tmp)]
  else:
    str_tmp = str_tmp[0:len(str_tmp)]
    
  if str_tmp != '[':
    par2 = find_char_norm(str_tmp,")")
    if str_tmp[0:1] == " ":
      obj = str_tmp[1:par2]
    else:
      obj = str_tmp[0:par2]
    # Checks if it is a simple number
    obj = numero(obj)
    if check_var(obj) == 1 and num[1]!=[]:
      obj = num[1][0]
    str_tmp = str_tmp[par2+1:len(str_tmp)]
  else:
    qua = find_char_norm(str_tmp,"]")
    lista_2 = str_tmp[0:qua+1]
    lista_2_a = ricava_lista(lista_2)
    obj = "["
    p = 0
    while p < len(lista_2_a):
      el = lista_2_a[p]
      el = numero(el)
      if len(lista_2_a) == len(num[1]):      
        if check_var(el) == 1 and num[1][p]!="":
          el = num[1][p]
      else:
        if check_var(el) == 1:
          # Particular Case: Query with variable, answer with a container with variables. --> Random variable.
          el = "BBBBB"

      if p == len(lista_2_a)-1:
        obj = obj + el + "]"
      else:
        obj = obj + el + ", "
      p = p + 1
  
    str_tmp = str_tmp[qua+2:len(str_tmp)]
    
  if len(str_tmp) > 0 and str_tmp[0] == ',':
    if str_tmp[1] != ' ':
      str_tmp = str_tmp[1:len(str_tmp)]
    else:
      str_tmp = str_tmp[2:len(str_tmp)]
    aggiunta = ', ' + apici(str_tmp, num1, num2+1,lista)
  elif len(str_tmp) > 0 and str_tmp[0] == ';':
    if str_tmp[1] != ' ':
      str_tmp = str_tmp[1:len(str_tmp)]
    else:
      str_tmp = str_tmp[2:len(str_tmp)]
    aggiunta = '; ' + apici(str_tmp, num1, num2+1,lista)
  else:
    aggiunta = ''

  # Answers that contain implications: Case not allowed.
  if str_tmp[0:2] == ":-":
    return(-1)
  #    restante = apici_dx(str_tmp[1:len(str_tmp)])

  pre = "'" + pre + "'"

  # Gets rid of the quotes if present
  if sub[0] == "'":
    sub = sub[1:len(sub)-1]
  if obj[0] == "'":
    obj = obj[1:len(obj)-1]
  

  stringa = pre + "(" + sub + ", " + obj + ")" + aggiunta

  return(stringa)


#********************************************************************************************
# Gets rid of the superfluous quotes, to have an ouput that is compatible with the inferential system
#********************************************************************************************
def togli_apici(lista):

  if lista[0] == '(' and lista[len(lista)-1] == ')':
    lista = lista[1:len(lista)-1]
  if lista[0] in MINUSCOLE:
  
    n = find_char_norm(lista,'(')
    testa = "'"+lista[0:n]+"'"
    coda = lista[n:len(lista)]  
    u = 0
    while u < len(coda):
      if coda[u] == "'":
         coda = coda[0:u] + coda[u+1:len(coda)]
      else:
        u = u + 1
    tmp = testa + coda

    n1 = find_char_norm(tmp,')')

    sx = tmp[0:n1+1]
    tmpa = tmp[n1+1:len(tmp)]
    
    num = find_char_norm(tmpa, ':')
    num1 = find_char_norm(tmpa, ',')
    num2 = find_char_norm(tmpa, ';')
    
    if num != -1 and tmpa[num-1] != '=' and tmpa[num+1] != '=':
      if tmpa[num+1] == '-':
        tmp1 = togli_apici(tmpa[num+2:len(tmpa)])
        return(sx+':-'+tmp1)
    
    elif num1 != -1:
      tmp1 = togli_apici(tmpa[num1+1:len(tmpa)])
      return(sx+','+tmp1)
  
    elif num2 != -1:
      tmp1 = togli_apici(tmpa[num2+1:len(tmpa)])
      return(sx+';'+tmp1)
    else:
      return(sx)
  else:
    return(lista)


#********************************************************************************************
# Analysis output assertion of SWI-Prolog
#********************************************************************************************
def analyze_result_asser1(table, line, i, n, lista, asser, inc):

  try:
    dat1 = table[i+1]
    dat2 = table[i+2]
    dat3 = table[i+3]
    if line[0:7]=="assert(" and dat1=="True" and dat2==line and dat3=="End":
      t1 = togli_apici(asser[(i+inc)/4])
      return([t1, 0])
    elif line[0:7]=="assert(" and dat1=="End":
      inc1 = inc + 2
      t1 = togli_apici(asser[(i+inc1)/4])
      return([t1, 2])
    else:
      print("Error during read result assertions of Prolog Process1.\n")
      return(-1)
          
  except:
    print("Error during read result assertions of Prolog Process2.\n")
    return(-1)


#********************************************************************************************
# Analysis output query of the Prolog systems
#********************************************************************************************
def analyze_result_que1(table, line, i, n, lista):
     
  # transform returns  [1,list] if dat is a list or [0] if dat is not a list

  h = i + 1

  dat1 = table[h]

  que = []
  data = []
  u = 0
  while dat1[0:4] == "True":
    try:
      asser1 = table[h+1]
      asser2 = apici(asser1, n, 0, lista)
      
      h = h + 2
      dat1 = table[h]

      data = data + [asser2]
      u = u + 1      
    
    except:
      print("Error during read result of query1.\n")
      return(-1)

  if dat1 == "End":
    return(data, u)
  else: 
    print("Error during read result of query2.\n")
    return(-1)
  

#********************************************************************************************
# Analyzes the list and substitutes strings with non alphanumeric chars
#********************************************************************************************
def make_list(lista):
  n1 = find_char_norm(lista, '[')
  n2 = find_char_norm(lista, ']')

  string1 = lista[n1+1:n2]

  i = 0
  table = []
  while 1:
    na = find_char_norm(string1, ',')
    if na == -1:
      table = table + [string1[0:len(string1)]]
      break
    table = table + [string1[0:na]]
    string1 = string1[na+1:len(string1)]

  a = 0
  while a < len(table):
    el = table[a]
    if el[0] == ' ':
      table[a] = el[1:len(el)]
    if el[len(el)-1] == ' ':
      table[a] = el[0:len(el)-1]
    a = a + 1

  string_out = "["
  
  a = 0
  while a < len(table)-1:
    if mai(table[a]) == 0:
      str1 = "'" + table[a] + "'"
    else:
      str1 = table[a]
    string_out = string_out + str1 + ", "
    a = a + 1
  if mai(table[a]) == 0:
    str1 = "'" + table[a] + "'"
  else:
    str1 = table[a]
  string_out = string_out + str1 + "]"

  return(string_out)


#********************************************************************************************
# Analyzes string and recognizes the presence of lists
#********************************************************************************************
def analyze_liste(stringa):

  n1 = find_char_norm(stringa,"[")
  n2 = find_char_norm(stringa,"]")

  if n1 == n2:         # Strings withouts lists #
    
    num1 = find_char_norm(stringa,"'")
    st2 = stringa[num1+1:len(stringa)]
    num1a = find_char_norm(st2,",")    
    
    if st2[num1a-1]=="'":
      num2 = find_char_norm(st2,"'")
      st3 = st2[num2+1:len(st2)]
      num3 = find_char_norm(st3,"'")
    
    else:
      num2 = find_char_norm(st2,"(")
      st3 = st2[num2+1:len(st2)]      
      num3 = num1a-1
      
    sub = st3[0:num3]

    st4 = st3[num3+1:len(st3)]
    num3a = find_char_norm(st4,")")

    if st4[num3a-1]=="'":
      num4 = find_char_norm(st4,"'")
      num5 = num3a-1      

    else:
      h = 0
      oo=0
      while h < len(st4):
        if st4[h] != " ":
          break
        h = h+1
      num4 = h-1
      num5 = num3a

    obj = st4[num4+1:num5]

    return([sub,obj])
  
  else:
    nv = find_char_norm(stringa,",")

    # List in object
    if nv<n1:

      num1 = find_char_norm(stringa,"'")
      st2 = stringa[num1+1:len(stringa)]
      num1a = find_char_norm(st2,",")    
    
      if st2[num1a-1]=="'":
        num2 = find_char_norm(st2,"'")
        st3 = st2[num2+1:len(st2)]
        num3 = find_char_norm(st3,"'")
    
      else:
        num2 = find_char_norm(st2,"(")
        st3 = st2[num2+1:len(st2)]      
        num3 = num1a-1
      
      sub = st3[0:num3]

      obj = make_list(stringa[n1:n2+1])
      
      return(sub, obj)

    # List in subject
    else:
      
      sub = make_list(stringa[n1:n2+1])
      
      st4 = stringa[n2+1:len(stringa)]

      n1a = find_char_norm(st4,"[")
      n2a = find_char_norm(st4,"]")

      if n1a == n2a:         # Object not list
     
        num3a = find_char_norm(st4,")")  

        st4 = st4[1:len(st4)]
        if st4[num3a-1]=="'":
          num4 = find_char_norm(st4,"'")
          num5 = num3a-1      

        else:
          h = 0
          oo=0
          while h < len(st4):
            if st4[h] != " ":
              break
            h = h+1
          num4 = h-1
          num5 = num3a-1

        obj = st4[num4+1:num5]
        
      else:                 # Object is list
      
        obj = make_list(st4[n1a:n2a+1])
        
    return(sub, obj)


#********************************************************************************************
# Trassforms a string with only alphanumeric chars in the corresponding string with non alphanumeric chars
#********************************************************************************************
def norm_str_back(stringa):

  try:
    
    i = 0
    lung = len(stringa)
    while i < lung-4:
      if stringa[i] == 'e' and stringa[i+1] in NUMERI and stringa[i+2] in NUMERI and stringa[i+3] in NUMERI:
        num = stringa[i+1:i+4]
        num = int(num, 10)
        stringa = stringa[0:i] + chr(num) + stringa[i+4:len(stringa)]
        lung = len(stringa)
      i = i+1

    if lung > 2 and stringa[1] in MINUSCOLE:
      
      num = find_char_norm(stringa,"'")
      st1 = stringa[num+1:len(stringa)]
      num1 = find_char_norm(st1,"'")
    
      pre = st1[0:num1]

      nap = find_char_norm(st1,"(")
      nch = find_char_norm(st1,")")
    
      liste = analyze_liste(st1[nap:nch+1])

      sub = liste[0]
    
      obj = liste[1]
           
      if sub[0] != "'" and sub[0] != "[":
        sub = "'"+sub+"'"
      if obj[0] != "'" and obj[0] != "[":
        obj = "'"+obj+"'"

      resto = st1[nch+1:len(st1)]


      dx = ''      
      if len(resto)>3:
        if resto[0:2] == ':-':
          dx = resto[2:len(resto)]
          if dx[0] == ' ':
            dx = dx[1:len(dx)]
          tmp1 = ':-'+norm_str_back(dx)
        elif resto[0:1] == ',':
          dx = resto[1:len(resto)]
          if dx[0] == ' ':
            dx = dx[1:len(dx)]
          tmp1 = ','+norm_str_back(dx)
          
        elif resto[0:1] == ';':
          dx = resto[1:len(resto)]
          if dx[0] == ' ':
            dx = dx[1:len(dx)]
          tmp1 = ';'+norm_str_back(dx)
        else:
          tmp1 = ''

      else:
        tmp1 = ''

      return("'"+pre+"'("+sub+", "+obj+")"+tmp1)
    
    elif lung > 2 and stringa[1] in MAIUSCOLE:
      ap = find_char_norm(stringa, "'")
      while ap != -1:
        stringa = stringa[0:ap]+stringa[ap+1:len(stringa)]
        ap = find_char_norm(stringa, "'")        
      return(stringa)

    elif lung > 2 and stringa[1] in NUMERI:
      ap = find_char_norm(stringa, "'")
      while ap != -1:
        stringa = stringa[0:ap]+stringa[ap+1:len(stringa)]
        ap = find_char_norm(stringa, "'")        
      return(stringa)
    
    else:
      return(stringa)
  except:
    print('\nError during string conversion.\n')
  
    return(-1)
    

#********************************************************************************************
# Transforms a tree containing only alphanumeric chars in a tree with non alphanumeric chars
# by using the conversion table
#********************************************************************************************
def name2uri(table):
  table_1 = table
  if type(table) == TYPELIST:
    if len(table) == 0:
      return([])
    else:
      i = 0
      while i < len(table):
        table_2 = name2uri(table[i])
        table_1[i] = table_2
        i = i + 1
      return(table_1)
  elif type(table) == TYPESTRING:
    table_new = norm_str_back(table)
    return([table_new])
  else:
    return(table)


#********************************************************************************************
# Generates a list of strings from a single string enclosed between square brackets
#********************************************************************************************
def ricava_lista(stringa):

  # It is missing the handling of variables in the lists!
  tmp = stringa[1:len(stringa)-1]
  lista = []
  n = 1
  while 1:
    if tmp[0] == ' ':
      tmp = tmp[1:len(tmp)]
    if tmp[len(tmp)-1] == ' ':
      tmp = tmp[0:len(tmp)-1]
    n = find_char_norm(tmp, ',')
    if n != -1:
      str1 = tmp[0:n]
      if str1[0] == "'":
        str1 = str1[1:len(str1)]
      if str1[len(str1)-1] == "'":
        str1 = str1[0:len(str1)-1]      
      tmp = tmp[n+1:len(tmp)]
      lista.append(str1)
    else:
      if tmp[0] == "'":
        tmp = tmp[1:len(tmp)]
      if tmp[len(tmp)-1] == "'":
        tmp = tmp[0:len(tmp)-1]
      lista.append(tmp[0:len(tmp)])
      return(lista)
  

#********************************************************************************************
# Deletes from the result table the double answers
#********************************************************************************************
def normalize(table):
  i = 0
  tmp = []
  while i < len(table):
    el1 = table[i]
    if not(el1 in tmp):
      tmp = tmp + [el1]
    i = i + 1
  return(tmp)


#********************************************************************************************
# Deletes from the result table the double answers
#********************************************************************************************
def normalize_que(table):
  p = 0
  while p < len(table):
    if table[p][0] == 0:
      aaa = normalize(table[p][1])
      table[p][1] = aaa
    p = p + 1
  return(table)







