# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
# This module implements the class -ReadCode-
# used to read the Metalog code and the creation 
# of the list that encodes it once
# the strip-off of the code itself has been done

import sys

if 'cost' in dir():  # import cost module
    reload(cost)
else: import cost

#if 'net_a01' in dir():  # import module  used to get files from the WWW
#    reload(net_a01)
#else: import net_a01

# class that reads the Metalog code, elaborates the macro, does the
#strip-off, and returns the corresponding representation list
class ReadCode:

    # class constructor
    # F = instance of the File object
    # E = instance of the Error object
    def __init__(self,F,E):
        self.E=E
        self.F=F
        self.F.copyFileInToFileTmp()
        openPar=[]  # list used to check parentheses ) and (
        self.listWords=[] 
        self.listMacro=[] 


    # returns the list representing the code
    def returnList(self):
        return self.listWords

           
    # reading one char at the time the Metalog code creates the
    # corresponding representation list
    def stripOff(self):
        word=''
        openPar=[]
        i=0
        while i<len(self.F.stringTmp)-1:
            char=self.F.stringTmp[i]
           
            nextChar=self.F.stringTmp[i+1]

            if char in cost.IGNORE:      # reads characters to ignote
                i+=1
                continue

            elif char =='(':   # reads open parenthesis
                openPar.append(i)
                i+=1
                continue

            elif char ==')':   # reads close parenthesis
                if len(openPar)==0:
                    strMsg='ERROR: The corresponding open bracket cannot be found.'             
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    openPar.pop()                   
                i+=1
                continue

            elif char in cost.LINE_COMMENT:  # reads char for line comment
                tmpRes=self.readString(self.F.stringTmp,i+2,['\n',''])
                if tmpRes==-1:
                    strMsg='ERROR: comment in a line' 
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    i=tmpRes[1] 
                    continue

            elif char+nextChar in cost.COMMENT_OPEN:  # reads char for opening comment
                tmpRes=self.readString(self.F.stringTmp,i+2,cost.COMMENT_CLOSE)
                if tmpRes==-1:
                    strMsg='ERROR: No closing comment character found.' 
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    i=tmpRes[1] 
                    continue
            
            
            elif char+nextChar in cost.COMMENT_CLOSE:  # reads char for closing comment
                strMsg='ERROR: No closing comment character found' 
                self.E.errorToFile(self.F,strMsg,i) 
                
            elif char==cost.SINGLE_QUOT:   # reads char opening string single quotes
                tmpRes=self.readString(self.F.stringTmp,i+1,[cost.SINGLE_QUOT]) 
                if tmpRes==-1:
                    strMsg='ERROR: No closing string character found' 
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    self.listWords.append(['q',tmpRes[0],i])
                    i=tmpRes[1]
                    continue

            elif char==cost.DOUBLE_QUOT:   # reads char closing string double quotes
                tmpRes=self.readString(self.F.stringTmp,i+1,[cost.DOUBLE_QUOT]) 
                if tmpRes==-1:
                    strMsg='ERROR: No closing string character found' 
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    self.listWords.append(['q',tmpRes[0],i])
                    i=tmpRes[1]
                    continue
            
            elif char in cost.PUNCT:  #rads punctation char
                self.listWords.append([char,'',i])  
                i+=1                
                continue
            

            # if we haven't found one of the chars previously handled, 
            # we build the word using the characters
            else:
                word+=char
                if nextChar in cost.IGNORE+cost.PUNCT+[cost.DOUBLE_QUOT]+[cost.SINGLE_QUOT]:

                    type=self.classific(word)
                    # handling comment
                    if type =='comment': #new addition 25/4/03 build
                        tmpRes=self.readStringIgnoreQuot(self.F.stringTmp,i+1,'.') 
                        if tmpRes==-1:
                            strMsg='ERROR: No closing comment character found' 
                            self.E.errorToFile(self.F,strMsg,i) 
                        else:
                            i=tmpRes[1]
                    # end handling comment
                                                                     

		    elif type in ['and','or','imply','not','order','add','sub','times','divide']:
                        self.listWords.append([type,'',(i+1-len(word))])

		    elif type in ['less','great','eq','neq']:
                        out_t = self.predicateMath(type)
                        self.listWords.append([out_t,'',(i+1-len(word))])
                        
                    elif type == 'v':
                        self.listWords.append(['v',word,(i+1-len(word))])
                    elif type == 'from':
                        i=self.theFrom(i)
                    elif type == 'E':
                        strMsg='ERROR: Invalid word.'
                        self.E.errorToFile(self.F,strMsg,i) 
                    elif type == cost.REPRESENTS[0]:
                        i=self.macro(i)
                    elif type == 'include':
                        i=self.theInclude(i)
                    word=''
                i+=1

        if len(openPar)!=0: #handling opening brackets
            strMsg='ERROR: No corresponding close bracket found'
            index=openPar.pop()
            self.E.errorToFile(self.F,strMsg,index) #handle also the origin file



    # classifies the words and gives back a string among:
    # ('v','imply','and','or','not','order','from',cost.REPRESENTS,'J','E')
    # word = word to classify
    def classific(self,word):
        if word.isupper() and word.isalpha(): # modified in the 24/4/02 build
            return 'v'
        elif word.islower():
            if word in cost.COMMENT:
                return 'comment'
            elif word in cost.IMPLY:
                return 'imply'
            elif word in cost.AND:
                return 'and'
            elif word in cost.OR:
                return 'or'
            elif word in cost.NOT:
                return 'not'
            elif word in cost.ORDER:
                return 'order'
            elif word in cost.FROM:
                return 'from'
            elif word in cost.REPRESENTS:
                return cost.REPRESENTS[0]
            elif word in cost.INCLUDE:
                return 'include'
            elif word in cost.ADD:
                return 'add'
            elif word in cost.SUB:
                return 'sub'            
            elif word in cost.TIMES:
                return 'times'
            elif word in cost.DIVIDE:
                return 'divide'
            elif word in cost.LESS:
                return 'less'
            elif word in cost.GREAT:
                return 'great'
            elif word in cost.EQUAL:
                return 'eq'
            elif word in cost.NEQUAL:
                return 'neq'
            else:
                return 'J'  #junk= word to discard
        else:
            return 'E' # word composed by upper and lower case chars


    # substitutes to the keyword of the math predicate
    # the corresponding URI defined in the math metalog namespace
    def predicateMath(self, type):
        if type=='neq':
#            return  cost.URI_NEQ
            return(type)
        elif type=='less':
            return(type)
#            return  cost.URI_LESS
        elif type=='great':
            return(type)
#            return  cost.URI_GREAT
        elif type=='eq':
            if self.listWords[-1][0]=='less':# and self.listWords[-1][1]==cost.URI_LESS:
                self.listWords.pop(-1)
                return('leq')
#                return  cost.URI_LEQ
            elif self.listWords[-1][0]=='great':# and self.listWords[-1][1]==cost.URI_GREAT:
                self.listWords.pop(-1)                
                return('geq')
#                return  cost.URI_GEQ
            else:
                return('eq')
#                return  cost.URI_EQ
           


    # takes an input string
    # starting from the initial position given in input
    # returns the substring delimited from such position
    # to one of the first chars present in the delimiters list,
    # also returns the position of the input string
    # after such delimiter chars.
    # If no such delimiters are found, returns -1.
    # The output is of the form [stringOut,newPosix]
    # stringIn = input string
    # startPosix = initial position
    # listEndStr = list of the delimiter chars
    def readString(self,stringIn,startPosix,listEndStr):
        for endStr in listEndStr:
            endPosix=stringIn.find(endStr,startPosix)
            if endPosix!=-1:
                stringOut= stringIn[startPosix : endPosix] 
                newPosix= endPosix + len(endStr) # I dropped out -1
                return[stringOut,newPosix]
        return -1  

 # added in built 24/4/02 h 21.28
    # TO COMMENT WELL
    # We have to create a suitable procedure that handles macros and comments
    # so such a procedure looks for the terminating char and returns the string
    # but if such terminating char (that is, the dot) is contained inside the
    # quotes, we do not consider it as terminating char.

    def readStringIgnoreQuot(self,stringIn,startPosix,endChar):
        stringOut=''
        i=startPosix-1
        while i<len(stringIn)-1:    
            i+=1
            char=stringIn[i]
            if char==endChar:
                return[stringOut,i+1]
            elif char==cost.DOUBLE_QUOT:
                tmpRes=self.readString(self.F.stringTmp,i+1,[cost.DOUBLE_QUOT])
                if tmpRes==-1:
                    strMsg='ERROR: No closing string character found' 
                    self.E.errorToFile(self.F,strMsg,i) 
                else:
                    stringOut+='"'+tmpRes[0]+'"'
                    i=tmpRes[1]-1
                    continue
            stringOut+=char
        return -1



    # takes an input string
    # starting from the initial position given in input
    # returns the substring delimited by such a position
    # until the delimiter string
    # also returns the position of the input string
    # after such delimiter string.
    # If no such delimiter is found, returns -1.
    # Allows the presence within the string
    # of delimiter chars only if preceeded by the Escape
    # character (defined in the cost module)
    # The output is of the form [stringOut,newPosix]
    # stringIn = input string
    # startPosix = initial position
    # listEndStr = list of the delimiter chars

    
    def readStringEsc(self,stringIn,startPosix,endStr):
        endPosix=stringIn.find(endStr,startPosix)
        while stringIn[endPosix-1:endPosix+1] == cost.ESCAPE[0]:  
            endPosix=stringIn.find(endStr,endPosix+1)
        if endPosix!=-1:
            stringOut= stringIn[startPosix : endPosix] 
            newPosix= endPosix + len(endStr) 
            stringOut=stringOut.replace(cost.ESCAPE[0],cost.ESCAPE[1]) 
            return[stringOut,newPosix]
        return -1  



    # macro handling
    # adjourns the macro list
    # substitutes in the tmp file the macro definition
    # with white spaces
    # this in order to maintain the consistency as far as
    # the number of rows is concerned
    # with respect to the input file for the subsequent
    # error handling, and then substitutes the variables
    # with their value in the macro.
    # Also returns the position from which the analysis of the
    # code can be continued.
    # posix= position where the keyword is

    def macro(self, posix):
        if len(self.listWords)==0:
            strMsg='ERROR: The first valid word cannot be "'+cost.REPRESENTS[0]+'"'
            self.E.errorToFile(self.F,strMsg,posix) 
        elemLeft=self.listWords.pop()
        if elemLeft[0]=='v':
            tmpRes=self.readStringIgnoreQuot(self.F.stringTmp,posix+1,'.') 
            if tmpRes!=-1:
                strRight=tmpRes[0]
                posixEndMacro=tmpRes[1]
                lenMacro=posixEndMacro-posix+1
                self.F.stringTmp=self.F.stringTmp[:elemLeft[2]]+' '*(lenMacro+4)+self.F.stringTmp[posixEndMacro:] 
                self.listMacro.append([elemLeft[1],strRight])
                self.listWords=[] 
                self.subMacro()     
                return -1 # starting position
            else:
                strMsg='ERROR: No end of macro has been found after the '+cost.REPRESENTS[0]
                self.E.errorToFile(self.F,strMsg,posix) 
        else:
            strMsg='ERROR: Missing variable at the left of "'+cost.REPRESENTS[0]+'"' #ERROR HANDLING
            self.E.errorToFile(self.F,strMsg,posix) #handles the origin file too


      
        
    # substitutes the variables in the tmp file
    # with the corresponding definition in the macro list
    def subMacro(self):
        for m in self.listMacro:
            for charBefore in [' ','.',',','\n','?']:
                for charAfter in [' ','.',',','\n','?']:
                    self.F.stringTmp=self.F.stringTmp.replace(charBefore+m[0]+charAfter,\
                                                              charBefore+m[1]+charAfter)                    
        self.F.writeToFileTmp(self.F.stringTmp)  # writes in the tmp file



    # handles the construction of the extended URIs (URI-references)
    # using the keyword "from"
    # found in the method strip-off
    # returns the position from which the analysis of the code can go on
        # posix = posizione where the keyword "from" has been found
    def theFrom(self,posix):
        startPosix=posix
        if len(self.listWords)==0:
            strMsg='ERROR: The first valid word cannot be "from"' 
            self.E.errorToFile(self.F,strMsg,posix) 
            return -1 
        elemLeft=self.listWords.pop()
        if elemLeft[0]=='q':
            strLeft=elemLeft[1]
            originPosix=elemLeft[2]
            startPosix=self.F.stringTmp.find('"',posix,len(self.F.stringTmp))  
            if startPosix ==-1:
                strMsg='ERROR: A quoted URI must appear at the right of "from"'
                self.E.errorToFile(self.F,strMsg,posix) 
                return -1
            tmpRes=self.readString(self.F.stringTmp,startPosix+1,['"']) 
            if tmpRes!=-1:
                strRight=tmpRes[0]
                endPosix=tmpRes[1]
                if len(strLeft)!=0:
                    URI= strRight+ '#' + strLeft
                else:
                    URI= strRight
                self.listWords.append(['u',URI,originPosix])
                return endPosix -1  
            else:
                strMsg='ERROR: Missing closing quotes for the string at the right of "from"'
                self.E.errorToFile(self.F,strMsg,startPosix) 
                return -1
        else:
            strMsg='ERROR: A string must appear at the left of "from"' 
            self.E.errorToFile(self.F,strMsg,startPosix) 
            return -1                

            
    #Allows to insert a file
    def theInclude(self,posix):
        posixIni=posix- (len(cost.INCLUDE[0])-1)

        tmpRes=self.readStringIgnoreQuot(self.F.stringTmp,posix+1,'.') 
        if tmpRes==-1:
            strMsg='ERROR: No end of include has been found after the "include"'
            self.E.errorToFile(self.F,strMsg,posix) 
        
        startPosix=self.F.stringTmp.find('"',posix,len(self.F.stringTmp))  
        if startPosix ==-1:
            strMsg='ERROR: A quoted URL must appear at the right of "include"'
            self.E.errorToFile(self.F,strMsg,posix) 
            return -1
        tmpRes=self.readString(self.F.stringTmp,startPosix+1,['"']) # I should hae the URI between quotes

        if tmpRes!=-1:            
            URI=tmpRes[0]
            if len(URI)==0:
                strMsg='ERROR: A quoted URL must appear at the right of "include"'
                self.E.errorToFile(self.F,strMsg,posix) 
            endPosix=tmpRes[1]

        stringFromURI=self.F.retrieve(URI)   # gets back the file from the WWW
        if stringFromURI==-1:
                strMsg='ERROR: URL not found'
                self.E.errorToFile(self.F,strMsg,posix)             
        
        self.replaceString(stringFromURI,posixIni, endPosix+1)
	posixRestart=posixIni-1
        return posixRestart # restart the file reading

    # substitutes in the tmp file the stringIn string
    # from the index startPosix till endPosix
    def replaceString(self,stringIn,startPosix, endPosix):
        self.F.stringTmp= self.F.stringTmp[:startPosix]+ stringIn+ \
                                    self.F.stringTmp[endPosix:]

       
        self.F.writeToFileTmp(self.F.stringTmp)  # writes in the tmp file
                       
        
        
      
