# METALOG PROJECT (http://www.w3.org/RDF/Metalog)

# Module that handles the creation of the RDF/XML code

import string #used for the atoif function

if 'cost' in dir(): 
    reload(cost)
else: import cost

if 'indentation_a01' in dir(): #OOP
    reload(indentation_a01)
else: import indentation_a01



class RdfXml:

    def __init__(self,F,E):
        self.F=F #do not remove
        self.E=E #do not remove
        self.indentation=indentation_a01.Indent(cost.INDENT) #used to indent the code

        self.treeIn=None # The input tree (containing representation of the code)
        self.codeRDFXML='' # The out code

        self.nameSpace={} # dictionary with namespace in the form (ns:prefix)
        self.idNS=0       # namespace prefix
        self.numID=0      # used as identifier of the "inline" resource for the containers in the subject

      



    def createRDFXML(self, treeCode):
        self.treeIn=self.upgradeTree(treeCode) #adjourns the input tree
        self.tagRdf()  #function creating the code by adjourning self.codeRDFXML
        return  self.codeRDFXML  




    #creates the outermost tag
    def tagRdf(self):
        self.addLineCode(cost.PRE_XML,0,ret='no')#insert in the line the XML header
        self.addLineCode('<rdf:RDF')  #opening tag
        self.addLineCode('xmlns:rdf="'+cost.RDF_NS+'"',offset=1)
      #  self.addLineCode('xmlns:ml  = "'+ cost.METALOG_NS+'"',offset=1)
      #  self.addLineCode('xmlns:nml = "'+ cost.METALOG_NOT_NS+'"',offset=1)
        for uriNs in self.nameSpace.keys():
            prefix=self.nameSpace[uriNs]
            self.addLineCode('xmlns:'+ prefix+ '="' + uriNs+'#"',offset=1)
        self.addLineCode(' >',ret='no')

        for subTree in self.treeIn:
            self.addLineCode()
            self.indent(2)
            self.recCodeRdf(subTree) #recursive call
            self.indent(-2)
        self.addLineCode()
        self.addLineCode('</rdf:RDF>') #closing tag

    # recursive call to the code
    # used to distinguish the kind of operation to do
    def recCodeRdf(self,tree): 
        if tree[0]=='stat':
            return self.codeStat(tree)        
        elif tree[0]=='bag':
            return self.codeCont('bag',tree)
        elif tree[0]=='alt':
            return self.codeCont('alt',tree)  
        elif tree[0]=='seq':
            return self.codeCont('seq',tree)
        else:
            return self.oneValue(tree)


    # adds code for a statement and a description
    # inside the RDF/XML code
    def codeStat(self,stat):
        stat.pop(0) # take out the label 'stat'
        if stat[0][0] in ['bag','alt','seq']:  #statement with containers in the subject
            self.codeStatwithSubjCont(stat)  #recursive
        else:  #I have a statement without containers in the subject
            subj=stat[0][1]
            pred=stat[1][1]
            obj=stat[2]
            self.addLineCode('<rdf:Description rdf:about="'+subj+'">') 
            self.indent(1)
            self.addLineCode('<'+pred+'>')
            self.indent(2)
            self.recCodeRdf(obj)   #recursive call in the object
            self.indent(-2)
            self.addLineCode('</'+pred+'>')
            self.indent(-1)
            self.addLineCode('</rdf:Description>')

    def oneValue(self,elem):
        if elem[0]=='q': # it is a string
            self.addLineCode(elem[1])
        elif elem[0]=='u': # it is a URI
             self.addLineCode('<rdf:Description rdf:about="'+elem[1]+'" />')  #abbreviated syntax



    #code for the RDF containers as
    #object in the statement
    def codeCont(self,op,tree):
        tree.pop(0) # takes out the container label
        if op=='bag':
            tagOpen='<rdf:Bag>'
            tagClose='</rdf:Bag>'
        elif op=='seq':
            tagOpen='<rdf:Seq>'
            tagClose='</rdf:Seq>'
        elif op=='alt':
            tagOpen='<rdf:Alt>'
            tagClose='</rdf:Alt>'
        else:
            tagOpen=tagClose='ERR'            
        self.addLineCode(tagOpen)
        for elem in tree:
            self.indent(2)
            self.addLineCode('<rdf:li>')
            self.indent(1)
            self.recCodeRdf(elem) #recursive call
            self.indent(-1)
            self.addLineCode('</rdf:li>')
            self.indent(-2)
        self.addLineCode(tagClose)   



    def newID(self,name):
        self.numID+=1
        return 'metalog_'+name +'_'+ str(self.numID)     


    #handles containers in the subject

    def codeStatwithSubjCont(self,tree): 
        ID=self.newID(tree[0][0])
        if tree[0][0]=='bag':
            tagOpen='<rdf:Bag'
            tagClose='</rdf:Bag>'
        elif tree[0][0]=='seq':
            tagOpen='<rdf:Seq'
            tagClose='</rdf:Seq>'
        elif tree[0][0]=='alt':
            tagOpen='<rdf:Alt'
            tagClose='</rdf:Alt>'
        elif tree[0][0]=='var':   #addition for variables, still TO HANDLE
            tagOpen='<ml:Var'
            tagClose='</ml:Var>'
        else:
            tagOpen=tagClose='ERR'

        cont=tree.pop(0)  
        cont.pop(0) # takes out the label of the container
        self.addLineCode(tagOpen+' ID="'+ID+'">')
        for elem in cont:
            self.indent(2) 
            self.addLineCode('<rdf:li>')
            self.indent(1)
            codeElem=self.recCodeRdf(elem) #recursive call
            self.indent(-1)
            self.addLineCode('</rdf:li>')
            self.indent(-2)
        self.addLineCode(tagClose)
   
        self.addLineCode()
        self.addLineCode('<rdf:Description rdf:about="#'+ID+'">')
        pred=tree[0][1]
        obj=tree[1]
        self.indent(1)
        self.addLineCode('<'+pred+'>')
        self.indent(2)
        self.recCodeRdf(obj)   #recursive call on the object
        self.indent(-2)
        self.addLineCode('</'+pred+'>')
        self.indent(-1)
        self.addLineCode('</rdf:Description>')        

    def addLineCode(self,string='',offset=0,ret='yes'):
        self.codeRDFXML+=self.indentation.string(string,offset,ret)

    def indent(self,num):
        if num>0:
            self.indentation.incr(num)
        if num<0:
            self.indentation.decr(-num)


    # function that given an input tree (in the usual form)
    # returns as output a readjusted tree 
    # by adjourning the system namespaces
    # if there are metalog extensions returns an error
    def NEWupgradeTree(self,treeIn):
	newTree=[]
	treeIn.pop(0) #removes the root of the discourse
        for stat in treeIn:
	    if stat[0]!= 'stat':
		strMsg='ERROR: The Metalog extensions cannot be translate in RDF/XML'
                self.E.errorToFile(self.F,strMsg,-1)

	    subj= stat[1] #handles bag or maybe not
	    obj=stat[3] #handles bag or maybe not
	    uriNs=self.toNameSpace(stat[2]) 
	    pred=['u',uriNs]
	    newTree.append(['stat',subj,pred,obj])

        newTWOTree=self.collapseObj(newTree)        

        return newTWOTree


    def NEWcollapseObj(self, treeIn):
        self.treeOut=[]
        while len(treeIn)!=0:
            stat=treeIn[0]
            #stat=treeIn.pop(0)
            newObj=self.recCollapseObj(treeIn,stat)
            self.treeOut.append(['stat',stat[1],stat[2],newObj])
        print 'OuT colllapse:'
        print self.treeOut
        return slef.treeOut

    def NEWrecCollapseObj(self,treeIn,statIn):
        objIn=statIn[3]
        i=-1
        while i<len(treeIn)-1:
            i+=1
            if objIn==treeIn[i][1]:
                statObj=treeIn.pop(i-1)
                return(['stat',statObj[1],statObj[2], self.recCollapseObj(treeIn,statObj)])
        return objIn


    def upgradeTree(self,treeIn):
	newTree=[]
	treeIn.pop(0) #removes the root of the discourse
        for stat in treeIn:
	    if stat[0]!= 'stat':
		strMsg='ERROR: The Metalog extensions cannot be translated in RDF/XML'
                self.E.errorToFile(self.F,strMsg,-1)

	    subj= stat[1] #handle bag or mabe not
	    obj=stat[3] #handle bag or mabe not
	    uriNs=self.toNameSpace(stat[2]) 
	    pred=['u',uriNs]
	    newTree.append(['stat',subj,pred,obj])
        return newTree



    # function that given as input a predicate returns back 
    # the string to use in the tag of the RDF/XML code
    # and adjourns the namespace dictionary
    def toNameSpace(self,predIn):
	if predIn[0]=='u':
	    uri=predIn[1]
	    uri_e_fram=uri.split('#')
	    if len(uri_e_fram)!=2:
		return  predIn[1] #returns the predicate as it was
	    ns=self.addNameSpace(uri_e_fram[0])
	    return ns+':'+ uri_e_fram[1]
	else:
	    return predIn[1] #returns the predicate as it was

    # adds the new namespace (if necessary)
    # and returns the prefix
    def addNameSpace(self,uriNs):
	if uriNs in self.nameSpace.keys(): #namespace already present
	    return self.nameSpace[uriNs]
	else: #we have to create a new namespace prefix
	    prefix=self.newNameSpace()
	    self.nameSpace[uriNs]=prefix
	return prefix

    #crates an id for the new namespace
    def newNameSpace(self):
        self.idNS+=1
        return 'ns'+str(self.idNS)







            
