# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module that generates the list of the queries          #
#********************************************************#


# Import misc constants
from definitions import *

# Import procedures
from procedure import *


#********************************************************#
# Class that creates the queries listing                 #
#********************************************************#
class QueriesClass:

  "Class that create Table with queries "

  
  #********************************************************************************************
  # Initialization of internal data structures
  #********************************************************************************************
  def __init__(self):
    self.data = []

  #********************************************************************************************
  # Procedure that creates the assertions starting from a "tree" graph by applying the conversion rules
  #********************************************************************************************
  def create_queries(self, tree, explode):
    tmp = []

#    Forcing explode to 2 the containers are not exploded
#    explode = '2'

    # CONTAINER IN SUBJECT
    if tree[0] in CONTAINER:
      # CONTAINER IN SUBJECT AND OBJECT
      if tree[3] in CONTAINER:
        if explode == '1':
          list_ok1 = buid_list_cont(tree[0],tree[1])
          list_ok2 = buid_list_cont(tree[3],tree[4])
        else:
          list_ok1 = buid_list_cont1(tree[0],tree[1])
          list_ok2 = buid_list_cont1(tree[3],tree[4])          
        u1 = 0
        tmp1 = []
        str_tmp = ''
        while u1 < len(list_ok1):
          u2 = 0
          while u2<len(list_ok2):          
            temp = (tree[2]+"("+str(list_ok1[u1])+","+str(list_ok2[u2])+")")
            if u1 == len(list_ok1)-1 and u2 == len(list_ok2)-1:
              str_tmp = str_tmp + temp
            else:              
              str_tmp = str_tmp + temp + ","
            u2 = u2+1
          u1 = u1+1
        tmp1 = [str_tmp]

        self.data = (tmp1, tree[0], tree[3])

      # CONTAINER IN SUBJET AND MATH OP IN OBJECT
      elif riconosci_op(tree[3]) in MATH:
        if explode == '1':
          list_ok = buid_list_cont(tree[0], tree[1])
        else:
          list_ok = buid_list_cont1(tree[0], tree[1])
        stringa = op_math(riconosci_op(tree[3]), tree[4],0)
        if stringa != -1:
          l = 0
          tmp2 = []
          str_tmp = ''
          while l < len(list_ok):
            temp = (tree[2]+"('"+str(list_ok[l])+"',A):-(A is ("+stringa+"))")
            if l == len(list_ok)-1:          
              str_tmp = str_tmp + temp
            else:
              str_tmp = str_tmp + temp + ','
            l=l+1
          
          tmp2 = [str_tmp]
          self.data = (tmp2, "assertions")
        else:
          self.data = [-1]

      # CONTAINER ONLY IN SUBJECT
      else:
        if explode == '1':
          list_ok = buid_list_cont(tree[0], tree[1])
        else:
          list_ok = buid_list_cont1(tree[0], tree[1])

        str_tmp = ''
        u = 0
        while u < len(list_ok):
          obj = check_var(tree[3])
          obj = check_num(obj)
          temp = (tree[2]+"("+str(list_ok[u])+","+obj+")")
          if u == len(list_ok)-1:          
            str_tmp = str_tmp + temp
          else:
            str_tmp = str_tmp + temp + ','
          
          u = u+1
          
        tmp1 = [str_tmp]
        self.data = (tmp1, tree[0])
    
    # LOGICAL OPERATORS
    elif tree[0] in LOGIC:

      # "AND" LOGICAL OP
      if tree[0] == "and":
  
        max = len(tree)-1
        r=0
        out=[]
        out1 = ''
        while r < max-1:

          sub_assertions = QueriesClass()
          sub_assertions.create_queries(tree[r+1], explode)
          out_assertions = sub_assertions.data
          del sub_assertions

          if out_assertions==[-1]:
            print("Information loss, fact/clause not analyzable.")
            self.data = [-2]
          else:
            if type(out_assertions) == TYPETUPLE:
              out_assertions = out_assertions[0]
#            out = out+out_assertions
            out1 = out1 + out_assertions[0] + ','
          r=r+1
          
        sub_assertions = QueriesClass()
        sub_assertions.create_queries(tree[r+1], explode)
        out_assertions = sub_assertions.data
        del sub_assertions

        if out_assertions==[-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-2]
        else:
          if type(out_assertions) == TYPETUPLE:
            out_assertions = out_assertions[0]
#           out = out+out_assertions
          out1 = out1 + out_assertions[0] 
          
        self.data = ([out1], "and")
    
      # "OR" LOGICAL OP
      if tree[0] == "or":
 
        max = len(tree)-1
        r = 0
        out = []
        out1 = ''
        while r < max-1:

          sub_assertions = QueriesClass()
          sub_assertions.create_queries(tree[r+1], explode)
          out_assertions = sub_assertions.data
          del sub_assertions

          if out_assertions == [-1]:
            print("Information loss, fact/clause not analyzable.")
            self.data = [-3]
          else:
            if type(out_assertions) == TYPETUPLE:
              out_assertions = out_assertions[0]
#            out = out+out_assertions
            out1 = out1 + out_assertions[0] + ';'
          r = r+1

        sub_assertions = QueriesClass()
        sub_assertions.create_queries(tree[r+1], explode)
        out_assertions = sub_assertions.data
        del sub_assertions

        if out_assertions == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-3]
        else:
          if type(out_assertions) == TYPETUPLE:
            out_assertions = out_assertions[0]
#            out = out+out_assertions
          out1 = out1 + out_assertions[0]

        self.data = ([out1], "or")

      # "NOT" LOGICAL OP
      if tree[0] == "not":
        sub_assertions = QueriesClass()
        sub_assertions.create_queries(tree[1], explode)
        list_not = sub_assertions.data
        del sub_assertions

        if list_not == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-4]
        else:
          tmp_list_not = []
          u = 0
          while u < len(list_not)-1:
            if list_not[u][0] == [-1]:
              print("Information loss, fact/clause not analyzable.")
              self.data = [-5]
            tmp_list_not.append("not("+list_not[u][0]+")")
            u = u+1
          self.data = (tmp_list_not, "not")
  
      # Don't care, my logical systems don't allow => in query
      # "IMPLY" LOGICAL OP
      if tree[0] == "implies":
        print("Information loss, fact/clause not analyzable.")
        return([-100])

        sub_assertions = QueriesClass()
        sub_assertions.create_queries(tree[1], explode)
        first_list = sub_assertions.data
        del sub_assertions

        sub_assertions = QueriesClass()
        sub_assertions.create_queries(tree[2], explode)
        second_list = sub_assertions.data
        del sub_assertions

        # Lost data in at least one of the two imply operators
        if first_list == [-1] or second_list == [-1]:
          print("Information loss, fact/clause not analyzable.")
          self.data = [-6]

        # ASSERTIONS=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in ("assertions", "not"):
          tmp = [first_list[0][0]+":-("+second_list[0][0]+")"]

        # CONTAINER=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in CONTAINER:
          u = 0
          tmp = []
          while u < len(second_list[0]):
            tmp.append(first_list[0][0]+":-("+second_list[0][u]+")")
            u = u+1

        # ASSERTIONS= > CONTAINER
        elif first_list[1] in CONTAINER and second_list[1] in ("assertions", "not"):
          u = 0
          tmp = []
          while u < len(first_list[0]):
            tmp.append(first_list[0][u]+":-("+second_list[0][0]+")")
            u = u+1

        # CONT=>CONT
        elif first_list[1] in CONTAINER and second_list[1] in CONTAINER:
          u = 0
          tmp = []
          while u < len(first_list[0]):
            j = 0
            while j < len(second_list[0]):
              tmp.append(first_list[0][u]+":-("+second_list[0][j]+")")
              j = j+1
            u = u+1

        # (ASSERTIONS or ASSERTIONS)=> ASSERTIONS 
        elif first_list[1] in ("assertions", "not") and second_list[1] == "or":
          u = 0
          tmp = []
          while u < len(second_list[0]) - 1:
            tmp.append(first_list[0][0]+":-("+second_list[0][u]+")")
            u = u+1 
          tmp = [tmp1]
 
        # ASSERTIONS => (ASSERTIONS and ASSERTIONS)  
        elif first_list[1] == "and" and second_list[1] in ("assertions", "not"):
          u = 0
          tmp = []
          while u < len(first_list[0]) -1:
            tmp.append(first_list[0][u]+":-("+second_list[0][0]+")")
            u = u+1
            
 
        # (ASSERTIONS or ASSERTIONS) => CONTAINER
        elif first_list[1] in CONTAINER and second_list[1] == "or":
          u = 0
          tmp = []
          while u < len(second_list[0]):
            y = 0
            while y < len(first_list[0]):
              tmp.append(first_list[0][y]+":-("+second_list[0][u]+")") 
              y = y+1
            u = u+1

        # CONTAINER => (ASSERTIONS and ASSERTIONS)   
        elif first_list[1] == "and" and second_list[1] in CONTAINER:
          u = 0
          tmp = []
          while u < len(first_list[0]):
            y = 0
            while y < len(second_list[0]):
              tmp.append(first_list[0][u]+":-("+second_list[0][y]+")")
              y = y+1
            u = u+1
 
        # PRED CONFR=>ASSERTIONS
        elif first_list[1] in ("assertions", "not") and second_list[1] in PRED_CONFR:
          tmp = [first_list[0][0]+":-("+second_list[0][0]+")"]

        # INFORMATION LOSS
        else:
          print("Information loss")
          self.data = [-7]

        # Save data
        self.data = (tmp, "implies")


    # COMPARISON PREDICATES
    elif tree[0] in PRED_CONFR:
      if tree[0] == "eq":
        confr = "=:="
      elif tree[0] == "neq":
        confr = "=\="
      elif tree[0] == "less":
        confr = "<"
      elif tree[0] == "great":
        confr = ">"
      elif tree[0] == "leq":
        confr = "=<"
      elif tree[0] == "geq":
        confr = "=>"
      
      num1 = tree[1][0]
      num2 = tree[1][1]
      self.data = [num1[1:len(num1)-1]+confr+num2[1:len(num2)-1]], tree[0]

    # MATH OPS
    elif riconosci_op(tree[2]) in MATH:
      stringa = op_math(riconosci_op(tree[2]), tree[3], 0)
      if stringa != -1:
        sub = check_var(tree[0])
        sub = check_num(sub)
        temp = (tree[1]+"("+sub+",A):-(A is ("+stringa+"))")
        tmp.append(temp)
        self.data = (tmp, "assertions")

      else:
        self.data = [-8]

    # CONTAINER ONLY IN OBJECT
    elif tree[2] in CONTAINER:
      if explode == '1':
        list_ok = buid_list_cont(tree[2], tree[3])
      else:
        list_ok = buid_list_cont1(tree[2], tree[3])
      u = 0
      str_tmp = ''
      while u < len(list_ok):
        sub = check_var(tree[0])
        sub = check_num(sub)
        temp = (tree[1]+"("+sub+","+str(list_ok[u])+")")
        if u == len(list_ok)-1:          
          str_tmp = str_tmp + temp
        else:
          str_tmp = str_tmp + temp + ','
        u = u+1
      tmp = [str_tmp]
      self.data = (tmp, tree[2])    

    # SIMPLE ASSERTION
    else:
      sub = check_var(tree[0])
      obj = check_var(tree[2])
      sub = check_num(sub)
      obj = check_num(obj)
      temp = (tree[1]+"("+sub+","+obj+")")
      tmp.append(temp)
      self.data = (tmp, "assertions")


  
#********************************************************************************************
# Auxiliary procedures needed by the QueriesClass class
#********************************************************************************************
# Procedure the checks if the subject or the object are numbers. If so, returns the number without quotes.
#********************************************************************************************
def check_num(stringa):
  if len(stringa) > 4:
    tmp = stringa[2:len(stringa)-2]    
    for char in tmp:
      if not(char in NUMERI):
        return(stringa)
    return(tmp)
  else:
    return(stringa)
  

#********************************************************************************************
# Procedure returning all the possible permutations of the input string
#********************************************************************************************
def permut(lista):
  if len(lista)==2:
    return([(lista[0],lista[1]),(lista[1],lista[0])])
  else:
    l=0
    tmp=[]

    while l<len(lista):  
      u=0
      ric=permut(lista[0:l]+lista[l+1:len(lista)])
      
      while(u<len(ric)):
        tmp.append(ric[u]+tuple([lista[l]]))
        u=u+1
      l=l+1
    return(tmp)

  
#********************************************************************************************
# Procedure that builds the element list for a container
#********************************************************************************************
def buid_list_cont(treea,treeb):
  if treea=="bag":    # Permutation of all the elements
    list_ok=permut(treeb)
    y=0
    list_ok2=[]
    while y<len(list_ok):
      bb=list_ok[y]
      p=1
      list_ok1=[]
      if bb[0][0]=="var":
        tmp=bb[0][1]
        list_ok1s="["+str(tmp)
      else:
        list_ok1s="['"+str(bb[0])+"'"
      while p<len(bb):
        if bb[p][0]=="var":
          tmp=bb[p][1]
          list_ok1s=list_ok1s+", "+str(tmp)
        else:
          list_ok1s=list_ok1s+", '"+str(bb[p])+"'"
        p=p+1
      list_ok2.append(list_ok1s+"]")
      y=y+1
    list_ok=list_ok2
    
  elif treea=="seq":  # Simple sequence of all the elements
    if treeb[0][0]=="var":
      tmp=treeb[0][1]
      list_tmp="["+str(tmp)
    else:
      list_tmp="['"+str(treeb[0])+"'"
    y=1
    while y<len(treeb):
      if treeb[y][0]=="var":
        tmp=treeb[y][1]
        list_tmp=list_tmp+", "+str(tmp)
      else:
        list_tmp=list_tmp+", '"+str(treeb[y])+"'"
      y=y+1

    list_ok=[list_tmp+"]"]

    
  elif treea=="alt":  # ALTernative of the elements
    y=0
    list_tmp=[]
    while y<len(treeb):
      if treeb[y][0]=="var":
        tmp=treeb[y][1]
        list_tmp.append(str(tmp))
      else:
        list_tmp.append(str(treeb[y]))
      y=y+1

    list_ok=list_tmp

  return(list_ok)


#********************************************************************************************
# Procedure that builds the element list of a container
#********************************************************************************************
def buid_list_cont1(treea, treeb):
  if treeb[0][0]=="var":
    tmp=treeb[0][1]
    list_tmp="["+str(tmp)
  else:
    list_tmp="['"+str(treeb[0])+"'"
  y=1
  while y<len(treeb):
    if treeb[y][0]=="var":
      tmp=treeb[y][1]
      list_tmp=list_tmp+", "+str(tmp)
    else:
      list_tmp=list_tmp+", '"+str(treeb[y])+"'"
    y=y+1

  list_ok=[list_tmp+"]"]
  return(list_ok)


#********************************************************************************************
# Procedure that bulds a list starting from a math op
#********************************************************************************************
def op_math(type,lista,i):
  if type=="add":
    op="+"
  elif type=="divide":
    op="/"      
  elif type=="sub":
    op="-"            
  elif type=="times":
    op="*"
  else:
    return(-1)
  if (riconosci_op(lista[0][0]) in MATH):
    stringa1=op_math(riconosci_op(lista[0][0]),lista[0][1],i+1)
  else:
    stringa1=lista[0][1:len(lista[0])-1]
  if (riconosci_op(lista[1][0]) in MATH):
    stringa2=op_math(riconosci_op(lista[1][0]),lista[1][1],i+1)
  else:
    stringa2=lista[1][1:len(lista[1])-1]
 
  stri="("+stringa1+op+stringa2+")"
  return(stri)


#********************************************************************************************
# Procedure that creates a list by starting with a tuple of a string
#********************************************************************************************
def create_list(element):
  if type(element)==TYPELIST:
    return(element)
  elif type(element)==TYPESTRING:
    return([element])
  elif type(element)==TYPETUPLE:
    i=0
    tmp=[]
    while i<len(element):
      tmp.append(element[i])
      i=i+1
  else:
    print("Error in data")
    return([])


#********************************************************************************************
# Procedure that checks whether or not the element of an assertion is a Variable; in the affirmative case, gets rid of the quotes
#********************************************************************************************
def check_var(stringa):
  if stringa[0]=="var":
    return(stringa[1])
  else:
    return("'"+stringa+"'")
  
