# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Module containing misc auxiliary procedures
#********************************************************#

import Tkinter

# Import libraries of the OS
import os,os.path

# Import library containing logic and math operators
import operator

# Import constants
from  definitions      import *


# Import cost module
if 'cost' in dir():  
    reload(cost)
else: import cost

#********************************************************************************************
# Procedure that opens a text file, analyzes it and stores in 'data' the data (in N-triple format) contained therein
# Input:  name  = name of the file to open
#********************************************************************************************
def open_data(name):

  aggiusta_n(name)
  f=open(NAMETMP,'r')

  cont=0
  data=[]
  data_line=f.readline()
  while data_line <> '':

    tripla=0
    assertions=""
    if len(data_line)>0 and data_line <> '' and data_line[0] in ("<","_",'"'):
      while tripla<3:
        char= data_line[0]
        if char in ("<","_",'"'):
          data_line_next=f.readline()
          if data_line_next!='':
            data_line_ins=data_line[0:len(data_line)-1]
          else:
            data_line_ins=data_line[0:len(data_line)]
          tripla=tripla+1
          assertions=assertions+data_line_ins
          data_line=data_line_next
        else:
          data_line=f.readline()
      if assertions[len(assertions)-1:len(assertions)]=="\n":
        assertions=assertions[0:len(assertions)-1] 
      char=assertions[0]
      if tripla==3 and assertions[len(assertions)-1:len(assertions)]==".":

        k=0
        i=1
        list_elem=["","",""]
        tf=1
        for k in range(3):
          if char=="<":
            a1 = search(assertions,i,'>')
            i=i+len(a1)+1
          elif char=='"':
            a0 = search(assertions,i,'"')
            a1 = '"' + a0 + '"'
            i=i+len(a0)+1
          elif char=='_':
            a1 = search(assertions,i,'_')
            i=i+len(a1)-1
            tf=0
          else:
            print "Sintax error: the data are not in correct form"
            tf=0
            a1=""
            break
          list_elem[k]=a1
          char=assertions[i]
          k=k+1
          i=i+1
#        if tf==1:
#          list_elem[0]="1"

        data=data+[list_elem]
        
        cont=cont+1
      else:
        return(-1)
    else:
      data_line=f.readline()

  f.close()

  return(data,cont)


#********************************************************************************************
# Procedure that orders the input triples
#********************************************************************************************
def order(data):
    
  i = 0
  data_temp = []
  while i < len(data):
    if typeelement(data[i][0]) == "an":
      data_temp = inserisci(data_temp, data[i])
    else:
      data_temp.append(data[i])
    i = i + 1    

  return(data_temp)


#********************************************************************************************
# Transforms a string made up by characters only in a number string
#********************************************************************************************
def str2num(stringa):

  i = len(stringa)-1
  decine = 1
  totale = 0
  while i > -1 :
    num = ord(stringa[i])-48
    totale = totale + num * decine
    decine = decine * 10
    i = i - 1
  return(totale)


#********************************************************************************************
# Transform a one-figure number in the corresponding string
#********************************************************************************************
def mappanum(intero):
  return(chr(intero+48))


#********************************************************************************************
# Transforms a number in the corresponding string
#********************************************************************************************
def num2str(num):

  num_tmp = num
  i = 1
  tmp = ''
  while num_tmp >= 10 :
    tmp = mappanum(operator.mod(num_tmp, 10)) + tmp
    num_tmp = num_tmp / 10
    i = i + 1

  tmp = mappanum(operator.mod(num_tmp, 10)) + tmp
  return tmp


#********************************************************************************************
# Procedure that opens a text file, analyzes it and stores in 'data' the data (in N-triple format)
#********************************************************************************************
def aggiusta_n(name):
  f=open(name,'r')
  f1=open(NAMETMP,'w')
  data_line=f.readline()
  while data_line!='':
    
    if data_line[0]=="#":
      data_line=f.readline()
    elif data_line=="\n":      
      data_line=f.readline()
    elif data_line[0]==" ":
      data_line=data_line[1:len(data_line)]
      
    elif data_line[0]=="<":
      po=find_char(data_line,">")
      if po+1==len(data_line):
        f1.write(data_line)
        data_line=f.readline()
      elif data_line[po+1]==".":
        f1.write(data_line[0:po+2]+"\n")
        if len(data_line)==po+1:
          data_line=f.readline()
        else:
          data_line=data_line[po+2:len(data_line)]
      else:
        f1.write(data_line[0:po+1]+"\n")        
        data_line=data_line[po+1:len(data_line)]
        
    elif data_line[0]=="_":
      po=find_char(data_line,"_")
      if po+2==len(data_line):
        f1.write(data_line)
        data_line=f.readline()
      elif data_line[po+1]==".":
        f1.write(data_line[0:po+2]+"\n")
        if len(data_line)==po+1:
          data_line=f.readline()
        else:
          data_line=data_line[po+2:len(data_line)]
      else:
        f1.write(data_line[0:po+1]+"\n")        
        data_line=data_line[po+1:len(data_line)]
        
    elif data_line[0]=='"':

      po=find_char(data_line,'"')
      
      if po+1==len(data_line):
        f1.write(data_line)
        data_line=f.readline()
      elif data_line[po+1]==".":
        f1.write(data_line[0:po+2]+"\n")
        if len(data_line)==po+1:
          data_line=f.readline()
        else:
          data_line=data_line[po+2:len(data_line)]
      else:
        f1.write(data_line[0:po+1]+"\n")        
        data_line=data_line[po+1:len(data_line)]

        
    else:
      data_line=f.readline()
  
  f.close()
  f1.close()


#********************************************************************************************
# Procedure that finds the char in the string
#********************************************************************************************
def find_char_norm(data,carattere):
  i=0
  while i<len(data):
    if data[i]==carattere:
      return(i)
    i=i+1
  return(-1)

#********************************************************************************************
# Procedure that finds the chars in the string
#********************************************************************************************
def find_chars_norm(data,lista):
  i=0
  while i<len(data):
    if data[i] in lista:
      return(i)
    i=i+1
  return(-1)



#********************************************************************************************
# Procedure that finds the char in the string or finds the position "anonymous node"
#********************************************************************************************
def find_char(data,carattere):

  if carattere == ">":
    i=1
    while i<len(data):
      if data[i]==carattere:
        return(i)
      i=i+1
  elif carattere == '"':
    i=1
    while i<len(data):
      if i>1:
        if data[i]==carattere and data[i-1] != '\\':
          return(i)
      if i>2:
        if data[i]==carattere and data[i-1] == '\\' and data[i-2] == '\\':
          return(i)
      i=i+1
  else:   # carattere = "_"
    if data[1:4]==":an":
      l=4
      while 1:
        if not(data[l] in("0","1","2","3","4","5","6","7","8","9")):
          return(l-1)
        l=l+1


#********************************************************************************************
# Function to read the saved data with N-triple syntax
# Output: list [3 x N] where N are the assertions saved on the file and 3 are the components of each assertion
# The components are in this order: Subject, Predicate, Object
#********************************************************************************************
def search(data,i,car):
  j=i+2
  if car=="_":
    while not(data[j] in ('<','"','.')):
      j=j+1
      if data[j] in ("\n","\t"):
        return 0
    return data[i-1:j]

  elif car == '"':
    j=j-1
    while data[j] != car and data[j-1] != '\\':
      j=j+1
      if data[j]=='\\':
        j=j+2
      if data[j] in ("\n","\t"):
        return 0
    return data[i:j]

  else:
    j=j-1
    while data[j]<>car:
      j=j+1
      if data[j]=='\\':
        j=j+2
      if data[j] in ("\n","\t"):
        return 0
    return data[i:j]
      


#********************************************************************************************
# Function that returns the type of the element in the string Subject predicate object; the element type can be
# a literal (kinda text string), a real text (es. 'Mary from http://www.w3.org/Staff')
# or a symbol _:anX where the  X is a number, representing an anonymous node
#********************************************************************************************
def typeelement(test):
  if (test[0]=="_"):
    return("an")
  elif (test[0]=='"'):
    return("l")
  else:
    return("x")


#********************************************************************************************
# Procedure that inserts string in list at position num
#********************************************************************************************
def inserisci(dat, dato):
  i=0
  temp=[]
  num = str2num(dato[0][4:len(dato[0])])      
  while i < len(dat):
    if typeelement(dat[i][0])=="an":
      string = dat[i][0]
      num1 = str2num(string[4:len(string)])      
      if num1>num:
        return(dat[0:i-1]+[dato]+dat[i-1:len(dat)])
    
    i=i+1
  return(dat+[dato])


#********************************************************************************************
# Function that recognizes the operator (and, or, etc...)
#********************************************************************************************
def riconosci_op(stringa):
  if stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#type":
    return("type")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt":
    return("alt")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag":
    return("bag")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq":
    return("seq")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement":
    return("sta")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#subject":
    return("sub")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate":
    return("pre")
  elif stringa=="http://www.w3.org/1999/02/22-rdf-syntax-ns#object":
    return("obj")
  elif stringa=="http://www.w3.org/RDF/Metalog#operator":
    return("op")
  elif stringa=="http://www.w3.org/RDF/Metalog#name":
    return("var")
  elif stringa=="http://www.w3.org/RDF/Metalog#And":
    return("and")
  elif stringa=="http://www.w3.org/RDF/Metalog#Or":
    return("or")
  elif stringa=="http://www.w3.org/RDF/Metalog#Implies":
    return("implies")
  elif stringa=="http://www.w3.org/RDF/Metalog/not/NAF#Not":
    return("not")
  elif stringa[0:44]=="http://www.w3.org/1999/02/22-rdf-syntax-ns#_":
    return "op"+stringa[len(stringa)-1]
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#operator":
    return("mathop")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#add":
    return("add")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#divide":
    return("divide")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#sub":
    return("sub")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#times":
    return("times")  
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#eq":
    return("eq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#neq":
    return("neq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#great":
    return("great")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#geq":
    return("geq")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#less":
    return("less")
  elif stringa=="http://www.w3.org/RDF/Metalog/Math#leq":
    return("leq")
  elif stringa[0]=='"' and stringa[len(stringa)-1]=='"':
    return("literal")
  else:
    return(stringa)


#********************************************************************************************
# Checks if a string denotes an element of a subject/object
#********************************************************************************************
def riconoscila(stringa):
  if len(stringa) > 44:
    if stringa[0:44] == "http://www.w3.org/1999/02/22-rdf-syntax-ns#_":
      return(1)
    else:
      return(0)
  else:
    return(0)


#####################################################################
# Settles the nt file by putting triples on single lines
#####################################################################
def modify_nt_format(name, NT_FORMAT):
  
  if NT_FORMAT == '1':
    dati = open_data(name)
    dati = dati[0]

    ann = 0
    annotation = "http://www.w3.org/RDF/Metalog#annotation"
    ns = "http://www.w3.org/RDF/Metalog#ns"
    if dati != -1:
      f = open(name, 'w')
      f.write('# N-Triples generated by Metalog\n\n')

      for el in dati:
       
        if ann == 0:
          if el[1] == annotation or el[1] == ns:
            f.write('\n\n# Annotation N-triples generated by Metalog\n\n')
            ann = 1  

        myfirst = adj(el[0])
        mysecond = adj(el[1])
        mythird = adj(el[2])

        f.write(myfirst+' '+mysecond+' '+mythird+'.\n')
       
      f.close()
    

#####################################################################
# Settles element of a triple to be save in an NT file
#####################################################################
def adj(stringa):
  if stringa[0]=='_':
    return(stringa)
  elif stringa[0] == '"':
    return stringa
  else:
    return '<'+stringa+'>'



#********************************************************************************************
# Recursive procedure to copy a list
#********************************************************************************************
def copylist(list):
  if type(list)==TYPESTRING:
    return(list)
  else:
    tmp=[]
    for elem in list:
      new = copylist(elem)
      tmp = tmp + [elem]
    return(tmp)  
    

#********************************************************************************************
# Transforms a table series that represent assertions into a single table
#********************************************************************************************
def flat(table):
  tmp = []
  for element in table:
    for tmp_el in element[0]:
      tmp.append(tmp_el)
  return(tmp)


#********************************************************************************************
# Analysis of a string containing a variable
#********************************************************************************************
def cerca_varand(stringa):
  tmp = stringa
  i = 0
  num = ''
  while i < len(tmp) and (tmp[i] in MAIUSCOLE or tmp[i] == '_'):
    num = num + tmp[i]
    i = i + 1
  if i == 0:
    return(-1)
  tmp = tmp[i:len(tmp)]
  if tmp[0] == ' ':
    tmp = tmp[1:len(tmp)]
  return(num, tmp)


#********************************************************************************************
# Analysis configuration file of Metalog. Returns a sequence of values:
# [ANSWERS, SYSTEM_POLOG, EXPLODE_ASSERTIONS, EXPLODE_QUERY, MACRO, MLNT, CALCULATE_CONT, DELETE_TMP,
# DELETE_RESULT, DELETE_DEDUCED]
#
# ANSWERES:         Number of answers for a query     (1 = "one answer per query", 2 = "more answers per query")
# SYSTEM_PROLOG:    Logical system to use             (1 = "SWI-Prolog", 2 = "Pylog")
# EXPLODE_ASS:      Containers in assertions          (1 = "Explode containers", 2 = "Bag and Alt made as simple Seq's")
# EXPLODE_QUE:      Containers in queries             (1 = "Explode containers", 2 = "Bag and Alt made as simple Seq's")
# MACRO:            Macros support                    (1 = "Use macros obtained from assertions/queries" 2= "Do not use macros"
# CALCULATE_CONT:   Rebuild Bag and Alt (1 = "Rebuild Bag and Alt" 2= "Do not rebuild"
# DELETE_TMP:       Delete temp files
# DELETE_INPUT_NT:  Delete nt input files files nt di input (computed or copied)
# DELETE_RESULT:    Delete result files (nt and ml)
# DELETE_DEDUCED:   Delete deduced files (nt and ml)
# VIDEO_MESSAGE:    Visualize messages in Python windows
# NT_FORMAT:        Format of NT file.
#********************************************************************************************
def read_choose():
  try:
    numvar = 12
    
    str_tmp = ''
    op1 = open(CONFIG_FILE)
    data = []
    data_line = 'myfirst'
    while data_line <> '':
      data_line = op1.readline()
      str_tmp = str_tmp + data_line
      if data_line != '\n' and data_line !='\r':
        data.append(data_line)
    op1.close()
    
    data1 = []
    for el in data:
      el1 = ""
      for car in el:
        if car != ' ' and car != '\t' and car != '\r':
          el1 = el1 + car
      if len(el1)>1:
        if el1[0] != '#':
          if el1[len(el1)-1]=='\n' or el1[len(el1)-1]=='\r':
            el1 = el1[0:len(el1)-1]
          data1.append(el1)
    lista = []

    for el in data1: 
      [var, tmp] = cerca_varand(el)
      tmp = tmp[1:len(tmp)]
      num = ''
      for car in tmp:
        if car in NUMERI:
            num = num + car
        else:
            num = '-1'
            break

      if not(num in ('1', '2')):
        print("  Error during reading configurations file: Value of variables are not correct.\n  You must re-configure file: "+CONFIG_FILE)
        return([-1, str_tmp])
      else:
        lista.append([var, num])

    if len(lista) != numvar:     
      print("  Error during reading configurations file: number of variables are not correct.\n  You must re-configure file: "+CONFIG_FILE)
      return([-2, str_tmp])
    else:
      tmp = []
      for i in range(numvar):
        tmp.append('-1')
      for i in range(numvar):
        if lista[i][0] == 'ANSWERS':
          tmp[0] = lista[i][1]
        elif lista[i][0] == 'SYSTEM_PROLOG':
          tmp[1] = lista[i][1]
        elif lista[i][0] == 'EXPLODE_ASSERTIONS':
          tmp[2] = lista[i][1]
        elif lista[i][0] == 'EXPLODE_QUERY':
          tmp[3] = lista[i][1]
        elif lista[i][0] == 'MACRO':
          tmp[4] = lista[i][1]
        elif lista[i][0] == 'CALCULATE_CONT':
          tmp[5] = lista[i][1]
        elif lista[i][0] == 'DELETE_TMP':
          tmp[6] = lista[i][1]
        elif lista[i][0] == 'DELETE_INPUT_NT':
          tmp[7] = lista[i][1]
        elif lista[i][0] == 'DELETE_RESULT':
          tmp[8] = lista[i][1]
        elif lista[i][0] == 'DELETE_DEDUCED':
          tmp[9] = lista[i][1]
        elif lista[i][0] == 'VIDEO_MESSAGE':
          tmp[10] = lista[i][1]
        elif lista[i][0] == 'NT_FORMAT':
          tmp[11] = lista[i][1]
        else:
          print("  Error during reading configurations file: name of variables are not correct.\n  You must re-configure file:"+CONFIG_FILE)
          return([-3, str_tmp])
        
      if tmp[0] == '1':            
        print('\n\n Warning: the settings in this session only allow one asnwer for each query. In case of multiple answers just the first answer will be computed.\n')
        print(' To change the settings, edit (manually or via menu) the file : ' + CONFIG_FILE)
      if tmp[1] == '2':
        print('\n\n Warning: the settings in this session do not allow usage of SWI_Prolog. The inference power could be limited..\n')
        print(' To change the settings, edit (manually or via menu) the file : ' + CONFIG_FILE)
      if tmp[2] == '2':
        print('\n\n Warning: the settings in this session do not explode the BAG and ALT container; in this configuration, some inferences could be lost.\n')
        print(' To change the settings, edit (manually or via menu) the file : ' + CONFIG_FILE)
      if tmp[3] == '2':
        print('\n\n  Warning: the settings in this session do not explode the BAG and ALT containers in the queries; in this configuration, queries with such containers could give unsound results.\n')
        print(' To change the settings, edit (manually or via menu) the file : ' + CONFIG_FILE)
      if tmp[4] == '2':
        print('\n\n Warning: the settings in this session do not rebuild macros (present in the input assertions and queries) in the final results .\n')
        print(' To modify the configuration you can also manually edit the file: ' + CONFIG_FILE)
      if tmp[5] == '2':
        print('\n\n Warning: the settings in this session read the input data in N-triple format. The default setting allows reading ML files and translating them into NT format.\n')
        print(' To change the settings, edit (manually or via menu) the file : ' + CONFIG_FILE)
 
      # Return the computed values
      return([tmp, str_tmp])
  except:
    print("  Error when reading configuration file;\n  You must re-configure file:"+CONFIG_FILE)
    return([-4, ''])


#********************************************************************************************
# Read configuration variabile 'variable'
# number: ok
# -1: value of variabile not correct
# -2: variabile not found
# -3 error when reading
#********************************************************************************************
def read_config(variable):
  try:
    numvar = 100
    
    op1 = open(CONFIG_FILE)
    data = []
    data_line = 'myfirst'
    while data_line <> '':
      data_line = op1.readline()
      if data_line != '\n' and data_line !='\r':
        data.append(data_line)
    op1.close()
    
    data1 = []
    for el in data:
      el1 = ""
      for car in el:
        if car != ' ' and car != '\t' and car != '\r':
          el1 = el1 + car
      if len(el1)>1:
        if el1[0] != '#':
          if el1[len(el1)-1]=='\n' or el1[len(el1)-1]=='\r':
            el1 = el1[0:len(el1)-1]
          data1.append(el1)
    lista = []

    for el in data1: 
      [var, tmp] = cerca_varand(el)
      tmp = tmp[1:len(tmp)]
      num = ''
      for car in tmp:
        if car in NUMERI:
            num = num + car
        else:
            num = '-1'
            break

      lista.append([var, num])

    for el in lista:
      if el[0] == variable:
        return(el[1])
    # If no variable is found then returns -2
    return(-2)
  
  except:
    print("  Error when reading configuration file;\n  You must re-configure file:"+CONFIG_FILE)
    return(-3) # errore during file reading


#********************************************************************************************
# Read configuration variabile 'variable'
# number: ok
# -1: value of variabile not correct
# -2: variabile not found
# -3 error when reading
#********************************************************************************************
def change_config(variable, val, present):
  try:
    
    stringatoins =variable+' = '+val+'\n'
    
    op1 = open(CONFIG_FILE)
    datat = []
    data_line = 'myfirst'
    while data_line <> '':
      data_line = op1.readline()
      datat.append(data_line)
    op1.close()

    data = copylist(datat)

    if present:  # If variable is present in the file
    
      data1 = []
      i = 0
      for el in data:
        el1 = ""
        for car in el:
          if car != ' ' and car != '\t' and car != '\r':
            el1 = el1 + car
        if len(el1)>1:
          if el1[0] != '#':
            if el1[len(el1)-1]=='\n' or el1[len(el1)-1]=='\r':
              el1 = el1[0:len(el1)-1]
            data1.append([el1, i])
        i = i + 1
    
      lista = []

      i = 0
      for el in data1:
        stringa1 = el[0]
        if (len(stringa1)>len(variable)):
          if stringa1[0:len(variable)] == variable:
            nline = i    
            break
        i = i + 1
    
      data[data1[nline][1]] = stringatoins
      
    else: # If variable not present, add it to the tail
      stringatoins  = '\n\n'+stringatoins+'\n\n'
      data.append(stringatoins)
    op1 = open(CONFIG_FILE, 'w')
    for el in data:
      n = op1.write(el)
    op1.close()
  
  except:
    print("  Error during writing configurations file;\n  You must re-configure file:"+CONFIG_FILE)
    return(-1) # error when reading file


#********************************************************************************************
# Reading enter from user
#********************************************************************************************
def pressenter():
  x = "-1"
  try:
    x = str(raw_input("\n  Press enter to continue: "))
  except ValueError:
    print "Keyboard error. Please choose again:"


#********************************************************************************************
# Checks if a number is present. If so, returns a number between double quotes
#********************************************************************************************
def numero(sub):
  for char in sub:
    if not(char in NUMERI):
      return(sub)
  return('"'+sub+'"')


#********************************************************************************************
# Procedure that turns a string in upper case
#********************************************************************************************
def maiusc(stringa):
  out=''
  for car in stringa:
    if car == 'a':
      out = out + 'A'
    elif car == 'b':
      out = out + 'B'
    elif car == 'c':
      out = out + 'C'
    elif car == 'd':
      out = out + 'D'
    elif car == 'e':
      out = out + 'E'
    elif car == 'f':
      out = out + 'F'
    elif car == 'g':
      out = out + 'G'
    elif car == 'h':
      out = out + 'H'
    elif car == 'i':
      out = out + 'I'
    elif car == 'j':
      out = out + 'J'
    elif car == 'k':
      out = out + 'K'
    elif car == 'l':
      out = out + 'L'
    elif car == 'm':
      out = out + 'M'
    elif car == 'n':
      out = out + 'N'
    elif car == 'o':
      out = out + 'O'
    elif car == 'p':
      out = out + 'P'
    elif car == 'q':
      out = out + 'Q'
    elif car == 'r':
      out = out + 'R'
    elif car == 's':
      out = out + 'S'
    elif car == 't':
      out = out + 'T'
    elif car == 'u':
      out = out + 'U'
    elif car == 'v':
      out = out + 'V'
    elif car == 'w':
      out = out + 'W'
    elif car == 'x':
      out = out + 'X'
    elif car == 'y':
      out = out + 'Y'
    elif car == 'z':
      out = out + 'Z'
    else:
      out = out + car    
  return(out)


#********************************************************************************************
# Verify that a string has all upper case symbols
#********************************************************************************************
def mai(stringa):
  for character in stringa:
    if not(character in MAIUSCOLE):
      return(0)
  return(1)


#********************************************************************************************
# Appends the computed annotations in the N-triple file without annotations
#********************************************************************************************
def mergeNtripleAnnotation(nameNt, nameAnnNt):
  dat_Nt = open_data(nameNt)
  max = 0
  for el in dat_Nt[0]:
    if typeelement(el[0])=='an':
      anoni = el[0][4:len(el[0])]
      if str2num(anoni)>max:
        max = str2num(anoni)

  f1 = open(nameAnnNt,'r')
  f2 = open(nameNt,'a')
  writed = f2.write('\n\n')
  data_line = f1.readline()
  while data_line <> '':
    if len(data_line)>4:
      num = data_line[0:len(data_line)-1]
      if typeelement(num)=='an':
        data_line1='_:an'+num2str(max+str2num(num[4:len(num)]))+'\n'
      else:
        data_line1 = data_line  
    else:
      data_line1 = data_line  
    writed = f2.write(data_line1)
    data_line = f1.readline()

  f1.close()
  f2.close()


#********************************************************************************************
# Computes the names to use in the various modules
#********************************************************************************************
def cal_name(name):

  (n0,n1)=os.path.split(name)
  (name_tmp,_) = os.path.splitext(n1)
  name_file_que = os.path.normpath(os.path.join(n0,name_tmp+'_QRY.nt'))

  return(name_tmp, name_file_que)


#********************************************************************************************
# Checks presence of support temp file
#********************************************************************************************<
def checkfiletmp():
  f = open(TMP_ASSERTION,'w')
  f.write('comment: tmp assertion file.\n\n')
  f.write('MARY '+cost.REPRESENTS[0]+' "Mary" from "http://www.example.org/staff/".\n')
  f.write('IS '+cost.REPRESENTS[0]+' "is" from "http://www.actions.example.com/".\n')
  f.write('RICH '+cost.REPRESENTS[0]+' "rich" from "http://www.term.examples.com/".\n')
  f.write('MARY IS RICH.\n')
  f.close()


#---------------------------------------------------------------------------

def opj(path):
    """Convert paths to the platform-specific separator"""
    return apply(os.path.join, tuple(path.split('/')))

#---------------------------------------------------------------------------
# Begin of WxPython-dependant part

try:
    from   wxPython.wx import *
    from   wxPython.html import wxHtmlWindow
    import images


    class MySplashS(wxSplashScreen):
        def __init__(self, IMG, mm):
            img = wxImage(opj(IMG)).ConvertToBitmap()
            wxSplashScreen.__init__(self, img,
                                wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT,
                                mm, None, -1,
                                style = wxSIMPLE_BORDER|wxFRAME_NO_TASKBAR|wxSTAY_ON_TOP)
#            EVT_CLOSE(self, self.OnClose)

    class displayBegin(wxApp):
        def OnInit(self):
            """
            Create and show the splash screen.  It will then create and show
            the main frame when it is time to do so.
            """

            IMG = os.path.normpath(os.path.join(DIR_WORK,'images/splash.jpg'))
            wxInitAllImageHandlers()
            splash = MySplashS(IMG, 4000)
            splash.Show()
            return true

    class displayAbout(wxApp):
        def OnInit(self):
            """
            Create and show the splash screen.  It will then create and show
            the main frame when it is time to do so.
            """
            IMG = os.path.normpath(os.path.join(DIR_WORK,'images/about.jpg'))
            wxInitAllImageHandlers()
            splash = MySplashS(IMG, 18000)
            splash.Show()


            return true
except:
    print "** Start-up error: wxPython not installed"
    print "** wxPython is not strictly necessary, so, bypassing..."

# End of WxPython-dependant part
#---------------------------------------------------------------------------




# Calc firstCar of string
def firstrcar(stringa):
    for el in stringa:
        if not(el in (' ', '\t', '\n', '\r')):
            return(el)
    return(' ')

# verify if string is comment
def verify_com(lista, a):
    index = a
    testo = ''
    for el in lista[index:len(lista)]:
      testo=testo+el

    ind=0
    for el in testo:
        if not(el in(' ', '\t', '\r')):
            break
        else:
            ind=ind+1
            
    testo=testo[ind:len(testo)]
    if testo[0:7]=='comment':
        nline=0
        virgolette=0
        apici=0
        prec = '\n'
        for el in testo:
            if el =='\n':
                nline = nline+1
            elif el=='"' and virgolette==1 :
                virgolette=0
            elif el=='"' and virgolette==0 and apici==0:
                virgolette=1
            elif el=="'" and apici==1 :
                apici=0
            elif el=="'" and apici==0 and virgolette==0:
                apici=1
            elif el=='.' and apici==0 and virgolette==0:
                return(1, a+nline+1)
        return(0,a)
    else:              
        return(0,a)

# verify if string is macro
def verify_mac(lista, a):
    index = a
    testo = ''
    for el in lista[index:len(lista)]:
      testo=testo+el

    ind=0
    acapo=0
    for el in testo:
        if not(el in(' ', '\t', '\r')):
            break
        elif el=='\n':
            cacapo=acapo+1
            ind=ind+1
        else:
            ind=ind+1
            
    sp = find_chars_norm(testo,[' ','\t','\n','\r'])
    
    if sp!=-1:
        if testo[sp]=='\n':
            acapo=acapo+1
            
        stringa=testo[0:sp]
        if mai(stringa):  
            testo=testo[sp+1:len(testo)]       
            if testo[0:len(cost.REPRESENTS[0])]==cost.REPRESENTS[0]:
                nline=0
                virgolette=0
                apici=0
                prec = '\n'
                for el in testo:
                    if el =='\n':
                        acapo = acapo+1
                    elif el=='"' and virgolette==1 :
                        virgolette=0
                    elif el=='"' and virgolette==0 and apici==0:
                        virgolette=1
                    elif el=="'" and apici==1 :
                        apici=0
                    elif el=="'" and apici==0 and virgolette==0:
                        apici=1
                    elif el=='.' and apici==0 and virgolette==0:
                        return(1, a+acapo+1)
            return(0,a)
        
        else:
            return(0,a)            
    else:              
        return(0,a)
    
