# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Main module of the METALOG PROJECT (not graphic)
#********************************************************#

import os
import sys
import time
    
# Import Metalog Class
from  bare_metalog import MetalogClass

# Import definitions and constants
from definitions       import *

# Import misc procedures
from  procedure         import *

#********************************************************#
# Class Metalog Deduced
#********************************************************#
class MetalogDeducedClass:

  "Metalog Deduced Class"
  
  #********************************************************************************************
  # Initialize the internal data structur
  #********************************************************************************************
  def __init__(self):
    self.result_que             = []    
    self.result_assertions      = []
    self.deduced                = []
    self.macro_ok               = []

  #********************************************************************************************
  # Procedure Main program
  #********************************************************************************************<
  def mainprogram(self, fileNameIn, fileType):

    try:

      # Reads from configuration file the system settings
      [configurations, str_tmp]= read_choose()

      DELETE_DEDUCED = configurations[9]
      VIDEO_MESSAGE = configurations[10]
      if VIDEO_MESSAGE == '1':
        varprint = 1
      elif VIDEO_MESSAGE == '2':
        varprint = 0

      # Starts the metalog class
      class_metalog = MetalogClass()
      out = class_metalog.mainprogram(fileNameIn, fileType)
      data_macro = class_metalog.data_macro
      result_assertions = class_metalog.result_assertions
      result_que = class_metalog.result_que
      table = class_metalog.result
      MACRO_OK = class_metalog.macro_ok
      del class_metalog

      if out == 1:
        o = 0
        if fileType == 'ml':
          deduced_pre = result_assertions[0]
          deduced_stri = result_assertions[1]
        else:
          deduced_pre = []
          deduced_stri = []
    
        # Cycle analyzing the answers to the queries
        while o < len(table):
    
          result_que_merged = merge_result_que(result_que[o])

          # Merge the results with the assertions (result_assertions has been generated in Macro2Ntriple)
          deduced_pre = merge(deduced_pre, result_que_merged[0])
          deduced_stri = merge(deduced_stri, result_que_merged[1])

          o = o + 1

        # If the macro reading has been ok (Note: only with the assertions data we can create the deduced files!)
        if MACRO_OK == 1:

          # Computation of the name of the files to save on disk
          local_time = time.localtime()
          string = time.asctime(local_time)
          str1 = string[8:10] + string[4:7] + string[22:24] + "-" + string[11:13] + string[14:16] + string[17:19] + "_" + str(o)

          deduced = [deduced_pre, deduced_stri]
          savededuced(deduced, str1, varprint)
      
          self.result_assertions = result_assertions
          self.result_que = result_que
          self.deduced = deduced
          self.macro_ok = MACRO_OK

        # Correct termination
        return(1)
        
      else:
        return(out)
    except:
      print "Error during computation of Deduced Data.\n\n"
      return(-1)


#********************************************************************************************
# Perform the merge of tables between assertions and queries
#********************************************************************************************
def merge(tableassertions, tableque):
  
  tmp = []
  for el in tableassertions:
    if not(el in tmp):
      tmp.append(el)

  for el in tableque:
    if not(el in tmp):
      tmp.append(el)
        
  return(tmp)


#********************************************************************************************
# Performs the merge between answer tables and a single query (note: each query can have more answers)
#********************************************************************************************
def merge_result_que(que):
  pre = que[0]
  stri = que[1]
  tmp_pre = []
  tmp_stri = []

  i = 0
  while i < len(pre):
    for el in pre[i]:
      if not(el in tmp_pre):
        tmp_pre.append(el)
    for el in stri[i]:
      if not(stri[i][0] in tmp_stri):
        tmp_stri.append(stri[i][0])
    i = i + 1
  return([tmp_pre, tmp_stri])


#********************************************************************************************
# Adjust the assertion table to make it compatible with the queries one
#********************************************************************************************
def aggiusta_table_assertions(table):
  tmp = []
  for el in table:
    tmp = tmp + [[1, [el]]]
  return(tmp)


