# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
#                                                        #
# Metalog Project                                        #
# Graphics Module                                        #
#                                                        #
#********************************************************#
# This module generates the graphics interface of the    #
# Project                                                #
#********************************************************#

# Import of standard libraries
import Tkinter; Tk=Tkinter
import tkFileDialog
import SimpleDialog
import tkMessageBox
import tkColorChooser
import tkFont
import os
import os.path
import shutil
import time
import sys
import string


# Import the Metalog Class
from  bare_metalog   import MetalogClass

# Import the MetalogDeduced Class
from  metalogdeduced import MetalogDeducedClass

# Import the scrolled Box library
from scrolledWindow import *

# Import the traslator from ML to NT format (with annotations)
from  translatorAnn import TranslatorAnnClass

# Import definitions and constants
from definitions import *

# Import auxiliary procedures
from  procedure import *


# Import cost module of editor
if 'cost' in dir():  
    reload(cost)
else: import cost

INPUT_FILE_TYPES = [('Metalog File','.ml'),('N-Triple File','.nt'),('XML File','.xml'),('All Files','.*')]

INPUT_FILE_NT = [('N-Triple File','.nt'),('All Files','.*')]
INPUT_FILE_ML = [('Metalog File','.ml'),('All Files','.*')]
INPUT_FILE_XML = [('XML File','.xml'),('All Files','.*')]


# The graphical editor class
class editMetalog:

    def __init__(self, M, input_file):
        self.fileNameIn=input_file
        self.fileName=''
        self.fileType=None
        self.userFileDir=DIALOGUES_FOLDER
        self.isSaved=0
        self.isModif=0
        self.rootWinOut=None
        self.fileIn=None
	self.M=M
        self.CreateWidgets()

    def CreateWidgets(self):

        self.rootWin=Tkinter.Tk()
        self.rootWin.title("Metalog Project v2.0b")
        self.mainFrame=Tkinter.Frame(self.rootWin)
        self.createMenu()
        self.createTextBox()
        self.keyBinding()
        self.createFrameDebug()
        self.mainFrame.pack(fill=Tkinter.BOTH,expand=Tkinter.YES)

        if self.fileNameIn!=None:             
          try:
            [newText, lista] = self.read_file(self.fileNameIn)
            self.rootWin.title('Metalog v2.0b : '+self.fileNameIn)
            self.isModif=0
            self.isSaved=1
            if self.fileNameIn[len(self.fileNameIn)-2:len(self.fileNameIn)] == 'ml':
              self.fileType='ml'
            elif self.fileNameIn[len(self.fileNameIn)-2:len(self.fileNameIn)] == 'nt':
              self.fileType='nt'
            else:
              self.fileType='??'
          except IOError:
            msg='Impossible to open file'
            tkMessageBox.showerror (msg)
            return        

          self.closeWinOut()
          self.clearText()               
          self.textBox.insert(Tkinter.END,newText)

          if self.fileType == 'nt':
                    
              # Color nt text insered on screen
              self.nt_color(lista)
                    
          elif self.fileType == 'ml':
              # Color nt text insered on screen
              self.ml_color(lista)

          if not(os.access(fileName,os.W_OK)):
              stringa="Warning: you opened a Read-Only file.          \nPlease save it on disk before reasoning or computing N-triples.   " 
              tkMessageBox.showinfo(title='Read Only File',message=stringa)
              
              #Seve new file on disk if file opened is Read-Only
              self.saveAs()
              
          
        else:
          self.closeWinOut()
          self.clearText()               
          self.textBox.insert(Tkinter.END,'')                 

    def start(self):
        self.rootWin.mainloop()


    # Graphics interface of menu
    def createMenu(self):

        self.flagSaveNT=Tkinter.IntVar()
        self.flagSaveNTQ=Tkinter.IntVar()
        self.flagSaveRDFXML=Tkinter.IntVar()

        menuFrame=Tkinter.Frame(self.rootWin)
        menuFrame.pack(side=Tkinter.TOP,fill=Tkinter.X)

        #Menu File
        fileMenuButton=Tkinter.Menubutton(menuFrame,text='File',underline=0)
        fileMenu=Tkinter.Menu(fileMenuButton,tearoff=0)
        fileMenu.add_separator()
        fileMenu.add_command(label='New File',underline=0,command=self.fileNew)
        fileMenu.add_command(label='Open',underline=0,command=self.fileOpen)
        fileMenu.add_command(label='Save',underline=0,command=self.save)
        fileMenu.add_command(label='Save As...',underline=6,command=self.saveAs)
        fileMenu.add_separator
        fileMenu.add_command(label='Exit',underline=1,command=self.exit)
        fileMenu.add_separator()
#        fileMenu.add_command(label='')
        fileMenuButton['menu']=fileMenu
        fileMenuButton.pack(side=Tkinter.LEFT,anchor=Tkinter.W)

        #Menu CONFIG
        metalogMenuButton=Tkinter.Menubutton(menuFrame,text='Configuration',underline=0)
        metalogMenu=Tkinter.Menu(metalogMenuButton,tearoff=0)
        metalogMenu.add_separator()
        metalogMenu.add_command(label='Show Actual Configuration',underline=1,command=self.verifyConfiguration)

        metalogMenu.add_separator()
        metalogMenu.add_command(label='Set Answers for query',underline=0,command=self.modconfans)
        # metalogMenu.add_command(label='Set Logic System',underline=1,command=self.modconfls)
        metalogMenu.add_command(label='Set Containers in Assertions',underline=2,command=self.modconfexa)
        metalogMenu.add_command(label='Set Containers in Queries', underline=4,command=self.modconfexq)
        metalogMenu.add_command(label='Set Annotations in Output', underline=4,command=self.modconfmacro)
        metalogMenu.add_command(label='Set Erasing Temporary Files', underline=4,command=self.modconfdtmp)
        metalogMenu.add_command(label='Set Erasing NT-input File', underline=12,command=self.modconfdnti)
        metalogMenu.add_command(label='Set Erasing Result Files', underline=10,command=self.modconfdre)
        metalogMenu.add_command(label='Set Console Messages', underline=6,command=self.modconfcm)
        metalogMenu.add_command(label='Set N-triples Format', underline=8,command=self.modconfntf)

        metalogMenu.add_separator()
        metalogMenu.add_command(label='Set to Default Configuration',underline=7,command=self.defaultConfiguration)
        
        metalogMenu.add_separator()
#        metalogMenu.add_command(label='')

        metalogMenuButton['menu']=metalogMenu
        metalogMenuButton.pack(side=Tkinter.LEFT,anchor=Tkinter.W)

        #Menu METALOG
        reasonMenuButton=Tkinter.Menubutton(menuFrame,text='Reason',underline=0)
        reasonMenu=Tkinter.Menu(reasonMenuButton,tearoff=0)
        reasonMenu.add_separator()
        reasonMenu.add_command(label='Check correctness',underline=0,command=self.metalogCheck)
        reasonMenu.add_separator()
        reasonMenu.add_command(label='Think!',underline=0,command=self.metalogResult)
        reasonMenu.add_separator()
#        reasonMenu.add_command(label='')
#        metalogMenu.add_command(label='Calculate Merged Data (merge of Results)',underline=10,command=self.metalogDeduced)

        reasonMenuButton['menu']=reasonMenu
        reasonMenuButton.pack(side=Tkinter.LEFT,anchor=Tkinter.W)

        #Menu N-triple
        ntMenuButton=Tkinter.Menubutton(menuFrame,text='Translate',underline=0)
        ntMenu=Tkinter.Menu(ntMenuButton,tearoff=0)
        ntMenu.add_separator()
        ntMenu.add_command(label='Assertions to N-triples (with Annotations)',underline=14,command=self.ntwiths)
        ntMenu.add_command(label='Assertions to N-triples (without Annotations)',underline=25,command=self.ntwithouts)
        ntMenu.add_separator()
        ntMenu.add_command(label='Assertions to RDF/XML (no Metalog extensions)',underline=14,command=self.rdfxmls)
        ntMenu.add_separator()
        ntMenu.add_command(label='Queries to N-triples (with Annotations)',underline=0,command=self.ntwithq)
        ntMenu.add_command(label='Queries to N-triples (without Annotations)',underline=1,command=self.ntwithoutq)
        ntMenu.add_separator()
        ntMenu.add_command(label='Queries to RDF/XML (no Metalog extensions)',underline=2,command=self.rdfxmlq)
        ntMenu.add_separator()
#        ntMenu.add_command(label='')

        ntMenuButton['menu']=ntMenu
        ntMenuButton.pack(side=Tkinter.LEFT,anchor=Tkinter.W)

        #Creates the menu HELP
        helpMenuButton=Tkinter.Menubutton(menuFrame,text='Help',underline=0)
        helpMenu=Tkinter.Menu(helpMenuButton,tearoff=0)  
        helpMenu.add_separator()
        helpMenu.add_command(label='About...',underline=0,command=self.about)
        helpMenu.add_command(label='Quick User Guide',underline=0,command=self.userGuide)
        helpMenu.add_command(label='Metalog WWW Home Page',underline=0,command=self.homePage)
        helpMenu.add_separator()
#        helpMenu.add_command(label='')
        helpMenuButton['menu']=helpMenu
        helpMenuButton.pack(side=Tkinter.LEFT,anchor=Tkinter.W)

#        tkSimpleDialog.test()
#        tkColorChooser.
#        tkFont.

    def saveNT(self):
        return self.flagSaveNT.get() 


    # Frame of debug messages
    def createFrameDebug(self):
        debugFrame=Tkinter.Frame(self.rootWin)
        debugFrame.pack(side=Tkinter.BOTTOM,fill=Tkinter.X)
        self.textDebug=Tkinter.Label(debugFrame,anchor=Tkinter.W)
        self.textDebug['foreground']='#FF0000'
        self.textDebug.pack()


    # Main text field
    def createTextBox(self):
        self.textBox=Tkinter.Text(self.mainFrame)
        self.textBox.pack(fill=Tkinter.BOTH,expand=Tkinter.YES)
        self.textBox['font']=('Verdana',9,'normal')
        #scrollbar
        scrollY=Tkinter.Scrollbar(orient=Tkinter.VERTICAL,command=self.textBox.yview)
        scrollY.pack(side=Tkinter.RIGHT,fill=Tkinter.BOTH)#anchor=Tkinter.E)
        self.textBox["yscrollcommand"]= scrollY.set

    # Key binding
    def keyBinding(self):
        self.textBox.bind("<Key>", self.textUpdate)
        self.textBox.bind("<Control-KeyPress-s>", self.save)
        self.textBox.bind("<Control-KeyPress-S>", self.save)
        self.textBox.bind("<Control-KeyPress-n>", self.fileNew)
        self.textBox.bind("<Control-KeyPress-N>", self.fileNew)
        self.textBox.bind("<Control-KeyPress-o>", self.fileOpen)
        self.textBox.bind("<Control-KeyPress-O>", self.fileOpen)
        self.textBox.bind("<Alt-KeyPress-s>", self.saveAs)
        self.textBox.bind("<Alt-KeyPress-S>", self.saveAs)
        self.textBox.bind("<Alt-KeyPress-c>", self.metalogCheck)
        self.textBox.bind("<Alt-KeyPress-C>", self.metalogCheck)
        self.textBox.bind("<Alt-KeyPress-t>", self.metalogResult)
        self.textBox.bind("<Alt-KeyPress-T>", self.metalogResult)
        self.textBox.bind("<Alt-KeyPress-d>", self.defaultConfiguration)
        self.textBox.bind("<Alt-KeyPress-D>", self.defaultConfiguration)
        self.textBox.bind("<Alt-KeyPress-q>", self.userGuide)
        self.textBox.bind("<Alt-KeyPress-Q>", self.userGuide)
        self.textBox.bind("<Alt-KeyPress-a>", self.about)
        self.textBox.bind("<Alt-KeyPress-A>", self.about)


    def closeWinOut(self):
        print #''

    # Result of queries
    def metalogCheck(self, event=None):
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return


        if self.fileType =='ml':
            triple = self.M.createNTriple(self.fileNameIn, type='stat')
            self.M.destroyAll()

            triple = self.M.createNTriple(self.fileNameIn, type='query')
            self.M.destroyAll()

            triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
            self.M.destroyAll()

            self.remove_msgDebug()

            self.closeWinOut()
            self.clearText()

            [newText, lista] = self.read_file(self.fileNameIn)

            self.textBox.insert(Tkinter.END,newText)   

            # Color edit file
            self.ml_color(lista)          

            str_tmp = "The format of this Metalog file is correct. \nYou can Think on it, and/or translate it to N-triples. "
            tkMessageBox.showinfo('ML format is ok',str_tmp)            
            
        else:
            str_tmp = "The file is not an ML file. It's not checkable."
            tkMessageBox.showinfo('Not an ML file',str_tmp)
                          

    # Result of queries
    def metalogResult(self, event=None):
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return

        # Reading of system configuration from file
        [configuration, str_tmp] = read_choose()
        if not(configuration in (-1,-2,-3,-4)):
          DELETE_DEDUCED = configuration[9]
          VIDEO_MESSAGE = configuration[10]
          if VIDEO_MESSAGE == '1':
            varprint = 1
          elif VIDEO_MESSAGE == '2':
            varprint = 0

          if not(self.fileType in('ml','nt')):
            if self.fileType == 'cfg':
              stringa="This is the configuration file. You can't elaborate it.\n Please edit another file."
            else:
              stringa='The format of file is not correct.\n The file to work must be in "nt" or "ml" format.'
            tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)
          else:
            # Running of the Metalog class
            class_metalog = MetalogClass(self.M)
     	    out = class_metalog.mainprogram(self.fileNameIn, self.fileType)

            # out:          
            # [-1]          - error             "Error during result\n\n"
            # [-2]          - false             "It's false, there are no assertions to unify query."
            # [-3]          - false             "It's false, there are no assertions to unify query."
            # [-4]          - sintax error      "Syntax Error in assertios: probably this problem is not representable in Metalog"
      	    if out == 1:
              data_macro = class_metalog.data_macro
              result_assertions = class_metalog.result_assertions
              result_que = class_metalog.result_que
  
              if self.fileType == 'ml':
                # This table contains the query list in ml format
                table_que = class_metalog.table_que
                isml = 1
              else:
                isml = 0
              
              table = class_metalog.result
              MACRO_OK = class_metalog.macro_ok
              del class_metalog

              tmp = ''
              i = 0
              while i<len(result_que):
                
                query_i = result_que[i]
                if isml:
                  str_query = table_que[1][i]

                msg = '\ncomment:-----------------------------------------------.\n'
                msg = msg + 'comment: query '+str(i+1)+' (of '+str(len(result_que))+').\n'
                if isml:
                  msg = msg + 'comment: query: "'+str_query+' ?".\n'
              
                tmp = tmp +msg
                if query_i == [-1]:
                  tmp = tmp + '\nError in Computation of Resulting Data in query '+str(i+1)+'.\n\n'
                elif query_i == [-2] or query_i == [-3]:
                  tmp = tmp + "\nIt's false.\n\n"
                elif query_i == [-4]:
                  tmp = tmp + '\nError in Computation of Resulting Data in query '+str(i+1)+'.\n'
                  tmp = tmp + "Syntax Error in assertions, It's probably that this query is not representable in Metalog.\n\n"
                
                # ok: print result 
                else:
                  j = 0
                  while j<len(query_i[0]):
                    tmp = tmp + 'comment: Metalog result '+ str(j+1)+' (of '+str(len(query_i[0]))+').\n\n'

                    pre = query_i[0][j]
                    body = query_i[1][j]
                    for el in pre:
                      tmp = tmp + el + '.\n'
                    tmp = tmp + '\n'
                    for el in body:
                      tmp = tmp + el + '.\n'
                    tmp = tmp + '\n\n'
                    j = j+1
                  
                i = i+1

              tmp_file=os.path.normpath(os.path.join(TMP_FOLDER,'abcde.tmp'))
              file=open(tmp_file,'w')
              file.write(tmp)
              file.close()
            
              window = Tkinter.Tk()
              t = Text(window)
              t.text.configure(width=80, height=30, wrap='none')
              t.text.insert('end', tmp)

              [newText, lista] = self.read_file(tmp_file)
              t.ml_color(lista)

              os.remove(tmp_file)

              t.frame.pack(fill='both', expand='yes')

                            
              window.title('Metalog v2.0b : Resulting Data of file "'+self.fileName+'"')
              # window1.mainloop()

            elif out == -1:
              tkMessageBox.showerror('Error in configuration file','Please edit and modify it.')
            elif out == -2:
              stringa='Error, ML file is not in correct form.'
              tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)
            elif out == -3:
              stringa='Error, NT file is not in correct form\nor queries NT file is missing.'
              tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)                        
            else:
              stringa='Error in Computation of Resulting Data'
              tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)

        else:
          if configuration == -1:
            msgerr = 'Value of one or more variables is not correct.\nPlease re-configure Configuration file'
          elif configuration == -2:
            msgerr = 'Number of variables is not correct.\nPlease re-configure Configuration file'
          elif configuration == -3:
            msgerr = 'Name of one or more variables is not correct.\nPlease re-configure Configuration file'
          elif configuration == -4:
            msgerr = 'Please re-configure it'
          tkMessageBox.showerror('Error in configuration file',msgerr)

        if self.fileNameIn !=None:
  
            if self.flagSaveNT.get()==1:
                nameFileOut=self.nameFileNT(self.fileNameIn)
            else:
                nameFileOut=None


    # Merge of results (not complete)
    def metalogDeduced(self, event=None):   
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)   
            return
        
        try:
            # Reading system configuration from file
            [configuration, str_tmp] = read_choose()
            if not(configuration in (-1,-2,-3,-4)):
              DELETE_DEDUCED = configuration[9]
              VIDEO_MESSAGE = configuration[10]
              if VIDEO_MESSAGE == '1':
                varprint = 1
              elif VIDEO_MESSAGE == '2':
                varprint = 0

              # Running the metalogDeduced class
              class_metalog = MetalogDeducedClass()
              out = class_metalog.mainprogram(self.fileNameIn, self.fileType)
              
              if out == 1:
                result_assertions = class_metalog.result_assertions
                result_que = class_metalog.result_que
                deduced = class_metalog.deduced
                MACRO_OK = class_metalog.macro_ok
                del class_metalog

                tmp = 'comment:-----------------------------------------------\ncomment: ML file of merged results)\n'
                i = 0

                pre = deduced[0]
                body = deduced[1]
                for el in pre:
                  tmp = tmp + el + '.\n'
                  i = i+1
                tmp = tmp + '\n'
                for el in body:
                  tmp = tmp + el + '.\n'
                tmp = tmp + '\n\n'

                window1 = Tkinter.Tk()
                t1 = Text(window1)
                t1.text.configure(width=80, height=30, wrap='none')
                t1.text.insert('end', tmp)
                t1.frame.pack(fill='both', expand='yes')
                window1.title("Merged results of Metalog System")
                #  window1.mainloop()
                
                if self.fileType == 'nt':
                  str_tmp = 'The output is not the merge of results plus initial data\nbecause the input file is in nt-format.\nThe output in this case is only the merge of results.'
                  tkMessageBox.showinfo('Warning',str_tmp)

              elif out == -1:
                tkMessageBox.showerror('Error in configuration file','Please edit and modify it.')
              elif out == -2:
                stringa='Error, ML file is not in correct form.'
                tkMessageBox.showerror(title='Error in Computation Resulting Data', message=stringa)
              elif out == -3:
                stringa='Error, NT file is not in correct form\nor the queries NT file is missing.'
                tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)              
                              
            else:
              if configuration == -1:
                msgerr = 'Value of one or more variables is not correct.\nPlease re-configure Configuration file'
              elif configuration == -2:
                msgerr = 'Number of variables is not correct.\nPlease re-configure Configuration file'
              elif configuration == -3:
                msgerr = 'Name of one or more variables is not correct.\nPlease re-configure Configuration file'
              elif configuration == -4:
                msgerr = 'Please re-configure it'
              tkMessageBox.showerror('Error in configuration file',msgerr)

        except:
            stringa='Error in Computation of Resulting Data'
            tkMessageBox.showerror(title='Error in Computation of Resulting Data', message=stringa)

        if self.fileNameIn !=None:

            if self.flagSaveNT.get()==1:                      
                nameFileOut=self.nameFileNT(self.fileNameIn)
            else:
                nameFileOut=None

    # verify configuration
    def verifyConfiguration(self, event=None):
        [configuration, str_tmp] = read_choose()
        msgerr= ''

        if configuration == -1:
          msgerr = 'Value of one or more variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -2:
          msgerr = 'Number of variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -3:
          msgerr = 'Name of one or more variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -4:
          msgerr = 'Please re-configure it'

        if msgerr != '':
          tkMessageBox.showerror('Error in configuration file',msgerr)
        else:
          str_tmp = 'The current Metalog settings are:\n'


          if configuration[0] == '2':
            str_tmp = str_tmp + '\nAnswers for query: all'
          else:
            str_tmp = str_tmp + '\nAnswers for query: one'
          if configuration[2] == '2':
            str_tmp = str_tmp + '\nContainers: exploded in assertions: no'
          else:
            str_tmp = str_tmp + '\nContainers exploded in assertions: yes'
          if configuration[3] == '2':
            str_tmp = str_tmp + '\nContainers exploded in queries: no'
          else:
            str_tmp = str_tmp + '\nContainers exploded in queries: yes'
          if configuration[4] == '2':
            str_tmp = str_tmp + '\nSupport of annotations: no'
          else:
            str_tmp = str_tmp + '\nSupport of annotations: yes'
          if configuration[6] == '2':
            str_tmp = str_tmp + '\nDelete temporary files: no'
          else:
            str_tmp = str_tmp + '\nDelete temporary files: yes'
          if configuration[7] == '2':
            str_tmp = str_tmp + '\nDelete intermediate NT files: no'
          else:
            str_tmp = str_tmp + '\nDelete intermediate NT files: yes'
          if configuration[8] == '2':
            str_tmp = str_tmp + '\nDelete results: no'
          else:
            str_tmp = str_tmp + '\nDelete results: yes'
          if configuration[10] == '2':
            str_tmp = str_tmp + '\nLog messages in console: no'
          else:
            str_tmp = str_tmp + '\nLog messages in console: yes'
          if configuration[11] == '2':
            str_tmp = str_tmp + '\nN-triple format: multiple lines'
          else:
            str_tmp = str_tmp + '\nN-triple format: single line'

          tkMessageBox.showinfo('Correct Configuration',str_tmp)


    # load default configuration
    def defaultConfiguration(self, event=None):

        title = 'Modification of System Configuration '
        texto = 'Do you really want to reset the actual configuration to the default configuration ?'
        answer = tkMessageBox.askokcancel(title, texto)
        if answer == 0:
            return

        os.remove(CONFIG_FILE)
        shutil.copy(DEFAULT_CONFIG,CONFIG_FILE)
        
        [configuration, str_tmp] = read_choose()
        msgerr= ''

        if configuration == -1:
          msgerr = 'Value of one or more variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -2:
          msgerr = 'Number of variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -3:
          msgerr = 'Name of one or more variables is not correct.\nPlease re-configure Configuration file'
        elif configuration == -4:
          msgerr = 'Please re-configure it'

        if msgerr != '':
          tkMessageBox.showerror('Error in configuration file',msgerr)
        else:
          str_tmp = 'The current Metalog settings are:\n'

          if configuration[0] == '2':
            str_tmp = str_tmp + '\nAnswers for query: all'
          else:
            str_tmp = str_tmp + '\nAnswers for query: one'
          if configuration[2] == '2':
            str_tmp = str_tmp + '\nContainers: exploded in assertions: no'
          else:
            str_tmp = str_tmp + '\nContainers exploded in assertions: yes'
          if configuration[3] == '2':
            str_tmp = str_tmp + '\nContainers exploded in queries: no'
          else:
            str_tmp = str_tmp + '\nContainers exploded in queries: yes'
          if configuration[4] == '2':
            str_tmp = str_tmp + '\nSupport of annotations: no'
          else:
            str_tmp = str_tmp + '\nSupport of annotations: yes'
          if configuration[6] == '2':
            str_tmp = str_tmp + '\nDelete temporary files: no'
          else:
            str_tmp = str_tmp + '\nDelete temporary files: yes'
          if configuration[7] == '2':
            str_tmp = str_tmp + '\nDelete intermediate NT files: no'
          else:
            str_tmp = str_tmp + '\nDelete intermediate NT files: yes'
          if configuration[8] == '2':
            str_tmp = str_tmp + '\nDelete results: no'
          else:
            str_tmp = str_tmp + '\nDelete results: yes'
          if configuration[10] == '2':
            str_tmp = str_tmp + '\nLog messages in console: no'
          else:
            str_tmp = str_tmp + '\nLog messages in console: yes'
          if configuration[11] == '2':
            str_tmp = str_tmp + '\nN-triple format: multiple lines'
          else:
            str_tmp = str_tmp + '\nN-triple format: single line'

          tkMessageBox.showinfo('Correct Configuration',str_tmp)


    # Display initial message  # block keyboard !!!!!!!!!
    def visualizeMSG(self):
        stringa= '\n\n\nDeveloped by Massimo Marchiori, Antonio Epifani, Samuele Trevisan   '
        stringa = stringa +"\n\nCa' Foscari University of Venice\n\n"
        stringa = stringa +'\n\nversion 2.0b\n\n'
        tkMessageBox.showinfo(title='METALOG system',message=stringa)

 
    # translate ML2Ntriple with annotations (statement)
    def ntwiths(self, event=None):
        self.remove_msgDebug()
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return

        if self.fileType == 'ml':

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)

            [configuration, str_tmp] = read_choose()

            # Setting of files directories and extensions
            assertions_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".nt"))
            que_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + "_QRY.nt"))
            ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + ".nt"))
            ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
            ml_name = self.fileNameIn

            # translation of the ML file to Nt file with annotation
            class_translator = TranslatorAnnClass(self.M)
            if not(configuration in (-1,-2,-3,-4)):
              NT_FORMAT = configuration[11]
            out = class_translator.translatorAnn(ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name, 'stat', '1', NT_FORMAT)
            
            if out == 1:

                # Reading of files
                [text, lista] = self.read_file(assertions_name)
                
                window = Tkinter.Tk()
                t = Text(window)
                t.text.configure(width=80, height=30, wrap='none')
                t.text.insert('end', text)

                # Color nt text insered on screen
                t.nt_color(lista)
                                    
                t.frame.pack(fill='both', expand='yes')
                window.title('Metalog v2.0b : N-triples with annotations of file "'+self.fileName+'"')

            del class_translator

            # Save the output file.
            self.saveWindow(text, INPUT_FILE_NT)
            

           # Here goes the file saving
           
        elif self.fileType == 'cfg':
          stringa='This is the configuration file. You cannot translate it to "nt" form.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)

        elif self.fileType == 'nt':
          stringa='This is "nt" file. You cannot translate "nt" file to "nt" file.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)
        
        else:
            stringa='The file format is not ML'
            tkMessageBox.showerror(title='File format not valid',message=stringa)
            return


    # translate ML2Ntriple without annotations (statement)
    def ntwithouts(self, event=None):
        self.remove_msgDebug()
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return

        if self.fileType == 'ml':

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)

            [configuration, str_tmp] = read_choose()

            # Setting files directories and extensions
            assertions_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".nt"))
            que_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + "_QRY.nt"))
            ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + ".nt"))
            ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
            ml_name = self.fileNameIn

            # Computation of N-triple assertions
            if not(configuration in (-1,-2,-3,-4)):
              NT_FORMAT = configuration[11]

            triple = self.M.createNTriple(ml_name, type='stat', nameFileOut=assertions_name)
            self.M.destroyAll()

	    triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
            self.M.destroyAll()
 
            modify_nt_format(assertions_name, NT_FORMAT)
            
            # Reading files
            [text, lista] = self.read_file(assertions_name)

            window = Tkinter.Tk()
            t = Text(window)
            t.text.configure(width=80, height=30, wrap='none')
            t.text.insert('end', text)

            # Color nt text insered on screen
            t.nt_color(lista)

            t.frame.pack(fill='both', expand='yes')
            window.title('Metalog v2.0b : N-triples without annotations of file "'+self.fileName+'"')

            # Save the output file.
            self.saveWindow(text, INPUT_FILE_NT)


        elif self.fileType == 'cfg':
          stringa='This is the configuration file. You cannot translate it to "nt" form.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)

        elif self.fileType == 'nt':
          stringa='This is an "nt" file. You cannot translate an "nt" file to an "nt" file.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)

        
        else:
            stringa='The file format is not ML'
            tkMessageBox.showerror(title='File format not valid',message=stringa)
            return


    # translate ML2Ntriple with annotations (query)
    def ntwithq(self, event=None):
        self.remove_msgDebug()       
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return

        if self.fileType == 'ml':

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)


            [configuration, str_tmp] = read_choose()

            # Setting files directories and extensions
            assertions_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".nt"))
            que_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + "_QRY.nt"))
            ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + ".nt"))
            ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
            ml_name = self.fileNameIn

            # translation of the ML file to Nt file with annotation
            class_translator = TranslatorAnnClass(self.M)
            if not(configuration in (-1,-2,-3,-4)):
              NT_FORMAT = configuration[11]

            out = class_translator.translatorAnn(ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name, 'query', 1, NT_FORMAT)
            if out == 1:

                # Reading files
                [text, lista] = self.read_file(que_name)

                window = Tkinter.Tk()
                t = Text(window)
                t.text.configure(width=80, height=30, wrap='none')
                t.text.insert('end', text)

                # Color nt text insered on screen
                t.nt_color(lista)

                t.frame.pack(fill='both', expand='yes')
                window.title('Metalog v2.0b : Queries N-triples with annotations of file "'+self.fileName+'"')

                # Save the output file.
                self.saveWindow(text, INPUT_FILE_NT)

            del class_translator

        elif self.fileType == 'cfg':
          stringa='This is the configuration file. You cannot translate it to "nt" form.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)

        elif self.fileType == 'nt':
          stringa='This is "nt" file. You cannot translate "nt" file to "nt" file.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='Format file not valid', message=stringa)
        
        else:
            stringa='The file format is not ML'
            tkMessageBox.showerror(title='File format not valid',message=stringa)
            return


    # translate ML2Ntriple without annotations (query)
    def ntwithoutq(self, event=None):
        self.remove_msgDebug()
        self.closeWinOut()
        if self.isSaved==0:
            stringa='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=stringa)
            return

        if self.fileType == 'ml':

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)

            [configuration, str_tmp] = read_choose()

            # Setting files directories and extensions
            assertions_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".nt"))
            que_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + "_QRY.nt"))
            ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + ".nt"))
            ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
            ml_name = self.fileNameIn

            if not(configuration in (-1,-2,-3,-4)):
              NT_FORMAT = configuration[11]

            # Compute NTriple queries
            triple = self.M.createNTriple(ml_name, type='query', nameFileOut=que_name)
            self.M.destroyAll()

	    triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
            self.M.destroyAll()

            modify_nt_format(que_name, NT_FORMAT)

            # Reading files
            [text, lista] = self.read_file(assertions_name)

            window = Tkinter.Tk()
            t = Text(window)
            t.text.configure(width=80, height=30, wrap='none')
            t.text.insert('end', text)

            # Color nt text insered on screen
            t.nt_color(lista)

            t.frame.pack(fill='both', expand='yes')
            window.title('Metalog v2.0b : Queries N-triples without annotations of file "'+self.fileName+'"')

            # Save the output file.
            self.saveWindow(text, INPUT_FILE_NT)

        elif self.fileType == 'cfg':
          stringa='This is the configuration file. You cannot translate it to "nt" form.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='File format not valid', message=stringa)

        elif self.fileType == 'nt':
          stringa='This is "nt" file. You cannot translate "nt" file to "nt" file.\n Please edit "ml" file.'
          tkMessageBox.showerror(title='File format not valid', message=stringa)
          
        else:
            stringa='The file format is not ML'
            tkMessageBox.showerror(title='File format not valid',message=stringa)
            return



    # translate ML2RDF/XML statement
    def rdfxmls(self):
        self.remove_msgDebug()
        self.closeWinOut()
        if self.isSaved==0:
            str='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=str)
            return
        if self.fileNameIn !=None:

            if self.flagSaveRDFXML.get()==1:
                nameFileOut=self.nameFileRDFXML(self.fileNameIn)
                title='RDF/XML (file: '+ nameFileOut+')'
            else:
                nameFileOut=None
                title='RDF/XML (not saved)'

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)

            # Setting files directories and extensions
            nameFileOut = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".xml"))

            triple=self.M.createCodeRdf(self.fileNameIn,'stat',nameFileOut)
            self.M.destroyAll()

	    triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
            self.M.destroyAll()

            # Reading files
            [text, lista] = self.read_file(nameFileOut)

            window = Tkinter.Tk()
            t = Text(window)
            t.text.configure(width=80, height=30, wrap='none')
            t.text.insert('end', text)

            for a in range(1,len(lista)+1):
                if lista[a-1]!='':
                    if firstrcar(lista[a-1][0]) == '#':
                        colore = COLOR_COMMENT
                    else:
                        colore = COLOR_NTRIPLE
                else:
                    colore = COLOR_NTRIPLE 
                t.colorline(a, -1, color=colore)

            t.frame.pack(fill='both', expand='yes')
            window.title('Metalog v2.0b : RDF/XML of file "'+self.fileName+'"')
            self.M.destroyAll()

            # Save the output file.
            self.saveWindow(triple, INPUT_FILE_XML)



    # translate ML2RDF/XML queries
    def rdfxmlq(self):
        self.remove_msgDebug()
        self.closeWinOut()
        if self.isSaved==0:
            str='File not saved\nPlease Save first'
            tkMessageBox.showerror(title='File not saved',message=str)
            return
        if self.fileNameIn !=None:

            if self.flagSaveRDFXML.get()==1:
                nameFileOut=self.nameFileRDFXML(self.fileNameIn)
                title='RDF/XML (file: '+ nameFileOut+')'
            else:
                nameFileOut=None
                title='RDF/XML (not saved)'

            [name_tmp, name_file_que] = cal_name(self.fileNameIn)

            # Setting files directories and extensions
            nameFileOut = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".xml"))

            triple=self.M.createCodeRdf(self.fileNameIn,'query',nameFileOut)
            self.M.destroyAll()

	    triple = self.M.createNTriple(TMP_ASSERTION , type='stat')
            self.M.destroyAll()

            # Reading files
            [text, lista] = self.read_file(nameFileOut)

            window = Tkinter.Tk()
            t = Text(window)
            t.text.configure(width=80, height=30, wrap='none')
            t.text.insert('end', text)

            for a in range(1,len(lista)+1):
                if lista[a-1]!='':
                    if firstrcar(lista[a-1][0]) == '#':
                        colore = COLOR_COMMENT
                    else:
                        colore = COLOR_NTRIPLE
                else:
                    colore = COLOR_NTRIPLE 
                t.colorline(a, -1, color=colore)

            t.frame.pack(fill='both', expand='yes')
            window.title('Metalog v2.0b : Queries RDF/XML of file "'+self.fileName+'"')
            self.M.destroyAll()

            # Save the output file.
            self.saveWindow(triple, INPUT_FILE_XML)


    # User's Guide
    def homePage(self, event=None):
        
        if OP_SYSTEM == 'win':
          aa = os.startfile('http://www.w3.org/RDF/Metalog/')
        else:
          aa = os.system('netscape http://www.w3.org/RDF/Metalog/ &')

    # User's Guide
    def userGuide(self, event=None):
        
        if OP_SYSTEM == 'win':
            aa= os.startfile(os.path.normpath(os.path.join(DIR_WORK,'doc/index.html')))
        else:
          aa = os.system("netscape "+os.path.normpath(os.path.join(DIR_WORK,'doc/index.html'))+' &')


    def messageDebug(self,texto,line,col=-1):
        self.textDebug['text']=texto
        self.textDebug.pack()
        self.highlightLine(line,col)



    def test(self):
        self.textBox.get(2.3)


    def highlightLine(self,line,col=-1):
        startLine= str(line)+'.0'
        endLine= str(line)+'.end'
        self.textBox.see(startLine)
        self.textBox.tag_add("HLline",startLine,endLine)
        self.textBox.tag_config("HLline",background=cost.HIGHTLIGHT_ERROR)


        if col!=-1:
            startCol= str(line)+'.'+ str(col)
            endCol= str(line)+'.'+ str(col+1)
            self.textBox.tag_add("underText",startCol,endCol)
            self.textBox.tag_config("underText",underline=1)

    def remove_msgDebug(self):
        self.textBox.tag_delete("HLline")
        self.textBox.tag_delete("underText")
        self.textDebug['text']=''
        self.textDebug.pack()



    def textUpdate(self,event):
        if event.char!='':
            if self.isModif==0:
                self.isSaved=0
                self.isModif=1
                self.rootWin.title( '* '+self.rootWin.title())
            self.remove_msgDebug()
        return


    def winOutput(self, title, testo):
        self.rootWinOut=Tkinter.Tk()
        self.rootWinOut.title(title)
        frameOut=Tkinter.Frame(self.rootWinOut)
        self.textBoxOut=Tkinter.Text(frameOut)
        self.textBoxOut.pack(fill=Tkinter.BOTH,expand=Tkinter.YES)
        self.textBoxOut['font']=('Courier',10,'normal')
        self.textBoxOut.delete('1.0',Tkinter.END)
        self.textBoxOut.insert(Tkinter.END,text)
        frameOut.pack(fill=Tkinter.BOTH,expand=Tkinter.YES)
        self.remove_msgDebug()


    def about(self, event=None):
#        if OP_SYSTEM =='win':
         try:
            app = displayAbout(wxPlatform == "__WXMAC__")
            app.MainLoop()

#        else:
         except:
            stringa =  '\nMETALOG\nTowards the Semantic Web.'
            stringa = stringa +'\n(c) 1998-2003 by W3C and UNIVE'
            stringa= stringa +'\n\nAuthors: Massimo Marchiori, Antonio Epifani, Samuele Trevisan'
            stringa = stringa +'\nVersion 2.0b'
            stringa = stringa +'\nYear 2003'
            stringa = stringa +'\n\nmetalog@w3.org'            
            tkMessageBox.showinfo(title='About Metalog',message=stringa)
            self.remove_msgDebug()


    def clearText(self):
        self.textBox.delete('1.0',Tkinter.END)
        return

    def fileNew(self, event=None):
        self.closeWinOut()
        if self.isModif==1:
            msg='File modified: do you want to save it?'
            if tkMessageBox.askyesno(title='Save file?',message=msg):
               self.save()

        self.isModif=0
        self.isSave=0
        self.clearText()
        self.fileNameIn=None
        self.rootWin.title("Metalog Project v2.0b")
        self.remove_msgDebug()
        return


    def fileOpen(self,event=None):
        if self.isModif==1:
            msg='File modified, do you want to save it?'
            if tkMessageBox.askyesno(title='Save file?',message=msg):
               self.save()
        fileName=tkFileDialog.askopenfilename(filetypes=INPUT_FILE_TYPES,initialdir=self.userFileDir)
        if fileName==None or fileName=='':
            return
        else:
            self.userFileDir=os.path.dirname(fileName)

        try:
            self.namecalc(fileName)
            # Reading files
            [newText, lista] = self.read_file(fileName)
                
            self.fileNameIn=fileName
            self.rootWin.title('Metalog v2.0b : '+self.fileNameIn)
            self.isModif=0
            self.isSaved=1
            if fileName[len(fileName)-2:len(fileName)] == 'ml':
                self.fileType='ml'
            elif fileName[len(fileName)-2:len(fileName)] == 'nt':
                self.fileType='nt'
            else:
                self.fileType='??'
            self.remove_msgDebug()

            self.closeWinOut()
            self.clearText()
               
            self.textBox.insert(Tkinter.END,newText)
            
            if self.fileType == 'nt':
                    
                # Color nt text insered on screen
                self.nt_color(lista)
                    
            elif self.fileType == 'ml':
                # Color nt text insered on screen
                self.ml_color(lista)
                
            if not(os.access(fileName,os.W_OK)):
                stringa="Warning: you opened a Read-Only file.          \nPlease save it on disk before reasoning or computing N-triples.   " 
                tkMessageBox.showinfo(title='Read Only File',message=stringa)

                #Save new file on disk if file opened is Read-Only
                self.saveAs()            
                
        except IOError:
            msg='Error while reading self.fileIn: %s' %fileName
            tkMessageBox.showerror (msg)
            return


    def saveToFile(self,fileName):
        try:
            file=open(fileName,'w')
            newText=self.textBox.get('1.0',Tkinter.END)
            file.write(newText)
            file.close()
            self.fileNameIn=fileName
            self.fileIn= file

            self.namecalc(fileName)
            
            self.rootWin.title('Metalog v2.0b : '+self.fileNameIn)
            self.isSaved=1
            self.isModif=0 
            self.closeWinOut()
            self.remove_msgDebug()

            self.clearText()

            [newText, lista] = self.read_file(fileName)
            self.textBox.insert(Tkinter.END,newText)   

            if self.fileType=='ml':
               # Color edit file
                self.ml_color(lista)
            elif self.fileType=='nt':
               # Color edit file
                self.nt_color(lista)            
            
        except IOError:
            msg='Saving is impossible'
            tkMessageBox.showerror (msg)
            return

    def save(self,event=None):
        if self.isModif==0:
            return
        if self.fileNameIn==None or self.fileNameIn=='':
            self.saveAs()
        else:
            self.saveToFile(self.fileNameIn)
        return


    def saveAs(self,event=None):
        if self.fileType=='ml':
            INPUT_FILE_TYPE = INPUT_FILE_ML
        elif self.fileType=='nt':
            INPUT_FILE_TYPE = INPUT_FILE_NT
        elif self.fileType=='xml':
            INPUT_FILE_TYPE = INPUT_FILE_XML
        else:
            INPUT_FILE_TYPE = [('All Files','.*')]
            
        fileName=tkFileDialog.asksaveasfilename(filetypes=INPUT_FILE_TYPE,initialdir=self.userFileDir)
        if fileName==None or fileName=='':
            return
        else:
            self.userFileDir=os.path.dirname(fileName)

        self.namecalc(fileName)
        if not('.' in self.fileName):
            if self.fileType=='ml':
                fileName = fileName + '.ml'
            elif self.fileType=='nt':
                fileName = fileName + '.nt'
            elif self.fileType=='xml':
                fileName = fileName + '.xml'
                
        self.saveToFile(fileName)
        return
    
    def saveWindow(self,newText,INPUT_NAME):
        try:
            if tkMessageBox.askyesno(title='Save file?',message='Process terminated.\nWould you like to save Output file?'):            
              fileName=tkFileDialog.asksaveasfilename(filetypes=INPUT_NAME)
              if fileName==None or fileName=='':
                return
              if INPUT_NAME == INPUT_FILE_ML:
                  este = '.ml'
              elif INPUT_NAME == INPUT_FILE_NT:
                  este = '.nt'
              elif INPUT_NAME == INPUT_FILE_XML:
                  este = '.xml'
              name1 = namecalc(fileName)
              if not('.' in name1):
                  fileName = fileName + este   
              if fileName==None or fileName=='':
                  return
                 
              file=open(fileName,'w')
              file.write(newText)
              file.close()
              self.remove_msgDebug()
        except IOError:
            msg='Saving impossible'
            tkMessageBox.showerror (msg)
            return
   

    def exit(self,event=None):
        if self.isModif==1 and self.isSaved==0:
            msg='File modified: do you want to exit anyway?'
            if not tkMessageBox.askyesno(title='Save on close',message=msg):
                return
        try:
            os.remove(TMP_ASSERTION)
        except:
            sys.exit()
        sys.exit()
      
    def namecalc(self, nomefile):
        num = len(nomefile)-1
        punto = -1
        while 1:
          cara = nomefile[num]
          if cara in ['\\','/','//']:
            barra = num
            break
          num = num-1            

        self.fileName = nomefile[barra+1:len(nomefile)]

    ###########################################################################
    # Modify system configuration file
    def modconfans(self):
        str_var = 'ANSWERS'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of the Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'Every Metalog Query could get many answers from Logic Systems. \nSetting this option you can choose how many answers there will be in the output.       \n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration the output gives only one answer for query. \n'                    
                elif configu == '2':
                    texto = texto + 'In the actual configuration the output gives all possible answers per query. \n'
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to get all the possible answers in the output ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '2', present)
                else:
                    change_config(str_var, '1', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)
            

    # Modify system configuration file
    def modconfls(self):
        str_var = 'SYSTEM_PROLOG'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'Metalog uses a Logic System to do inference and reasoning on data.    \nSetting this option you can choose the System that Metalog will overwork.    \nIf you choose SWI-Prolog be sure that it is installed on your PC. \n You can use also the built-in Pylog Module, at the expense of some reasoning power...      \n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'Actually Metalog uses SWI-Prolog system. \n'                    
                elif configu == '2':
                    texto = texto + 'Actually Metalog uses Pylog system. \n'    
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + "\nWould you like to use SWI-Prolog system to do inference (It's advised) ? "
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)


    # Modify system configuration file
    def modconfexa(self):
        str_var = 'EXPLODE_ASSERTIONS'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'In Metalog there are containers. Setting this option you can choose the way to realize them.\nThe containers can be realized Exploding them or not. \nIf you choose to explode them the system could be slow.\nIf you choose "no" there might be loss of inferences.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration containers in Assertions are exploded. \n'                    
                elif configu == '2':
                    texto = texto + 'In the actual configuration containers in Assertions are not exploded. \n'
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to explode containers in Assertions ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)
            

    # Modify system configuration file
    def modconfexq(self):
        str_var = 'EXPLODE_QUERY'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'In Metalog there are containers. Setting this option you can choose the way to realize them.\nThe container can be realized Exploding themself or not. \nIf you choose to explode them the system could be slow.\nIf you choose "no" there might be loss of soundness.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration containers in Queries are exploded. \n'                    
                elif configu == '2':
                    texto = texto + 'In the actual configuration containers in Queries are not exploded. \n'
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to explode containers in Queries ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfmacro(self):
        str_var = 'MACRO'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'In Metalog assertions and queries can be written and read with Annotations.       \nUsing Annotations, code is more readable and comprehensible and the output of the system is similar to the input.    \nSetting this option you can choose to use or not Annotations in the output of Metalog.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration the output contains Annotations. \n'                    
                elif configu == '2':
                    texto = texto + "In the actual configuration the output doesn't contain Annotations. \n"
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to use Annotations in the output of Metalog ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfdtmp(self):
        str_var = 'DELETE_TMP'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'Metalog system creates temporary files in the installation directory.      \nThey are not essential for Metalog operations.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration Temporary Files are erased. \n'                    
                elif configu == '2':
                    texto = texto + "In the actual configuration Temporary Files aren't erased. \n"
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to erase Temporary Files ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfdnti(self):
        str_var = 'DELETE_INPUT_NT'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'During computation Metalog creates N-triple temporary files (translation of Metalog Language input).    \nThey are not essential for Metalog opearations.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration NT Temporary Files are erased. \n'                    
                elif configu == '2':
                    texto = texto + "In the actual configuration NT Temporary Files aren't erased. \n"
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to erase NT Temporary Files ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfdre(self):
        str_var = 'DELETE_RESULT'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'Metalog creates Output Files. \nThe files are ML (Metalog Language) and NT (N-triple Language) files.    \nThey are not essential for operation of Metalog.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration Output Files are erased. \n'                    
                elif configu == '2':
                    texto = texto + "In the actual configuration Output Files aren't erased. \n"
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to erase Output (ML and N-triple) Files ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfcm(self):
        str_var = 'VIDEO_MESSAGE'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'Metalog can display log messages on the Console Window during use. \nSetting this option you can choose to display or not log messages.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration Log Messages are displayed on Console. \n'                    
                elif configu == '2':
                    texto = texto + "In the actual configuration Log Messages aren't displayed on Console. \n"
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to display Log Messages ?'
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Modify system configuration file
    def modconfntf(self):
        str_var = 'NT_FORMAT'
        configu = read_config(str_var)
        if configu != -3 :
        
            title = 'Modification of System Configuration '
            texto = 'Warning. You chose to change the actual configuration of Metalog System. \nWould you like to continue ?'
            answer = tkMessageBox.askokcancel(title, texto)
            if answer == 1:
                title = 'Modification of System Configuration '
                texto = 'In Metalog N-triple data format could be:   \n - One Line for One Triple\n - Three Lines for One Triple.    \nSetting this option you can choose the visualization mode of N-triple data.\n\n'
                present = 1
                if configu == -1:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                elif configu == -2:
                    texto = texto + 'The variable "'+str_var+'" is not present in the configuration file. \n'
                    texto = texto + 'The variable "'+str_var+'" will be created. \n'
                    present = 0
                elif configu == '1':
                    texto = texto + 'In the actual configuration one Triple is displayed in one line. \n'                    
                elif configu == '2':
                    texto = texto + 'In the actual configuration one Triple is displayed in three lines. \n'                    
                else:
                    texto = texto + 'The actual value of variable "'+str_var+'" is not correct. \n'
                    
                texto = texto + '\nWould you like to display NT data in one line ? '
                answer = tkMessageBox.askquestion(title, texto)
                if answer == 'yes':
                    change_config(str_var, '1', present)
                else:
                    change_config(str_var, '2', present)                
        else:
            msgerr = 'Error while reading the configuration file.\nPlease create new config file or re-install Metalog Software'
            tkMessageBox.showerror('Error in configuration file',msgerr)

    # Color lines of main window
    def colorline(self,line,col=-1, color='#000000', bagr='#ffffff'):
        startLine= str(line)+'.0'
        endLine= str(line)+'.end'
        self.textBox.see(startLine)
        self.textBox.tag_add("line"+str(line),startLine,endLine)
        self.textBox.tag_config("line"+str(line), foreground=color)
        if col!=-1:
            startCol= str(line)+'.'+ str(col)
            endCol= str(line)+'.'+ str(col+1)
            self.textBox.tag_add("under"+str(line),startCol,endCol)
            self.textBox.tag_config("under"+str(line),underline=1)


    # Color nt text inserted on screen
    def nt_color(self, lista):
        for a in range(1,len(lista)+1):
            if lista[a-1]!='':
                if firstrcar(lista[a-1][0]) == '#':
                    colore = COLOR_COMMENT
                else:
                   colore = COLOR_NTRIPLE
            else:
                colore = COLOR_NTRIPLE 
            self.colorline(a, -1, color=colore)


    # Color ml text inserted on screen
    def ml_color(self, lista):
        a = 0
        while a<len(lista):
            if lista[a]=='\n':
                a=a+1
            else:
                [com_true, a1] = verify_com(lista, a)
                # string is comment
                if com_true:
                    color = COLOR_COMMENT
                    i = a+1
                    while i<= a1+1:
                        self.colorline(i, -1, color)
                        i = i+1
                    a = a1
                else:
                    [macro_true, a1] = verify_mac(lista, a)
    
                    # The string define macro
                    if macro_true:
                        color = COLOR_MACRO
                        i = a+1
                        while i<= a1+1:
                            self.colorline(i, -1, color)
                            i = i+1
                        a = a1
    
                    # body: assertions and queries
                    else:
                        color = COLOR_ASSERT
                        self.colorline(a+1, -1, color)
                        a = a+1
        

    # Reading files
    def read_file(self, assertions_name):
        file = open(assertions_name,'r')
        i = 0
        t = ' '
        text = ''
        lista = []
        while t != '':
            t=file.readline()
            text = text + t
            lista.append(t)
            i = i+1
        file.close()
        return([text, lista])



# Compute name of file
def namecalc(nomefile):
    num = len(nomefile)-1
    punto = -1
    while 1:
        cara = nomefile[num]
        if cara in ['\\','/','//']:
            barra = num
            break
        num = num-1
    return(nomefile[barra+1:len(nomefile)])

