# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#In this module we define all the constants that are globally used in the program """

import os  # imports this to define the "end of line" chars


# ------ Editor Metalog----------

# kind of input files allowed
#INPUT_FILE_TYPES=[('Text file','.txt'),('All files','.*')]
INPUT_FILE_TYPES=[('Metalog File','.ml'),('N-Triple File','.nt'),('RDF/XML File','.xml'),('All files','.*')]

# font size for the Metalog code
DIM_FONT=10

# color for errors
#HIGHTLIGHT_ERROR='#A1F111'
HIGHTLIGHT_ERROR='#ffffaa'



# --------- Metalog code

# list of words to ignore (spaces, end of lines and tabs)
#IGNORE=[' ',os.linesep,'\t',] 
IGNORE=[' ','\n','\t','\r'] 

# list of punctuation allowed in the Metalog language, apart from what needed for the macros which is handled in an autonomous way
PUNCT=['.',',','?'] #aggiunto ? il 18/6/02 


#string delimiter
DOUBLE_QUOT='"'   # non deve essere una lista!!
SINGLE_QUOT="'"     # non deve essere una lista!! 

#end of file char
EOF=''

#list of keywords
KEYS=['and','or','not','order','then','imply','implies','from'] #lista parole chiavi
# the "from" is excluded
# Note that KEYS is not in use in the 2/4/02 built (legge_b01)

# list of keywords used for the implication
IMPLY=['then','imply','implies'] #list of keywords in global module

#keywords used for the and, or, not and ordering
AND=['and']
OR=['or']
NOT=['not']
ORDER=['order']

#keywords for the math ops
ADD=['add','plus']
SUB=['sub','minus']
TIMES=['times','mult']
DIVIDE=['divided','div']
OPERAMATH = ADD+SUB+TIMES+DIVIDE


#keywords for the comparison predicates
LESS=['less']
GREAT=['greater']
EQUAL=['equal','equals']
NEQUAL=['different']




# keyword for the macro definition
REPRESENTS=['represents']
#macro delimiter char
#END_MACRO='.'

#keyword for the "from"
FROM=['from']

#keyword for the "include"
INCLUDE=['include']


# Added in 2/4/02 built h 16.55
#defines the char lists that can interrupt a word
STOPWORD=['.',',',' ','\n','\t','\r']  # not used from the 17/4/02 built


# chars used to identify a Holder
HOLDER=['q','v','u']      

#keywords for comments
COMMENT_OPEN= ['[[']  
COMMENT_CLOSE=[']]']
LINE_COMMENT=['@']
COMMENT=['comment:']

#defines the escape char for strings
# [seq_esc, char_replaced]
ESCAPE=['&"','"']



# ------------- RDF/XML code --------------------
# header of the RDF/XML code
PRE_XML ='<?xml version="1.0"?>'

# Name space  RDF
#RDF_NS= 'http://w3.org/TR/1999/PR-rdf-syntax-19990105#'

RDF_NS= 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'



#Name space Metalog and "not" Metalog
METALOG_NS= 'http://www.w3.org/RDF/Metalog#'
METALOG_NOT_NS='http://www.w3.org/RDF/Metalog/not/NAF#'
METALOG_MATH_NS='http://www.w3.org/RDF/Metalog/Math#'

# ------- Formatting RDF/XML code
#indentation spaces
INDENT= 2   


# Metalog version

VER_EDT='MetalogEdit ver. 2.0b'
VER_TRANS='Metalog Translator ver. 2.0b'


#URI for the comparison predicates

URI_EQ='http://www.w3.org/RDF/Metalog/Math#eq'
URI_NEQ='http://www.w3.org/RDF/Metalog/Math#neq'
URI_LESS='http://www.w3.org/RDF/Metalog/Math#less'
URI_GREAT='http://www.w3.org/RDF/Metalog/Math#great'
URI_LEQ='http://www.w3.org/RDF/Metalog/Math#leq'
URI_GEQ='http://www.w3.org/RDF/Metalog/Math#geq'



#instructions for the translator from command text

HELP_TRAD= '\nUsage: metaTrans <NameFileIn> [<NameFileOut>] [-Option] [-log]\n\n' + \
'Options:\n'+\
'-NT Translate statement to N-Triple (default if missing) \n'+\
'-NTQ    Translate query to N-Triple\n'+\
'-RDFXML Translate statement to RDF/XML\n\n' +\
'-log  Save error to file .log'

#flag for the log file

ERROR='none' # 'none' = Don't print error and don't save file output
             # 'onlylog' =  Don't print error and save log file
             # 'onlyprint'= Print error but don't save file
             # 'all' = Print error and save log file


