# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# This modules deletes the temp files created by Metalog
#********************************************************#

import os,os.path
import sys
import time
    
# Import constants
from definitions import *

# Import procedures
from procedure import *


#********************************************************************************************
# Procedure for cleaning temp files, result files, and deduced files
#********************************************************************************************
def delete_files():

  print "\n\n  =========================================================="
  print "  This procedure deletes files produced by the Metalog System."
  print "  You can delete Temp files, Result files and Deduced files."
  print "  =========================================================="

  # Deletes temp files
  choose_tmp()

  # Deletes result files
  choose_res()

  # Deletes deduced files
  choose_ded()

    
#********************************************************************************************
# Clean the temp files directory
#********************************************************************************************
def delete_temp():
  try:
    list_files = os.listdir(TMP_FOLDER)
    for el in list_files:
      if os.path.normpath(os.path.join(TMP_FOLDER,el)) != TMP_ASSERTION:
        os.remove(os.path.normpath(os.path.join(TMP_FOLDER,el)))
  except:
    print("\n\n Warning: Temp files cannot be deleted, probably some of them are still open.")


#********************************************************************************************
# Cleans directory of the result files mt and nt
#********************************************************************************************
def delete_res():
  try:
    list_files = os.listdir(ML_RESULT_FOLDER)
    for el in list_files:
      os.remove(os.path.normpath(os.path.join(ML_RESULT_FOLDER,el)))
    list_files = os.listdir(NT_RESULT_FOLDER)
    for el in list_files:
      os.remove(os.path.normpath(os.path.join(NT_RESULT_FOLDER,el)))
  except:
    print("\n\n Warning: Result files cannot be deleted, probably some of them are still open.")


#********************************************************************************************
# Cleans directory of the deduced files ml and nt
#********************************************************************************************
def delete_ded(): 
  try:
    list_files = os.listdir(ML_DEDUCED_FOLDER)
    for el in list_files:
      os.remove(os.path.normpath(os.path.join(ML_DEDUCED_FOLDER,el)))
    list_files = os.listdir(NT_DEDUCED_FOLDER)
    for el in list_files:
      os.remove(os.path.normpath(os.path.join(NT_DEDUCED_FOLDER,el)))
  except:
    print("\n\n Warning: Deduced files cannot be deleted, probably some of them are still open.")    


#********************************************************************************************
# Cleans directory of the computed or copied nt files
#********************************************************************************************
def delete_nt():
  try:      
    list_files = os.listdir(NT_FOLDER)
    for el in list_files:
      os.remove(os.path.normpath(os.path.join(NT_FOLDER,el)))
  except:
    print("\n\n Warning: Deduced files cannot be deleted, probably some of them are still open.")    



