# METALOG PROJECT (http://www.w3.org/RDF/Metalog)
#********************************************************#
# Main metalog module (no graphics)
#********************************************************#

# Import of standard libraries
import os
import sys
import time
import shutil

# Import the Metalog Class
from metalogmodule import MetalogHeartClass

# Import the FeedBack Metalog Module
from feedback import FeedBackClass

# Import the traslator with annotation Metalog Module
from translatorAnn import TranslatorAnnClass

# Import Definizioni e costanti
from  definitions       import *

# Import misc Procedures
from  procedure         import *

# Import Procedures to delete temp files
from  clear_files       import *


#********************************************************#
# Class Metalog
#********************************************************#
class MetalogClass:

  "Metalog Class"

  #********************************************************************************************
  # Initalization of the data structures internal to the class
  #********************************************************************************************
  def __init__(self, M):
    self.assertions             = []
    self.result_que             = []
    self.data_macro             = []
    self.result                 = []
    self.result_assertions      = []
    self.table_que              = []
    self.macro_ok               =  -1
    self.M                      = M

  #********************************************************************************************
  # Procedure Main program
  #********************************************************************************************
  def mainprogram(self, name, typefile):

    # Check presence of support temp file
    checkfiletmp()

    # Read from the configuration file the system settings
    [configurations, str_tmp] = read_choose()

    if configurations != -1:
      MACRO = configurations[4]
      MLNT = typefile
      CALCULATE_CONT = configurations[5]
      DELETE_TMP = configurations[6]
      DELETE_INPUT_NT = configurations[7]
      DELETE_RESULT = configurations[8]
      DELETE_DEDUCED = configurations[9]
      VIDEO_MESSAGE = configurations[10]
      NT_FORMAT = configurations[11]


      # calculates the name to use
      [name_tmp, name_file_que] = cal_name(name)

      # Sets directory and file extensions
      assertions_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + ".nt"))
      que_name = os.path.normpath(os.path.join(NT_FOLDER,name_tmp + "_QRY.nt"))
      ann_assertions_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + ".nt"))
      ann_que_name = os.path.normpath(os.path.join(TMP_FOLDER,name_tmp + "_QRY.nt"))
      ml_name = name

      # If reading data from Metalog file...
      if MLNT == 'ml':

        # translate the file ml into nt with metalog annotations
        class_translator = TranslatorAnnClass(self.M)
        out = class_translator.translatorAnn(ml_name, assertions_name, que_name, ann_assertions_name, ann_que_name, 'both', MACRO, NT_FORMAT)

        if out != 1:
          del class_translator
          return(out)
        else:
          data_assertions = class_translator.d_assertions
          data_que = class_translator.d_que
          table_assertions = class_translator.t_assertions
          table_que = class_translator.t_que
          self.result_assertions = class_translator.t_assertions
          MACRO_OK = class_translator.m_ok
          self.macro_ok = MACRO_OK
          del class_translator

      # If reading file from an N-triple file...
      elif MLNT == 'nt':
        try:
          shutil.copyfile(name, assertions_name)
          shutil.copyfile(name_file_que, que_name)

          if MACRO != '1':   # Clears the macro tables assertions and query
            data_assertions = []
            data_que = []
            MACRO_OK = 1
            self.macro_ok = 1
          else:
            data_assertions = ricava_nt(assertions_name)
            data_que = ricava_nt(que_name)
            MACRO_OK = 1
            self.macro_ok = 1
          table_que = [[],[]]
        except:          
          print "Error during copy nt files\n"
          return(-3)

      self.table_que = table_que

      # STARTS CLASS METALOGHEART: creates tree, calculates assertions, calulates answers with inferential system, normalizes results
      class_metalogheart = MetalogHeartClass()
      class_metalogheart.runmetalog(assertions_name, que_name, configurations[0:7])
      result = class_metalogheart.data
      del class_metalogheart

      # Return codes of the Metalog Class: result is a table containing the following codes for each answer to a query
      # [[-1],[bla]]         - error             "Error during result\n\n"
      # [[-2],...]           - false             "It's false, there are no assertions to unify query."
      # [[-3],...]           - false             "It's false, there are no assertions to unify query."
      # [[-4],...] ]         - sintax error      "Sintax Error in assertios, It's probably that the problem's class of this problem are not representable in Metalog"
      # [data, data]         - true              "It's True"

      # Feedback of the results: trasformation of the data into format ML and NT, application of the conversion to obtain macros in te output files
      class_feedback = FeedBackClass(self.M)
      class_feedback.feed(result, data_assertions, data_que, MACRO, MACRO_OK, assertions_name, que_name, CALCULATE_CONT, VIDEO_MESSAGE, NT_FORMAT)
      self.result_que = class_feedback.tmp_que
      self.data_macro = class_feedback.data_macro
      del class_feedback
      
      self.result = result
      self.assertions = data_assertions
      
      # Deletes temp files.
      if DELETE_TMP == '1':
        delete_temp()            

      # Deletes result files.
      if DELETE_RESULT == '1':
        delete_res() 

      # Cancellazione files nt calcolati i ingresso o copiati.
      if DELETE_RESULT == '1':
        delete_nt() 

      return(1)

    else:
      return(-1)


#********************************************************************************************
# Obtain the table containing the annotations from an nt file
#********************************************************************************************<
def ricava_nt(name):
  table = open_data(name)
  tab = table[0]
  tmp = []
  for el in tab:
    if el[1] == 'http://www.w3.org/RDF/Metalog#ns' or el[1]=='http://www.w3.org/RDF/Metalog#annotation':
      i = 0
      for tre in el:
        if tre[0] != '_' and tre[0] != '"':
          tre1 = '<'+tre+'>'
        else:
          tre1 = tre
        if i == 2:
          tre1 = tre1+'.'
        tmp.append(tre1)
        i = i+1
  return(tmp)



